/* MathLib: Pilot shared library of IEEE-754 double math functions
 *
 * Minimum subset of GCC math_private.h file; just enough to allow proper
 * compilation of the GCC source code with as few changes as possible.
.* These frequently used extraction and insertion macros have been
 * rewritten to generate more efficient code under CodeWarrior.
 *
 * Copyright (C) 1997 Rick Huebner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; see file COPYING.LIB.  If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA
 *
 * Version 1.0, 15 August 1997, Rick Huebner
 */

// Typedefs used in math routines
typedef long int32_t;
typedef unsigned long u_int32_t;

// Prototypes for primary math functions, copied verbatim from GCC source
double __ieee754_acos(double x);
double __ieee754_asin(double x);
double __atan(double x);
double __ieee754_atan2(double y, double x);
double __cos(double x);
double __sin(double x);
double __tan(double x);
void   __sincos(double x, double *sinx, double *cosx);
double __ieee754_cosh(double x);
double __ieee754_sinh(double x);
double __tanh(double x);
double __ieee754_acosh(double x);
double __asinh(double x);
double __ieee754_atanh(double x);
double __ieee754_exp(double x);
double __frexp(double x, int32_t *eptr);
double __ldexp(double value, int32_t exp);
double __ieee754_log(double x);
double __ieee754_log10(double x);
double __modf(double x, double *iptr);
double __expm1(double x);
double __log1p(double x);
double __logb(double x);
double __log2(double x);
double __ieee754_pow(double x, double y);
double __ieee754_sqrt(double x);
double __ieee754_hypot(double x, double y);
double __cbrt(double x);
double __ceil(double x);
double __fabs(double x);
double __floor(double x);
double __ieee754_fmod(double x, double y);
int32_t __isinf(double x);
int32_t __finite(double x);
double __scalbn(double x, int32_t n);
double __ieee754_remainder(double x, double p);
double __significand(double x);
double __copysign(double x, double y);
int32_t __isnan(double x);
int32_t __ilogb(double x);
double __rint(double x);
double __nextafter(double x, double y);
double __ieee754_scalb(double x, double fn);
double __round(double x);
double __trunc(double x);
int32_t __signbit(double x);

// Prototypes for special routines used by primary math functions
double __kernel_cos(double x, double y);
double __kernel_sin(double x, double y, int32_t iy);
double __kernel_tan(double x, double y, int32_t iy);
int32_t __ieee754_rem_pio2(double x, double *y);
int32_t __kernel_rem_pio2(double *x, double *y, int32_t e0, int32_t nx, int32_t prec, const int32_t *ipio2);

// Prototypes for our "jump island" stubs to avoid 32KB pc-rel jsr limit
double jumpto__ieee754_sqrt(double x);
double jumpto__fabs(double x);
double jumpto__scalbn(double x, int32_t n);

// Stub out unused macros
#define weak_alias(x,y)
#define strong_alias(x,y)

#undef __HI32
#undef __LO32

#define __HI32(x) *((u_int32_t *) &x)
#define __LO32(x) *((u_int32_t *) &x + 1)

/* Get two 32 bit ints from a double.  */
#define EXTRACT_WORDS(ix0,ix1,d)                                \
do {															\
	(ix0) = __HI32(d);											\
	(ix1) = __LO32(d);											\
} while (0)

/* Get the more significant 32 bit int from a double.  */
#define GET_HIGH_WORD(i,d)                                      \
do {                                                            \
	(i) = __HI32(d);											\
} while (0)

/* Get the less significant 32 bit int from a double.  */
#define GET_LOW_WORD(i,d)                                     	\
do {                                                            \
	(i) = __LO32(d);											\
} while (0)

/* Set a double from two 32 bit ints.  */
#define INSERT_WORDS(d,ix0,ix1)                                 \
do {                                                            \
	__HI32(d) = (ix0);											\
	__LO32(d) = (ix1);											\
} while (0)

/* Set the more significant 32 bits of a double from an int.  */
#define SET_HIGH_WORD(d,v)		                                \
do {                                                            \
	__HI32(d) = (v);											\
} while (0)

/* Set the less significant 32 bits of a double from an int.  */
#define SET_LOW_WORD(d,v)		                                \
do {                                                            \
	__LO32(d) = (v);											\
} while (0)
