/*
 *	updated:	October 29. 2003
 *
 *	Copyright (c) by Collin R. Mulliner <palm@mulliner.org>
 *	http://www.mulliner.org/palm/
 *
 *	Feel free to use this function in any of your programms, as long as you give credit!
 *
 *	This function gets or sets the PalmOS UserName (the HostSync name) and UserID.
 *	
 *	set		: true to write/false to read
 *	palm_name	: pointer to 41 bytes of mem, UserName (max 40 chars) + the zero byte
 *	palm_id		: pointer to a UInt16, UserID
 */
void get_set_palm_name(UInt8 get_or_set, char *palm_name, UInt16 *palm_id)
{
	DmOpenRef db_ref;
	void *res_ptr;
	MemHandle res_hand;
	UInt32 res_size;
	unsigned char *in_buffer, *out_buffer;
	UInt8 name_length;
	UInt8 i;
	Int16 res_index;
	unsigned char ins_name_length;
	UInt32 offset;
	UInt16 big, small;
	

	/* PalmOS version check */
	if (FtrGet(sysFtrCreator, sysFtrNumROMVersion, &offset) != 0) {
		offset = 0;
	}
	else {
		/* < PalmOS 5.x */
		if (offset < 0x05000000) {
			big = 44;
			small = 42;
		}
		/* >= PalmOS 5.x */
		else {
			big = 46;
			small = 44;
		}
	}

	/* open prefs database */
	db_ref = DmOpenDatabaseByTypeCreator('pref', 'psys', dmModeReadWrite);

	res_index = DmFindResource(db_ref, 'psys', 4, NULL);

	if (res_index != -1) {
		res_hand = DmGetResource('psys', 4);
		res_size = MemHandleSize(res_hand);
		res_ptr = MemHandleLock(res_hand);
	
		in_buffer = MemPtrNew(res_size);
	
		if (get_or_set == 1) {	/* set it */
			name_length = StrLen(palm_name);
			out_buffer = MemPtrNew(big+name_length+1);
		}
		MemMove(in_buffer, res_ptr, res_size);
		MemHandleUnlock(res_hand);
	
		if (get_or_set == 0) {	/* get it */
			i = 1;
			while (*(in_buffer+small+i) != '\0') {
				i++;
			}
			MemMove(palm_name, in_buffer+small, i+1);

			MemMove(palm_id, in_buffer+4, 2);
		}
	
		if (get_or_set == 1) {	/* set it */
			DmResizeResource(res_hand, big+name_length+1);
			res_ptr = MemHandleLock(res_hand);
	
			MemMove(out_buffer, in_buffer, small);
			MemMove(out_buffer+small, palm_name, name_length+1);
			
			ins_name_length = (unsigned char) name_length + 1;

			MemMove(out_buffer+(small-4), &ins_name_length, 1);
				
			MemMove(out_buffer+4, palm_id, 2);
			/* this is the user ID */

			DmWrite(res_ptr, 0, out_buffer, big+name_length+1);
			MemHandleUnlock(res_hand);
			MemPtrFree(out_buffer);
		}
	
		DmReleaseResource(res_hand);
		MemPtrFree(in_buffer);
	}
	else {		/* resource not found */
		if (get_or_set == 0) {	/* get it */
		/*	*(palm_name) = '\0'; */
		}
		if (get_or_set == 1) {	/* set it */
			name_length = StrLen(palm_name);
			res_hand = DmNewResource(db_ref, 'psys', 4, big+name_length+1);
			res_ptr = MemHandleLock(res_hand);
			out_buffer = MemPtrNew(big+name_length+1);
			MemSet(out_buffer, 0x00, big+name_length+1);
			MemMove(out_buffer+small, palm_name, name_length+1);

			ins_name_length = (unsigned char) name_length + 1;

			MemMove(out_buffer+small-4, &ins_name_length, 1);

			MemMove(out_buffer+4, palm_id, 2);
			/* this is the user ID */

			DmWrite(res_ptr, 0, out_buffer, big+name_length+1);
			MemHandleUnlock(res_hand);
			MemPtrFree(out_buffer);
			DmReleaseResource(res_hand);
		}
	}
	
	DmCloseDatabase(db_ref);
}
