/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElementProvider;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator;
import org.eclipse.cdt.managedbuilder.scannerconfig.IManagedScannerInfoCollector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManagedBuildManager
extends AbstractCExtension
implements IScannerInfoProvider {
    private static final QualifiedName buildInfoProperty = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "managedBuildInfo");
    private static final String ROOT_NODE_NAME = "ManagedProjectBuildInfo";
    public static final String SETTINGS_FILE_NAME = ".cdtbuild";
    private static final ITarget[] emptyTargets = new ITarget[0];
    public static final String INTERFACE_IDENTITY = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".ManagedBuildManager";
    public static final String EXTENSION_POINT_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".ManagedBuildInfo";
    private static final String REVISION_ELEMENT_NAME = "managedBuildRevision";
    private static final String VERSION_ELEMENT_NAME = "fileVersion";
    private static final String MANIFEST_VERSION_ERROR = "ManagedBuildManager.error.manifest.version.error";
    private static final String PROJECT_VERSION_ERROR = "ManagedBuildManager.error.project.version.error";
    private static final PluginVersionIdentifier buildInfoVersion = new PluginVersionIdentifier(2, 0, 0);
    private static Map depCalculatorsMap;
    private static boolean extensionTargetsLoaded;
    private static Map extensionTargetMap;
    private static List extensionTargets;
    private static Map extensionToolMap;
    private static Map configElementMap;
    private static Map buildModelListeners;

    static {
        extensionTargetsLoaded = false;
    }

    public static ITarget[] getDefinedTargets(IProject iProject) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException buildException) {
            buildException.printStackTrace();
        }
        List list = null;
        int n = extensionTargets != null ? extensionTargets.size() + (list != null ? list.size() : 0) : 0;
        ITarget[] iTargetArray = new ITarget[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < extensionTargets.size()) {
            iTargetArray[n2++] = (ITarget)extensionTargets.get(n3);
            ++n3;
        }
        if (list != null) {
            n3 = 0;
            while (n3 < list.size()) {
                iTargetArray[n2++] = (ITarget)list.get(n3);
                ++n3;
            }
        }
        return iTargetArray;
    }

    public static IManagedDependencyGenerator getDependencyGenerator(String string) {
        return (IManagedDependencyGenerator)ManagedBuildManager.getExtensionDepCalcMap().get(string);
    }

    public static IManagedDependencyGenerator createDependencyGenerator(String string) {
        try {
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(EXTENSION_POINT_ID);
            if (iExtensionPoint != null) {
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                int n = 0;
                while (n < iExtensionArray.length) {
                    IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                    int n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                        if (iConfigurationElement.getName().equals("tool")) {
                            if (iConfigurationElement.getAttribute("id").equals(string) && iConfigurationElement.getAttribute("dependencyCalculator") != null) {
                                return (IManagedDependencyGenerator)iConfigurationElement.createExecutableExtension("dependencyCalculator");
                            }
                        } else if (iConfigurationElement.getName().equals("target")) {
                            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren("tool");
                            int n3 = 0;
                            while (n3 < iConfigurationElementArray2.length) {
                                IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[n3];
                                if (iConfigurationElement2.getAttribute("id").equals(string) && iConfigurationElement2.getAttribute("dependencyCalculator") != null) {
                                    return (IManagedDependencyGenerator)iConfigurationElement2.createExecutableExtension("dependencyCalculator");
                                }
                                ++n3;
                            }
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    protected static Map getExtensionDepCalcMap() {
        if (depCalculatorsMap == null) {
            depCalculatorsMap = new HashMap();
        }
        return depCalculatorsMap;
    }

    protected static Map getExtensionTargetMap() {
        if (extensionTargetMap == null) {
            extensionTargetMap = new HashMap();
        }
        return extensionTargetMap;
    }

    protected static Map getExtensionToolMap() {
        if (extensionToolMap == null) {
            extensionToolMap = new HashMap();
        }
        return extensionToolMap;
    }

    public static ITarget[] getTargets(IResource iResource) {
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo(iResource);
        if (iManagedBuildInfo != null) {
            List list = iManagedBuildInfo.getTargets();
            return list.toArray(new ITarget[list.size()]);
        }
        return emptyTargets;
    }

    public static ITool getTool(String string) {
        return (ITool)ManagedBuildManager.getExtensionToolMap().get(string);
    }

    public static ITarget getTarget(IResource iResource, String string) {
        IManagedBuildInfo iManagedBuildInfo;
        ITarget iTarget = null;
        if (iResource != null && (iManagedBuildInfo = ManagedBuildManager.getBuildInfo(iResource)) != null) {
            iTarget = iManagedBuildInfo.getTarget(string);
        }
        if (iTarget == null) {
            iTarget = (ITarget)ManagedBuildManager.getExtensionTargetMap().get(string);
        }
        return iTarget;
    }

    public static void setDefaultConfiguration(IProject iProject, IConfiguration iConfiguration) {
        if (iProject == null || iConfiguration == null) {
            return;
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        if (iManagedBuildInfo != null) {
            iManagedBuildInfo.setDefaultConfiguration(iConfiguration);
        }
    }

    public static void setSelectedTarget(IProject iProject, ITarget iTarget) {
        if (iProject == null || iTarget == null) {
            return;
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        if (iManagedBuildInfo != null) {
            iManagedBuildInfo.setSelectedTarget(iTarget);
        }
    }

    public static IManagedBuilderMakefileGenerator getMakefileGenerator(String string) {
        try {
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(EXTENSION_POINT_ID);
            if (iExtensionPoint != null) {
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                int n = 0;
                while (n < iExtensionArray.length) {
                    IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                    int n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                        if (iConfigurationElement.getName().equals("target") && iConfigurationElement.getAttribute("id").equals(string) && iConfigurationElement.getAttribute("makefileGenerator") != null) {
                            return (IManagedBuilderMakefileGenerator)iConfigurationElement.createExecutableExtension("makefileGenerator");
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {}
        return new GnuMakefileGenerator();
    }

    public static IManagedScannerInfoCollector getScannerInfoCollector(String string) {
        try {
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(EXTENSION_POINT_ID);
            if (iExtensionPoint != null) {
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                int n = 0;
                while (n < iExtensionArray.length) {
                    IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                    int n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                        if (iConfigurationElement.getName().equals("target") && iConfigurationElement.getAttribute("id").equals(string) && iConfigurationElement.getAttribute("scannerInfoCollector") != null) {
                            return (IManagedScannerInfoCollector)iConfigurationElement.createExecutableExtension("scannerInfoCollector");
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static ITarget getSelectedTarget(IProject iProject) {
        if (iProject == null) {
            return null;
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        if (iManagedBuildInfo != null) {
            return iManagedBuildInfo.getSelectedTarget();
        }
        return null;
    }

    private static void notifyListeners(IConfiguration iConfiguration, IOption iOption) {
        if (iOption.getValueType() != 4 && iOption.getValueType() != 5) {
            return;
        }
        IResource iResource = iConfiguration.getOwner();
        List list = (List)ManagedBuildManager.getBuildModelListeners().get(iResource);
        if (list == null) {
            return;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            ((IScannerInfoChangeListener)listIterator.next()).changeNotification(iResource, (IScannerInfo)ManagedBuildManager.getBuildInfo(iResource));
        }
    }

    public static void setNewProjectVersion(IProject iProject) {
        ManagedBuildInfo managedBuildInfo = ManagedBuildManager.findBuildInfo((IResource)iProject);
        managedBuildInfo.setVersion(buildInfoVersion.toString());
    }

    public static void setOption(IConfiguration iConfiguration, IOption iOption, boolean bl) {
        try {
            iConfiguration.setOption(iOption, bl);
            ManagedBuildManager.notifyListeners(iConfiguration, iOption);
        }
        catch (BuildException buildException) {
            return;
        }
    }

    public static void setOption(IConfiguration iConfiguration, IOption iOption, String string) {
        try {
            iConfiguration.setOption(iOption, string);
            ManagedBuildManager.notifyListeners(iConfiguration, iOption);
        }
        catch (BuildException buildException) {
            return;
        }
    }

    public static void setOption(IConfiguration iConfiguration, IOption iOption, String[] stringArray) {
        try {
            iConfiguration.setOption(iOption, stringArray);
            ManagedBuildManager.notifyListeners(iConfiguration, iOption);
        }
        catch (BuildException buildException) {
            return;
        }
    }

    public static void setToolCommand(IConfiguration iConfiguration, ITool iTool, String string) {
        if (iTool instanceof IToolReference) {
            ((IToolReference)iTool).setToolCommand(string);
        } else {
            iConfiguration.setToolCommand(iTool, string);
        }
    }

    public static void saveBuildInfo(IProject iProject, boolean bl) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            ManagedBuildInfo managedBuildInfo = (ManagedBuildInfo)ManagedBuildManager.getBuildInfo((IResource)iProject);
            if (managedBuildInfo != null && (bl || managedBuildInfo.isDirty())) {
                Node node;
                String string = managedBuildInfo.getVersion();
                if (string != null) {
                    node = document.createProcessingInstruction(VERSION_ELEMENT_NAME, string);
                    document.appendChild(node);
                }
                node = document.createElement(ROOT_NODE_NAME);
                document.appendChild(node);
                managedBuildInfo.serialize(document, (Element)node);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                DOMSource dOMSource = new DOMSource(document);
                StreamResult streamResult = new StreamResult(byteArrayOutputStream);
                transformer.transform(dOMSource, streamResult);
                IFile iFile = iProject.getFile(SETTINGS_FILE_NAME);
                String string2 = byteArrayOutputStream.toString("UTF8");
                if (iFile.exists()) {
                    iFile.setContents((InputStream)new ByteArrayInputStream(string2.getBytes()), 1, null);
                } else {
                    iFile.create((InputStream)new ByteArrayInputStream(string2.getBytes()), 1, null);
                }
                byteArrayOutputStream.close();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            transformerFactoryConfigurationError.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public static void removeBuildInfo(IResource iResource) {
        try {
            iResource.setSessionProperty(buildInfoProperty, null);
        }
        catch (CoreException coreException) {}
    }

    public static void resetConfiguration(IProject iProject, IConfiguration iConfiguration) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException buildException) {
            buildException.printStackTrace();
        }
        IConfiguration iConfiguration2 = iConfiguration.getParent();
        IManagedConfigElement iManagedConfigElement = ManagedBuildManager.getConfigElement(iConfiguration2);
        ((Configuration)iConfiguration).reset(iManagedConfigElement);
    }

    public static void addExtensionTarget(Target target) {
        if (extensionTargets == null) {
            extensionTargets = new ArrayList();
        }
        extensionTargets.add(target);
        ManagedBuildManager.getExtensionTargetMap().put(target.getId(), target);
    }

    public static void addExtensionTool(Tool tool) {
        ManagedBuildManager.getExtensionToolMap().put(tool.getId(), tool);
        ManagedBuildManager.getExtensionDepCalcMap().put(tool.getId(), ManagedBuildManager.createDependencyGenerator(tool.getId()));
    }

    public static ITarget createTarget(IResource iResource, ITarget iTarget) throws BuildException {
        IResource iResource2 = iTarget.getOwner();
        if (iResource2 != null && iResource2.equals((Object)iResource)) {
            return iTarget;
        }
        if (iResource instanceof IProject) {
            if (iResource2 != null) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.owner_not_null"));
            }
        } else {
            if (iResource2 == null) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.null_owner"));
            }
            if (!iResource2.equals((Object)iResource.getProject())) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.owner_not_project"));
            }
        }
        return new Target(iResource, iTarget);
    }

    public static IStatus initBuildInfoContainer(IResource iResource) {
        ManagedBuildInfo managedBuildInfo = null;
        try {
            managedBuildInfo = ManagedBuildManager.findBuildInfo((IResource)iResource.getProject());
            ManagedBuildManager.initBuildInfoContainer(managedBuildInfo);
        }
        catch (CoreException coreException) {
            return new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, coreException.getLocalizedMessage(), (Throwable)coreException);
        }
        return new Status(0, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ManagedMakeMessages.getFormattedString("ManagedBuildInfo.message.init.ok", iResource.getName()), null);
    }

    private static void initBuildInfoContainer(ManagedBuildInfo managedBuildInfo) throws CoreException {
        if (managedBuildInfo == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, new String(), null));
        }
        ICProject iCProject = managedBuildInfo.getCProject();
        IPathEntry[] iPathEntryArray = iCProject.getRawPathEntries();
        ArrayList<IPathEntry> arrayList = new ArrayList<IPathEntry>(Arrays.asList(iPathEntryArray));
        if (!arrayList.contains(ManagedBuildInfo.containerEntry)) {
            arrayList.add((IPathEntry)ManagedBuildInfo.containerEntry);
            iCProject.setRawPathEntries(arrayList.toArray(new IPathEntry[arrayList.size()]), (IProgressMonitor)new NullProgressMonitor());
            managedBuildInfo.setContainerCreated(true);
        }
    }

    private static boolean isVersionCompatible(IExtension iExtension) {
        PluginVersionIdentifier pluginVersionIdentifier = null;
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals(REVISION_ELEMENT_NAME)) {
                pluginVersionIdentifier = new PluginVersionIdentifier(iConfigurationElement.getAttribute(VERSION_ELEMENT_NAME));
                break;
            }
            ++n;
        }
        if (pluginVersionIdentifier == null) {
            return true;
        }
        return buildInfoVersion.isCompatibleWith(pluginVersionIdentifier);
    }

    private static ManagedBuildInfo loadBuildInfo(IProject iProject) {
        ManagedBuildInfo managedBuildInfo = null;
        IFile iFile = iProject.getFile(SETTINGS_FILE_NAME);
        if (!iFile.exists()) {
            return null;
        }
        try {
            NodeList nodeList;
            InputStream inputStream = iFile.getContents();
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            String string = null;
            Node node = document.getFirstChild();
            if (node.getNodeType() == 7) {
                string = node.getNodeValue();
                nodeList = new PluginVersionIdentifier(string);
                if (!buildInfoVersion.isCompatibleWith((PluginVersionIdentifier)nodeList)) {
                    throw new BuildException(ManagedMakeMessages.getResourceString(PROJECT_VERSION_ERROR));
                }
                buildInfoVersion.isGreaterThan((PluginVersionIdentifier)nodeList);
            }
            if ((nodeList = document.getElementsByTagName(ROOT_NODE_NAME)).getLength() > 0) {
                Node node2 = nodeList.item(0);
                managedBuildInfo = new ManagedBuildInfo((IResource)iProject, (Element)node2);
                if (string != null) {
                    managedBuildInfo.setVersion(string);
                }
                iProject.setSessionProperty(buildInfoProperty, (Object)managedBuildInfo);
            }
        }
        catch (Exception exception) {
            managedBuildInfo = null;
        }
        return managedBuildInfo;
    }

    private static synchronized void loadExtensions() throws BuildException {
        Object object;
        Object object2;
        if (extensionTargetsLoaded) {
            return;
        }
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            object2 = iExtensionArray[n];
            if (!ManagedBuildManager.isVersionCompatible((IExtension)object2)) {
                throw new BuildException(ManagedMakeMessages.getResourceString(MANIFEST_VERSION_ERROR));
            }
            object = object2.getConfigurationElements();
            ManagedBuildManager.loadConfigElements(DefaultManagedConfigElement.convertArray((IConfigurationElement[])object));
            ++n;
        }
        Iterator iterator = ManagedBuildManager.getExtensionToolMap().values().iterator();
        while (iterator.hasNext()) {
            try {
                object2 = (Tool)iterator.next();
                ((Tool)object2).resolveReferences();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object2 = ManagedBuildManager.getExtensionTargetMap().values().iterator();
        while (object2.hasNext()) {
            try {
                object = (Target)object2.next();
                ((Target)object).resolveReferences();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        extensionTargetsLoaded = true;
    }

    private static void loadConfigElements(IManagedConfigElement[] iManagedConfigElementArray) {
        int n = 0;
        while (n < iManagedConfigElementArray.length) {
            try {
                IManagedConfigElement iManagedConfigElement = iManagedConfigElementArray[n];
                if (iManagedConfigElement.getName().equals("tool")) {
                    new Tool(iManagedConfigElement);
                } else if (iManagedConfigElement.getName().equals("target")) {
                    new Target(iManagedConfigElement);
                } else if (iManagedConfigElement.getName().equals("dynamicElementProvider") && iManagedConfigElement instanceof DefaultManagedConfigElement) {
                    IManagedConfigElementProvider iManagedConfigElementProvider = ManagedBuildManager.createConfigProvider((DefaultManagedConfigElement)iManagedConfigElement);
                    IManagedConfigElement[] iManagedConfigElementArray2 = iManagedConfigElementProvider.getConfigElements();
                    ManagedBuildManager.loadConfigElements(iManagedConfigElementArray2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
    }

    public static void createBuildInfo(IResource iResource) {
        ManagedBuildInfo managedBuildInfo = new ManagedBuildInfo(iResource);
        try {
            iResource.setSessionProperty(buildInfoProperty, (Object)managedBuildInfo);
        }
        catch (CoreException coreException) {
            managedBuildInfo = null;
        }
    }

    private static IManagedConfigElementProvider createConfigProvider(DefaultManagedConfigElement defaultManagedConfigElement) throws CoreException {
        return (IManagedConfigElementProvider)defaultManagedConfigElement.getConfigurationElement().createExecutableExtension("class");
    }

    public static boolean manages(IResource iResource) {
        IProject iProject = null;
        if (iResource instanceof IProject) {
            iProject = (IProject)iResource;
        } else if (iResource instanceof IFile) {
            iProject = ((IFile)iResource).getProject();
        } else {
            return false;
        }
        IFile iFile = iProject.getFile(SETTINGS_FILE_NAME);
        if (iFile.exists()) {
            try {
                InputStream inputStream = iFile.getContents();
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = documentBuilder.parse(inputStream);
                NodeList nodeList = document.getElementsByTagName(ROOT_NODE_NAME);
                return nodeList.getLength() > 0;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private static ManagedBuildInfo findBuildInfo(IResource iResource) {
        if (iResource == null) {
            return null;
        }
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException buildException) {
            buildException.printStackTrace();
            return null;
        }
        ManagedBuildInfo managedBuildInfo = null;
        try {
            managedBuildInfo = (ManagedBuildInfo)iResource.getSessionProperty(buildInfoProperty);
            if (managedBuildInfo != null) {
                managedBuildInfo.updateOwner(iResource);
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        if (managedBuildInfo == null && iResource instanceof IProject) {
            managedBuildInfo = ManagedBuildManager.loadBuildInfo((IProject)iResource);
            try {
                ManagedBuildManager.initBuildInfoContainer(managedBuildInfo);
            }
            catch (CoreException coreException) {}
        }
        return managedBuildInfo;
    }

    public static IManagedBuildInfo getBuildInfo(IResource iResource) {
        return ManagedBuildManager.findBuildInfo((IResource)iResource.getProject());
    }

    public static PluginVersionIdentifier getBuildInfoVersion() {
        return buildInfoVersion;
    }

    private static Map getBuildModelListeners() {
        if (buildModelListeners == null) {
            buildModelListeners = new HashMap();
        }
        return buildModelListeners;
    }

    public IScannerInfo getScannerInformation(IResource iResource) {
        return (IScannerInfo)ManagedBuildManager.getBuildInfo((IResource)iResource.getProject());
    }

    public synchronized void subscribe(IResource iResource, IScannerInfoChangeListener iScannerInfoChangeListener) {
        IResource iResource2 = null;
        if (iResource instanceof IProject) {
            iResource2 = iResource;
        } else if (iResource instanceof IFile) {
            iResource2 = ((IFile)iResource).getProject();
        } else {
            return;
        }
        Map map = ManagedBuildManager.getBuildModelListeners();
        ArrayList<IScannerInfoChangeListener> arrayList = (ArrayList<IScannerInfoChangeListener>)map.get(iResource2);
        if (arrayList == null) {
            arrayList = new ArrayList<IScannerInfoChangeListener>();
        }
        if (!arrayList.contains(iScannerInfoChangeListener)) {
            arrayList.add(iScannerInfoChangeListener);
            map.put(iResource2, arrayList);
        }
    }

    public synchronized void unsubscribe(IResource iResource, IScannerInfoChangeListener iScannerInfoChangeListener) {
        IResource iResource2 = null;
        if (iResource instanceof IProject) {
            iResource2 = iResource;
        } else if (iResource instanceof IFile) {
            iResource2 = ((IFile)iResource).getProject();
        } else {
            return;
        }
        Map map = ManagedBuildManager.getBuildModelListeners();
        List list = (List)map.get(iResource2);
        if (list != null && !list.isEmpty()) {
            list.remove(iScannerInfoChangeListener);
            map.put(iResource2, list);
        }
    }

    private static Map getConfigElementMap() {
        if (configElementMap == null) {
            configElementMap = new HashMap();
        }
        return configElementMap;
    }

    public static void putConfigElement(IBuildObject iBuildObject, IManagedConfigElement iManagedConfigElement) {
        ManagedBuildManager.getConfigElementMap().put(iBuildObject, iManagedConfigElement);
    }

    public static IManagedConfigElement getConfigElement(IBuildObject iBuildObject) {
        return (IManagedConfigElement)ManagedBuildManager.getConfigElementMap().get(iBuildObject);
    }
}

