/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.OptionReference;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Configuration
extends BuildObject
implements IConfiguration {
    private boolean isDirty = false;
    private IConfiguration parent;
    private boolean rebuildNeeded = false;
    private boolean resolved = true;
    private ITarget target;
    private List toolReferences;

    public Configuration(Target target, Element element) {
        Object object;
        this.target = target;
        this.setId(element.getAttribute("id"));
        target.addConfiguration(this);
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        if (element.hasAttribute("parent")) {
            object = target.getParent();
            this.parent = object != null ? object.getConfiguration(element.getAttribute("parent")) : null;
        }
        object = element.getChildNodes();
        int n = 0;
        while (n < object.getLength()) {
            Node node = object.item(n);
            if (node.getNodeName().equals("toolReference")) {
                new ToolReference((BuildObject)this, (Element)node);
            }
            ++n;
        }
    }

    public Configuration(Target target, IConfiguration iConfiguration, String string) {
        this.id = string;
        this.name = iConfiguration.getName();
        this.target = target;
        this.parent = iConfiguration.getParent() == null ? iConfiguration : iConfiguration.getParent();
        IProject cfr_ignored_0 = (IProject)target.getOwner();
        Vector vector = new Vector(target.getLocalToolReferences());
        vector.addAll(((Configuration)iConfiguration).getLocalToolReferences());
        ListIterator listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            ToolReference toolReference = (ToolReference)listIterator.next();
            ITool iTool = toolReference.getTool();
            ToolReference toolReference2 = new ToolReference((BuildObject)this, iTool);
            String string2 = toolReference.getToolCommand();
            if (!string2.equals(iTool.getToolCommand())) {
                toolReference2.setToolCommand(string2);
            }
            List list = toolReference.getOptionReferenceList();
            ListIterator listIterator2 = list.listIterator();
            while (listIterator2.hasNext()) {
                OptionReference optionReference = (OptionReference)listIterator2.next();
                IOption iOption = optionReference.getOption();
                try {
                    switch (iOption.getValueType()) {
                        case 0: {
                            new OptionReference(toolReference2, iOption).setValue(optionReference.getBooleanValue());
                            break;
                        }
                        case 2: {
                            new OptionReference(toolReference2, iOption).setValue(optionReference.getStringValue());
                            break;
                        }
                        case 1: {
                            new OptionReference(toolReference2, iOption).setValue(optionReference.getSelectedEnum());
                            break;
                        }
                        case 3: {
                            new OptionReference(toolReference2, iOption).setValue(optionReference.getStringListValue());
                            break;
                        }
                        case 4: {
                            new OptionReference(toolReference2, iOption).setValue(optionReference.getIncludePaths());
                            break;
                        }
                        case 5: {
                            new OptionReference(toolReference2, iOption).setValue(optionReference.getDefinedSymbols());
                            break;
                        }
                        case 6: {
                            new OptionReference(toolReference2, iOption).setValue(optionReference.getLibraries());
                            break;
                        }
                        case 7: {
                            new OptionReference(toolReference2, iOption).setValue(optionReference.getUserObjects());
                        }
                    }
                }
                catch (BuildException buildException) {}
            }
        }
        target.addConfiguration(this);
    }

    public Configuration(Target target, IManagedConfigElement iManagedConfigElement) {
        this.target = target;
        ManagedBuildManager.putConfigElement(this, iManagedConfigElement);
        this.resolved = false;
        this.setId(iManagedConfigElement.getAttribute("id"));
        target.addConfiguration(this);
        this.setName(iManagedConfigElement.getAttribute("name"));
        IManagedConfigElement[] iManagedConfigElementArray = iManagedConfigElement.getChildren();
        int n = 0;
        while (n < iManagedConfigElementArray.length) {
            IManagedConfigElement iManagedConfigElement2 = iManagedConfigElementArray[n];
            if (iManagedConfigElement2.getName().equals("toolReference")) {
                new ToolReference((BuildObject)this, iManagedConfigElement2);
            }
            ++n;
        }
    }

    public Configuration(Target target, String string) {
        this.id = string;
        this.target = target;
        target.addConfiguration(this);
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            Iterator iterator = this.getLocalToolReferences().iterator();
            while (iterator.hasNext()) {
                ToolReference toolReference = (ToolReference)iterator.next();
                toolReference.resolveReferences();
            }
        }
    }

    public void addToolReference(ToolReference toolReference) {
        this.getLocalToolReferences().add(toolReference);
    }

    private OptionReference createOptionReference(IOption iOption) {
        ToolReference toolReference = null;
        ToolReference toolReference2 = null;
        if (iOption instanceof OptionReference) {
            OptionReference optionReference = (OptionReference)iOption;
            toolReference = optionReference.getToolReference();
            if (toolReference.ownedByConfiguration(this)) {
                return optionReference;
            }
            toolReference2 = this.findLocalReference(toolReference);
            if (toolReference2 == null) {
                toolReference2 = new ToolReference((BuildObject)this, toolReference);
            }
            return toolReference2.createOptionReference(iOption);
        }
        toolReference = (ToolReference)this.getToolReference(iOption.getTool());
        toolReference2 = toolReference == null ? new ToolReference((BuildObject)this, iOption.getTool()) : (!toolReference.ownedByConfiguration(this) ? new ToolReference((BuildObject)this, toolReference) : toolReference);
        return toolReference2.createOptionReference(iOption);
    }

    private ToolReference findLocalReference(ToolReference toolReference) {
        Iterator iterator = this.getLocalToolReferences().iterator();
        while (iterator.hasNext()) {
            ToolReference toolReference2 = (ToolReference)iterator.next();
            if (!toolReference.getTool().equals(toolReference2.getTool())) continue;
            return toolReference2;
        }
        return null;
    }

    public ITool[] getFilteredTools(IProject iProject) {
        ITool[] iToolArray = this.getTools();
        Vector<ITool> vector = new Vector<ITool>(iToolArray.length);
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            try {
                switch (iTool.getNatureFilter()) {
                    case 0: {
                        if (iProject.hasNature("org.eclipse.cdt.core.cnature") && !iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                            vector.add(iTool);
                        }
                        break;
                    }
                    case 1: {
                        if (iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                            vector.add(iTool);
                        }
                        break;
                    }
                    case 2: {
                        vector.add(iTool);
                        break;
                    }
                }
            }
            catch (CoreException coreException) {}
            ++n;
        }
        return vector.toArray(new ITool[vector.size()]);
    }

    protected List getLocalToolReferences() {
        if (this.toolReferences == null) {
            this.toolReferences = new ArrayList();
        }
        return this.toolReferences;
    }

    public String getName() {
        return this.name == null && this.parent != null ? this.parent.getName() : this.name;
    }

    public ITool[] getTools() {
        ITool[] iToolArray = this.parent != null ? this.parent.getTools() : this.target.getTools();
        IProject iProject = (IProject)this.target.getOwner();
        if (iProject != null) {
            ArrayList<ITool> arrayList = new ArrayList<ITool>();
            int n = 0;
            while (n < iToolArray.length) {
                ITool iTool = iToolArray[n];
                switch (iTool.getNatureFilter()) {
                    case 0: {
                        try {
                            if (!iProject.hasNature("org.eclipse.cdt.core.cnature") || iProject.hasNature("org.eclipse.cdt.core.ccnature")) break;
                            arrayList.add(iTool);
                        }
                        catch (CoreException coreException) {}
                        break;
                    }
                    case 1: {
                        try {
                            if (!iProject.hasNature("org.eclipse.cdt.core.ccnature")) break;
                            arrayList.add(iTool);
                        }
                        catch (CoreException coreException) {}
                        break;
                    }
                    case 2: {
                        arrayList.add(iTool);
                    }
                }
                ++n;
            }
            iToolArray = arrayList.toArray(new ITool[arrayList.size()]);
        }
        int n = 0;
        while (n < iToolArray.length) {
            IToolReference iToolReference = this.getToolReference(iToolArray[n]);
            if (iToolReference != null) {
                iToolArray[n] = iToolReference;
            }
            ++n;
        }
        return iToolArray;
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        ListIterator listIterator = this.getLocalToolReferences().listIterator();
        while (listIterator.hasNext()) {
            IToolReference iToolReference = (IToolReference)listIterator.next();
            if (!iToolReference.isDirty()) continue;
            return true;
        }
        return this.isDirty;
    }

    public boolean needsRebuild() {
        return this.rebuildNeeded;
    }

    public IConfiguration getParent() {
        return this.parent;
    }

    protected List getOptionReferences(ITool iTool) {
        ArrayList<OptionReference> arrayList = new ArrayList<OptionReference>();
        IToolReference iToolReference = this.getToolReference(iTool);
        if (iToolReference != null) {
            arrayList.addAll(iToolReference.getOptionReferenceList());
        }
        if (this.parent != null) {
            List list = ((Configuration)this.parent).getOptionReferences(iTool);
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                OptionReference optionReference = (OptionReference)listIterator.next();
                if (arrayList.contains(optionReference)) continue;
                arrayList.add(optionReference);
            }
        }
        return arrayList;
    }

    public ITool getToolById(String string) {
        ITool[] iToolArray = this.parent != null ? this.parent.getTools() : this.target.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            IToolReference iToolReference = this.getToolReference(iToolArray[n]);
            if (iToolReference != null) {
                iToolArray[n] = iToolReference;
            }
            ++n;
        }
        n = iToolArray.length - 1;
        while (n >= 0) {
            if (iToolArray[n].getId().equals(string)) {
                return iToolArray[n];
            }
            --n;
        }
        return null;
    }

    public ITarget getTarget() {
        return this.target == null && this.parent != null ? this.parent.getTarget() : this.target;
    }

    public IResource getOwner() {
        return this.getTarget().getOwner();
    }

    private IToolReference getToolReference(ITool iTool) {
        Object object;
        if (iTool == null) {
            return null;
        }
        ListIterator listIterator = this.getLocalToolReferences().listIterator();
        while (listIterator.hasNext()) {
            object = (ToolReference)listIterator.next();
            if (!((ToolReference)object).references(iTool)) continue;
            return object;
        }
        object = this.target.getTools();
        int n = ((ITool[])object).length - 1;
        while (n >= 0) {
            Object object2 = object[n];
            if (object2 instanceof ToolReference && ((ToolReference)object2).references(iTool)) {
                return (ToolReference)object2;
            }
            --n;
        }
        return null;
    }

    public void reset(IManagedConfigElement iManagedConfigElement) {
        this.getLocalToolReferences().clear();
        IManagedConfigElement[] iManagedConfigElementArray = iManagedConfigElement.getChildren();
        int n = 0;
        while (n < iManagedConfigElementArray.length) {
            IManagedConfigElement iManagedConfigElement2 = iManagedConfigElementArray[n];
            if (iManagedConfigElement2.getName().equals("toolReference")) {
                ToolReference toolReference = new ToolReference((BuildObject)this, iManagedConfigElement2);
                toolReference.resolveReferences();
            }
            ++n;
        }
        this.isDirty = true;
    }

    public void serialize(Document document, Element element) {
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.parent != null) {
            element.setAttribute("parent", this.parent.getId());
        }
        ListIterator listIterator = this.getLocalToolReferences().listIterator();
        while (listIterator.hasNext()) {
            ToolReference toolReference = (ToolReference)listIterator.next();
            Element element2 = document.createElement("toolReference");
            element.appendChild(element2);
            toolReference.serialize(document, element2);
        }
        this.isDirty = false;
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
        ListIterator listIterator = this.getLocalToolReferences().listIterator();
        while (listIterator.hasNext()) {
            ((ToolReference)listIterator.next()).setDirty(bl);
        }
    }

    public void setOption(IOption iOption, boolean bl) throws BuildException {
        if (iOption.getBooleanValue() != bl) {
            this.createOptionReference(iOption).setValue(bl);
            this.isDirty = true;
            this.rebuildNeeded = true;
        }
    }

    public void setOption(IOption iOption, String string) throws BuildException {
        String string2 = iOption.getValueType() == 1 ? iOption.getSelectedEnum() : iOption.getStringValue();
        if (string2 != null && !string2.equals(string)) {
            this.createOptionReference(iOption).setValue(string);
            this.isDirty = true;
            this.rebuildNeeded = true;
        }
    }

    public void setOption(IOption iOption, String[] stringArray) throws BuildException {
        Object[] objectArray;
        switch (iOption.getValueType()) {
            case 3: {
                objectArray = iOption.getStringListValue();
                break;
            }
            case 4: {
                objectArray = iOption.getIncludePaths();
                break;
            }
            case 5: {
                objectArray = iOption.getDefinedSymbols();
                break;
            }
            case 6: {
                objectArray = iOption.getLibraries();
                break;
            }
            case 7: {
                objectArray = iOption.getUserObjects();
                break;
            }
            default: {
                objectArray = new String[]{};
            }
        }
        if (!Arrays.equals(stringArray, objectArray)) {
            this.createOptionReference(iOption).setValue(stringArray);
            this.isDirty = true;
            this.rebuildNeeded = true;
        }
    }

    public void setRebuildState(boolean bl) {
        this.rebuildNeeded = bl;
    }

    public void setToolCommand(ITool iTool, String string) {
        if (string != null) {
            IToolReference iToolReference = this.getToolReference(iTool);
            if (iToolReference == null) {
                iToolReference = new ToolReference((BuildObject)this, iTool);
            }
            if (iToolReference != null) {
                this.rebuildNeeded = this.isDirty = iToolReference.setToolCommand(string);
            }
        }
    }
}

