/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;

public class GeneratedMakefileBuilder
extends ACBuilder {
    private static final String BUILD_ERROR = "ManagedMakeBuilder.message.error";
    private static final String BUILD_FINISHED = "ManagedMakeBuilder.message.finished";
    private static final String CONSOLE_HEADER = "ManagedMakeBuilder.message.console.header";
    private static final String ERROR_HEADER = "GeneratedmakefileBuilder error [";
    private static final String MAKE = "ManagedMakeBuilder.message.make";
    private static final String MARKERS = "ManagedMakeBuilder.message.creating.markers";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String NOTHING_BUILT = "ManagedMakeBuilder.message.no.build";
    private static final String REFRESH = "ManagedMakeBuilder.message.updating";
    private static final String REFRESH_ERROR = "ManagedMakeBuilder.message.error.refresh";
    private static final String TRACE_FOOTER = "]: ";
    private static final String TRACE_HEADER = "GeneratedmakefileBuilder trace [";
    private static final String TYPE_CLEAN = "ManagedMakeBuilder.type.clean";
    private static final String TYPE_FULL = "ManagedMakeBuilder.type.full";
    private static final String TYPE_INC = "ManagedMakeBuider.type.incremental";
    public static boolean VERBOSE = false;
    private IConsole console;
    protected Vector generationProblems;
    protected IProject[] referencedProjects;
    protected List resourcesToBuild;
    protected List ruleList;

    public static void outputTrace(String string, String string2) {
        if (VERBOSE) {
            System.out.println(TRACE_HEADER + string + TRACE_FOOTER + string2 + NEWLINE);
        }
    }

    public static void outputError(String string, String string2) {
        if (VERBOSE) {
            System.err.println(ERROR_HEADER + string + TRACE_FOOTER + string2 + NEWLINE);
        }
    }

    private void addBuilderMarkers(ErrorParserManager errorParserManager) {
        IWorkspaceRoot iWorkspaceRoot = CCorePlugin.getWorkspace().getRoot();
        Iterator iterator = this.getGenerationProblems().iterator();
        while (iterator.hasNext()) {
            IStatus iStatus = (IStatus)iterator.next();
            IResource iResource = iWorkspaceRoot.findMember(iStatus.getMessage());
            if (iStatus.getCode() != 0) continue;
            errorParserManager.generateMarker(iResource, -1, ManagedMakeMessages.getResourceString("MakefileGenerator.error.spaces"), 1, null);
        }
    }

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        this.referencedProjects = this.getProject().getReferencedProjects();
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        if (iManagedBuildInfo == null) {
            GeneratedMakefileBuilder.outputError(this.getProject().getName(), "Build information was not found");
            return this.referencedProjects;
        }
        String string = iManagedBuildInfo.getDefaultTarget().getParent().getId();
        IManagedBuilderMakefileGenerator iManagedBuilderMakefileGenerator = ManagedBuildManager.getMakefileGenerator(string);
        iManagedBuilderMakefileGenerator.initialize(this.getProject(), iManagedBuildInfo, iProgressMonitor);
        if (n == 6 || iManagedBuildInfo.needsRebuild()) {
            GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Full build needed/requested");
            this.fullBuild(iManagedBuildInfo, iManagedBuilderMakefileGenerator, iProgressMonitor);
        } else if (n == 9 && iManagedBuildInfo.needsRebuild()) {
            GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Autobuild requested, full build needed");
            this.fullBuild(iManagedBuildInfo, iManagedBuilderMakefileGenerator, iProgressMonitor);
        } else {
            ResourceDeltaVisitor resourceDeltaVisitor = new ResourceDeltaVisitor(iManagedBuildInfo);
            IResourceDelta iResourceDelta = this.getDelta(this.getProject());
            if (iResourceDelta == null) {
                GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Incremental build requested, full build needed");
                this.fullBuild(iManagedBuildInfo, iManagedBuilderMakefileGenerator, iProgressMonitor);
            } else {
                iResourceDelta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
                if (resourceDeltaVisitor.shouldBuild()) {
                    GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Incremental build requested");
                    this.incrementalBuild(iResourceDelta, iManagedBuildInfo, iManagedBuilderMakefileGenerator, iProgressMonitor);
                }
            }
        }
        iManagedBuildInfo.setRebuildState(false);
        return this.referencedProjects;
    }

    public void checkCancel(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Build cancelled");
            this.forgetLastBuiltState();
            throw new OperationCanceledException();
        }
    }

    protected void clean(IProgressMonitor iProgressMonitor) throws CoreException {
        this.referencedProjects = this.getProject().getReferencedProjects();
        GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Clean build requested");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        if (iManagedBuildInfo == null) {
            GeneratedMakefileBuilder.outputError(this.getProject().getName(), "Build information was not found");
            return;
        }
        IPath iPath = this.getProject().getLocation().append(iManagedBuildInfo.getConfigurationName());
        IWorkspace iWorkspace = CCorePlugin.getWorkspace();
        IContainer iContainer = iWorkspace.getRoot().getContainerForLocation(iPath);
        if (iContainer == null || !iContainer.isAccessible()) {
            GeneratedMakefileBuilder.outputError(iContainer.getName(), "Could not delete the build directory");
            return;
        }
        try {
            String string = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.clean.deleting.output", iContainer.getName());
            iProgressMonitor.subTask(string);
            iWorkspace.delete(new IResource[]{iContainer}, true, iProgressMonitor);
        }
        catch (CoreException coreException) {
            String string = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.clean.build.clean", iContainer.getName());
            iProgressMonitor.subTask(string);
            String string2 = iManagedBuildInfo.getDefaultTarget().getParent().getId();
            IManagedBuilderMakefileGenerator iManagedBuilderMakefileGenerator = ManagedBuildManager.getMakefileGenerator(string2);
            iManagedBuilderMakefileGenerator.initialize(this.getProject(), iManagedBuildInfo, iProgressMonitor);
            this.cleanBuild(iManagedBuildInfo, iManagedBuilderMakefileGenerator, iProgressMonitor);
        }
    }

    protected void cleanBuild(IManagedBuildInfo iManagedBuildInfo, IManagedBuilderMakefileGenerator iManagedBuilderMakefileGenerator, IProgressMonitor iProgressMonitor) {
        IPath iPath = iManagedBuilderMakefileGenerator.getBuildWorkingDir();
        if (iPath == null) {
            iPath = new Path(iManagedBuildInfo.getConfigurationName());
        }
        IPath iPath2 = this.getProject().getLocation().append(iPath.append(iManagedBuilderMakefileGenerator.getMakefileName()));
        IWorkspaceRoot iWorkspaceRoot = CCorePlugin.getWorkspace().getRoot();
        IFile iFile = iWorkspaceRoot.getFileForLocation(iPath2);
        if (iPath != null && iFile != null && iFile.isAccessible()) {
            String string = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.starting", this.getProject().getName());
            iProgressMonitor.subTask(string);
            this.checkCancel(iProgressMonitor);
            this.invokeMake(15, iPath, iManagedBuildInfo, iManagedBuilderMakefileGenerator, iProgressMonitor);
        }
    }

    protected void fullBuild(IManagedBuildInfo iManagedBuildInfo, IManagedBuilderMakefileGenerator iManagedBuilderMakefileGenerator, IProgressMonitor iProgressMonitor) throws CoreException {
        IPath iPath;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        this.checkCancel(iProgressMonitor);
        String string = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.rebuild.makefiles", this.getProject().getName());
        iProgressMonitor.subTask(string);
        String string2 = iManagedBuildInfo.getDefaultTarget().getParent().getId();
        iManagedBuilderMakefileGenerator = ManagedBuildManager.getMakefileGenerator(string2);
        iManagedBuilderMakefileGenerator.initialize(this.getProject(), iManagedBuildInfo, iProgressMonitor);
        MultiStatus multiStatus = iManagedBuilderMakefileGenerator.regenerateMakefiles();
        if (multiStatus.getCode() == 2 || multiStatus.getCode() == 1) {
            iPath = multiStatus.getChildren();
            int n = 0;
            while (n < ((IStatus[])iPath).length) {
                IStatus iStatus = iPath[n];
                if (iStatus.getCode() == 1) {
                    return;
                }
                this.getGenerationProblems().add(iStatus);
                ++n;
            }
        }
        this.checkCancel(iProgressMonitor);
        string = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.starting", this.getProject().getName());
        iProgressMonitor.subTask(string);
        iPath = iManagedBuilderMakefileGenerator.getBuildWorkingDir();
        if (iPath == null) {
            string = ManagedMakeMessages.getFormattedString(NOTHING_BUILT, this.getProject().getName());
            iProgressMonitor.subTask(string);
            return;
        }
        this.invokeMake(6, iPath, iManagedBuildInfo, iManagedBuilderMakefileGenerator, iProgressMonitor);
        this.checkCancel(iProgressMonitor);
        string = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.regen.deps", this.getProject().getName());
        iProgressMonitor.subTask(string);
        iManagedBuilderMakefileGenerator.regenerateDependencies(false);
        string = ManagedMakeMessages.getFormattedString(BUILD_FINISHED, this.getProject().getName());
        iProgressMonitor.subTask(string);
    }

    public IManagedDependencyGenerator getDependencyCalculator(String string) {
        try {
            IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ManagedBuilderCorePlugin.getUniqueIdentifier(), "dependencyCalculator");
            if (iExtensionPoint != null) {
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                int n = 0;
                while (n < iExtensionArray.length) {
                    IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                    int n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                        if (iConfigurationElement.getName().equals("tool") && iConfigurationElement.getAttribute("id").equals(string) && iConfigurationElement.getAttribute("dependencyCalculator") != null) {
                            return (IManagedDependencyGenerator)iConfigurationElement.createExecutableExtension("dependencyCalculator");
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    private Vector getGenerationProblems() {
        if (this.generationProblems == null) {
            this.generationProblems = new Vector();
        }
        return this.generationProblems;
    }

    protected String[] getMakeTargets(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (n) {
            case 15: {
                arrayList.add("clean");
                break;
            }
            case 6: {
                arrayList.add("clean");
            }
            case 10: {
                arrayList.add("all");
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected List getResourcesToBuild() {
        if (this.resourcesToBuild == null) {
            this.resourcesToBuild = new ArrayList();
        }
        return this.resourcesToBuild;
    }

    protected List getRuleList() {
        if (this.ruleList == null) {
            this.ruleList = new ArrayList();
        }
        return this.ruleList;
    }

    public IPath getWorkingDirectory() {
        return this.getProject().getLocation();
    }

    protected void incrementalBuild(IResourceDelta iResourceDelta, IManagedBuildInfo iManagedBuildInfo, IManagedBuilderMakefileGenerator iManagedBuilderMakefileGenerator, IProgressMonitor iProgressMonitor) throws CoreException {
        Path path;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        this.checkCancel(iProgressMonitor);
        String string = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.update.makefiles", this.getProject().getName());
        iProgressMonitor.subTask(string);
        MultiStatus multiStatus = iManagedBuilderMakefileGenerator.generateMakefiles(iResourceDelta);
        if (multiStatus.getCode() == 2 || multiStatus.getCode() == 1) {
            path = multiStatus.getChildren();
            int n = 0;
            while (n < ((IStatus[])path).length) {
                IStatus iStatus = path[n];
                if (iStatus.getCode() == 1) {
                    return;
                }
                this.getGenerationProblems().add(iStatus);
                ++n;
            }
        }
        this.checkCancel(iProgressMonitor);
        string = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.starting", this.getProject().getName());
        iProgressMonitor.subTask(string);
        path = new Path(iManagedBuildInfo.getConfigurationName());
        if (path == null) {
            string = ManagedMakeMessages.getFormattedString(NOTHING_BUILT, this.getProject().getName());
            iProgressMonitor.subTask(string);
            return;
        }
        this.invokeMake(10, (IPath)path, iManagedBuildInfo, iManagedBuilderMakefileGenerator, iProgressMonitor);
        this.checkCancel(iProgressMonitor);
        string = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.updating.deps", this.getProject().getName());
        iProgressMonitor.subTask(string);
        iManagedBuilderMakefileGenerator.generateDependencies();
        string = ManagedMakeMessages.getFormattedString(BUILD_FINISHED, this.getProject().getName());
        iProgressMonitor.subTask(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void invokeMake(int n, IPath iPath, IManagedBuildInfo iManagedBuildInfo, IManagedBuilderMakefileGenerator iManagedBuilderMakefileGenerator, IProgressMonitor iProgressMonitor) {
        block33: {
            block32: {
                block31: {
                    IProject iProject = this.getProject();
                    if (iProgressMonitor == null) {
                        iProgressMonitor = new NullProgressMonitor();
                    }
                    try {
                        try {
                            String[] stringArray;
                            String[] stringArray2;
                            ArrayList<String> arrayList;
                            ConsoleOutputStream consoleOutputStream;
                            StringBuffer stringBuffer;
                            Path path;
                            IPath iPath2;
                            block34: {
                                int n2;
                                iPath2 = this.getWorkingDirectory().append(iPath);
                                IWorkspace iWorkspace = iProject.getWorkspace();
                                if (iWorkspace == null) {
                                    Object var32_9 = null;
                                    this.getGenerationProblems().clear();
                                    return;
                                }
                                IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
                                if (iWorkspaceRoot == null) {
                                    break block31;
                                }
                                IPath iPath3 = iPath2.addTrailingSeparator().append(iManagedBuilderMakefileGenerator.getMakefileName());
                                if (iWorkspaceRoot.getFileForLocation(iPath3) == null) {
                                    break block32;
                                }
                                path = new Path(iManagedBuildInfo.getMakeCommand());
                                if (path == null) break block33;
                                String[] stringArray3 = new String[]{path.toString(), iProject.getName()};
                                iProgressMonitor.subTask(ManagedMakeMessages.getFormattedString(MAKE, stringArray3));
                                stringBuffer = new StringBuffer();
                                consoleOutputStream = this.getConsole().getOutputStream();
                                String[] stringArray4 = new String[3];
                                switch (n) {
                                    case 6: {
                                        stringArray4[0] = ManagedMakeMessages.getResourceString(TYPE_FULL);
                                        break;
                                    }
                                    case 10: {
                                        stringArray4[0] = ManagedMakeMessages.getResourceString(TYPE_INC);
                                        break;
                                    }
                                    case 15: {
                                        stringArray4[0] = ManagedMakeMessages.getResourceString(TYPE_CLEAN);
                                        break;
                                    }
                                }
                                stringArray4[1] = iManagedBuildInfo.getConfigurationName();
                                stringArray4[2] = iProject.getName();
                                stringBuffer.append(System.getProperty("line.separator", "\n"));
                                stringBuffer.append(ManagedMakeMessages.getFormattedString(CONSOLE_HEADER, stringArray4));
                                stringBuffer.append(System.getProperty("line.separator", "\n"));
                                stringBuffer.append(System.getProperty("line.separator", "\n"));
                                consoleOutputStream.write(stringBuffer.toString().getBytes());
                                consoleOutputStream.flush();
                                this.removeAllMarkers(iProject);
                                int n3 = 0;
                                while (true) {
                                    Object object;
                                    if (n3 >= this.referencedProjects.length) {
                                        arrayList = new ArrayList<String>();
                                        object = iManagedBuildInfo.getMakeArguments();
                                        if (((String)object).length() > 0) {
                                            stringArray2 = ((String)object).split("\\s");
                                            n2 = 0;
                                            break;
                                        }
                                        break block34;
                                    }
                                    object = this.referencedProjects[n3];
                                    this.removeAllMarkers((IProject)object);
                                    ++n3;
                                }
                                while (n2 < stringArray2.length) {
                                    arrayList.add(stringArray2[n2]);
                                    ++n2;
                                }
                            }
                            arrayList.addAll(Arrays.asList(this.getMakeTargets(n)));
                            stringArray2 = arrayList.toArray(new String[arrayList.size()]);
                            String string = null;
                            CommandLauncher commandLauncher = new CommandLauncher();
                            commandLauncher.showCommand(true);
                            Properties properties = commandLauncher.getEnvironment();
                            properties.put("CWD", iPath2.toOSString());
                            properties.put("PWD", iPath2.toOSString());
                            String[] stringArray5 = null;
                            ArrayList<String> arrayList2 = new ArrayList<String>();
                            Enumeration<?> enumeration = properties.propertyNames();
                            if (enumeration != null) {
                                while (true) {
                                    if (!enumeration.hasMoreElements()) {
                                        stringArray5 = arrayList2.toArray(new String[arrayList2.size()]);
                                        break;
                                    }
                                    stringArray = (String)enumeration.nextElement();
                                    arrayList2.add(String.valueOf(stringArray) + "=" + properties.getProperty((String)stringArray));
                                }
                            }
                            stringArray = iManagedBuildInfo.getDefaultTarget().getErrorParserList();
                            ErrorParserManager errorParserManager = new ErrorParserManager(this.getProject(), iPath2, (IMarkerGenerator)this, stringArray);
                            errorParserManager.setOutputStream((OutputStream)consoleOutputStream);
                            OutputStream outputStream = errorParserManager.getOutputStream();
                            OutputStream outputStream2 = errorParserManager.getOutputStream();
                            Process process = commandLauncher.execute((IPath)path, stringArray2, stringArray5, iPath2);
                            if (process != null) {
                                try {
                                    process.getOutputStream().close();
                                }
                                catch (IOException iOException) {}
                                if (commandLauncher.waitAndRead(outputStream, outputStream2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, -1)) != 0) {
                                    string = commandLauncher.getErrorMessage();
                                }
                                iProgressMonitor.subTask(ManagedMakeMessages.getResourceString(REFRESH));
                                try {
                                    iProject.refreshLocal(2, null);
                                    int n4 = 0;
                                    while (n4 < this.referencedProjects.length) {
                                        IProject iProject2 = this.referencedProjects[n4];
                                        iProject2.refreshLocal(2, null);
                                        ++n4;
                                    }
                                }
                                catch (CoreException coreException) {
                                    iProgressMonitor.subTask(ManagedMakeMessages.getResourceString(REFRESH_ERROR));
                                }
                            } else {
                                string = commandLauncher.getErrorMessage();
                            }
                            stringBuffer = new StringBuffer();
                            if (string != null && string.length() > 0) {
                                String string2 = ManagedMakeMessages.getResourceString(BUILD_ERROR);
                                stringBuffer.append(string2);
                                stringBuffer.append(System.getProperty("line.separator", "\n"));
                                stringBuffer.append("(").append(string).append(")");
                            } else {
                                String string3 = ManagedMakeMessages.getFormattedString(BUILD_FINISHED, iProject.getName());
                                stringBuffer.append(string3);
                                stringBuffer.append(System.getProperty("line.separator", "\n"));
                            }
                            consoleOutputStream.write(stringBuffer.toString().getBytes());
                            consoleOutputStream.flush();
                            outputStream.close();
                            outputStream2.close();
                            iProgressMonitor.subTask(ManagedMakeMessages.getResourceString(MARKERS));
                            this.addBuilderMarkers(errorParserManager);
                            errorParserManager.reportProblems();
                        }
                        catch (Exception exception) {
                            this.forgetLastBuiltState();
                        }
                        break block33;
                    }
                    catch (Throwable throwable) {
                        Object var32_12 = null;
                        this.getGenerationProblems().clear();
                        throw throwable;
                    }
                }
                Object var32_10 = null;
                this.getGenerationProblems().clear();
                return;
            }
            Object var32_11 = null;
            this.getGenerationProblems().clear();
            return;
        }
        Object var32_13 = null;
        this.getGenerationProblems().clear();
    }

    private IConsole getConsole() {
        if (this.console == null) {
            this.console = CCorePlugin.getDefault().getConsole();
            this.console.start(this.getProject());
        }
        return this.console;
    }

    private void removeAllMarkers(IProject iProject) {
        IMarker[] iMarkerArray;
        if (iProject == null || !iProject.isAccessible()) {
            return;
        }
        IWorkspace iWorkspace = iProject.getWorkspace();
        try {
            iMarkerArray = iProject.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        }
        catch (CoreException coreException) {
            return;
        }
        if (iMarkerArray != null) {
            try {
                iWorkspace.deleteMarkers(iMarkerArray);
            }
            catch (CoreException coreException) {
                return;
            }
        }
    }

    public class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private String buildGoalName;
        private IManagedBuildInfo buildInfo;
        private boolean buildNeeded = true;
        private List reservedNames;

        public ResourceDeltaVisitor(IManagedBuildInfo iManagedBuildInfo) {
            this.buildInfo = iManagedBuildInfo;
            String string = this.buildInfo.getBuildArtifactExtension();
            this.buildGoalName = string.length() > 0 ? String.valueOf(this.buildInfo.getOutputPrefix(string)) + this.buildInfo.getBuildArtifactName() + "." + string : this.buildInfo.getBuildArtifactName();
            this.reservedNames = Arrays.asList(".cdtbuild", ".cdtproject", ".project");
        }

        private boolean isGeneratedResource(IResource iResource) {
            IPath iPath = iResource.getProjectRelativePath();
            String[] stringArray = this.buildInfo.getConfigurationNames();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                Path path = new Path(string);
                if (path.isPrefixOf(iPath)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private boolean isProjectFile(IResource iResource) {
            return this.reservedNames.contains(iResource.getName());
        }

        public boolean shouldBuild() {
            return this.buildNeeded;
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            IResource iResource = iResourceDelta.getResource();
            if (iResource != null && iResource.getProject() == GeneratedMakefileBuilder.this.getProject()) {
                IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
                int n = iResourceDeltaArray.length - 1;
                while (n >= 0) {
                    IResource iResource2 = iResourceDeltaArray[n].getResource();
                    if (iResource2 instanceof IFolder) {
                        return true;
                    }
                    String string = iResource2.getName();
                    String string2 = iResource2.getFileExtension();
                    if (string.equals(this.buildGoalName)) {
                        this.buildNeeded = true;
                        break;
                    }
                    if (iResource.isDerived()) {
                        this.buildNeeded |= false;
                    } else if (this.isGeneratedResource(iResource2)) {
                        this.buildNeeded |= false;
                    } else {
                        if (this.buildInfo.buildsFileType(string2) || this.buildInfo.isHeaderFile(string2)) {
                            this.buildNeeded = true;
                            break;
                        }
                        this.buildNeeded = this.isProjectFile(iResource2) ? (this.buildNeeded |= false) : true;
                    }
                    --n;
                }
                return false;
            }
            return true;
        }
    }
}

