/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.scannerconfig.ManagedBuildCPathEntryContainer;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ManagedBuildInfo
implements IManagedBuildInfo,
IScannerInfo {
    public static final IContainerEntry containerEntry = CoreModel.newContainerEntry((IPath)new Path("org.eclipse.cdt.managedbuilder.MANAGED_CONTAINER"));
    private static final QualifiedName defaultConfigProperty = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "defaultConfig");
    private static final QualifiedName defaultTargetProperty = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "defaultTarget");
    public static final String MAJOR_SEPERATOR = ";";
    public static final String MINOR_SEPERATOR = "::";
    private boolean containerCreated;
    private ICProject cProject;
    private String defaultConfigIds;
    private Map defaultConfigMap;
    private ITarget defaultTarget;
    private String defaultTargetId;
    private boolean isDirty;
    private IResource owner;
    private boolean rebuildNeeded;
    private ITarget selectedTarget;
    private List targetList;
    private Map targetMap;
    private String version;

    public ManagedBuildInfo(IResource iResource) {
        this.owner = iResource;
        this.cProject = CoreModel.getDefault().create(iResource.getProject());
        this.containerCreated = false;
        this.isDirty = false;
        this.rebuildNeeded = true;
        IProject iProject = iResource.getProject();
        this.defaultTargetId = null;
        try {
            this.defaultTargetId = iProject.getPersistentProperty(defaultTargetProperty);
        }
        catch (CoreException coreException) {
            return;
        }
        this.defaultConfigIds = null;
        try {
            this.defaultConfigIds = iProject.getPersistentProperty(defaultConfigProperty);
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public ManagedBuildInfo(IResource iResource, Element element) {
        this(iResource);
        this.containerCreated = true;
        NodeList nodeList = element.getElementsByTagName("target");
        int n = nodeList.getLength() - 1;
        while (n >= 0) {
            new Target(this, (Element)nodeList.item(n));
            --n;
        }
        this.rebuildNeeded = false;
    }

    public void addTarget(ITarget iTarget) {
        this.getTargetMap().put(iTarget.getId(), iTarget);
        this.getTargets().add(iTarget);
        this.setDirty(true);
    }

    public boolean buildsFileType(String string) {
        IProject iProject = (IProject)this.owner;
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] iToolArray = iConfiguration.getFilteredTools(iProject);
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            if (iTool != null && iTool.buildsFileType(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getBuildArtifactExtension() {
        String string = new String();
        ITarget iTarget = this.getDefaultTarget();
        if (iTarget != null) {
            string = iTarget.getArtifactExtension();
        }
        return string;
    }

    public String getBuildArtifactName() {
        String string = new String();
        ITarget iTarget = this.getDefaultTarget();
        if (iTarget != null) {
            string = iTarget.getArtifactName();
        }
        return string;
    }

    public String getCleanCommand() {
        String string = new String();
        ITarget iTarget = this.getDefaultTarget();
        if (iTarget != null) {
            string = iTarget.getCleanCommand();
        }
        return string;
    }

    public String getConfigurationName() {
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        return iConfiguration == null ? new String() : iConfiguration.getName();
    }

    public String[] getConfigurationNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        IConfiguration[] iConfigurationArray = this.getDefaultTarget().getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            IConfiguration iConfiguration = iConfigurationArray[n];
            arrayList.add(iConfiguration.getName());
            ++n;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public ICProject getCProject() {
        return this.cProject;
    }

    private Map getDefaultConfigMap() {
        if (this.defaultConfigMap == null) {
            this.defaultConfigMap = new HashMap();
            if (this.defaultConfigIds != null) {
                String[] stringArray = this.defaultConfigIds.split(MAJOR_SEPERATOR);
                int n = stringArray.length - 1;
                while (n >= 0) {
                    IConfiguration iConfiguration;
                    String[] stringArray2;
                    ITarget iTarget;
                    String string = stringArray[n];
                    if (string != null && (iTarget = this.getTarget((stringArray2 = string.split(MINOR_SEPERATOR))[0])) != null && (iConfiguration = iTarget.getConfiguration(stringArray2[1])) != null) {
                        this.defaultConfigMap.put(iTarget.getId(), iConfiguration);
                    }
                    --n;
                }
            }
        }
        return this.defaultConfigMap;
    }

    public IConfiguration getDefaultConfiguration(ITarget iTarget) {
        IConfiguration[] iConfigurationArray;
        IConfiguration iConfiguration = (IConfiguration)this.getDefaultConfigMap().get(iTarget.getId());
        if (iConfiguration == null && (iConfigurationArray = this.getDefaultTarget().getConfigurations()).length > 0) {
            iConfiguration = iConfigurationArray[0];
        }
        return iConfiguration;
    }

    public ITarget getDefaultTarget() {
        if (this.defaultTarget == null) {
            if (this.defaultTargetId != null) {
                this.defaultTarget = (ITarget)this.getTargetMap().get(this.defaultTargetId);
            }
            if (this.defaultTarget == null && this.getTargets().size() > 0) {
                return (ITarget)this.getTargets().get(0);
            }
        }
        return this.defaultTarget;
    }

    public Map getDefinedSymbols() {
        HashMap hashMap = this.getMacroPathEntries();
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] iToolArray = iConfiguration.getFilteredTools(this.owner.getProject());
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            IOption[] iOptionArray = iTool.getOptions();
            int n2 = 0;
            while (n2 < iOptionArray.length) {
                IOption iOption = iOptionArray[n2];
                if (iOption.getValueType() == 5) {
                    try {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.addAll(Arrays.asList(iOption.getDefinedSymbols()));
                        ListIterator listIterator = arrayList.listIterator();
                        while (listIterator.hasNext()) {
                            String string = (String)listIterator.next();
                            if (string.length() == 0) continue;
                            String[] stringArray = string.split("=");
                            String string2 = stringArray[0].trim();
                            String string3 = stringArray.length > 1 ? stringArray[1].trim() : new String();
                            hashMap.put(string2, string3);
                        }
                    }
                    catch (BuildException buildException) {}
                }
                ++n2;
            }
            ++n;
        }
        return hashMap;
    }

    public IManagedDependencyGenerator getDependencyGenerator(String string) {
        try {
            ITarget iTarget = this.getDefaultTarget();
            ITool[] iToolArray = this.getFilteredTools();
            int n = 0;
            while (n < iToolArray.length) {
                if (iToolArray[n].buildsFileType(string)) {
                    return iTarget.getDependencyGenerator(iToolArray[n].getId());
                }
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        return null;
    }

    private ITool[] getFilteredTools() {
        IProject iProject = this.owner.getProject();
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        return iConfiguration.getFilteredTools(iProject);
    }

    public String getFlagsForSource(String string) {
        ITool[] iToolArray = this.getFilteredTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            if (iTool != null && iTool.buildsFileType(string)) {
                try {
                    return iTool.getToolFlags();
                }
                catch (BuildException buildException) {
                    return null;
                }
            }
            ++n;
        }
        return null;
    }

    public String getFlagsForTarget(String string) {
        String string2 = string == null ? new String() : string;
        ITool[] iToolArray = this.getFilteredTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            if (iTool.producesFileType(string2)) {
                try {
                    return iTool.getToolFlags();
                }
                catch (BuildException buildException) {
                    return null;
                }
            }
            ++n;
        }
        return null;
    }

    private ArrayList getIncludePathEntries() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.cProject != null) {
            try {
                IPathEntry[] iPathEntryArray = this.cProject.getResolvedPathEntries();
                int n = 0;
                while (n < iPathEntryArray.length) {
                    IIncludeEntry iIncludeEntry;
                    int n2 = iPathEntryArray[n].getEntryKind();
                    if (n2 == 4 && (iIncludeEntry = (IIncludeEntry)iPathEntryArray[n]).isSystemInclude()) {
                        IPath iPath = iIncludeEntry.getFullIncludePath();
                        arrayList.add(iPath.toString());
                    }
                    ++n;
                }
            }
            catch (CModelException cModelException) {
                arrayList.clear();
                return arrayList;
            }
        }
        return arrayList;
    }

    public String[] getIncludePaths() {
        ArrayList arrayList = this.getIncludePathEntries();
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        IPath iPath = this.owner.getLocation();
        if (iPath == null) {
            iPath = new Path(".");
        }
        IPath iPath2 = iPath.addTrailingSeparator().append(iConfiguration.getName());
        ITool[] iToolArray = iConfiguration.getFilteredTools(this.owner.getProject());
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            IOption[] iOptionArray = iTool.getOptions();
            int n2 = 0;
            while (n2 < iOptionArray.length) {
                IOption iOption = iOptionArray[n2];
                if (iOption.getValueType() == 4) {
                    try {
                        String[] stringArray = iOption.getIncludePaths();
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            Path path = new Path(stringArray[n3]);
                            if (path.isAbsolute()) {
                                arrayList.add(path.toOSString());
                            } else {
                                IPath iPath3 = iPath2.addTrailingSeparator().append((IPath)path);
                                arrayList.add(iPath3.makeAbsolute().toOSString());
                            }
                            ++n3;
                        }
                    }
                    catch (BuildException buildException) {}
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getInputFlag(String string) {
        String string2 = string == null ? new String() : string;
        String string3 = new String();
        ITool[] iToolArray = this.getFilteredTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            if (iTool.producesFileType(string2)) {
                string3 = iTool.getInputFlag();
            }
            ++n;
        }
        return string3;
    }

    public String[] getLibsForTarget(String string) {
        Vector<String> vector = new Vector<String>();
        ITool[] iToolArray = this.getFilteredTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            if (iTool.producesFileType(string)) {
                IOption[] iOptionArray = iTool.getOptions();
                int n2 = 0;
                while (n2 < iOptionArray.length) {
                    IOption iOption = iOptionArray[n2];
                    if (iOption.getValueType() == 6) {
                        try {
                            String string2 = iOption.getCommand();
                            String[] stringArray = iOption.getLibraries();
                            int n3 = 0;
                            while (n3 < stringArray.length) {
                                String string3 = stringArray[n3];
                                vector.add(String.valueOf(string2) + string3);
                                ++n3;
                            }
                        }
                        catch (BuildException buildException) {}
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return vector.toArray(new String[vector.size()]);
    }

    private HashMap getMacroPathEntries() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.cProject != null) {
            try {
                IPathEntry[] iPathEntryArray = this.cProject.getResolvedPathEntries();
                int n = 0;
                while (n < iPathEntryArray.length) {
                    if (iPathEntryArray[n].getEntryKind() == 6) {
                        IMacroEntry iMacroEntry = (IMacroEntry)iPathEntryArray[n];
                        hashMap.put(iMacroEntry.getMacroName(), iMacroEntry.getMacroValue());
                    }
                    ++n;
                }
            }
            catch (CModelException cModelException) {
                hashMap.clear();
                return hashMap;
            }
        }
        return hashMap;
    }

    public String getMakeArguments() {
        return this.getDefaultTarget().getMakeArguments();
    }

    public String getMakeCommand() {
        return this.getDefaultTarget().getMakeCommand();
    }

    public String getOutputExtension(String string) {
        String string2 = null;
        ITool[] iToolArray = this.getFilteredTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            string2 = iTool.getOutputExtension(string);
            if (string2 != null) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    public String getOutputFlag(String string) {
        String string2 = string == null ? new String() : string;
        String string3 = new String();
        ITool[] iToolArray = this.getFilteredTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            if (iTool.producesFileType(string2)) {
                string3 = iTool.getOutputFlag();
            }
            ++n;
        }
        return string3;
    }

    public String getOutputPrefix(String string) {
        String string2 = string == null ? new String() : string;
        String string3 = new String();
        ITool[] iToolArray = this.getFilteredTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            if (iTool.producesFileType(string2)) {
                string3 = iTool.getOutputPrefix();
            }
            ++n;
        }
        return string3;
    }

    public IResource getOwner() {
        return this.owner;
    }

    public ITarget getSelectedTarget() {
        return this.selectedTarget;
    }

    public ITarget getTarget(String string) {
        return (ITarget)this.getTargetMap().get(string);
    }

    private Map getTargetMap() {
        if (this.targetMap == null) {
            this.targetMap = new HashMap();
        }
        return this.targetMap;
    }

    public List getTargets() {
        if (this.targetList == null) {
            this.targetList = new ArrayList();
        }
        return this.targetList;
    }

    public String getToolForSource(String string) {
        ITool[] iToolArray = this.getFilteredTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            if (iTool.buildsFileType(string)) {
                return iTool.getToolCommand();
            }
            ++n;
        }
        return null;
    }

    public String getToolForTarget(String string) {
        String string2 = string == null ? new String() : string;
        ITool[] iToolArray = this.getFilteredTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            if (iTool.producesFileType(string2)) {
                return iTool.getToolCommand();
            }
            ++n;
        }
        return null;
    }

    public String[] getUserObjectsForTarget(String string) {
        Vector<String> vector = new Vector<String>();
        ITool[] iToolArray = this.getFilteredTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            if (iTool.producesFileType(string)) {
                IOption[] iOptionArray = iTool.getOptions();
                int n2 = 0;
                while (n2 < iOptionArray.length) {
                    IOption iOption = iOptionArray[n2];
                    if (iOption.getValueType() == 7) {
                        try {
                            vector.addAll(Arrays.asList(iOption.getUserObjects()));
                        }
                        catch (BuildException buildException) {}
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String getVersion() {
        return this.version;
    }

    private void initializePathEntries() {
        try {
            ManagedBuildCPathEntryContainer managedBuildCPathEntryContainer = new ManagedBuildCPathEntryContainer(this.getOwner().getProject());
            CoreModel.getDefault().setPathEntryContainer(new ICProject[]{this.cProject}, (IPathEntryContainer)managedBuildCPathEntryContainer, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CModelException cModelException) {}
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        ListIterator listIterator = this.getTargets().listIterator();
        while (listIterator.hasNext()) {
            if (!((ITarget)listIterator.next()).isDirty()) continue;
            return true;
        }
        return false;
    }

    public boolean isHeaderFile(String string) {
        IProject iProject = (IProject)this.owner;
        IConfiguration iConfiguration = this.getDefaultConfiguration(this.getDefaultTarget());
        ITool[] iToolArray = iConfiguration.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            try {
                switch (iTool.getNatureFilter()) {
                    case 0: {
                        if (iProject.hasNature("org.eclipse.cdt.core.cnature") && !iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                            return iTool.isHeaderFile(string);
                        }
                        break;
                    }
                    case 1: {
                        if (!iProject.hasNature("org.eclipse.cdt.core.ccnature")) break;
                        return iTool.isHeaderFile(string);
                    }
                    case 2: {
                        return iTool.isHeaderFile(string);
                    }
                }
            }
            catch (CoreException coreException) {}
            ++n;
        }
        return false;
    }

    public boolean needsRebuild() {
        if (this.rebuildNeeded) {
            return true;
        }
        ListIterator listIterator = this.getTargets().listIterator();
        while (listIterator.hasNext()) {
            if (!((ITarget)listIterator.next()).needsRebuild()) continue;
            return true;
        }
        return false;
    }

    private void persistDefaultConfigurations() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        ListIterator listIterator = this.getTargets().listIterator();
        while (listIterator.hasNext()) {
            object = (ITarget)listIterator.next();
            IConfiguration iConfiguration = this.getDefaultConfiguration((ITarget)object);
            if (iConfiguration == null) continue;
            stringBuffer.append(object.getId());
            stringBuffer.append(MINOR_SEPERATOR);
            stringBuffer.append(iConfiguration.getId());
            stringBuffer.append(MAJOR_SEPERATOR);
        }
        object = this.owner.getProject();
        try {
            object.setPersistentProperty(defaultConfigProperty, stringBuffer.toString().trim());
        }
        catch (CoreException coreException) {}
    }

    private void persistDefaultTarget() {
        IProject iProject = this.owner.getProject();
        ITarget iTarget = this.getDefaultTarget();
        if (iTarget != null) {
            try {
                iProject.setPersistentProperty(defaultTargetProperty, iTarget.getId());
            }
            catch (CoreException coreException) {}
        }
    }

    public void removeTarget(String string) {
        this.getTargets().remove(this.getTarget(string));
        this.getTargetMap().remove(string);
        this.setDirty(true);
    }

    public void serialize(Document document, Element element) {
        ListIterator listIterator = this.getTargets().listIterator();
        while (listIterator.hasNext()) {
            Target target = (Target)listIterator.next();
            Element element2 = document.createElement("target");
            element.appendChild(element2);
            target.serialize(document, element2);
        }
        this.persistDefaultTarget();
        this.persistDefaultConfigurations();
        this.setDirty(false);
    }

    public void setContainerCreated(boolean bl) {
        this.containerCreated = bl;
    }

    public void setDefaultConfiguration(IConfiguration iConfiguration) {
        if (iConfiguration == null) {
            return;
        }
        ITarget iTarget = iConfiguration.getTarget();
        IConfiguration iConfiguration2 = this.getDefaultConfiguration(iTarget);
        if (iTarget != this.defaultTarget || iConfiguration != iConfiguration2) {
            this.setDefaultTarget(iTarget);
            this.getDefaultConfigMap().put(iTarget.getId(), iConfiguration);
            this.persistDefaultConfigurations();
        }
    }

    public boolean setDefaultConfiguration(String string) {
        if (string != null) {
            IConfiguration[] iConfigurationArray = this.getDefaultTarget().getConfigurations();
            int n = iConfigurationArray.length - 1;
            while (n >= 0) {
                IConfiguration iConfiguration = iConfigurationArray[n];
                if (string.equalsIgnoreCase(iConfiguration.getName())) {
                    this.setDefaultConfiguration(iConfiguration);
                    return true;
                }
                --n;
            }
        }
        return false;
    }

    public void setDefaultTarget(ITarget iTarget) {
        if (iTarget == null) {
            return;
        }
        if (!iTarget.equals(this.defaultTarget)) {
            this.defaultTarget = iTarget;
            this.defaultTargetId = iTarget.getId();
            this.persistDefaultTarget();
            if (this.containerCreated) {
                this.initializePathEntries();
            }
        }
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
        ListIterator listIterator = this.getTargets().listIterator();
        while (listIterator.hasNext()) {
            ITarget iTarget = (ITarget)listIterator.next();
            iTarget.setDirty(bl);
        }
    }

    public void setRebuildState(boolean bl) {
        ListIterator listIterator = this.getTargets().listIterator();
        while (listIterator.hasNext()) {
            ((ITarget)listIterator.next()).setRebuildState(bl);
        }
        this.rebuildNeeded = bl;
    }

    public void setSelectedTarget(ITarget iTarget) {
        this.selectedTarget = iTarget;
    }

    public void setVersion(String string) {
        if (string != null && !string.equals(this.version)) {
            this.version = string;
            this.setDirty(true);
        }
    }

    public String toString() {
        return "Managed build information for " + this.owner.getName();
    }

    public void updateOwner(IResource iResource) {
        if (iResource != null && !this.owner.equals((Object)iResource)) {
            this.owner = iResource;
            ListIterator listIterator = this.getTargets().listIterator();
            while (listIterator.hasNext()) {
                ITarget iTarget = (ITarget)listIterator.next();
                iTarget.updateOwner(iResource);
            }
            this.cProject = CoreModel.getDefault().create(this.owner.getProject());
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }
}

