/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;

public class Option
extends BuildObject
implements IOption {
    private static final String EMPTY_STRING = new String();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private int browseType;
    private List builtIns;
    private IOptionCategory category;
    private String command;
    private String commandFalse;
    private String defaultEnumId;
    private Map enumCommands;
    private Map enumNames;
    private ITool tool;
    private Object value;
    private int valueType;
    private boolean resolved = true;

    public Option(ITool iTool) {
        this.tool = iTool;
    }

    public Option(Tool tool, IManagedConfigElement iManagedConfigElement) {
        this(tool);
        Object object;
        ManagedBuildManager.putConfigElement(this, iManagedConfigElement);
        this.resolved = false;
        this.setId(iManagedConfigElement.getAttribute("id"));
        tool.addOption(this);
        this.setName(iManagedConfigElement.getAttribute("name"));
        this.command = iManagedConfigElement.getAttribute("command");
        this.commandFalse = iManagedConfigElement.getAttribute("commandFalse");
        String string = iManagedConfigElement.getAttribute("valueType");
        this.valueType = string == null ? -1 : (string.equals("string") ? 2 : (string.equals("stringList") ? 3 : (string.equals("boolean") ? 0 : (string.equals("enumerated") ? 1 : (string.equals("includePath") ? 4 : (string.equals("libs") ? 6 : (string.equals("userObjs") ? 7 : 5)))))));
        switch (this.valueType) {
            case 0: {
                this.value = new Boolean(iManagedConfigElement.getAttribute("defaultValue"));
                break;
            }
            case 2: {
                this.value = iManagedConfigElement.getAttribute("defaultValue");
                break;
            }
            case 1: {
                object = new ArrayList();
                IManagedConfigElement[] iManagedConfigElementArray = iManagedConfigElement.getChildren("enumeratedOptionValue");
                int n = 0;
                while (n < iManagedConfigElementArray.length) {
                    String string2 = iManagedConfigElementArray[n].getAttribute("id");
                    object.add(string2);
                    this.getEnumCommandMap().put(string2, iManagedConfigElementArray[n].getAttribute("command"));
                    this.getEnumNameMap().put(string2, iManagedConfigElementArray[n].getAttribute("name"));
                    Boolean bl = new Boolean(iManagedConfigElementArray[n].getAttribute("isDefault"));
                    if (bl.booleanValue()) {
                        this.defaultEnumId = string2;
                    }
                    ++n;
                }
                this.value = object;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ArrayList<String> arrayList = new ArrayList<String>();
                this.builtIns = new ArrayList();
                IManagedConfigElement[] iManagedConfigElementArray = iManagedConfigElement.getChildren("listOptionValue");
                int n = 0;
                while (n < iManagedConfigElementArray.length) {
                    IManagedConfigElement iManagedConfigElement2 = iManagedConfigElementArray[n];
                    Boolean bl = new Boolean(iManagedConfigElement2.getAttribute("builtIn"));
                    if (bl.booleanValue()) {
                        this.builtIns.add(iManagedConfigElement2.getAttribute("value"));
                    } else {
                        arrayList.add(iManagedConfigElement2.getAttribute("value"));
                    }
                    ++n;
                }
                this.value = arrayList;
                break;
            }
        }
        object = iManagedConfigElement.getAttribute("browseType");
        if (object == null || ((String)object).equals("none")) {
            this.browseType = 0;
        } else if (((String)object).equals("file")) {
            this.browseType = 1;
        } else if (((String)object).equals("directory")) {
            this.browseType = 2;
        }
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            IManagedConfigElement iManagedConfigElement = ManagedBuildManager.getConfigElement(this);
            String string = iManagedConfigElement.getAttribute("category");
            if (string != null) {
                this.setCategory(((Tool)this.tool).getOptionCategory(string));
            }
        }
    }

    public String[] getApplicableValues() {
        List list = (List)this.value;
        if (list == null || list.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[list.size()];
        int n = 0;
        while (n < list.size()) {
            stringArray[n] = (String)this.getEnumNameMap().get(list.get(n));
            ++n;
        }
        return stringArray;
    }

    public boolean getBooleanValue() {
        Boolean bl = (Boolean)this.value;
        return bl;
    }

    public int getBrowseType() {
        return this.browseType;
    }

    public String[] getBuiltIns() {
        return this.builtIns == null ? EMPTY_STRING_ARRAY : this.builtIns.toArray(new String[this.builtIns.size()]);
    }

    public IOptionCategory getCategory() {
        return this.category != null ? this.category : this.getTool().getTopOptionCategory();
    }

    public String getCommand() {
        return this.command;
    }

    public String getCommandFalse() {
        return this.commandFalse;
    }

    public String[] getDefinedSymbols() throws BuildException {
        if (this.valueType != 5) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList arrayList = (ArrayList)this.value;
        if (arrayList == null) {
            return EMPTY_STRING_ARRAY;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getEnumCommand(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        String string2 = (String)this.getEnumCommandMap().get(string);
        if (string2 == null) {
            List list = (List)this.value;
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                String string3 = (String)listIterator.next();
                String string4 = (String)this.getEnumNameMap().get(string3);
                if (!string.equals(string4)) continue;
                string2 = (String)this.getEnumCommandMap().get(string3);
                break;
            }
        }
        return string2 == null ? EMPTY_STRING : string2;
    }

    public String getEnumName(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        String string2 = (String)this.getEnumNameMap().get(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    private Map getEnumCommandMap() {
        if (this.enumCommands == null) {
            this.enumCommands = new HashMap();
        }
        return this.enumCommands;
    }

    public String getEnumeratedId(String string) {
        if (string == null) {
            return null;
        }
        Set set = this.getEnumNameMap().keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)this.getEnumNameMap().get(string2);
            if (!string.equals(string3)) continue;
            return string2;
        }
        return null;
    }

    private Map getEnumNameMap() {
        if (this.enumNames == null) {
            this.enumNames = new HashMap();
        }
        return this.enumNames;
    }

    public String[] getIncludePaths() throws BuildException {
        if (this.valueType != 4) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList arrayList = (ArrayList)this.value;
        if (arrayList == null) {
            return EMPTY_STRING_ARRAY;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getLibraries() throws BuildException {
        if (this.valueType != 6) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList arrayList = (ArrayList)this.value;
        if (arrayList == null) {
            return EMPTY_STRING_ARRAY;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getSelectedEnum() throws BuildException {
        if (this.valueType != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        return this.defaultEnumId == null ? EMPTY_STRING : this.defaultEnumId;
    }

    public String[] getStringListValue() throws BuildException {
        if (this.valueType != 3) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList arrayList = (ArrayList)this.value;
        if (arrayList == null) {
            return EMPTY_STRING_ARRAY;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getStringValue() throws BuildException {
        if (this.valueType != 2) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        return this.value == null ? EMPTY_STRING : (String)this.value;
    }

    public ITool getTool() {
        return this.tool;
    }

    public String[] getUserObjects() throws BuildException {
        if (this.valueType != 7) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList arrayList = (ArrayList)this.value;
        if (arrayList == null) {
            return EMPTY_STRING_ARRAY;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public int getValueType() {
        return this.valueType;
    }

    public void setCategory(IOptionCategory iOptionCategory) {
        this.category = iOptionCategory;
    }

    public IOption setValue(IConfiguration iConfiguration, String string) throws BuildException {
        if (this.valueType != 2 || this.valueType != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        if (iConfiguration == null) {
            this.value = string;
            return this;
        }
        return null;
    }

    public IOption setValue(IConfiguration iConfiguration, String[] stringArray) throws BuildException {
        if (this.valueType != 3 || this.valueType != 4 || this.valueType != 5 || this.valueType != 6 || this.valueType != 7) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        if (iConfiguration == null) {
            this.value = stringArray;
            return this;
        }
        return null;
    }
}

