/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.OptionReference;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Target
extends BuildObject
implements ITarget {
    private static final String EMPTY_STRING = new String();
    private static final IConfiguration[] emptyConfigs = new IConfiguration[0];
    private String artifactName;
    private String binaryParserId;
    private String cleanCommand;
    private List configList;
    private Map configMap;
    private String defaultExtension;
    private Map depCalculatorsMap;
    private String errorParserIds;
    private String extension;
    private boolean isAbstract = false;
    private boolean isDirty = false;
    private boolean isTest = false;
    private String makeArguments;
    private String makeCommand;
    private IResource owner;
    private ITarget parent;
    private boolean resolved = true;
    private List targetArchList;
    private List targetOSList;
    private List toolList;
    private Map toolMap;
    private List toolReferences;

    public Target(IManagedConfigElement iManagedConfigElement) {
        int n;
        String[] stringArray;
        ManagedBuildManager.putConfigElement(this, iManagedConfigElement);
        this.resolved = false;
        this.setId(iManagedConfigElement.getAttribute("id"));
        ManagedBuildManager.addExtensionTarget(this);
        this.setName(iManagedConfigElement.getAttribute("name"));
        this.artifactName = iManagedConfigElement.getAttribute("artifactName");
        this.binaryParserId = iManagedConfigElement.getAttribute("binaryParser");
        this.errorParserIds = iManagedConfigElement.getAttribute("errorParsers");
        this.defaultExtension = iManagedConfigElement.getAttribute("defaultExtension");
        this.isAbstract = "true".equals(iManagedConfigElement.getAttribute("isAbstract"));
        this.isTest = "true".equals(iManagedConfigElement.getAttribute("isTest"));
        this.cleanCommand = iManagedConfigElement.getAttribute("cleanCommand");
        this.makeCommand = iManagedConfigElement.getAttribute("makeCommand");
        this.makeArguments = iManagedConfigElement.getAttribute("makeArguments");
        String string = iManagedConfigElement.getAttribute("osList");
        if (string != null) {
            this.targetOSList = new ArrayList();
            stringArray = string.split(",");
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.targetOSList.add(stringArray[n2].trim());
                ++n2;
            }
        }
        if ((stringArray = iManagedConfigElement.getAttribute("archList")) != null) {
            this.targetArchList = new ArrayList();
            String[] stringArray2 = stringArray.split(",");
            n = 0;
            while (n < stringArray2.length) {
                this.targetArchList.add(stringArray2[n].trim());
                ++n;
            }
        }
        IManagedConfigElement[] iManagedConfigElementArray = iManagedConfigElement.getChildren("toolReference");
        n = 0;
        while (n < iManagedConfigElementArray.length) {
            new ToolReference((BuildObject)this, iManagedConfigElementArray[n]);
            ++n;
        }
        IManagedConfigElement[] iManagedConfigElementArray2 = iManagedConfigElement.getChildren("tool");
        int n3 = 0;
        while (n3 < iManagedConfigElementArray2.length) {
            new Tool(this, iManagedConfigElementArray2[n3]);
            ++n3;
        }
        IManagedConfigElement[] iManagedConfigElementArray3 = iManagedConfigElement.getChildren("configuration");
        int n4 = 0;
        while (n4 < iManagedConfigElementArray3.length) {
            new Configuration(this, iManagedConfigElementArray3[n4]);
            ++n4;
        }
    }

    protected Target(IResource iResource) {
        this.owner = iResource;
    }

    public Target(IResource iResource, ITarget iTarget) {
        this(iResource);
        this.parent = iTarget;
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        int n = random.nextInt();
        if (n < 0) {
            n *= -1;
        }
        this.setId(String.valueOf(iResource.getName()) + "." + iTarget.getId() + "." + n);
        this.setName(iTarget.getName());
        this.setArtifactName(iTarget.getArtifactName());
        this.binaryParserId = iTarget.getBinaryParserId();
        this.errorParserIds = iTarget.getErrorParserIds();
        this.defaultExtension = iTarget.getArtifactExtension();
        this.isTest = iTarget.isTestTarget();
        this.cleanCommand = iTarget.getCleanCommand();
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo(iResource);
        iManagedBuildInfo.addTarget(this);
    }

    public Target(ManagedBuildInfo managedBuildInfo, Element element) {
        this(managedBuildInfo.getOwner());
        String string;
        this.setId(element.getAttribute("id"));
        managedBuildInfo.addTarget(this);
        this.setName(element.getAttribute("name"));
        this.artifactName = element.getAttribute("artifactName");
        if (element.hasAttribute("extension")) {
            this.extension = element.getAttribute("extension");
        }
        if ((string = element.getAttribute("parent")) != null) {
            this.parent = ManagedBuildManager.getTarget(null, string);
        }
        if ("true".equals(element.getAttribute("isAbstract"))) {
            this.isAbstract = true;
        }
        this.isTest = "true".equals(element.getAttribute("isTest"));
        if (element.hasAttribute("cleanCommand")) {
            this.cleanCommand = element.getAttribute("cleanCommand");
        }
        if (element.hasAttribute("errorParsers")) {
            this.errorParserIds = element.getAttribute("errorParsers");
        }
        if (element.hasAttribute("makeCommand")) {
            this.makeCommand = element.getAttribute("makeCommand");
        }
        if (element.hasAttribute("makeArguments")) {
            this.makeArguments = element.getAttribute("makeArguments");
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equals("configuration")) {
                new Configuration(this, (Element)node);
            }
            node = node.getNextSibling();
        }
    }

    public void addConfiguration(IConfiguration iConfiguration) {
        this.getConfigurationList().add(iConfiguration);
        this.getConfigurationMap().put(iConfiguration.getId(), iConfiguration);
    }

    public void addTool(ITool iTool) {
        this.getToolList().add(iTool);
        this.getToolMap().put(iTool.getId(), iTool);
        this.getDepCalcMap().put(iTool.getId(), ManagedBuildManager.createDependencyGenerator(iTool.getId()));
    }

    public void addToolReference(ToolReference toolReference) {
        this.getLocalToolReferences().add(toolReference);
    }

    private void addToolsToArray(Vector vector) {
        if (this.parent != null) {
            ((Target)this.parent).addToolsToArray(vector);
        }
        vector.addAll(this.getToolList());
        vector.addAll(this.getLocalToolReferences());
    }

    public IConfiguration createConfiguration(IConfiguration iConfiguration, String string) {
        this.isDirty = true;
        return new Configuration(this, iConfiguration, string);
    }

    public IConfiguration createConfiguration(String string) {
        return new Configuration(this, string);
    }

    public String getArtifactExtension() {
        if (this.extension != null) {
            return this.extension;
        }
        if (this.defaultExtension == null) {
            if (this.parent != null) {
                return this.parent.getArtifactExtension();
            }
            return EMPTY_STRING;
        }
        return this.defaultExtension;
    }

    public String getArtifactName() {
        if (this.artifactName == null) {
            if (this.parent != null) {
                return this.parent.getArtifactName();
            }
            return EMPTY_STRING;
        }
        return this.artifactName;
    }

    public String getBinaryParserId() {
        if (this.binaryParserId == null) {
            if (this.parent != null) {
                return this.parent.getBinaryParserId();
            }
            return EMPTY_STRING;
        }
        return this.binaryParserId;
    }

    public String getCleanCommand() {
        if (this.cleanCommand == null) {
            if (this.parent != null) {
                return this.parent.getCleanCommand();
            }
            if (Platform.getOS().equals("OS_WIN32")) {
                return new String("del");
            }
            return new String("rm");
        }
        return this.cleanCommand;
    }

    public IConfiguration getConfiguration(String string) {
        return (IConfiguration)this.getConfigurationMap().get(string);
    }

    private List getConfigurationList() {
        if (this.configList == null) {
            this.configList = new ArrayList();
        }
        return this.configList;
    }

    private Map getConfigurationMap() {
        if (this.configMap == null) {
            this.configMap = new HashMap();
        }
        return this.configMap;
    }

    public IConfiguration[] getConfigurations() {
        return this.getConfigurationList().toArray(new IConfiguration[this.getConfigurationList().size()]);
    }

    public String getDefaultExtension() {
        return this.defaultExtension == null ? EMPTY_STRING : this.defaultExtension;
    }

    private Map getDepCalcMap() {
        if (this.depCalculatorsMap == null) {
            this.depCalculatorsMap = new HashMap();
        }
        return this.depCalculatorsMap;
    }

    public IManagedDependencyGenerator getDependencyGenerator(String string) {
        IManagedDependencyGenerator iManagedDependencyGenerator = (IManagedDependencyGenerator)this.getDepCalcMap().get(string);
        if (iManagedDependencyGenerator == null && this.parent != null) {
            iManagedDependencyGenerator = this.parent.getDependencyGenerator(string);
        }
        if (iManagedDependencyGenerator == null && this.parent == null) {
            iManagedDependencyGenerator = ManagedBuildManager.getDependencyGenerator(string);
        }
        return iManagedDependencyGenerator;
    }

    public String getErrorParserIds() {
        if (this.errorParserIds == null && this.parent != null) {
            return this.parent.getErrorParserIds();
        }
        return this.errorParserIds;
    }

    public String[] getErrorParserList() {
        String string = this.getErrorParserIds();
        String[] stringArray = null;
        if (string != null) {
            if (string.length() == 0) {
                stringArray = new String[]{};
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
                while (stringTokenizer.hasMoreElements()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                String[] stringArray2 = new String[]{""};
                stringArray = arrayList.toArray(stringArray2);
            }
        } else {
            stringArray = CCorePlugin.getDefault().getAllErrorParsersIDs();
        }
        return stringArray;
    }

    protected List getLocalToolReferences() {
        if (this.toolReferences == null) {
            this.toolReferences = new ArrayList();
        }
        return this.toolReferences;
    }

    public String getMakeArguments() {
        if (this.makeArguments == null) {
            if (this.parent != null) {
                return this.parent.getMakeArguments();
            }
            return new String("");
        }
        return this.makeArguments;
    }

    public String getMakeCommand() {
        if (this.makeCommand == null) {
            if (this.parent != null) {
                return this.parent.getMakeCommand();
            }
            return new String("make");
        }
        return this.makeCommand;
    }

    public String getName() {
        if (this.name == null) {
            if (this.parent != null) {
                return this.parent.getName();
            }
            return new String("");
        }
        return this.name;
    }

    protected List getOptionReferences(ITool iTool) {
        ArrayList<OptionReference> arrayList = new ArrayList<OptionReference>();
        ToolReference toolReference = this.getToolReference(iTool);
        if (toolReference != null) {
            arrayList.addAll(toolReference.getOptionReferenceList());
        }
        if (this.parent != null) {
            List list = ((Target)this.parent).getOptionReferences(iTool);
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                OptionReference optionReference = (OptionReference)listIterator.next();
                if (arrayList.contains(optionReference)) continue;
                arrayList.add(optionReference);
            }
        }
        return arrayList;
    }

    public IResource getOwner() {
        return this.owner;
    }

    public ITarget getParent() {
        return this.parent;
    }

    public String[] getTargetArchList() {
        if (this.targetArchList == null) {
            if (this.parent != null) {
                return this.parent.getTargetArchList();
            }
            return new String[]{"all"};
        }
        return this.targetArchList.toArray(new String[this.targetArchList.size()]);
    }

    public String[] getTargetOSList() {
        if (this.targetOSList == null) {
            if (this.parent != null) {
                return this.parent.getTargetOSList();
            }
            return new String[]{"all"};
        }
        return this.targetOSList.toArray(new String[this.targetOSList.size()]);
    }

    public ITool getTool(String string) {
        ITool iTool = null;
        iTool = (ITool)this.getToolMap().get(string);
        if (iTool == null && this.parent != null) {
            iTool = ((Target)this.parent).getTool(string);
        }
        if (iTool == null) {
            iTool = ManagedBuildManager.getTool(string);
        }
        return iTool;
    }

    private List getToolList() {
        if (this.toolList == null) {
            this.toolList = new ArrayList();
        }
        return this.toolList;
    }

    private Map getToolMap() {
        if (this.toolMap == null) {
            this.toolMap = new HashMap();
        }
        return this.toolMap;
    }

    private ToolReference getToolReference(ITool iTool) {
        ToolReference toolReference = null;
        if (iTool == null) {
            return toolReference;
        }
        ListIterator listIterator = this.getLocalToolReferences().listIterator();
        while (listIterator.hasNext()) {
            ToolReference toolReference2 = (ToolReference)listIterator.next();
            if (!toolReference2.references(iTool)) continue;
            toolReference = toolReference2;
            break;
        }
        return toolReference;
    }

    public ITool[] getTools() {
        Vector vector = new Vector();
        this.addToolsToArray(vector);
        return vector.toArray(new ITool[vector.size()]);
    }

    public boolean hasOverridenMakeCommand() {
        return this.makeCommand != null && !this.makeCommand.equals(this.parent.getMakeCommand()) || this.makeArguments != null && !this.makeArguments.equals(this.parent.getMakeArguments());
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        ListIterator listIterator = this.getConfigurationList().listIterator();
        while (listIterator.hasNext()) {
            if (!((IConfiguration)listIterator.next()).isDirty()) continue;
            return true;
        }
        return false;
    }

    public boolean isTestTarget() {
        return this.isTest;
    }

    public boolean needsRebuild() {
        ListIterator listIterator = this.getConfigurationList().listIterator();
        while (listIterator.hasNext()) {
            if (!((IConfiguration)listIterator.next()).needsRebuild()) continue;
            return true;
        }
        return false;
    }

    public void removeConfiguration(String string) {
        ListIterator listIterator = this.getConfigurationList().listIterator();
        while (listIterator.hasNext()) {
            IConfiguration iConfiguration = (IConfiguration)listIterator.next();
            if (!iConfiguration.getId().equals(string)) continue;
            this.getConfigurationList().remove(iConfiguration);
            this.getConfigurationMap().remove(string);
            this.isDirty = true;
            break;
        }
    }

    public void resetMakeCommand() {
        if (this.makeCommand != null) {
            this.setDirty(true);
        }
        this.makeCommand = null;
        this.makeArguments = null;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            Object object;
            IConfiguration[] iConfigurationArray;
            this.resolved = true;
            IManagedConfigElement iManagedConfigElement = ManagedBuildManager.getConfigElement(this);
            String string = iManagedConfigElement.getAttribute("parent");
            if (string != null) {
                this.parent = ManagedBuildManager.getTarget(null, string);
                ((Target)this.parent).resolveReferences();
                iConfigurationArray = this.parent.getConfigurations();
                int n = 0;
                while (n < iConfigurationArray.length) {
                    this.addConfiguration(iConfigurationArray[n]);
                    ++n;
                }
            }
            iConfigurationArray = this.getToolList().iterator();
            while (iConfigurationArray.hasNext()) {
                Tool tool = (Tool)iConfigurationArray.next();
                tool.resolveReferences();
            }
            Iterator iterator = this.getLocalToolReferences().iterator();
            while (iterator.hasNext()) {
                object = (ToolReference)iterator.next();
                ((ToolReference)object).resolveReferences();
            }
            object = this.getConfigurationList().iterator();
            while (object.hasNext()) {
                Configuration configuration = (Configuration)object.next();
                configuration.resolveReferences();
            }
        }
    }

    public void serialize(Document document, Element element) {
        element.setAttribute("id", this.getId());
        element.setAttribute("name", this.getName());
        if (this.parent != null) {
            element.setAttribute("parent", this.parent.getId());
        }
        element.setAttribute("isAbstract", this.isAbstract ? "true" : "false");
        element.setAttribute("artifactName", this.getArtifactName());
        if (this.extension != null) {
            element.setAttribute("extension", this.extension);
        }
        element.setAttribute("isTest", this.isTest ? "true" : "false");
        if (this.makeCommand != null) {
            element.setAttribute("makeCommand", this.makeCommand);
        }
        if (this.makeArguments != null) {
            element.setAttribute("makeArguments", this.makeArguments);
        }
        if (this.errorParserIds != null) {
            element.setAttribute("errorParsers", this.errorParserIds);
        }
        ListIterator listIterator = this.getConfigurationList().listIterator();
        while (listIterator.hasNext()) {
            Configuration configuration = (Configuration)listIterator.next();
            Element element2 = document.createElement("configuration");
            element.appendChild(element2);
            configuration.serialize(document, element2);
        }
        this.isDirty = false;
    }

    public void setArtifactExtension(String string) {
        if (string != null) {
            this.extension = string;
            this.isDirty = true;
        }
    }

    public void setArtifactName(String string) {
        if (string != null) {
            this.artifactName = string;
            this.setRebuildState(true);
            this.isDirty = true;
        }
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
        ListIterator listIterator = this.getConfigurationList().listIterator();
        while (listIterator.hasNext()) {
            IConfiguration iConfiguration = (IConfiguration)listIterator.next();
            iConfiguration.setDirty(bl);
        }
    }

    public void setErrorParserIds(String string) {
        if (string == null) {
            return;
        }
        String string2 = this.getErrorParserIds();
        if (string2 == null || !string2.equals(string)) {
            this.errorParserIds = string;
            this.isDirty = true;
        }
    }

    public void setMakeArguments(String string) {
        if (string != null && !this.getMakeArguments().equals(string)) {
            this.makeArguments = string;
            this.setRebuildState(true);
            this.isDirty = true;
        }
    }

    public void setMakeCommand(String string) {
        if (string != null && !this.getMakeCommand().equals(string)) {
            this.makeCommand = string;
            this.setRebuildState(true);
            this.isDirty = true;
        }
    }

    public void setRebuildState(boolean bl) {
        ListIterator listIterator = this.getConfigurationList().listIterator();
        while (listIterator.hasNext()) {
            ((IConfiguration)listIterator.next()).setRebuildState(bl);
        }
    }

    public void updateOwner(IResource iResource) {
        if (!iResource.equals((Object)this.owner)) {
            this.owner = iResource;
        }
    }
}

