/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.OptionCategory;
import org.eclipse.cdt.managedbuilder.internal.core.Target;

public class Tool
extends BuildObject
implements ITool,
IOptionCategory {
    private static final String DEFAULT_SEPARATOR = ",";
    private static final IOptionCategory[] EMPTY_CATEGORIES = new IOptionCategory[0];
    private static final IOption[] EMPTY_OPTIONS = new IOption[0];
    private Vector categoryIds;
    private Map categoryMap;
    private List childOptionCategories;
    private String command;
    private List inputExtensions;
    private String inputFlag;
    private List interfaceExtensions;
    private int natureFilter;
    private Vector optionList;
    private Map optionMap;
    private String outputExtensions;
    private String outputFlag;
    private String outputPrefix;
    private boolean resolved = true;

    public Tool(IManagedConfigElement iManagedConfigElement) {
        this.loadFromManifest(iManagedConfigElement);
        ManagedBuildManager.addExtensionTool(this);
    }

    public Tool(Target target, IManagedConfigElement iManagedConfigElement) {
        this.loadFromManifest(iManagedConfigElement);
        target.addTool(this);
    }

    public void addChildCategory(IOptionCategory iOptionCategory) {
        if (this.childOptionCategories == null) {
            this.childOptionCategories = new ArrayList();
        }
        this.childOptionCategories.add(iOptionCategory);
    }

    public void addOption(Option option) {
        this.getOptionList().add(option);
        this.getOptionMap().put(option.getId(), option);
    }

    protected void addOptionCategory(IOptionCategory iOptionCategory) {
        this.getCategoryIds().add(iOptionCategory.getId());
        this.getCategoryMap().put(iOptionCategory.getId(), iOptionCategory);
    }

    public boolean buildsFileType(String string) {
        if (string == null) {
            return false;
        }
        return this.getInputExtensions().contains(string);
    }

    private Vector getCategoryIds() {
        if (this.categoryIds == null) {
            this.categoryIds = new Vector();
        }
        return this.categoryIds;
    }

    private Map getCategoryMap() {
        if (this.categoryMap == null) {
            this.categoryMap = new HashMap();
        }
        return this.categoryMap;
    }

    private Vector getOptionList() {
        if (this.optionList == null) {
            this.optionList = new Vector();
        }
        return this.optionList;
    }

    private Map getOptionMap() {
        if (this.optionMap == null) {
            this.optionMap = new HashMap();
        }
        return this.optionMap;
    }

    public IOption[] getOptions() {
        return this.getOptionList().toArray(new IOption[this.getOptionList().size()]);
    }

    public IOptionCategory getTopOptionCategory() {
        return this;
    }

    public IOptionCategory[] getChildCategories() {
        if (this.childOptionCategories != null) {
            return this.childOptionCategories.toArray(new IOptionCategory[this.childOptionCategories.size()]);
        }
        return EMPTY_CATEGORIES;
    }

    public List getInputExtensions() {
        if (this.inputExtensions == null) {
            this.inputExtensions = new ArrayList();
        }
        return this.inputExtensions;
    }

    public String getInputFlag() {
        return this.inputFlag == null ? new String() : this.inputFlag.trim();
    }

    private List getInterfaceExtensions() {
        if (this.interfaceExtensions == null) {
            this.interfaceExtensions = new ArrayList();
        }
        return this.interfaceExtensions;
    }

    public String getOutputFlag() {
        return this.outputFlag == null ? new String() : this.outputFlag.trim();
    }

    public String getOutputPrefix() {
        return this.outputPrefix == null ? new String() : this.outputPrefix.trim();
    }

    public IOptionCategory getOwner() {
        return null;
    }

    public ITool getTool() {
        return this;
    }

    public String getToolCommand() {
        return this.command.trim();
    }

    public String getToolFlags() throws BuildException {
        StringBuffer stringBuffer = new StringBuffer();
        IOption[] iOptionArray = this.getOptions();
        int n = 0;
        while (n < iOptionArray.length) {
            IOption iOption = iOptionArray[n];
            switch (iOption.getValueType()) {
                case 0: {
                    String string = iOption.getBooleanValue() ? iOption.getCommand() : iOption.getCommandFalse();
                    if (string == null || string.length() <= 0) break;
                    stringBuffer.append(String.valueOf(string) + " ");
                    break;
                }
                case 1: {
                    String string = iOption.getEnumCommand(iOption.getSelectedEnum());
                    if (string.length() <= 0) break;
                    stringBuffer.append(String.valueOf(string) + " ");
                    break;
                }
                case 2: {
                    String string = iOption.getCommand();
                    String string2 = iOption.getStringValue();
                    if (string2.length() <= 0) break;
                    if (string != null) {
                        stringBuffer.append(string);
                    }
                    stringBuffer.append(String.valueOf(string2) + " ");
                    break;
                }
                case 3: {
                    Object object2;
                    String string = iOption.getCommand() != null ? iOption.getCommand() : "";
                    String[] stringArray = iOption.getStringListValue();
                    String[] stringArray2 = string.split("%s");
                    string = stringArray2.length > 0 ? stringArray2[0] : string;
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        object2 = stringArray[n2];
                        if (string != null) {
                            stringBuffer.append(string);
                        }
                        stringBuffer.append(String.valueOf(object2) + " ");
                        ++n2;
                    }
                    break;
                }
                case 4: {
                    Object object;
                    String string = iOption.getCommand();
                    Object object2 = iOption.getIncludePaths();
                    int n3 = 0;
                    while (n3 < ((String[])object2).length) {
                        object = object2[n3];
                        stringBuffer.append(String.valueOf(string) + (String)object + " ");
                        ++n3;
                    }
                    break;
                }
                case 5: {
                    String string = iOption.getCommand();
                    Object object = iOption.getDefinedSymbols();
                    int n4 = 0;
                    while (n4 < ((String[])object).length) {
                        String string3 = object[n4];
                        stringBuffer.append(String.valueOf(string) + string3 + " ");
                        ++n4;
                    }
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    public IOption[] getOptions(IConfiguration iConfiguration) {
        IBuildObject[] iBuildObjectArray;
        IBuildObject iBuildObject = this;
        if (iConfiguration != null) {
            iBuildObjectArray = iConfiguration.getTools();
            int n = 0;
            while (n < iBuildObjectArray.length) {
                if (iBuildObjectArray[n] instanceof IToolReference) {
                    if (((IToolReference)iBuildObjectArray[n]).references((ITool)iBuildObject)) {
                        iBuildObject = iBuildObjectArray[n];
                        break;
                    }
                } else if (iBuildObjectArray[n].equals(iBuildObject)) break;
                ++n;
            }
        }
        iBuildObjectArray = iBuildObject.getOptions();
        ArrayList<IBuildObject> arrayList = new ArrayList<IBuildObject>();
        int n = 0;
        while (n < iBuildObjectArray.length) {
            IBuildObject iBuildObject2 = iBuildObjectArray[n];
            if (iBuildObject2.getCategory().equals(this)) {
                arrayList.add(iBuildObject2);
            }
            ++n;
        }
        arrayList.trimToSize();
        return arrayList.toArray(new IOption[arrayList.size()]);
    }

    public int getNatureFilter() {
        return this.natureFilter;
    }

    public IOption getOption(String string) {
        return this.getOptionById(string);
    }

    public IOption getOptionById(String string) {
        return (IOption)this.getOptionMap().get(string);
    }

    public IOptionCategory getOptionCategory(String string) {
        return (IOptionCategory)this.getCategoryMap().get(string);
    }

    public String[] getOutputExtensions() {
        return this.outputExtensions.split(DEFAULT_SEPARATOR);
    }

    public String getOutputExtension(String string) {
        ListIterator listIterator = this.getInputExtensions().listIterator();
        while (listIterator.hasNext()) {
            if (!((String)listIterator.next()).equals(string)) continue;
            return this.outputExtensions;
        }
        return null;
    }

    public boolean isHeaderFile(String string) {
        if (string == null) {
            return false;
        }
        return this.getInterfaceExtensions().contains(string);
    }

    protected void loadFromManifest(IManagedConfigElement iManagedConfigElement) {
        ManagedBuildManager.putConfigElement(this, iManagedConfigElement);
        this.resolved = false;
        this.setId(iManagedConfigElement.getAttribute("id"));
        this.setName(iManagedConfigElement.getAttribute("name"));
        String string = iManagedConfigElement.getAttribute("natureFilter");
        this.natureFilter = string == null || "both".equals(string) ? 2 : ("cnature".equals(string) ? 0 : ("ccnature".equals(string) ? 1 : 2));
        String string2 = iManagedConfigElement.getAttribute("sources") == null ? new String() : iManagedConfigElement.getAttribute("sources");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, DEFAULT_SEPARATOR);
        while (stringTokenizer.hasMoreElements()) {
            this.getInputExtensions().add(stringTokenizer.nextElement());
        }
        String string3 = iManagedConfigElement.getAttribute("headerExtensions");
        if (string3 == null) {
            string3 = new String();
        }
        stringTokenizer = new StringTokenizer(string3, DEFAULT_SEPARATOR);
        while (stringTokenizer.hasMoreElements()) {
            this.getInterfaceExtensions().add(stringTokenizer.nextElement());
        }
        this.outputExtensions = iManagedConfigElement.getAttribute("outputs") == null ? new String() : iManagedConfigElement.getAttribute("outputs");
        this.command = iManagedConfigElement.getAttribute("command") == null ? new String() : iManagedConfigElement.getAttribute("command");
        this.inputFlag = iManagedConfigElement.getAttribute("inputFlag") == null ? new String() : iManagedConfigElement.getAttribute("inputFlag");
        this.outputFlag = iManagedConfigElement.getAttribute("outputFlag") == null ? new String() : iManagedConfigElement.getAttribute("outputFlag");
        this.outputPrefix = iManagedConfigElement.getAttribute("outputPrefix") == null ? new String() : iManagedConfigElement.getAttribute("outputPrefix");
        this.addOptionCategory(this);
        IManagedConfigElement[] iManagedConfigElementArray = iManagedConfigElement.getChildren();
        int n = 0;
        while (n < iManagedConfigElementArray.length) {
            IManagedConfigElement iManagedConfigElement2 = iManagedConfigElementArray[n];
            if (iManagedConfigElement2.getName().equals("option")) {
                new Option(this, iManagedConfigElement2);
            } else if (iManagedConfigElement2.getName().equals("optionCategory")) {
                new OptionCategory(this, iManagedConfigElement2);
            }
            ++n;
        }
    }

    public boolean producesFileType(String string) {
        return this.outputExtensions.equals(string);
    }

    public void resolveReferences() {
        if (!this.resolved) {
            Object object;
            this.resolved = true;
            Iterator iterator = this.getOptionList().iterator();
            while (iterator.hasNext()) {
                object = (Option)iterator.next();
                ((Option)object).resolveReferences();
            }
            object = this.getCategoryIds().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                IOptionCategory iOptionCategory = (IOptionCategory)this.getCategoryMap().get(string);
                if (iOptionCategory instanceof Tool) {
                    ((Tool)iOptionCategory).resolveReferences();
                    continue;
                }
                if (!(iOptionCategory instanceof OptionCategory)) continue;
                ((OptionCategory)iOptionCategory).resolveReferences();
            }
        }
    }
}

