/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.OptionReference;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ToolReference
implements IToolReference {
    private static final String DEFAULT_SEPARATOR = ",";
    private String command;
    private String inputFlag;
    private boolean isDirty = false;
    private List optionReferences;
    private IBuildObject owner;
    private String outputExtensions;
    private String outputFlag;
    private String outputPrefix;
    protected ITool parent;
    private boolean resolved = true;

    public ToolReference(BuildObject buildObject, Element element) {
        Object object;
        this.owner = buildObject;
        if (buildObject instanceof Configuration) {
            if (this.parent == null) {
                object = (Target)((Configuration)buildObject).getTarget();
                try {
                    this.parent = ((Target)((Target)object).getParent()).getTool(element.getAttribute("id"));
                }
                catch (NullPointerException nullPointerException) {
                    this.parent = null;
                }
            }
            ((Configuration)buildObject).addToolReference(this);
        } else if (buildObject instanceof Target) {
            if (this.parent == null) {
                try {
                    this.parent = ((Target)((Target)buildObject).getParent()).getTool(element.getAttribute("id"));
                }
                catch (NullPointerException nullPointerException) {
                    this.parent = null;
                }
            }
            ((Target)buildObject).addToolReference(this);
        }
        if (element.hasAttribute("command")) {
            this.command = element.getAttribute("command");
        }
        if (element.hasAttribute("outputPrefix")) {
            this.outputPrefix = element.getAttribute("outputPrefix");
        }
        if (element.hasAttribute("outputs")) {
            this.outputExtensions = element.getAttribute("outputs");
        }
        if (element.hasAttribute("inputFlag")) {
            this.inputFlag = element.getAttribute("inputFlag");
        }
        if (element.hasAttribute("outputFlag")) {
            this.outputFlag = element.getAttribute("outputFlag");
        }
        object = element.getChildNodes();
        int n = 0;
        while (n < object.getLength()) {
            Node node = object.item(n);
            if (node.getNodeName().equals("optionReference")) {
                new OptionReference(this, (Element)node);
            }
            ++n;
        }
    }

    public ToolReference(BuildObject buildObject, IManagedConfigElement iManagedConfigElement) {
        ManagedBuildManager.putConfigElement(this, iManagedConfigElement);
        this.resolved = false;
        this.owner = buildObject;
        if (buildObject instanceof Configuration) {
            ((Configuration)buildObject).addToolReference(this);
        } else if (buildObject instanceof Target) {
            ((Target)buildObject).addToolReference(this);
        }
        this.command = iManagedConfigElement.getAttribute("command");
        this.outputPrefix = iManagedConfigElement.getAttribute("outputPrefix");
        String string = iManagedConfigElement.getAttribute("outputs");
        if (string != null) {
            this.outputExtensions = string;
        }
        this.inputFlag = iManagedConfigElement.getAttribute("inputFlag");
        this.outputFlag = iManagedConfigElement.getAttribute("outputFlag");
        IManagedConfigElement[] iManagedConfigElementArray = iManagedConfigElement.getChildren();
        int n = 0;
        while (n < iManagedConfigElementArray.length) {
            IManagedConfigElement iManagedConfigElement2 = iManagedConfigElementArray[n];
            if (iManagedConfigElement2.getName().equals("optionReference")) {
                new OptionReference(this, iManagedConfigElement2);
            }
            ++n;
        }
    }

    public ToolReference(BuildObject buildObject, ITool iTool) {
        this.owner = buildObject;
        this.parent = iTool instanceof ToolReference ? ((ToolReference)iTool).getTool() : iTool;
        this.command = iTool.getToolCommand();
        this.inputFlag = iTool.getInputFlag();
        this.outputFlag = iTool.getOutputFlag();
        this.outputPrefix = iTool.getOutputPrefix();
        String[] stringArray = iTool.getOutputExtensions();
        this.outputExtensions = new String();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    this.outputExtensions = String.valueOf(this.outputExtensions) + stringArray[n];
                    if (n < stringArray.length - 1) {
                        this.outputExtensions = String.valueOf(this.outputExtensions) + DEFAULT_SEPARATOR;
                    }
                }
                ++n;
            }
        }
        if (iTool instanceof ToolReference) {
            List list = ((ToolReference)iTool).getOptionReferenceList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IOption iOption = (IOption)iterator.next();
                OptionReference optionReference = this.createOptionReference(iOption);
                try {
                    switch (iOption.getValueType()) {
                        case 0: {
                            optionReference.setValue(iOption.getBooleanValue());
                            break;
                        }
                        case 2: {
                            optionReference.setValue(iOption.getStringValue());
                        }
                        case 1: {
                            optionReference.setValue(iOption.getSelectedEnum());
                            break;
                        }
                        default: {
                            optionReference.setValue(iOption.getStringListValue());
                            break;
                        }
                    }
                }
                catch (BuildException buildException) {}
            }
        }
        if (buildObject instanceof Configuration) {
            ((Configuration)buildObject).addToolReference(this);
        } else if (buildObject instanceof Target) {
            ((Target)buildObject).addToolReference(this);
        }
    }

    public boolean references(ITool iTool) {
        if (this.equals(iTool)) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        if (this.parent instanceof IToolReference) {
            return ((IToolReference)this.parent).references(iTool);
        }
        if (iTool instanceof IToolReference) {
            return this.parent.equals(((IToolReference)iTool).getTool());
        }
        return this.parent.equals(iTool);
    }

    public void resolveReferences() {
        if (!this.resolved) {
            Object object;
            this.resolved = true;
            IManagedConfigElement iManagedConfigElement = ManagedBuildManager.getConfigElement(this);
            if (this.owner instanceof Configuration) {
                object = (Target)((Configuration)this.owner).getTarget();
                this.parent = ((Target)object).getTool(iManagedConfigElement.getAttribute("id"));
            } else if (this.owner instanceof Target) {
                this.parent = ((Target)this.owner).getTool(iManagedConfigElement.getAttribute("id"));
            }
            if (this.parent instanceof Tool) {
                ((Tool)this.parent).resolveReferences();
            } else if (this.parent instanceof ToolReference) {
                ((ToolReference)this.parent).resolveReferences();
            }
            object = this.getOptionReferenceList().iterator();
            while (object.hasNext()) {
                OptionReference optionReference = (OptionReference)object.next();
                optionReference.resolveReferences();
            }
        }
    }

    public void addOptionReference(OptionReference optionReference) {
        this.getOptionReferenceList().add(optionReference);
        this.isDirty = true;
    }

    public boolean buildsFileType(String string) {
        if (this.parent == null) {
            return false;
        }
        return this.parent.buildsFileType(string);
    }

    public OptionReference createOptionReference(IOption iOption) {
        OptionReference optionReference = this.getOptionReference(iOption);
        if (optionReference == null || !optionReference.getToolReference().owner.equals(this.owner)) {
            optionReference = new OptionReference(this, iOption);
        }
        return optionReference;
    }

    protected List getAllOptionRefs() {
        if (this.owner instanceof Configuration) {
            return ((Configuration)this.owner).getOptionReferences(this.parent);
        }
        if (this.owner instanceof Target) {
            return ((Target)this.owner).getOptionReferences(this.parent);
        }
        return null;
    }

    public String getId() {
        if (this.parent == null) {
            return new String();
        }
        return this.parent.getId();
    }

    public List getInputExtensions() {
        return this.getTool().getInputExtensions();
    }

    public String getInputFlag() {
        if (this.inputFlag == null) {
            if (this.parent != null) {
                return this.parent.getInputFlag();
            }
            return new String();
        }
        return this.inputFlag;
    }

    public String getName() {
        if (this.parent == null) {
            return new String();
        }
        return this.parent.getName();
    }

    public int getNatureFilter() {
        if (this.parent == null) {
            return 2;
        }
        return this.parent.getNatureFilter();
    }

    public IOption getOption(String string) {
        return this.getOptionById(string);
    }

    public IOption getOptionById(String string) {
        IOption[] iOptionArray = this.getOptions();
        int n = 0;
        while (n < iOptionArray.length) {
            IOption iOption = iOptionArray[n];
            if (iOption.getId().equals(string)) {
                return iOption;
            }
            ++n;
        }
        return null;
    }

    public boolean producesFileType(String string) {
        if (!this.getOutputsList().contains(string)) {
            return this.parent.producesFileType(string);
        }
        return true;
    }

    private List getOutputsList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.outputExtensions != null) {
            String[] stringArray = this.outputExtensions.split(DEFAULT_SEPARATOR);
            arrayList.addAll(Arrays.asList(stringArray));
        }
        return arrayList;
    }

    public ITool getTool() {
        return this.parent;
    }

    public String getToolCommand() {
        if (this.command == null) {
            if (this.parent != null) {
                return this.parent.getToolCommand();
            }
            return new String();
        }
        return this.command;
    }

    public String getToolFlags() throws BuildException {
        StringBuffer stringBuffer = new StringBuffer();
        IOption[] iOptionArray = this.getOptions();
        int n = 0;
        while (n < iOptionArray.length) {
            IOption iOption = iOptionArray[n];
            switch (iOption.getValueType()) {
                case 0: {
                    String string = iOption.getBooleanValue() ? iOption.getCommand() : iOption.getCommandFalse();
                    if (string == null || string.length() <= 0) break;
                    stringBuffer.append(String.valueOf(string) + " ");
                    break;
                }
                case 1: {
                    String string = iOption.getEnumCommand(iOption.getSelectedEnum());
                    if (string.length() <= 0) break;
                    stringBuffer.append(String.valueOf(string) + " ");
                    break;
                }
                case 2: {
                    String string = iOption.getCommand();
                    String string2 = iOption.getStringValue();
                    if (string2.length() <= 0) break;
                    if (string != null) {
                        stringBuffer.append(string);
                    }
                    stringBuffer.append(String.valueOf(string2) + " ");
                    break;
                }
                case 3: {
                    Object object2;
                    String string = iOption.getCommand() != null ? iOption.getCommand() : "";
                    String[] stringArray = iOption.getStringListValue();
                    String[] stringArray2 = string.split("%s");
                    string = stringArray2.length > 0 ? stringArray2[0] : string;
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        object2 = stringArray[n2];
                        if (string != null) {
                            stringBuffer.append(string);
                        }
                        stringBuffer.append(String.valueOf(object2) + " ");
                        ++n2;
                    }
                    break;
                }
                case 4: {
                    Object object;
                    String string = iOption.getCommand();
                    Object object2 = iOption.getIncludePaths();
                    int n3 = 0;
                    while (n3 < ((String[])object2).length) {
                        object = object2[n3];
                        stringBuffer.append(String.valueOf(string) + (String)object + " ");
                        ++n3;
                    }
                    break;
                }
                case 5: {
                    String string = iOption.getCommand();
                    Object object = iOption.getDefinedSymbols();
                    int n4 = 0;
                    while (n4 < ((String[])object).length) {
                        String string3 = object[n4];
                        stringBuffer.append(String.valueOf(string) + string3 + " ");
                        ++n4;
                    }
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    public IOptionCategory getTopOptionCategory() {
        try {
            return this.parent.getTopOptionCategory();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private OptionReference getOptionReference(IOption iOption) {
        ListIterator listIterator = this.getAllOptionRefs().listIterator();
        while (listIterator.hasNext()) {
            OptionReference optionReference = (OptionReference)listIterator.next();
            if (!optionReference.references(iOption)) continue;
            return optionReference;
        }
        return null;
    }

    private OptionReference getOptionReference(String string) {
        Iterator iterator = this.getOptionReferenceList().iterator();
        while (iterator.hasNext()) {
            OptionReference optionReference = (OptionReference)iterator.next();
            if (!optionReference.getId().equals(string)) continue;
            return optionReference;
        }
        return null;
    }

    public List getOptionReferenceList() {
        if (this.optionReferences == null) {
            this.optionReferences = new ArrayList();
        }
        return this.optionReferences;
    }

    public IOption[] getOptions() {
        IOption[] iOptionArray = this.parent.getOptions();
        int n = 0;
        while (n < iOptionArray.length) {
            OptionReference optionReference = this.getOptionReference(iOptionArray[n]);
            if (optionReference != null) {
                iOptionArray[n] = optionReference;
            }
            ++n;
        }
        return iOptionArray;
    }

    public String[] getOutputExtensions() {
        if (this.outputExtensions == null) {
            this.outputExtensions = new String();
        }
        return this.outputExtensions.split(DEFAULT_SEPARATOR);
    }

    public String getOutputExtension(String string) {
        if (this.parent == null) {
            return new String();
        }
        return this.parent.getOutputExtension(string);
    }

    public String getOutputFlag() {
        if (this.outputFlag == null) {
            if (this.parent != null) {
                return this.parent.getOutputFlag();
            }
            return new String();
        }
        return this.outputFlag;
    }

    public String getOutputPrefix() {
        if (this.outputPrefix == null) {
            if (this.parent != null) {
                return this.parent.getOutputPrefix();
            }
            return new String();
        }
        return this.outputPrefix;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isHeaderFile(String string) {
        if (this.parent == null) {
            return false;
        }
        return this.parent.isHeaderFile(string);
    }

    public boolean ownedByConfiguration(IConfiguration iConfiguration) {
        if (this.owner instanceof Configuration) {
            return ((IConfiguration)this.owner).equals(iConfiguration);
        }
        return false;
    }

    public void serialize(Document document, Element element) {
        if (this.parent == null) {
            return;
        }
        element.setAttribute("id", this.parent.getId());
        if (this.command != null) {
            element.setAttribute("command", this.getToolCommand());
        }
        if (this.outputPrefix != null) {
            element.setAttribute("outputPrefix", this.getOutputPrefix());
        }
        if (this.inputFlag != null) {
            element.setAttribute("inputFlag", this.getInputFlag());
        }
        if (this.outputFlag != null) {
            element.setAttribute("outputFlag", this.getOutputFlag());
        }
        if (this.outputExtensions != null) {
            element.setAttribute("outputs", this.outputExtensions);
        }
        ListIterator listIterator = this.getOptionReferenceList().listIterator();
        while (listIterator.hasNext()) {
            OptionReference optionReference = (OptionReference)listIterator.next();
            Element element2 = document.createElement("optionReference");
            element.appendChild(element2);
            optionReference.serialize(document, element2);
        }
        this.isDirty = false;
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public boolean setToolCommand(String string) {
        if (string != null && !string.equals(this.command)) {
            this.command = string;
            this.isDirty = true;
            return true;
        }
        return false;
    }

    public String toString() {
        String string = new String();
        if (this.parent != null) {
            string = String.valueOf(string) + "Reference to " + this.parent.getName();
        }
        if (string.length() > 0) {
            return string;
        }
        return super.toString();
    }
}

