/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.scannerconfig;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.scannerconfig.IManagedScannerInfoCollector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;

public class ManagedBuildCPathEntryContainer
implements IPathEntryContainer {
    private static final String BUILDER_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".ScannerConfigBuilder";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String ERROR_HEADER = "PathEntryContainer error [";
    private static final String TRACE_FOOTER = "]: ";
    private static final String TRACE_HEADER = "PathEntryContainer trace [";
    private ITarget defaultTarget;
    private Vector entries;
    private IProject project;
    private ManagedBuildInfo info;
    public static boolean VERBOSE = false;

    public static void outputTrace(String string, String string2) {
        if (VERBOSE) {
            System.out.println(TRACE_HEADER + string + TRACE_FOOTER + string2 + NEWLINE);
        }
    }

    public static void outputError(String string, String string2) {
        if (VERBOSE) {
            System.err.println(ERROR_HEADER + string + TRACE_FOOTER + string2 + NEWLINE);
        }
    }

    public ManagedBuildCPathEntryContainer(IProject iProject) {
        this.project = iProject;
        this.entries = new Vector();
    }

    protected void addDefinedSymbols(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            boolean bl = true;
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            ListIterator listIterator = this.entries.listIterator();
            while (listIterator.hasNext()) {
                IPathEntry iPathEntry = (IPathEntry)listIterator.next();
                if (iPathEntry.getEntryKind() != 6 || !((IMacroEntry)iPathEntry).getMacroName().equals(string) || !((IMacroEntry)iPathEntry).getMacroValue().equals(string2)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.entries.add(CoreModel.newMacroEntry((IPath)Path.EMPTY, (String)string, (String)string2));
        }
    }

    protected void addIncludePaths(List list) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            IIncludeEntry iIncludeEntry = CoreModel.newIncludeEntry((IPath)Path.EMPTY, (IPath)Path.EMPTY, (IPath)new Path(string), (boolean)true);
            if (this.entries.contains(iIncludeEntry)) continue;
            this.entries.add(iIncludeEntry);
        }
    }

    protected void calculateBuiltIns(ITarget iTarget, IConfiguration iConfiguration) {
        ITool[] iToolArray = iConfiguration.getFilteredTools(this.info.getOwner().getProject());
        int n = 0;
        while (n < iToolArray.length) {
            ITool iTool = iToolArray[n];
            IOption[] iOptionArray = iTool.getOptions();
            int n2 = 0;
            while (n2 < iOptionArray.length) {
                String[] stringArray;
                IOption iOption = iOptionArray[n2];
                if (iOption.getValueType() == 5) {
                    stringArray = iOption.getBuiltIns();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        String string = stringArray[n3];
                        String[] stringArray2 = string.split("=");
                        String string2 = stringArray2[0].trim();
                        String string3 = stringArray2.length > 1 ? stringArray2[1] : new String();
                        hashMap.put(string2, string3);
                        ++n3;
                    }
                    this.addDefinedSymbols(hashMap);
                } else if (iOption.getValueType() == 4 && (stringArray = iOption.getBuiltIns()).length > 0) {
                    this.addIncludePaths(Arrays.asList(stringArray));
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void calculateEntriesDynamically(final IProject iProject, final IScannerInfoCollector iScannerInfoCollector) {
        final IScannerConfigBuilderInfo iScannerConfigBuilderInfo = MakeCorePlugin.createScannerConfigBuildInfo((Preferences)MakeCorePlugin.getDefault().getPluginPreferences(), (String)BUILDER_ID, (boolean)false);
        final IExternalScannerInfoProvider iExternalScannerInfoProvider = MakeCorePlugin.getDefault().getExternalScannerInfoProvider(MakeCorePlugin.DEFAULT_EXTERNAL_SI_PROVIDER_ID);
        Vector vector = new Vector();
        final String string = iScannerInfoCollector.getESIProviderArguments();
        final IPath iPath = iScannerInfoCollector.getESIProviderCommand();
        final Vector vector2 = vector;
        ISafeRunnable iSafeRunnable = new ISafeRunnable(){
            private String runArgs;
            private IPath runCommand;
            {
                this.runArgs = string2 == null ? null : new String(string2);
                this.runCommand = iPath2 == null ? null : new Path(iPath2.toString());
            }

            public void run() {
                NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
                iExternalScannerInfoProvider.invokeProvider((IProgressMonitor)nullProgressMonitor, iProject, iScannerConfigBuilderInfo, iPath, string, (List)vector2, iScannerInfoCollector);
            }

            public void handleException(Throwable throwable) {
                if (throwable instanceof OperationCanceledException) {
                    throw (OperationCanceledException)throwable;
                }
            }
        };
        Platform.run((ISafeRunnable)iSafeRunnable);
    }

    public IPathEntry[] getPathEntries() {
        this.info = (ManagedBuildInfo)ManagedBuildManager.getBuildInfo((IResource)this.project);
        if (this.info == null) {
            ManagedBuildCPathEntryContainer.outputError(this.project.getName(), "Build information is null");
            return this.entries.toArray(new IPathEntry[this.entries.size()]);
        }
        this.defaultTarget = this.info.getDefaultTarget();
        if (this.defaultTarget == null) {
            ManagedBuildCPathEntryContainer.outputError(this.project.getName(), "Build information has not been loaded yet");
            return this.entries.toArray(new IPathEntry[this.entries.size()]);
        }
        ITarget iTarget = this.defaultTarget.getParent();
        if (iTarget == null) {
            ManagedBuildCPathEntryContainer.outputError(this.project.getName(), "Build information has not been loaded yet");
            return this.entries.toArray(new IPathEntry[this.entries.size()]);
        }
        String string = iTarget.getId();
        IManagedScannerInfoCollector iManagedScannerInfoCollector = ManagedBuildManager.getScannerInfoCollector(string);
        if (iManagedScannerInfoCollector != null) {
            ManagedBuildCPathEntryContainer.outputTrace(this.project.getName(), "Path entries collected dynamically");
            iManagedScannerInfoCollector.setProject(this.info.getOwner().getProject());
            this.calculateEntriesDynamically((IProject)this.info.getOwner(), iManagedScannerInfoCollector);
            this.addIncludePaths(iManagedScannerInfoCollector.getIncludePaths());
            this.addDefinedSymbols(iManagedScannerInfoCollector.getDefinedSymbols());
        } else {
            IConfiguration iConfiguration = this.info.getDefaultConfiguration(this.defaultTarget);
            if (iConfiguration != null) {
                this.calculateBuiltIns(this.defaultTarget, iConfiguration);
                ManagedBuildCPathEntryContainer.outputTrace(this.project.getName(), "Path entries set using built-in definitions from " + iConfiguration.getName());
            } else {
                ManagedBuildCPathEntryContainer.outputError(this.project.getName(), "Configuration is null");
                return this.entries.toArray(new IPathEntry[this.entries.size()]);
            }
        }
        return this.entries.toArray(new IPathEntry[this.entries.size()]);
    }

    public String getDescription() {
        return "CDT Managed Build Project";
    }

    public IPath getPath() {
        return new Path("org.eclipse.cdt.managedbuilder.MANAGED_CONTAINER");
    }
}

