/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.makegen.gnu;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class GnuMakefileGenerator
implements IManagedBuilderMakefileGenerator {
    private static final String COMMENT = "MakefileGenerator.comment";
    private static final String AUTO_DEP = "MakefileGenerator.comment.autodeps";
    private static final String MESSAGE = "ManagedMakeBuilder.message";
    private static final String BUILD_ERROR = "ManagedMakeBuilder.message.error";
    private static final String DEP_INCL = "MakefileGenerator.comment.module.dep.includes";
    private static final String HEADER = "MakefileGenerator.comment.header";
    protected static final String MESSAGE_FINISH_BUILD = ManagedMakeMessages.getResourceString("MakefileGenerator.message.finish.build");
    protected static final String MESSAGE_FINISH_FILE = ManagedMakeMessages.getResourceString("MakefileGenerator.message.finish.file");
    protected static final String MESSAGE_START_BUILD = ManagedMakeMessages.getResourceString("MakefileGenerator.message.start.build");
    protected static final String MESSAGE_START_FILE = ManagedMakeMessages.getResourceString("MakefileGenerator.message.start.file");
    private static final String MOD_INCL = "MakefileGenerator.comment.module.make.includes";
    private static final String MOD_LIST = "MakefileGenerator.comment.module.list";
    private static final String MOD_RULES = "MakefileGenerator.comment.build.rule";
    private static final String SRC_LISTS = "MakefileGenerator.comment.source.list";
    private String buildTargetName;
    private Vector buildTools;
    private Vector deletedFileList;
    private Vector dependencyMakefiles;
    private String extension;
    private IManagedBuildInfo info;
    private Vector invalidDirList;
    private Vector modifiedList;
    private IProgressMonitor monitor;
    private Set outputExtensionsSet;
    private IProject project;
    private Vector ruleList;
    private Vector subdirList;
    private IPath topBuildDir;

    protected StringBuffer addDefaultHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        this.outputCommentLine(stringBuffer);
        stringBuffer.append("# " + ManagedMakeMessages.getResourceString(HEADER) + IManagedBuilderMakefileGenerator.NEWLINE);
        this.outputCommentLine(stringBuffer);
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        return stringBuffer;
    }

    protected StringBuffer addFragmentDependenciesHeader() {
        return this.addDefaultHeader();
    }

    protected StringBuffer addFragmentMakefileHeader() {
        return this.addDefaultHeader();
    }

    private StringBuffer addMacros() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ROOT := .." + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("-include $(ROOT)/makefile.init" + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("RM := ");
        stringBuffer.append(String.valueOf(this.info.getCleanCommand()) + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("# " + ManagedMakeMessages.getResourceString(SRC_LISTS) + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("-include sources.mk" + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("-include $(SUBDIRS:%=%/subdir.mk)" + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("-include objects.mk" + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("-include $(DEPS)" + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("-include $(ROOT)/makefile.defs" + IManagedBuilderMakefileGenerator.NEWLINE);
        return stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
    }

    private void addRule(String string, StringBuffer stringBuffer, IResource iResource) {
        Object object;
        boolean bl;
        String string2 = null;
        String string3 = this.getFileName(iResource);
        String string4 = iResource.getFileExtension();
        String string5 = this.info.getToolForSource(string4);
        String string6 = this.info.getOutputExtension(string4);
        String string7 = null;
        String string8 = null;
        String string9 = null;
        IManagedDependencyGenerator iManagedDependencyGenerator = this.info.getDependencyGenerator(string4);
        boolean bl2 = bl = iManagedDependencyGenerator != null && iManagedDependencyGenerator.getCalculatorType() == 1;
        if (bl) {
            object = String.valueOf(string) + string3 + "." + "d";
            this.getDependencyMakefiles().add(object);
        }
        object = iResource.getLocation();
        String string10 = this.project.getLocation().toString();
        String string11 = null;
        String string12 = null;
        if (!object.toString().startsWith(string10)) {
            string11 = object.toString();
            string12 = String.valueOf(string) + string3 + "." + string6 + ":" + " " + string11;
        } else {
            string11 = string;
            string12 = String.valueOf(string) + "%" + "." + string6 + ":" + " " + "$(ROOT)" + "/" + string11 + "%" + "." + string4;
        }
        if (this.getRuleList().contains(string12)) {
            return;
        }
        this.getRuleList().add(string12);
        stringBuffer.append(String.valueOf(string12) + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("\t@echo '" + MESSAGE_START_FILE + " " + "$<" + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
        string2 = this.info.getFlagsForSource(string4);
        string7 = this.info.getInputFlag(string6);
        string8 = this.info.getOutputFlag(string6);
        string9 = this.info.getOutputPrefix(string6);
        String string13 = String.valueOf(string5) + " " + string2 + " " + string8 + string9 + "$@" + " " + string7 + " " + "$<";
        stringBuffer.append("\t@echo " + string13 + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("\t@" + string13);
        if (bl && iManagedDependencyGenerator.getCalculatorType() == 1) {
            stringBuffer.append(" && \\\n");
            String string14 = iManagedDependencyGenerator.getDependencyCommand(iResource, this.info);
            stringBuffer.append(string14);
        }
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("\t@echo '" + MESSAGE_FINISH_FILE + " " + "$<" + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("\t@echo ' '" + IManagedBuilderMakefileGenerator.NEWLINE + IManagedBuilderMakefileGenerator.NEWLINE);
    }

    private StringBuffer addSources(IContainer iContainer) throws CoreException {
        CharSequence charSequence;
        Object object;
        IResource[] iResourceArray;
        Object object2;
        Object object3;
        IPath iPath = iContainer.getProjectRelativePath();
        String string = iPath.toString();
        string = String.valueOf(string) + (string.length() == 0 ? "" : "/");
        string = this.escapeWhitespaces(string);
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        this.getOutputExtentions();
        Iterator iterator = this.buildTools.iterator();
        while (iterator.hasNext()) {
            object3 = ((ITool)iterator.next()).getInputExtensions();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                iResourceArray = object2.next().toString();
                if (hashMap.containsKey(iResourceArray) || this.getOutputExtentions().contains(iResourceArray)) continue;
                StringBuffer stringBuffer = this.getMacroName((String)iResourceArray);
                object = new StringBuffer();
                ((StringBuffer)object).append(stringBuffer + " " + "+=" + " " + "\\\n");
                ((StringBuffer)object).append("${addprefix $(ROOT)/" + string + "," + " " + "\\\n");
                hashMap.put(iResourceArray, ((StringBuffer)object).toString());
            }
        }
        object3 = new StringBuffer();
        object2 = new StringBuffer("# " + ManagedMakeMessages.getResourceString(MOD_RULES) + IManagedBuilderMakefileGenerator.NEWLINE);
        iResourceArray = iContainer.members();
        int n = 0;
        while (n < iResourceArray.length) {
            object = iResourceArray[n];
            if (object.getType() == 1 && this.info.buildsFileType((String)(charSequence = object.getFileExtension()))) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(hashMap.get(charSequence).toString());
                if (stringBuffer != null && !this.getOutputExtentions().contains(stringBuffer.toString())) {
                    stringBuffer.append(String.valueOf(object.getName()) + " " + "\\\n");
                    hashMap.put(charSequence, stringBuffer.toString());
                    this.addRule(string, (StringBuffer)object2, (IResource)object);
                }
            }
            ++n;
        }
        Collection collection = hashMap.values();
        object = collection.iterator();
        while (object.hasNext()) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(object.next().toString());
            ((StringBuffer)charSequence).append("}" + IManagedBuilderMakefileGenerator.NEWLINE + IManagedBuilderMakefileGenerator.NEWLINE);
            ((StringBuffer)object3).append((StringBuffer)charSequence);
        }
        return ((StringBuffer)object3).append(object2 + IManagedBuilderMakefileGenerator.NEWLINE);
    }

    private StringBuffer addSubdirectories() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# " + ManagedMakeMessages.getResourceString(MOD_LIST) + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("SUBDIRS := \\\n");
        ListIterator listIterator = this.getSubdirList().listIterator();
        while (listIterator.hasNext()) {
            IContainer iContainer = (IContainer)listIterator.next();
            this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.adding.source.folder", iContainer.getFullPath().toString()));
            if (iContainer.getFullPath() == this.project.getFullPath()) {
                stringBuffer.append(". \\\n");
                continue;
            }
            IPath iPath = iContainer.getProjectRelativePath();
            stringBuffer.append(String.valueOf(iPath.toString()) + " " + "\\\n");
        }
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        return stringBuffer;
    }

    private StringBuffer addTargets(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.info.getToolForTarget(this.extension);
        String string2 = this.info.getFlagsForTarget(this.extension);
        String string3 = this.info.getOutputFlag(this.extension);
        String string4 = this.info.getOutputPrefix(this.extension);
        String string5 = bl ? "clean all" : "all";
        IProject[] iProjectArray = null;
        try {
            iProjectArray = this.project.getReferencedProjects();
        }
        catch (CoreException coreException) {}
        String string6 = "all:";
        stringBuffer.append(String.valueOf(string6) + " " + string4 + this.buildTargetName);
        if (this.extension.length() > 0) {
            stringBuffer.append("." + this.extension);
        }
        stringBuffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + IManagedBuilderMakefileGenerator.NEWLINE);
        Vector<String> vector = new Vector<String>(iProjectArray.length);
        if (iProjectArray.length > 0) {
            boolean bl2 = true;
            if (iProjectArray != null) {
                int n = 0;
                while (n < iProjectArray.length) {
                    IProject iProject = iProjectArray[n];
                    if (iProject.exists()) {
                        if (bl2) {
                            stringBuffer.append("dependents:" + IManagedBuilderMakefileGenerator.NEWLINE);
                            bl2 = false;
                        }
                        String string7 = iProject.getLocation().toString();
                        String string8 = string5;
                        if (ManagedBuildManager.manages((IResource)iProject)) {
                            IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
                            string7 = String.valueOf(string7) + "/" + iManagedBuildInfo.getConfigurationName();
                            String string9 = iManagedBuildInfo.getBuildArtifactName();
                            String string10 = iManagedBuildInfo.getBuildArtifactExtension();
                            String string11 = iManagedBuildInfo.getOutputPrefix(string10);
                            if (iManagedBuildInfo.needsRebuild()) {
                                string8 = "clean all";
                            }
                            String string12 = String.valueOf(string7) + "/" + string11 + string9;
                            if (string10.length() > 0) {
                                string12 = String.valueOf(string12) + "." + string10;
                            }
                            string12 = this.escapeWhitespaces(string12);
                            vector.add(string12);
                        }
                        stringBuffer.append("\t-cd " + this.escapeWhitespaces(string7) + " " + "&&" + " " + "$(MAKE) " + string8 + IManagedBuilderMakefileGenerator.NEWLINE);
                    }
                    ++n;
                }
            }
            stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        }
        stringBuffer.append(String.valueOf(string4) + this.buildTargetName);
        if (this.extension.length() > 0) {
            stringBuffer.append("." + this.extension);
        }
        stringBuffer.append(": $(OBJS)");
        ListIterator listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            stringBuffer.append(" " + (String)listIterator.next());
        }
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("\t@echo '" + MESSAGE_START_BUILD + " " + "$@" + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("\t" + string + " " + string2 + " " + string3 + " " + "$@" + " " + "$(OBJS) $(USER_OBJS) $(LIBS)" + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("\t@echo '" + MESSAGE_FINISH_FILE + " " + "$@" + "'" + IManagedBuilderMakefileGenerator.NEWLINE + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("clean:" + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("\t-$(RM) $(OBJS) $(DEPS) " + string4 + this.buildTargetName);
        if (this.extension.length() > 0) {
            stringBuffer.append("." + this.extension);
        }
        stringBuffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append(".PHONY: all clean dependents" + IManagedBuilderMakefileGenerator.NEWLINE);
        listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            stringBuffer.append(String.valueOf((String)listIterator.next()) + ":" + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("-include $(ROOT)/makefile.targets" + IManagedBuilderMakefileGenerator.NEWLINE);
        return stringBuffer;
    }

    protected StringBuffer addTopHeader() {
        return this.addDefaultHeader();
    }

    protected void appendBuildSubdirectory(IResource iResource) {
        IContainer iContainer = iResource.getParent();
        if (iResource.getProjectRelativePath().toString().indexOf(" ") != -1) {
            if (!this.getInvalidDirList().contains(iContainer)) {
                this.getInvalidDirList().add(iContainer);
            }
        } else if (!this.getSubdirList().contains(iContainer)) {
            this.getSubdirList().add(iContainer);
        }
    }

    protected void appendDeletedFile(IResource iResource) {
        this.getDeletedFileList().add(iResource);
    }

    protected void appendModifiedSubdirectory(IResource iResource) {
        IContainer iContainer = iResource.getParent();
        if (iResource.getProjectRelativePath().toString().indexOf(" ") != -1) {
            if (!this.getInvalidDirList().contains(iContainer)) {
                this.getInvalidDirList().add(iContainer);
            }
        } else if (!this.getModifiedList().contains(iContainer)) {
            this.getModifiedList().add(iContainer);
        }
    }

    protected void cancel(String string) {
        if (this.monitor != null && !this.monitor.isCanceled()) {
            throw new OperationCanceledException(string);
        }
    }

    protected void checkCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private IPath createDirectory(String string) throws CoreException {
        IFolder iFolder = this.project.getFolder(string);
        if (!iFolder.exists()) {
            IFolder iFolder2;
            IPath iPath = new Path(string).removeLastSegments(1);
            if (!iPath.isEmpty() && !(iFolder2 = this.project.getFolder(iPath)).exists()) {
                this.createDirectory(iPath.toString());
            }
            try {
                iFolder.create(true, true, null);
            }
            catch (CoreException coreException) {
                if (coreException.getStatus().getCode() == 374) {
                    iFolder.refreshLocal(0, null);
                }
                throw coreException;
            }
            if (!iFolder.isDerived()) {
                iFolder.setDerived(true);
            }
        }
        return iFolder.getFullPath();
    }

    private IFile createFile(IPath iPath) throws CoreException {
        IWorkspaceRoot iWorkspaceRoot = CCorePlugin.getWorkspace().getRoot();
        IFile iFile = iWorkspaceRoot.getFileForLocation(iPath);
        if (iFile == null) {
            iFile = iWorkspaceRoot.getFile(iPath);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
        try {
            iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            if (!iFile.isDerived()) {
                iFile.setDerived(true);
            }
        }
        catch (CoreException coreException) {
            if (coreException.getStatus().getCode() == 374) {
                iFile.refreshLocal(0, null);
            }
            throw coreException;
        }
        return iFile;
    }

    private void deleteBuildTarget(IResource iResource) {
        String string = this.getFileName(iResource);
        String string2 = iResource.getFileExtension();
        String string3 = this.info.getOutputExtension(string2);
        string = String.valueOf(string) + "." + string3;
        IPath iPath = iResource.getProjectRelativePath().removeLastSegments(1);
        IPath iPath2 = this.getBuildWorkingDir().append(iPath).append(string);
        IResource iResource2 = this.project.findMember(iPath2);
        if (iResource2 != null && iResource2.exists()) {
            try {
                iResource2.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException coreException) {}
        }
    }

    private void deleteDepFile(IResource iResource) {
        String string = this.getFileName(iResource);
        string = String.valueOf(string) + ".d";
        IPath iPath = iResource.getProjectRelativePath().removeLastSegments(1);
        IPath iPath2 = this.getBuildWorkingDir().append(iPath).append(string);
        IResource iResource2 = this.project.findMember(iPath2);
        if (iResource2 != null && iResource2.exists()) {
            try {
                iResource2.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException coreException) {}
        }
    }

    protected String escapeWhitespaces(String string) {
        String[] stringArray = string.split("\\s");
        if (stringArray.length > 1) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                if (n + 1 < stringArray.length) {
                    stringBuffer.append("\\ ");
                }
                ++n;
            }
            return stringBuffer.toString().trim();
        }
        return string;
    }

    public void generateDependencies() throws CoreException {
        IWorkspaceRoot iWorkspaceRoot = CCorePlugin.getWorkspace().getRoot();
        ListIterator listIterator = this.getSubdirList().listIterator();
        while (listIterator.hasNext()) {
            IContainer iContainer = (IContainer)listIterator.next();
            IPath iPath = iContainer.getProjectRelativePath();
            IPath iPath2 = this.topBuildDir.append(iPath);
            IFolder iFolder = iWorkspaceRoot.getFolder(iPath2);
            if (iFolder == null) continue;
            IResource[] iResourceArray = iFolder.members();
            int n = 0;
            while (n < iResourceArray.length) {
                IFile iFile;
                IResource iResource = iResourceArray[n];
                if ("d".equals(iResource.getFileExtension()) && (iFile = iWorkspaceRoot.getFile(iResource.getFullPath())) != null) {
                    try {
                        this.updateMonitor(ManagedMakeMessages.getFormattedString("GnuMakefileGenerator.message.postproc.dep.file", iFile.getName()));
                        this.populateDummyTargets(iFile, false);
                    }
                    catch (CoreException coreException) {
                        throw coreException;
                    }
                    catch (IOException iOException) {}
                }
                ++n;
            }
        }
    }

    public MultiStatus generateMakefiles(IResourceDelta iResourceDelta) throws CoreException {
        MultiStatus multiStatus;
        IFile iFile;
        IFile iFile2;
        IContainer iContainer;
        IFolder iFolder = this.project.getFolder(this.info.getConfigurationName());
        if (!iFolder.exists()) {
            return this.regenerateMakefiles();
        }
        this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.calc.delta", this.project.getName()));
        ResourceDeltaVisitor resourceDeltaVisitor = new ResourceDeltaVisitor(this, this.info);
        iResourceDelta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
        this.checkCancel();
        this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.finding.sources", this.project.getName()));
        ResourceProxyVisitor resourceProxyVisitor = new ResourceProxyVisitor(this, this.info);
        this.project.accept((IResourceProxyVisitor)resourceProxyVisitor, 0);
        this.checkCancel();
        if (this.getSubdirList().isEmpty()) {
            String string = ManagedMakeMessages.getFormattedString("MakefileGenerator.warning.no.source", this.project.getName());
            this.updateMonitor(string);
            MultiStatus multiStatus2 = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, string, null);
            multiStatus2.add((IStatus)new Status(1, ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, new String(), null));
            return multiStatus2;
        }
        this.topBuildDir = this.createDirectory(this.info.getConfigurationName());
        this.checkCancel();
        IPath iPath = this.topBuildDir.addTrailingSeparator().append("sources.mk");
        IFile iFile3 = this.createFile(iPath);
        this.populateSourcesMakefile(iFile3);
        this.checkCancel();
        Iterator iterator = this.getSubdirList().listIterator();
        while (iterator.hasNext()) {
            iContainer = (IContainer)iterator.next();
            if (this.getModifiedList().contains(iContainer) || (iFile2 = this.project.getFile((IPath)(iFile = this.getBuildWorkingDir().append(iContainer.getProjectRelativePath()).addTrailingSeparator().append("subdir.mk")))).exists()) continue;
            this.getModifiedList().add(iContainer);
        }
        iterator = this.getDeletedFileList().listIterator();
        while (iterator.hasNext()) {
            iContainer = (IResource)iterator.next();
            this.deleteDepFile((IResource)iContainer);
            this.deleteBuildTarget((IResource)iContainer);
        }
        iContainer = this.topBuildDir.addTrailingSeparator().append("makefile");
        iFile = this.createFile((IPath)iContainer);
        this.populateTopMakefile(iFile, false);
        this.checkCancel();
        iterator = this.getModifiedList().listIterator();
        while (iterator.hasNext()) {
            iFile2 = (IContainer)iterator.next();
            this.populateFragmentMakefile((IContainer)iFile2);
            this.checkCancel();
        }
        if (!this.getInvalidDirList().isEmpty()) {
            multiStatus = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 2, new String(), null);
            iterator = this.getInvalidDirList().iterator();
            while (iterator.hasNext()) {
                multiStatus.add((IStatus)new Status(2, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ((IContainer)iterator.next()).getFullPath().toString(), null));
            }
        } else {
            multiStatus = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, new String(), null);
        }
        return multiStatus;
    }

    public IPath getBuildWorkingDir() {
        if (this.topBuildDir != null) {
            return this.topBuildDir.removeFirstSegments(1);
        }
        return null;
    }

    private Vector getDeletedFileList() {
        if (this.deletedFileList == null) {
            this.deletedFileList = new Vector();
        }
        return this.deletedFileList;
    }

    private Vector getDependencyMakefiles() {
        if (this.dependencyMakefiles == null) {
            this.dependencyMakefiles = new Vector();
        }
        return this.dependencyMakefiles;
    }

    private String getFileName(IResource iResource) {
        String string = new String();
        String string2 = iResource.getName();
        int n = string2.lastIndexOf(".");
        if (n != -1) {
            string = string2.substring(0, n);
        }
        return string;
    }

    private Vector getInvalidDirList() {
        if (this.invalidDirList == null) {
            this.invalidDirList = new Vector();
        }
        return this.invalidDirList;
    }

    protected StringBuffer getMacroName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.equals(string.toUpperCase())) {
            stringBuffer.append(String.valueOf(string.toUpperCase()) + "_UPPER");
        } else {
            stringBuffer.append(string.toUpperCase());
        }
        stringBuffer.append("_SRCS");
        return stringBuffer;
    }

    public String getMakefileName() {
        return new String("makefile");
    }

    private Vector getModifiedList() {
        if (this.modifiedList == null) {
            this.modifiedList = new Vector();
        }
        return this.modifiedList;
    }

    protected Set getOutputExtentions() {
        if (this.outputExtensionsSet == null) {
            this.outputExtensionsSet = new HashSet();
            Iterator iterator = this.buildTools.iterator();
            while (iterator.hasNext()) {
                String[] stringArray = ((ITool)iterator.next()).getOutputExtensions();
                this.outputExtensionsSet.addAll(Arrays.asList(stringArray));
            }
        }
        return this.outputExtensionsSet;
    }

    private Vector getRuleList() {
        if (this.ruleList == null) {
            this.ruleList = new Vector();
        }
        return this.ruleList;
    }

    private Vector getSubdirList() {
        if (this.subdirList == null) {
            this.subdirList = new Vector();
        }
        return this.subdirList;
    }

    public void initialize(IProject iProject, IManagedBuildInfo iManagedBuildInfo, IProgressMonitor iProgressMonitor) {
        this.project = iProject;
        this.monitor = iProgressMonitor;
        this.info = iManagedBuildInfo;
        this.buildTargetName = iManagedBuildInfo.getBuildArtifactName();
        this.extension = iManagedBuildInfo.getBuildArtifactExtension();
        if (this.extension == null) {
            this.extension = new String();
        }
        this.buildTools = new Vector<ITool>(Arrays.asList(iManagedBuildInfo.getDefaultTarget().getTools()));
    }

    public boolean isGeneratedResource(IResource iResource) {
        IPath iPath = iResource.getProjectRelativePath();
        String[] stringArray = this.info.getConfigurationNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            Path path = new Path(string);
            if (path.isPrefixOf(iPath)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void outputCommentLine(StringBuffer stringBuffer) {
        int n = 0;
        while (n < 80) {
            stringBuffer.append("#");
            ++n;
        }
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
    }

    protected void populateDummyTargets(IFile iFile, boolean bl) throws CoreException, IOException {
        String string;
        String string2;
        Object object;
        String string3;
        CharSequence charSequence;
        if (iFile == null || !iFile.exists()) {
            return;
        }
        InputStream inputStream = iFile.getContents(false);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringBuffer stringBuffer = null;
        int n = inputStream.available();
        stringBuffer = new StringBuffer(n);
        char[] cArray = new char[n];
        int n2 = inputStreamReader.read(cArray);
        while (n2 > 0) {
            stringBuffer.append(cArray);
            n2 = inputStreamReader.read(cArray);
        }
        inputStream.close();
        if (stringBuffer == null) {
            return;
        }
        String string4 = stringBuffer.toString();
        if (!bl && string4.startsWith("#")) {
            return;
        }
        Vector<String> vector = new Vector<String>(Arrays.asList(string4.split("\\s")));
        Vector<String> vector2 = new Vector<String>(vector.size());
        Iterator<String> iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string5 = iterator.next();
            if (string5.lastIndexOf("\\") == string5.length() - 1 && string5.length() > 1) {
                while (iterator.hasNext()) {
                    charSequence = iterator.next();
                    string5 = String.valueOf(string5) + " " + (String)charSequence;
                    if (!((String)charSequence).endsWith("\\")) break;
                }
            }
            vector2.add(string5);
        }
        vector2.trimToSize();
        boolean bl2 = false;
        charSequence = null;
        try {
            string3 = (String)vector2.get(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        charSequence = !string3.startsWith("#") ? this.addDefaultHeader() : new StringBuffer();
        if (string3.startsWith("-n")) {
            try {
                object = (String)vector2.get(1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                object = new String();
            }
            if (((String)object).startsWith("'")) {
                ((StringBuffer)charSequence).append(String.valueOf(((String)object).substring(1)) + " ");
            } else {
                ((StringBuffer)charSequence).append(String.valueOf(object) + " ");
            }
            try {
                string2 = (String)vector2.get(2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string2 = new String();
            }
            int n3 = string2.lastIndexOf("'");
            if (n3 != -1) {
                if (n3 == 0) {
                    ((StringBuffer)charSequence).append(" ");
                } else {
                    ((StringBuffer)charSequence).append(string2.substring(0, n3 - 1));
                }
            } else {
                ((StringBuffer)charSequence).append(string2);
            }
            try {
                string = (String)vector2.get(3);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string = new String();
            }
            ((StringBuffer)charSequence).append(String.valueOf(string) + " ");
            try {
                ListIterator listIterator = vector2.listIterator(4);
                while (listIterator.hasNext()) {
                    String string6 = (String)listIterator.next();
                    if (string6.endsWith("\\")) {
                        ((StringBuffer)charSequence).append(String.valueOf(string6) + IManagedBuilderMakefileGenerator.NEWLINE + " ");
                        continue;
                    }
                    ((StringBuffer)charSequence).append(String.valueOf(string6) + " ");
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        } else {
            ((StringBuffer)charSequence).append(stringBuffer);
        }
        ((StringBuffer)charSequence).append(IManagedBuilderMakefileGenerator.NEWLINE);
        bl2 = true;
        object = vector2.iterator();
        while (object.hasNext()) {
            string2 = (String)object.next();
            Path path = new Path(string2);
            string = path.getFileExtension();
            if (!this.info.isHeaderFile(string)) continue;
            ((StringBuffer)charSequence).append(String.valueOf(string2) + ":" + IManagedBuilderMakefileGenerator.NEWLINE + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        if (bl2) {
            Util.save((StringBuffer)charSequence, (IFile)iFile);
        }
    }

    protected void populateFragmentMakefile(IContainer iContainer) throws CoreException {
        IPath iPath = iContainer.getProjectRelativePath();
        IPath iPath2 = this.getBuildWorkingDir();
        if (iPath2 == null) {
            return;
        }
        IPath iPath3 = iPath2.append(iPath);
        this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.gen.source.makefile", iPath3.toString()));
        IPath iPath4 = this.createDirectory(iPath3.toString());
        IFile iFile = this.createFile(iPath4.addTrailingSeparator().append("subdir.mk"));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addFragmentMakefileHeader());
        stringBuffer.append(this.addSources(iContainer));
        Util.save((StringBuffer)stringBuffer, (IFile)iFile);
    }

    protected void populateObjectsMakefile(IFile iFile) throws CoreException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addDefaultHeader());
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("OBJS := \\\n");
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append("DEPS := \\\n");
        stringBuffer.append("LIBS := ");
        String[] stringArray = this.info.getLibsForTarget(this.extension);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            stringBuffer.append("\\\n" + string);
            ++n;
        }
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("USER_OBJS := ");
        String[] stringArray2 = this.info.getUserObjectsForTarget(this.extension);
        int n2 = 0;
        while (n2 < stringArray2.length) {
            object = stringArray2[n2];
            stringBuffer.append("\\\n" + (String)object);
            ++n2;
        }
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        HashSet<String> hashSet = new HashSet<String>();
        object = this.buildTools.iterator();
        while (object.hasNext()) {
            ITool iTool = (ITool)object.next();
            List list = iTool.getInputExtensions();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                if (this.getOutputExtentions().contains(string) || hashSet.contains(string)) continue;
                hashSet.add(string);
                StringBuffer stringBuffer4 = this.getMacroName(string);
                stringBuffer2.append(" $(" + stringBuffer4 + ":" + "$(ROOT)" + "/" + "%" + "." + string + "=" + "%" + "." + iTool.getOutputExtension(string) + ")");
                stringBuffer3.append(" $(" + stringBuffer4 + ":" + "$(ROOT)" + "/" + "%" + "." + string + "=" + "%" + "." + "d" + ")");
            }
        }
        stringBuffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + IManagedBuilderMakefileGenerator.NEWLINE + stringBuffer2);
        stringBuffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + IManagedBuilderMakefileGenerator.NEWLINE + stringBuffer3);
        Util.save((StringBuffer)stringBuffer, (IFile)iFile);
    }

    protected void populateSourcesMakefile(IFile iFile) throws CoreException {
        StringBuffer stringBuffer = this.addDefaultHeader();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.buildTools.iterator();
        while (iterator.hasNext()) {
            List list = ((ITool)iterator.next()).getInputExtensions();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string = iterator2.next().toString();
                if (this.getOutputExtentions().contains(string) || hashSet.contains(string)) continue;
                hashSet.add(string);
                StringBuffer stringBuffer2 = this.getMacroName(string);
                stringBuffer.append(stringBuffer2 + " " + ":=" + " " + IManagedBuilderMakefileGenerator.NEWLINE);
            }
        }
        stringBuffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + this.addSubdirectories());
        Util.save((StringBuffer)stringBuffer, (IFile)iFile);
    }

    protected void populateTopMakefile(IFile iFile, boolean bl) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addTopHeader());
        stringBuffer.append(this.addMacros());
        stringBuffer.append(this.addTargets(bl));
        Util.save((StringBuffer)stringBuffer, (IFile)iFile);
    }

    public void regenerateDependencies(boolean bl) throws CoreException {
        IWorkspaceRoot iWorkspaceRoot = CCorePlugin.getWorkspace().getRoot();
        ListIterator listIterator = this.getDependencyMakefiles().listIterator();
        while (listIterator.hasNext()) {
            IPath iPath = this.topBuildDir.append((IPath)new Path((String)listIterator.next()));
            IFile iFile = iWorkspaceRoot.getFile(iPath);
            if (iFile == null || !iFile.isAccessible()) continue;
            try {
                this.updateMonitor(ManagedMakeMessages.getFormattedString("GnuMakefileGenerator.message.postproc.dep.file", iFile.getName()));
                this.populateDummyTargets(iFile, true);
            }
            catch (CoreException coreException) {
                throw coreException;
            }
            catch (IOException iOException) {}
        }
    }

    public MultiStatus regenerateMakefiles() throws CoreException {
        MultiStatus multiStatus;
        IContainer iContainer;
        ResourceProxyVisitor resourceProxyVisitor = new ResourceProxyVisitor(this, this.info);
        this.project.accept((IResourceProxyVisitor)resourceProxyVisitor, 0);
        this.checkCancel();
        if (this.getSubdirList().isEmpty()) {
            String string = ManagedMakeMessages.getFormattedString("MakefileGenerator.warning.no.source", this.project.getName());
            this.updateMonitor(string);
            MultiStatus multiStatus2 = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, string, null);
            multiStatus2.add((IStatus)new Status(1, ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, new String(), null));
            return multiStatus2;
        }
        this.topBuildDir = this.createDirectory(this.info.getConfigurationName());
        this.checkCancel();
        IPath iPath = this.topBuildDir.addTrailingSeparator().append("sources.mk");
        IFile iFile = this.createFile(iPath);
        this.populateSourcesMakefile(iFile);
        this.checkCancel();
        Iterator iterator = this.getSubdirList().listIterator();
        while (iterator.hasNext()) {
            iContainer = (IContainer)iterator.next();
            try {
                this.populateFragmentMakefile(iContainer);
            }
            catch (CoreException coreException) {
                this.checkCancel();
                continue;
            }
            this.checkCancel();
        }
        iContainer = this.topBuildDir.addTrailingSeparator().append("makefile");
        IFile iFile2 = this.createFile((IPath)iContainer);
        this.populateTopMakefile(iFile2, true);
        this.checkCancel();
        IPath iPath2 = this.topBuildDir.addTrailingSeparator().append("objects.mk");
        IFile iFile3 = this.createFile(iPath2);
        this.populateObjectsMakefile(iFile3);
        this.checkCancel();
        if (!this.getInvalidDirList().isEmpty()) {
            multiStatus = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 2, new String(), null);
            iterator = this.getInvalidDirList().iterator();
            while (iterator.hasNext()) {
                multiStatus.add((IStatus)new Status(2, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ((IContainer)iterator.next()).getFullPath().toString(), null));
            }
        } else {
            multiStatus = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, new String(), null);
        }
        return multiStatus;
    }

    protected void updateMonitor(String string) {
        if (this.monitor != null && !this.monitor.isCanceled()) {
            this.monitor.subTask(string);
            this.monitor.worked(1);
        }
    }

    public class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private GnuMakefileGenerator generator;
        private IManagedBuildInfo info;

        public ResourceDeltaVisitor(GnuMakefileGenerator gnuMakefileGenerator2, IManagedBuildInfo iManagedBuildInfo) {
            this.generator = gnuMakefileGenerator2;
            this.info = iManagedBuildInfo;
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            IResourceDelta[] iResourceDeltaArray;
            boolean bl = false;
            IResource iResource = iResourceDelta.getResource();
            if (iResource.getType() == 1) {
                iResourceDeltaArray = iResource.getFileExtension();
                switch (iResourceDelta.getKind()) {
                    case 1: {
                        if (this.generator.isGeneratedResource(iResource) || !this.info.buildsFileType((String)iResourceDeltaArray)) break;
                        this.generator.appendModifiedSubdirectory(iResource);
                        break;
                    }
                    case 2: {
                        if (this.generator.isGeneratedResource(iResource) || !this.info.buildsFileType((String)iResourceDeltaArray)) break;
                        this.generator.appendModifiedSubdirectory(iResource);
                        this.generator.appendDeletedFile(iResource);
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
            }
            if (iResource.getType() == 4) {
                iResourceDeltaArray = iResourceDelta.getAffectedChildren();
                if (iResourceDeltaArray != null && iResourceDeltaArray.length > 0) {
                    bl = true;
                }
            } else if (!this.generator.isGeneratedResource(iResource)) {
                bl = true;
            }
            return bl;
        }
    }

    protected class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private GnuMakefileGenerator generator;
        private IManagedBuildInfo info;

        public ResourceProxyVisitor(GnuMakefileGenerator gnuMakefileGenerator2, IManagedBuildInfo iManagedBuildInfo) {
            this.generator = gnuMakefileGenerator2;
            this.info = iManagedBuildInfo;
        }

        public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
            if (this.generator == null) {
                return false;
            }
            if (iResourceProxy.getType() == 1) {
                IResource iResource = iResourceProxy.requestResource();
                String string = iResource.getFileExtension();
                if (this.info.buildsFileType(string) && !this.generator.isGeneratedResource(iResource)) {
                    this.generator.appendBuildSubdirectory(iResource);
                }
                return false;
            }
            return true;
        }
    }
}

