/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.core.InfiniteSubProgressMonitor;

public class Policy {
    public static boolean DEBUG_CONSOLE_BUFFERING = false;
    protected static ResourceBundle bundle;

    static {
        if (CVSUIPlugin.getPlugin().isDebugging()) {
            DEBUG_CONSOLE_BUFFERING = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.team.cvs.ui/consolebuffering"));
        }
        bundle = null;
    }

    public static void localize(String bundleName) {
        bundle = ResourceBundle.getBundle(bundleName);
    }

    public static String bind(String id, String binding) {
        return Policy.bind(id, new String[]{binding});
    }

    public static String bind(String id, String binding1, String binding2) {
        return Policy.bind(id, new String[]{binding1, binding2});
    }

    public static String bind(String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public static String bind(String key, Object[] args) {
        try {
            return MessageFormat.format(Policy.bind(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public static void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            Policy.cancelOperation();
        }
    }

    public static void cancelOperation() {
        throw new OperationCanceledException();
    }

    public static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks);
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks, int style) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, ticks, style);
    }

    public static IProgressMonitor infiniteSubMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new InfiniteSubProgressMonitor(monitor, ticks);
    }

    public static ResourceBundle getBundle() {
        return bundle;
    }
}

