/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Annotate;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.AnnotateListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogEntry;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.AnnotateView;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class ShowAnnotationAction
extends WorkspaceAction {
    static /* synthetic */ Class class$0;

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        ICVSResource cvsResource = this.getSingleSelectedCVSResource();
        this.execute(cvsResource);
    }

    public void execute(final ICVSResource cvsResource) throws InvocationTargetException, InterruptedException {
        String revision;
        final AnnotateListener listener = new AnnotateListener();
        if (cvsResource == null) {
            return;
        }
        try {
            ResourceSyncInfo info = cvsResource.getSyncInfo();
            if (info == null) {
                this.handle((Exception)((Object)new CVSException(Policy.bind("ShowAnnotationAction.noSyncInfo", cvsResource.getName()))));
                return;
            }
            revision = cvsResource.getSyncInfo().getRevision();
        }
        catch (CVSException e) {
            throw new InvocationTargetException(e);
        }
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(null, 100);
                ShowAnnotationAction.this.fetchAnnotation(listener, cvsResource, revision, Policy.subMonitorFor(monitor, 80));
                try {
                    if (ShowAnnotationAction.this.hasCharset(cvsResource, listener.getContents())) {
                        listener.setContents(ShowAnnotationAction.this.getRemoteContents(cvsResource, Policy.subMonitorFor(monitor, 20)));
                    }
                }
                catch (CoreException e) {
                    CVSUIPlugin.log(e);
                }
                monitor.done();
            }
        }, true, 1);
        if (listener.hasError()) {
            throw new InvocationTargetException(new CVSException(Policy.bind("ShowAnnotationAction.1", listener.getError())));
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            try {
                PlatformUI.getWorkbench().showPerspective("org.eclipse.team.cvs.ui.cvsPerspective", window);
            }
            catch (WorkbenchException workbenchException) {}
        }
        try {
            AnnotateView view = AnnotateView.openInActivePerspective();
            view.showAnnotations(cvsResource, listener.getCvsAnnotateBlocks(), listener.getContents());
        }
        catch (PartInitException e1) {
            this.handle((Exception)((Object)e1));
        }
    }

    protected boolean hasCharset(ICVSResource cvsResource, InputStream contents) {
        try {
            return TeamPlugin.getCharset((String)cvsResource.getName(), (InputStream)contents) != null;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fetchAnnotation(AnnotateListener listener, ICVSResource cvsResource, String revision, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(null, 100);
            ICVSFolder folder = cvsResource.getParent();
            FolderSyncInfo info = folder.getFolderSyncInfo();
            ICVSRepositoryLocation location = KnownRepositories.getInstance().getRepository(info.getRoot());
            Session session = new Session(location, folder, true);
            session.open(Policy.subMonitorFor(monitor, 10), false);
            try {
                Command.QuietOption quietness = CVSProviderPlugin.getPlugin().getQuietness();
                try {
                    CVSProviderPlugin.getPlugin().setQuietness(Command.VERBOSE);
                    Command.LocalOption[] localOption = revision == null ? Command.NO_LOCAL_OPTIONS : new Command.LocalOption[]{Annotate.makeRevisionOption((String)revision)};
                    IStatus status = Command.ANNOTATE.execute(session, Command.NO_GLOBAL_OPTIONS, localOption, new ICVSResource[]{cvsResource}, (ICommandOutputListener)listener, Policy.subMonitorFor(monitor, 90));
                    if (status.getCode() == -10) {
                        throw new CVSServerException(status);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    CVSProviderPlugin.getPlugin().setQuietness(quietness);
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var12_15 = null;
                    CVSProviderPlugin.getPlugin().setQuietness(quietness);
                    monitor.done();
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                session.close();
                throw throwable;
            }
            {
                Object var14_18 = null;
                session.close();
                return;
            }
        }
        catch (CVSException e) {
            throw new InvocationTargetException(e);
        }
    }

    private InputStream getRemoteContents(ICVSResource resource, IProgressMonitor monitor) throws CoreException {
        ICVSRemoteResource remote = CVSWorkspaceRoot.getRemoteResourceFor((ICVSResource)resource);
        if (remote == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        IStorage storage = ((IResourceVariant)remote).getStorage(monitor);
        if (storage == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return storage.getContents();
    }

    protected boolean isEnabled() throws TeamException {
        ICVSResource resource = this.getSingleSelectedCVSResource();
        return resource != null && !resource.isFolder() && resource.isManaged();
    }

    protected ICVSResource getSingleSelectedCVSResource() {
        Object[] logEntries;
        ICVSResource[] cvsResources = this.getSelectedCVSResources();
        if (cvsResources.length == 1) {
            return cvsResources[0];
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.internal.ccvs.core.client.listeners.LogEntry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((logEntries = this.getSelectedResources(clazz)).length == 1) {
            LogEntry aLogEntry = (LogEntry)logEntries[0];
            ICVSRemoteFile cvsRemoteFile = aLogEntry.getRemoteFile();
            return cvsRemoteFile;
        }
        IResource[] resources = this.getSelectedResources();
        if (resources.length == 1) {
            return CVSWorkspaceRoot.getCVSResourceFor((IResource)resources[0]);
        }
        return null;
    }
}

