/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIMessages;
import org.eclipse.cdt.debug.mi.internal.ui.SolibSearchPathBlock;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class GDBSolibBlock
extends Observable
implements Observer {
    private SolibSearchPathBlock fSolibSearchPathBlock;
    private Button fAutoSoLibButton;
    private Button fStopOnSolibEventsButton;
    private Composite fControl;

    public void createBlock(Composite composite, boolean bl, boolean bl2, boolean bl3) {
        Composite composite2 = ControlFactory.createCompositeEx((Composite)composite, (int)1, (int)768);
        ((GridLayout)composite2.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)composite2.getLayout()).marginHeight = 0;
        ((GridLayout)composite2.getLayout()).marginWidth = 0;
        if (bl) {
            this.fSolibSearchPathBlock = new SolibSearchPathBlock();
            this.fSolibSearchPathBlock.createBlock(composite2);
            this.fSolibSearchPathBlock.addObserver(this);
        }
        if (bl2) {
            this.fAutoSoLibButton = ControlFactory.createCheckBox((Composite)composite2, (String)MIUIMessages.getString("GDBSolibBlock.0"));
            this.fAutoSoLibButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    GDBSolibBlock.this.updateButtons();
                    GDBSolibBlock.this.changed();
                }
            });
        }
        if (bl3) {
            this.fStopOnSolibEventsButton = ControlFactory.createCheckBox((Composite)composite2, (String)MIUIMessages.getString("GDBSolibBlock.1"));
            this.fStopOnSolibEventsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    GDBSolibBlock.this.updateButtons();
                    GDBSolibBlock.this.changed();
                }
            });
        }
        this.setControl(composite2);
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        if (this.fSolibSearchPathBlock != null) {
            this.fSolibSearchPathBlock.initializeFrom(iLaunchConfiguration);
        }
        try {
            if (this.fAutoSoLibButton != null) {
                this.fAutoSoLibButton.setSelection(iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, true));
            }
            if (this.fStopOnSolibEventsButton != null) {
                this.fStopOnSolibEventsButton.setSelection(iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, false));
            }
            this.initializeButtons(iLaunchConfiguration);
            this.updateButtons();
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        if (this.fSolibSearchPathBlock != null) {
            this.fSolibSearchPathBlock.performApply(iLaunchConfigurationWorkingCopy);
        }
        try {
            Map map = iLaunchConfigurationWorkingCopy.getAttributes();
            if (this.fAutoSoLibButton != null) {
                map.put(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, new Boolean(this.fAutoSoLibButton.getSelection()));
            }
            if (this.fStopOnSolibEventsButton != null) {
                map.put(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, new Boolean(this.fStopOnSolibEventsButton.getSelection()));
            }
            iLaunchConfigurationWorkingCopy.setAttributes(map);
        }
        catch (CoreException coreException) {}
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        if (this.fSolibSearchPathBlock != null) {
            this.fSolibSearchPathBlock.setDefaults(iLaunchConfigurationWorkingCopy);
        }
        iLaunchConfigurationWorkingCopy.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, true);
        iLaunchConfigurationWorkingCopy.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, false);
    }

    protected void updateButtons() {
    }

    public void dispose() {
        this.deleteObservers();
        if (this.fSolibSearchPathBlock != null) {
            this.fSolibSearchPathBlock.deleteObserver(this);
            this.fSolibSearchPathBlock.dispose();
        }
    }

    public void disable() {
        if (this.fAutoSoLibButton != null) {
            this.fAutoSoLibButton.setEnabled(false);
        }
        if (this.fStopOnSolibEventsButton != null) {
            this.fStopOnSolibEventsButton.setEnabled(false);
        }
    }

    public void update(Observable observable, Object object) {
        this.changed();
    }

    protected void changed() {
        this.setChanged();
        this.notifyObservers();
    }

    public Composite getControl() {
        return this.fControl;
    }

    protected void setControl(Composite composite) {
        this.fControl = composite;
    }

    protected void initializeButtons(ILaunchConfiguration iLaunchConfiguration) {
        try {
            boolean bl;
            boolean bl2 = bl = !"core".equals(iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", ""));
            if (this.fAutoSoLibButton != null) {
                this.fAutoSoLibButton.setEnabled(bl);
            }
            if (this.fStopOnSolibEventsButton != null) {
                this.fStopOnSolibEventsButton.setEnabled(bl);
            }
        }
        catch (CoreException coreException) {}
    }
}

