/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import java.util.Observable;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIMessages;
import org.eclipse.cdt.debug.mi.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.ComboDialogField;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.StringDialogField;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SerialPortSettingsBlock
extends Observable {
    private static final String DEFAULT_ASYNC_DEVICE = "/dev/ttyS0";
    private static final String DEFAULT_ASYNC_DEVICE_SPEED = "115200";
    private Shell fShell;
    private StringDialogField fDeviceField;
    private ComboDialogField fSpeedField;
    private String[] fSpeedChoices = new String[]{"9600", "19200", "38400", "57600", "115200"};
    private Control fControl;
    private String fErrorMessage = null;

    public SerialPortSettingsBlock() {
        this.fDeviceField = this.createDeviceField();
        this.fSpeedField = this.createSpeedField();
    }

    public void createBlock(Composite composite) {
        this.fShell = composite.getShell();
        Composite composite2 = ControlFactory.createCompositeEx((Composite)composite, (int)2, (int)1808);
        ((GridLayout)composite2.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)composite2.getLayout()).marginHeight = 0;
        ((GridLayout)composite2.getLayout()).marginWidth = 0;
        composite2.setFont(JFaceResources.getDialogFont());
        PixelConverter pixelConverter = new PixelConverter((Control)composite2);
        this.fDeviceField.doFillIntoGrid(composite2, 2);
        LayoutUtil.setWidthHint((Control)this.fDeviceField.getTextControl(null), pixelConverter.convertWidthInCharsToPixels(20));
        this.fSpeedField.doFillIntoGrid(composite2, 2);
        ((GridData)this.fSpeedField.getComboControl(null).getLayoutData()).horizontalAlignment = 1;
        this.setControl((Control)composite2);
    }

    protected Shell getShell() {
        return this.fShell;
    }

    public void dispose() {
        this.deleteObservers();
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.initializeDevice(iLaunchConfiguration);
        this.initializeSpeed(iLaunchConfiguration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV, DEFAULT_ASYNC_DEVICE);
        iLaunchConfigurationWorkingCopy.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV_SPEED, DEFAULT_ASYNC_DEVICE_SPEED);
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        if (this.fDeviceField != null) {
            iLaunchConfigurationWorkingCopy.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV, this.fDeviceField.getText().trim());
        }
        if (this.fSpeedField != null) {
            int n = this.fSpeedField.getSelectionIndex();
            iLaunchConfigurationWorkingCopy.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV_SPEED, this.getSpeedItem(n));
        }
    }

    private StringDialogField createDeviceField() {
        StringDialogField stringDialogField = new StringDialogField();
        stringDialogField.setLabelText(MIUIMessages.getString("SerialPortSettingsBlock.0"));
        stringDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                SerialPortSettingsBlock.this.deviceFieldChanged();
            }
        });
        return stringDialogField;
    }

    private ComboDialogField createSpeedField() {
        ComboDialogField comboDialogField = new ComboDialogField(12);
        comboDialogField.setLabelText(MIUIMessages.getString("SerialPortSettingsBlock.1"));
        comboDialogField.setItems(this.fSpeedChoices);
        comboDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                SerialPortSettingsBlock.this.speedFieldChanged();
            }
        });
        return comboDialogField;
    }

    protected void deviceFieldChanged() {
        this.updateErrorMessage();
        this.setChanged();
        this.notifyObservers();
    }

    protected void speedFieldChanged() {
        this.updateErrorMessage();
        this.setChanged();
        this.notifyObservers();
    }

    private void initializeDevice(ILaunchConfiguration iLaunchConfiguration) {
        if (this.fDeviceField != null) {
            try {
                this.fDeviceField.setText(iLaunchConfiguration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV, DEFAULT_ASYNC_DEVICE));
            }
            catch (CoreException coreException) {}
        }
    }

    private void initializeSpeed(ILaunchConfiguration iLaunchConfiguration) {
        if (this.fSpeedField != null) {
            int n = 0;
            try {
                n = this.getSpeedItemIndex(iLaunchConfiguration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV_SPEED, DEFAULT_ASYNC_DEVICE_SPEED));
            }
            catch (CoreException coreException) {}
            this.fSpeedField.selectItem(n);
        }
    }

    private String getSpeedItem(int n) {
        return n >= 0 && n < this.fSpeedChoices.length ? this.fSpeedChoices[n] : null;
    }

    private int getSpeedItemIndex(String string) {
        int n = 0;
        while (n < this.fSpeedChoices.length) {
            if (this.fSpeedChoices[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setControl(Control control) {
        this.fControl = control;
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        this.updateErrorMessage();
        return this.getErrorMessage() == null;
    }

    private void updateErrorMessage() {
        this.setErrorMessage(null);
        if (this.fDeviceField != null && this.fSpeedField != null) {
            if (this.fDeviceField.getText().trim().length() == 0) {
                this.setErrorMessage(MIUIMessages.getString("SerialPortSettingsBlock.2"));
            } else if (!this.deviceIsValid(this.fDeviceField.getText().trim())) {
                this.setErrorMessage(MIUIMessages.getString("SerialPortSettingsBlock.3"));
            } else if (this.fSpeedField.getSelectionIndex() < 0) {
                this.setErrorMessage(MIUIMessages.getString("SerialPortSettingsBlock.4"));
            }
        }
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    private void setErrorMessage(String string) {
        this.fErrorMessage = string;
    }

    private boolean deviceIsValid(String string) {
        return true;
    }
}

