/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import java.util.Collections;
import java.util.Observable;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIMessages;
import org.eclipse.cdt.debug.mi.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.IListAdapter;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.ListDialogField;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class SolibSearchPathBlock
extends Observable {
    private Shell fShell;
    private SolibSearchPathListDialogField fDirList;

    public SolibSearchPathBlock() {
        String[] stringArray = new String[6];
        stringArray[0] = MIUIMessages.getString("SolibSearchPathBlock.0");
        stringArray[2] = MIUIMessages.getString("SolibSearchPathBlock.1");
        stringArray[3] = MIUIMessages.getString("SolibSearchPathBlock.2");
        stringArray[5] = MIUIMessages.getString("SolibSearchPathBlock.3");
        String[] stringArray2 = stringArray;
        IListAdapter iListAdapter = new IListAdapter(){

            public void customButtonPressed(DialogField dialogField, int n) {
                SolibSearchPathBlock.this.buttonPressed(n);
            }

            public void selectionChanged(DialogField dialogField) {
            }
        };
        this.fDirList = new SolibSearchPathListDialogField(iListAdapter, stringArray2, (ILabelProvider)new LabelProvider());
        this.fDirList.setLabelText(MIUIMessages.getString("SolibSearchPathBlock.4"));
        this.fDirList.setUpButtonIndex(2);
        this.fDirList.setDownButtonIndex(3);
        this.fDirList.setRemoveButtonIndex(5);
    }

    public void createBlock(Composite composite) {
        this.fShell = composite.getShell();
        Composite composite2 = ControlFactory.createCompositeEx((Composite)composite, (int)2, (int)1808);
        ((GridLayout)composite2.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)composite2.getLayout()).marginHeight = 0;
        ((GridLayout)composite2.getLayout()).marginWidth = 0;
        composite2.setFont(JFaceResources.getDialogFont());
        PixelConverter pixelConverter = new PixelConverter((Control)composite2);
        this.fDirList.doFillIntoGrid(composite2, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fDirList.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fDirList.getLabelControl(null), pixelConverter.convertWidthInCharsToPixels(30));
        LayoutUtil.setHorizontalGrabbing(this.fDirList.getListControl(null));
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        if (this.fDirList != null) {
            try {
                this.fDirList.addElements(iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, Collections.EMPTY_LIST));
            }
            catch (CoreException coreException) {}
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, Collections.EMPTY_LIST);
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        if (this.fDirList != null) {
            iLaunchConfigurationWorkingCopy.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, this.fDirList.getElements());
        }
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.addDirectory();
        }
        this.setChanged();
        this.notifyObservers();
    }

    protected Shell getShell() {
        return this.fShell;
    }

    private void addDirectory() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        directoryDialog.setMessage(MIUIMessages.getString("SolibSearchPathBlock.5"));
        String string = directoryDialog.open();
        if (string != null) {
            this.fDirList.addElement(string);
        }
    }

    public void dispose() {
        this.deleteObservers();
    }

    public class SolibSearchPathListDialogField
    extends ListDialogField {
        public SolibSearchPathListDialogField(IListAdapter iListAdapter, String[] stringArray, ILabelProvider iLabelProvider) {
            super(iListAdapter, stringArray, iLabelProvider);
        }

        protected boolean managedButtonPressed(int n) {
            boolean bl = super.managedButtonPressed(n);
            if (bl) {
                SolibSearchPathBlock.this.buttonPressed(n);
            }
            return bl;
        }
    }
}

