/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui.actions;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class SetAutoSolibActionDelegate
implements IViewActionDelegate,
ISelectionListener,
IPartListener {
    private IViewPart fView = null;
    private IAction fAction;
    private IStatus fStatus = null;
    static /* synthetic */ Class class$0;

    public void init(IViewPart iViewPart) {
        this.fView = iViewPart;
        iViewPart.getSite().getPage().addPartListener((IPartListener)this);
        iViewPart.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
            this.update(this.getAction());
        }
    }

    public void run(IAction iAction) {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    SetAutoSolibActionDelegate.this.doAction(DebugUITools.getDebugContext());
                    SetAutoSolibActionDelegate.this.setStatus(null);
                }
                catch (DebugException debugException) {
                    SetAutoSolibActionDelegate.this.setStatus(debugException.getStatus());
                }
            }
        });
        if (this.getStatus() != null && !this.getStatus().isOK()) {
            IWorkbenchWindow iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
            if (iWorkbenchWindow != null) {
                CDebugUIPlugin.errorDialog((String)this.getErrorDialogMessage(), (IStatus)this.getStatus());
            } else {
                CDebugUIPlugin.log((IStatus)this.getStatus());
            }
        }
        this.update(iAction);
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.setAction(iAction);
        if (this.getView() != null) {
            this.update(iAction);
        }
    }

    protected void update(IAction iAction) {
        if (iAction != null) {
            IAdaptable iAdaptable = DebugUITools.getDebugContext();
            iAction.setEnabled(this.getEnableStateForSelection(iAdaptable));
            iAction.setChecked(this.getCheckStateForSelection(iAdaptable));
        }
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart.equals(this.getView())) {
            this.dispose();
        }
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    protected IViewPart getView() {
        return this.fView;
    }

    protected void setView(IViewPart iViewPart) {
        this.fView = iViewPart;
    }

    protected void setAction(IAction iAction) {
        this.fAction = iAction;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void dispose() {
        if (this.getView() != null) {
            this.getView().getViewSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            this.getView().getViewSite().getPage().removePartListener((IPartListener)this);
        }
    }

    protected boolean getCheckStateForSelection(IAdaptable iAdaptable) {
        SharedLibraryManager sharedLibraryManager = this.getSharedLibraryManager(iAdaptable);
        if (sharedLibraryManager != null) {
            try {
                return sharedLibraryManager.isAutoLoadSymbols();
            }
            catch (CDIException cDIException) {}
        }
        return false;
    }

    protected boolean getEnableStateForSelection(IAdaptable iAdaptable) {
        return iAdaptable instanceof IDebugElement && ((IDebugElement)iAdaptable).getDebugTarget().isSuspended() && this.getSharedLibraryManager(iAdaptable) != null;
    }

    protected String getStatusMessage() {
        return ActionMessages.getString("SetAutoSolibActionDelegate.0");
    }

    protected String getErrorDialogMessage() {
        return ActionMessages.getString("SetAutoSolibActionDelegate.1");
    }

    protected void setStatus(IStatus iStatus) {
        this.fStatus = iStatus;
    }

    protected IStatus getStatus() {
        return this.fStatus;
    }

    protected void doAction(IAdaptable iAdaptable) throws DebugException {
        if (this.getView() == null) {
            return;
        }
        SharedLibraryManager sharedLibraryManager = this.getSharedLibraryManager(iAdaptable);
        if (sharedLibraryManager != null && this.getAction() != null) {
            try {
                sharedLibraryManager.setAutoLoadSymbols(this.getAction().isChecked());
            }
            catch (CDIException cDIException) {
                this.getAction().setChecked(!this.getAction().isChecked());
                throw new DebugException((IStatus)new Status(4, MIPlugin.getUniqueIdentifier(), 5010, cDIException.getMessage(), null));
            }
        }
    }

    private SharedLibraryManager getSharedLibraryManager(IAdaptable iAdaptable) {
        if (iAdaptable != null) {
            ICDISession iCDISession;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.cdi.ICDISession");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iCDISession = (ICDISession)iAdaptable.getAdapter((Class)clazz)) instanceof Session && ((Session)iCDISession).getSharedLibraryManager() instanceof SharedLibraryManager) {
                return (SharedLibraryManager)((Session)iCDISession).getSharedLibraryManager();
            }
        }
        return null;
    }
}

