/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui.dialogfields;

import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.DialogField;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ComboDialogField
extends DialogField {
    private String fText = "";
    private int fSelectionIndex;
    private String[] fItems = new String[0];
    private Combo fComboControl;
    private ModifyListener fModifyListener;
    private int fFlags;

    public ComboDialogField(int n) {
        this.fFlags = n;
        this.fSelectionIndex = -1;
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        label.setLayoutData((Object)DialogField.gridDataForLabel(1));
        Combo combo = this.getComboControl(composite);
        combo.setLayoutData((Object)ComboDialogField.gridDataForCombo(n - 1));
        return new Control[]{label, combo};
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected static GridData gridDataForCombo(int n) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalSpan = n;
        return gridData;
    }

    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setFocus();
        }
        return true;
    }

    public Combo getComboControl(Composite composite) {
        if (this.fComboControl == null) {
            this.assertCompositeNotNull(composite);
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    ComboDialogField.this.doModifyText(modifyEvent);
                }
            };
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ComboDialogField.this.doSelectionChanged(selectionEvent);
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            };
            this.fComboControl = new Combo(composite, this.fFlags);
            this.fComboControl.setItems(this.fItems);
            if (this.fSelectionIndex != -1) {
                this.fComboControl.select(this.fSelectionIndex);
            } else {
                this.fComboControl.setText(this.fText);
            }
            this.fComboControl.setFont(composite.getFont());
            this.fComboControl.addModifyListener(this.fModifyListener);
            this.fComboControl.addSelectionListener(selectionListener);
            this.fComboControl.setEnabled(this.isEnabled());
        }
        return this.fComboControl;
    }

    protected void doModifyText(ModifyEvent modifyEvent) {
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fText = this.fComboControl.getText();
            this.fSelectionIndex = this.fComboControl.getSelectionIndex();
        }
        this.dialogFieldChanged();
    }

    protected void doSelectionChanged(SelectionEvent selectionEvent) {
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fItems = this.fComboControl.getItems();
            this.fText = this.fComboControl.getText();
            this.fSelectionIndex = this.fComboControl.getSelectionIndex();
        }
        this.dialogFieldChanged();
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setEnabled(this.isEnabled());
        }
    }

    public String[] getItems() {
        return this.fItems;
    }

    public void setItems(String[] stringArray) {
        this.fItems = stringArray;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setItems(stringArray);
        }
        this.dialogFieldChanged();
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String string) {
        this.fText = string;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setText(string);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void selectItem(int n) {
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.select(n);
        } else if (n >= 0 && n < this.fItems.length) {
            this.fText = this.fItems[n];
            this.fSelectionIndex = n;
        }
        this.dialogFieldChanged();
    }

    public int getSelectionIndex() {
        return this.fSelectionIndex;
    }

    public void setTextWithoutUpdate(String string) {
        this.fText = string;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.removeModifyListener(this.fModifyListener);
            this.fComboControl.setText(string);
            this.fComboControl.addModifyListener(this.fModifyListener);
        }
    }
}

