/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui.dialogfields;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.SWTUtil;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.IListAdapter;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ListDialogField
extends DialogField {
    protected TableViewer fTable;
    protected ILabelProvider fLabelProvider;
    protected ListViewerAdapter fListViewerAdapter;
    protected List fElements;
    protected ViewerSorter fViewerSorter;
    protected String[] fButtonLabels;
    private Button[] fButtonControls;
    private boolean[] fButtonsEnabled;
    private int fRemoveButtonIndex;
    private int fUpButtonIndex;
    private int fDownButtonIndex;
    private Label fLastSeparator;
    protected Table fTableControl;
    private Composite fButtonsControl;
    private ISelection fSelectionWhenEnabled;
    private IListAdapter fListAdapter;
    private Object fParentElement;

    public ListDialogField(IListAdapter iListAdapter, String[] stringArray, ILabelProvider iLabelProvider) {
        this.fListAdapter = iListAdapter;
        this.fLabelProvider = iLabelProvider;
        this.fListViewerAdapter = new ListViewerAdapter();
        this.fParentElement = this;
        this.fElements = new ArrayList(10);
        this.fButtonLabels = stringArray;
        if (this.fButtonLabels != null) {
            int n = this.fButtonLabels.length;
            this.fButtonsEnabled = new boolean[n];
            int n2 = 0;
            while (n2 < n) {
                this.fButtonsEnabled[n2] = true;
                ++n2;
            }
        }
        this.fTable = null;
        this.fTableControl = null;
        this.fButtonsControl = null;
        this.fRemoveButtonIndex = -1;
        this.fUpButtonIndex = -1;
        this.fDownButtonIndex = -1;
    }

    public void setRemoveButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fRemoveButtonIndex = n;
    }

    public void setUpButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fUpButtonIndex = n;
    }

    public void setDownButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fDownButtonIndex = n;
    }

    public void setViewerSorter(ViewerSorter viewerSorter) {
        this.fViewerSorter = viewerSorter;
    }

    private void buttonPressed(int n) {
        if (!this.managedButtonPressed(n)) {
            this.fListAdapter.customButtonPressed(this, n);
        }
    }

    protected boolean managedButtonPressed(int n) {
        if (n == this.fRemoveButtonIndex) {
            this.remove();
        } else if (n == this.fUpButtonIndex) {
            this.up();
        } else if (n == this.fDownButtonIndex) {
            this.down();
        } else {
            return false;
        }
        return true;
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        GridData gridData = DialogField.gridDataForLabel(1);
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
        Control control = this.getListControl(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = n - 2;
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(6);
        control.setLayoutData((Object)gridData);
        Composite composite2 = this.getButtonBox(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite2.setLayoutData((Object)gridData);
        return new Control[]{label, control, composite2};
    }

    public int getNumberOfControls() {
        return 3;
    }

    public void setButtonsMinWidth(int n) {
        if (this.fLastSeparator != null) {
            ((GridData)this.fLastSeparator.getLayoutData()).widthHint = n;
        }
    }

    public Control getListControl(Composite composite) {
        if (this.fTableControl == null) {
            this.assertCompositeNotNull(composite);
            this.fTable = this.createTableViewer(composite);
            this.fTable.setContentProvider((IContentProvider)this.fListViewerAdapter);
            this.fTable.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            this.fTable.addSelectionChangedListener((ISelectionChangedListener)this.fListViewerAdapter);
            this.fTableControl = (Table)this.fTable.getControl();
            this.fTable.setInput(this.fParentElement);
            if (this.fViewerSorter != null) {
                this.fTable.setSorter(this.fViewerSorter);
            }
            this.fTableControl.setEnabled(this.isEnabled());
            if (this.fSelectionWhenEnabled != null) {
                this.postSetSelection(this.fSelectionWhenEnabled);
            }
        }
        return this.fTableControl;
    }

    public TableViewer getTableViewer() {
        return this.fTable;
    }

    protected int getListStyle() {
        return 2818;
    }

    protected TableViewer createTableViewer(Composite composite) {
        Table table = new Table(composite, this.getListStyle());
        return new TableViewer(table);
    }

    protected Button createButton(Composite composite, String string, SelectionListener selectionListener) {
        Button button = new Button(composite, 8);
        button.setText(string);
        button.addSelectionListener(selectionListener);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 1;
        gridData.heightHint = SWTUtil.getButtonHeigthHint((Button)button);
        gridData.widthHint = SWTUtil.getButtonWidthHint((Button)button);
        button.setLayoutData((Object)gridData);
        return button;
    }

    private Label createSeparator(Composite composite) {
        Label label = new Label(composite, 0);
        label.setVisible(false);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.heightHint = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public Composite getButtonBox(Composite composite) {
        if (this.fButtonsControl == null) {
            this.assertCompositeNotNull(composite);
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    ListDialogField.this.doButtonSelected(selectionEvent);
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ListDialogField.this.doButtonSelected(selectionEvent);
                }
            };
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite2.setLayout((Layout)gridLayout);
            if (this.fButtonLabels != null) {
                this.fButtonControls = new Button[this.fButtonLabels.length];
                int n = 0;
                while (n < this.fButtonLabels.length) {
                    String string = this.fButtonLabels[n];
                    if (string != null) {
                        this.fButtonControls[n] = this.createButton(composite2, string, selectionListener);
                        this.fButtonControls[n].setEnabled(this.isEnabled() && this.fButtonsEnabled[n]);
                    } else {
                        this.fButtonControls[n] = null;
                        this.createSeparator(composite2);
                    }
                    ++n;
                }
            }
            this.fLastSeparator = this.createSeparator(composite2);
            this.updateButtonState();
            this.fButtonsControl = composite2;
        }
        return this.fButtonsControl;
    }

    protected void doButtonSelected(SelectionEvent selectionEvent) {
        if (this.fButtonControls != null) {
            int n = 0;
            while (n < this.fButtonControls.length) {
                if (selectionEvent.widget == this.fButtonControls[n]) {
                    this.buttonPressed(n);
                    return;
                }
                ++n;
            }
        }
    }

    public void dialogFieldChanged() {
        super.dialogFieldChanged();
        this.updateButtonState();
    }

    protected void updateButtonState() {
        if (this.fButtonControls != null) {
            ISelection iSelection = this.fTable.getSelection();
            int n = 0;
            while (n < this.fButtonControls.length) {
                Button button = this.fButtonControls[n];
                if (this.isOkToUse((Control)button)) {
                    boolean bl = this.getManagedButtonState(iSelection, n);
                    button.setEnabled(this.isEnabled() && bl && this.fButtonsEnabled[n]);
                }
                ++n;
            }
        }
    }

    protected boolean getManagedButtonState(ISelection iSelection, int n) {
        if (n == this.fRemoveButtonIndex) {
            return !iSelection.isEmpty();
        }
        if (n == this.fUpButtonIndex) {
            return !iSelection.isEmpty() && this.canMoveUp();
        }
        if (n == this.fDownButtonIndex) {
            return !iSelection.isEmpty() && this.canMoveDown();
        }
        return true;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        boolean bl = this.isEnabled();
        if (this.isOkToUse((Control)this.fTableControl)) {
            if (!bl) {
                this.fSelectionWhenEnabled = this.fTable.getSelection();
                this.selectElements(null);
            } else {
                this.selectElements(this.fSelectionWhenEnabled);
                this.fSelectionWhenEnabled = null;
            }
            this.fTableControl.setEnabled(bl);
        }
        this.updateButtonState();
    }

    public void enableButton(int n, boolean bl) {
        if (this.fButtonsEnabled != null && n < this.fButtonsEnabled.length) {
            this.fButtonsEnabled[n] = bl;
            this.updateButtonState();
        }
    }

    public void setElements(List list) {
        this.fElements = new ArrayList(list);
        if (this.fTable != null) {
            this.fTable.refresh();
        }
        this.dialogFieldChanged();
    }

    public List getElements() {
        return new ArrayList(this.fElements);
    }

    public Object getElement(int n) {
        return this.fElements.get(n);
    }

    public void replaceElement(Object object, Object object2) throws IllegalArgumentException {
        int n = this.fElements.indexOf(object);
        if (n != -1) {
            if (object.equals(object2) || this.fElements.contains(object2)) {
                return;
            }
            this.fElements.set(n, object2);
            if (this.fTable != null) {
                List list = this.getSelectedElements();
                if (list.remove(object)) {
                    list.add(object2);
                }
                this.fTable.refresh();
                this.selectElements((ISelection)new StructuredSelection(list));
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void addElement(Object object) {
        if (this.fElements.contains(object)) {
            return;
        }
        this.fElements.add(object);
        if (this.fTable != null) {
            this.fTable.add(object);
        }
        this.dialogFieldChanged();
    }

    public void addElements(List list) {
        int n = list.size();
        if (n > 0) {
            ArrayList arrayList = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                Object e = list.get(n2);
                if (!this.fElements.contains(e)) {
                    arrayList.add(e);
                }
                ++n2;
            }
            this.fElements.addAll(arrayList);
            if (this.fTable != null) {
                this.fTable.add(arrayList.toArray());
            }
            this.dialogFieldChanged();
        }
    }

    public void insertElementAt(Object object, int n) {
        if (this.fElements.contains(object)) {
            return;
        }
        this.fElements.add(n, object);
        if (this.fTable != null) {
            this.fTable.add(object);
        }
        this.dialogFieldChanged();
    }

    public void removeAllElements() {
        if (this.fElements.size() > 0) {
            this.fElements.clear();
            if (this.fTable != null) {
                this.fTable.refresh();
            }
            this.dialogFieldChanged();
        }
    }

    public void removeElement(Object object) throws IllegalArgumentException {
        if (this.fElements.remove(object)) {
            if (this.fTable != null) {
                this.fTable.remove(object);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void removeElements(List list) {
        if (list.size() > 0) {
            this.fElements.removeAll(list);
            if (this.fTable != null) {
                this.fTable.remove(list.toArray());
            }
            this.dialogFieldChanged();
        }
    }

    public int getSize() {
        return this.fElements.size();
    }

    public void selectElements(ISelection iSelection) {
        this.fSelectionWhenEnabled = iSelection;
        if (this.fTable != null) {
            this.fTable.setSelection(iSelection, true);
        }
    }

    public void selectFirstElement() {
        Object object = null;
        if (this.fViewerSorter != null) {
            Object[] objectArray = this.fElements.toArray();
            this.fViewerSorter.sort((Viewer)this.fTable, objectArray);
            if (objectArray.length > 0) {
                object = objectArray[0];
            }
        } else if (this.fElements.size() > 0) {
            object = this.fElements.get(0);
        }
        if (object != null) {
            this.selectElements((ISelection)new StructuredSelection(object));
        }
    }

    public void postSetSelection(final ISelection iSelection) {
        if (this.isOkToUse((Control)this.fTableControl)) {
            Display display = this.fTableControl.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (ListDialogField.this.isOkToUse((Control)ListDialogField.this.fTableControl)) {
                        ListDialogField.this.selectElements(iSelection);
                    }
                }
            });
        }
    }

    public void refresh() {
        this.fTable.refresh();
    }

    private List moveUp(List list, List list2) {
        int n = list.size();
        ArrayList arrayList = new ArrayList(n);
        Object e = null;
        int n2 = 0;
        while (n2 < n) {
            Object e2 = list.get(n2);
            if (list2.contains(e2)) {
                arrayList.add(e2);
            } else {
                if (e != null) {
                    arrayList.add(e);
                }
                e = e2;
            }
            ++n2;
        }
        if (e != null) {
            arrayList.add(e);
        }
        return arrayList;
    }

    private void moveUp(List list) {
        if (list.size() > 0) {
            this.setElements(this.moveUp(this.fElements, list));
            this.fTable.reveal(list.get(0));
        }
    }

    private void moveDown(List list) {
        if (list.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.fElements), list)));
            this.fTable.reveal(list.get(list.size() - 1));
        }
    }

    private List reverse(List list) {
        ArrayList arrayList = new ArrayList(list.size());
        int n = list.size() - 1;
        while (n >= 0) {
            arrayList.add(list.get(n));
            --n;
        }
        return arrayList;
    }

    private void remove() {
        this.removeElements(this.getSelectedElements());
    }

    private void up() {
        this.moveUp(this.getSelectedElements());
    }

    private void down() {
        this.moveDown(this.getSelectedElements());
    }

    private boolean canMoveUp() {
        if (this.isOkToUse((Control)this.fTableControl)) {
            int[] nArray = this.fTableControl.getSelectionIndices();
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] != n) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private boolean canMoveDown() {
        if (this.isOkToUse((Control)this.fTableControl)) {
            int[] nArray = this.fTableControl.getSelectionIndices();
            int n = this.fElements.size() - 1;
            int n2 = nArray.length - 1;
            while (n2 >= 0) {
                if (nArray[n2] != n) {
                    return true;
                }
                --n2;
                --n;
            }
        }
        return false;
    }

    public List getSelectedElements() {
        ISelection iSelection;
        ArrayList arrayList = new ArrayList();
        if (this.fTable != null && (iSelection = this.fTable.getSelection()) instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    protected void doListSelected(SelectionChangedEvent selectionChangedEvent) {
        this.updateButtonState();
        if (this.fListAdapter != null) {
            this.fListAdapter.selectionChanged(this);
        }
    }

    private class ListViewerAdapter
    implements IStructuredContentProvider,
    ISelectionChangedListener {
        ListViewerAdapter() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public boolean isDeleted(Object object) {
            return false;
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return ListDialogField.this.fElements.toArray();
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            ListDialogField.this.doListSelected(selectionChangedEvent);
        }
    }
}

