/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui.preferences;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.mi.core.IMIConstants;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.internal.ui.IMIHelpContextIds;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIPlugin;
import org.eclipse.cdt.debug.mi.internal.ui.preferences.PreferenceMessages;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class MIPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String GDB_MI_HELP_CONTEXT = "org.eclipse.cdt.debug.mi.uimi_preference_page_context";
    IntegerFieldEditor fDebugTimeoutText;
    IntegerFieldEditor fLaunchTimeoutText;

    public MIPreferencePage() {
        this.setPreferenceStore(MIUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferenceMessages.getString("MIPreferencePage.0"));
    }

    protected Control createContents(Composite composite) {
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IMIHelpContextIds.MI_PREFERENCE_PAGE);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        this.createSpacer(composite2, 1);
        this.createCommunicationPreferences(composite2);
        this.setValues();
        WorkbenchHelp.setHelp((Control)composite2, (String)GDB_MI_HELP_CONTEXT);
        return composite2;
    }

    private Composite createGroupComposite(Composite composite, int n, String string) {
        return ControlFactory.createGroup((Composite)composite, (String)string, (int)n);
    }

    private void setValues() {
        this.fDebugTimeoutText.setStringValue(new Integer(MIPlugin.getDefault().getPluginPreferences().getInt(IMIConstants.PREF_REQUEST_TIMEOUT)).toString());
        this.fLaunchTimeoutText.setStringValue(new Integer(MIPlugin.getDefault().getPluginPreferences().getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT)).toString());
    }

    public boolean performOk() {
        this.storeValues();
        MIUIPlugin.getDefault().savePluginPreferences();
        MIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.setDefaultValues();
        super.performDefaults();
    }

    private void setDefaultValues() {
        this.fDebugTimeoutText.setStringValue(new Integer(10000).toString());
        this.fLaunchTimeoutText.setStringValue(new Integer(30000).toString());
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected void createSpacer(Composite composite, int n) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
    }

    private void createCommunicationPreferences(Composite composite) {
        Composite composite2 = this.createGroupComposite(composite, 1, PreferenceMessages.getString("MIPreferencePage.1"));
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        composite3.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        composite3.setLayoutData((Object)gridData);
        this.fDebugTimeoutText = this.createTimeoutField(IMIConstants.PREF_REQUEST_TIMEOUT, PreferenceMessages.getString("MIPreferencePage.2"), composite3);
        this.fDebugTimeoutText.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("field_editor_is_valid")) {
                    MIPreferencePage.this.setValid(MIPreferencePage.this.fDebugTimeoutText.isValid());
                }
            }
        });
        this.fLaunchTimeoutText = this.createTimeoutField(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT, PreferenceMessages.getString("MIPreferencePage.3"), composite3);
        this.fLaunchTimeoutText.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("field_editor_is_valid")) {
                    MIPreferencePage.this.setValid(MIPreferencePage.this.fLaunchTimeoutText.isValid());
                }
            }
        });
    }

    private void storeValues() {
        MIPlugin.getDefault().getPluginPreferences().setValue(IMIConstants.PREF_REQUEST_TIMEOUT, this.fDebugTimeoutText.getIntValue());
        MIPlugin.getDefault().getPluginPreferences().setValue(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT, this.fLaunchTimeoutText.getIntValue());
    }

    private IntegerFieldEditor createTimeoutField(String string, String string2, Composite composite) {
        IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor(string, string2, composite);
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(10);
        integerFieldEditor.getTextControl(composite).setLayoutData((Object)gridData);
        integerFieldEditor.setPreferenceStore(MIUIPlugin.getDefault().getPreferenceStore());
        integerFieldEditor.setPreferencePage((PreferencePage)this);
        integerFieldEditor.setValidateStrategy(0);
        integerFieldEditor.setValidRange(100, Integer.MAX_VALUE);
        String string3 = Integer.toString(100);
        String string4 = Integer.toString(Integer.MAX_VALUE);
        integerFieldEditor.setErrorMessage(MessageFormat.format(PreferenceMessages.getString("MIPreferencePage.4"), string3, string4));
        integerFieldEditor.load();
        return integerFieldEditor;
    }
}

