/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore;

import com.palmsource.eclipse.palmoscore.projects.IPalmOSProject;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CorePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.palmsource.eclipse.palmoscore";
    public static final String PALMOS_CORE_PROBLEM_MARKER = "com.palmsource.eclipse.palmoscore.problem";
    public static final int PRODUCT_VERSION_ID_1_1_0 = 10100;
    public static final int PRODUCT_VERSION_CURRENT = 10100;
    protected static final String WHITESPACE = " ";
    protected static final String ESCAPE_WHITESPACE = "\\";
    private static final String PROPERTIES_DIRECTORY_NAME = "PalmOSMetaData";
    private static final String PROJECT_CONTRIBUTION_POINT = "projectContributions";
    private static final String PROJECT_CONTRIBUTION_NATURE = "natureId";
    private static final String PROJECT_CONTRIBUTION_CLASS = "class";
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    private static CorePlugin plugin;
    private static boolean attachPOD;
    public static final int MAIN_TAB_ICON = 5;
    public static final int TARGET_TAB_ICON = 0;
    public static final int DEBUGGER_TAB_ICON = 4;
    private static final String[] iconPaths;
    static /* synthetic */ Class class$0;

    static {
        attachPOD = false;
        iconPaths = new String[]{"icons/Palm16.gif", "icons/Palm32.gif", "icons/PalmOSNature.gif", "icons/Perspective.gif", "icons/debugger_tab.gif", "icons/main_tab.gif", "icons/xrd.gif", "icons/xrd_wizban.gif"};
    }

    public CorePlugin() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        Bundle bundle = this.getBundle();
        String string = bundle.getSymbolicName();
        if (string != null) {
            String string2 = String.valueOf(string) + "/debug/attachpod";
            String string3 = Platform.getDebugOption((String)string2);
            attachPOD = string3 == null ? false : string3.equalsIgnoreCase("true");
        }
    }

    public static CorePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getPluginID() {
        CorePlugin corePlugin = CorePlugin.getDefault();
        if (corePlugin != null) {
            return corePlugin.getBundle().getSymbolicName();
        }
        return PLUGIN_ID;
    }

    public static boolean getAttachPOD() {
        return attachPOD;
    }

    public static String getEclipseInstallDir() {
        URL uRL = Platform.getInstallLocation().getURL();
        Path path = new Path(uRL.getFile());
        return path.toString();
    }

    public static IPalmOSProject getPalmOSProject(IProject iProject) {
        IPalmOSProject iPalmOSProject = null;
        if (iProject == null) {
            return null;
        }
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(PLUGIN_ID, PROJECT_CONTRIBUTION_POINT);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                try {
                    if (iProject.hasNature(iConfigurationElement.getAttribute(PROJECT_CONTRIBUTION_NATURE))) {
                        iPalmOSProject = (IPalmOSProject)iConfigurationElement.createExecutableExtension(PROJECT_CONTRIBUTION_CLASS);
                        iPalmOSProject.setProject(iProject);
                    }
                }
                catch (CoreException coreException) {}
                ++n2;
            }
            ++n;
        }
        return iPalmOSProject;
    }

    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(String.valueOf(CorePlugin.getPluginID()) + ".CorePluginDefaults");
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            iPreferenceStore.setDefault(string, resourceBundle.getString(string));
        }
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
        String string = this.getBundle().getSymbolicName();
        int n = 0;
        while (n < iconPaths.length) {
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)string, (String)iconPaths[n]);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            imageRegistry.put(Long.toString(n), imageDescriptor);
            ++n;
        }
    }

    public static Image getImage(int n) {
        String string = Long.toString(n);
        return CorePlugin.getDefault().getImageRegistry().get(string);
    }

    public static IConfigurationElement[] getAllConfigurationElements(String string) {
        return CorePlugin.getAllConfigurationElements(PLUGIN_ID, string);
    }

    public static IConfigurationElement[] getAllConfigurationElements(String string, String string2) {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string, string2);
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        return iConfigurationElementArray;
    }

    public static Object createObject(IConfigurationElement iConfigurationElement, String string, Class clazz) {
        Object object = null;
        try {
            object = iConfigurationElement.createExecutableExtension(string);
        }
        catch (CoreException coreException) {
            System.err.println("Error creating object");
            if (coreException.getMessage() != null) {
                System.err.println(coreException.getMessage());
            }
            coreException.printStackTrace();
            return null;
        }
        if (clazz != null && !clazz.isInstance(object)) {
            System.err.println("Created object is not an instance of " + clazz.getName());
            return null;
        }
        return object;
    }

    public static String[] flattenResources(IResource[] iResourceArray) {
        ArrayList<String> arrayList = new ArrayList<String>(iResourceArray.length);
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            arrayList.add(iResource.getFullPath().toString());
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void flattenResources(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy, String string, IResource[] iResourceArray) {
        String[] stringArray = CorePlugin.flattenResources(iResourceArray);
        List<String> list = Arrays.asList(stringArray);
        iLaunchConfigurationWorkingCopy.setAttribute(string, list);
    }

    public static IResource[] resurrectResources(String[] stringArray) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>(stringArray.length);
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            Path path = new Path(string);
            IResource iResource = iWorkspaceRoot.findMember((IPath)path);
            if (iResource == null) {
                System.err.println("ResurrectResources: unable to find file " + string);
            } else {
                arrayList.add(iResource);
            }
            ++n;
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    public static IResource[] resurrectResources(ILaunchConfiguration iLaunchConfiguration, String string) throws CoreException {
        try {
            List list = iLaunchConfiguration.getAttribute(string, new ArrayList());
            String[] stringArray = list.toArray(new String[0]);
            IResource[] iResourceArray = CorePlugin.resurrectResources(stringArray);
            return iResourceArray;
        }
        catch (DebugException debugException) {
            return new IResource[0];
        }
    }

    public static void dumpBytes(PrintStream printStream, byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            printStream.print(CorePlugin.formatHexByte(byArray[n]));
            if (n != byArray.length - 1) {
                if (n % 32 == 31) {
                    printStream.print("\n");
                } else {
                    printStream.print(WHITESPACE);
                }
            }
            ++n;
        }
        printStream.print("\n");
    }

    public static String formatHexByte(int n) {
        int n2 = n & 0xFF;
        String string = Integer.toHexString(n2);
        while (string.length() < 2) {
            string = "0" + string;
        }
        return string;
    }

    public static String formatHexShort(int n) {
        int n2 = n & 0xFFFF;
        String string = Integer.toHexString(n2);
        while (string.length() < 4) {
            string = "0" + string;
        }
        return string;
    }

    public static String formatHexInt(int n) {
        String string = Integer.toHexString(n);
        while (string.length() < 8) {
            string = "0" + string;
        }
        return string;
    }

    public static String escapeString(String string) {
        String string2 = string;
        if (ESCAPE_WHITESPACE.length() > 0 && string != null) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = 0;
            while (n < string.length()) {
                int n2 = string.indexOf(WHITESPACE, n);
                if (n2 == -1) {
                    stringBuffer.append(string.toCharArray(), n, string.length() - n);
                    break;
                }
                stringBuffer.append(string.toCharArray(), n, n2 - n);
                stringBuffer.append(ESCAPE_WHITESPACE);
                stringBuffer.append(WHITESPACE);
                n = n2 + 1;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static String escapePath(String string) {
        String string2 = string;
        if (ESCAPE_WHITESPACE.length() > 0 && string != null) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = 0;
            while (n < string.length()) {
                int n2 = string.indexOf(47, n);
                if (n2 == -1) {
                    stringBuffer.append(string.toCharArray(), n, string.length() - n);
                    break;
                }
                stringBuffer.append(string.toCharArray(), n, n2 - n);
                stringBuffer.append('\\');
                stringBuffer.append('/');
                n = n2 + 1;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String findProperty(String string, String string2) {
        if (string == null) return null;
        if (string2 == null) {
            return null;
        }
        IPreferencesService iPreferencesService = Platform.getPreferencesService();
        String string3 = iPreferencesService.getString(string, string2, null, null);
        if (string3 != null) return string3;
        String string4 = System.getProperty("PODSPrefDir");
        if (string4 == null) return string3;
        Path path = new Path(string4);
        if (!path.toFile().exists()) return string3;
        if (!(path = path.append(String.valueOf(string) + ".pref")).toFile().exists()) return string3;
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(path.toFile());
                if (fileInputStream != null) {
                    properties.load(fileInputStream);
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (fileInputStream == null) throw throwable;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (fileInputStream == null) return properties.getProperty(string2);
        ((InputStream)fileInputStream).close();
        return properties.getProperty(string2);
    }

    public static ICElement getContext() {
        ICElement iCElement = null;
        IWorkbenchPage iWorkbenchPage = LaunchUIPlugin.getActivePage();
        if (iWorkbenchPage != null) {
            IStructuredSelection iStructuredSelection;
            ISelection iSelection = iWorkbenchPage.getSelection();
            if (iSelection instanceof IStructuredSelection && !(iStructuredSelection = (IStructuredSelection)iSelection).isEmpty()) {
                Object object = iStructuredSelection.getFirstElement();
                if (object instanceof IResource) {
                    IResource iResource = (IResource)object;
                    iCElement = CoreModel.getDefault().create(iResource);
                    if (iCElement == null) {
                        IProject iProject = iResource.getProject();
                        iCElement = CoreModel.getDefault().create(iProject);
                    }
                } else if (object instanceof ICElement) {
                    iCElement = (ICElement)object;
                }
                return iCElement;
            }
            iStructuredSelection = iWorkbenchPage.getActiveEditor();
            if (iStructuredSelection != null) {
                IEditorInput iEditorInput = iStructuredSelection.getEditorInput();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return (ICElement)iEditorInput.getAdapter((Class)clazz);
            }
        }
        return null;
    }

    public static IEditorPart openInEditor(IFile iFile) {
        IEditorPart iEditorPart = null;
        if (iFile != null) {
            IWorkbenchPage iWorkbenchPage = null;
            IWorkbenchWindow iWorkbenchWindow = CorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            if (iWorkbenchWindow != null) {
                iWorkbenchPage = iWorkbenchWindow.getActivePage();
            }
            if (iWorkbenchPage != null) {
                try {
                    FileEditorInput fileEditorInput = new FileEditorInput(iFile);
                    iEditorPart = iWorkbenchPage.openEditor((IEditorInput)fileEditorInput, CorePlugin.getEditorID(iFile.getName()), true);
                }
                catch (PartInitException partInitException) {}
            }
        }
        return iEditorPart;
    }

    public static String getEditorID(String string) {
        IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (iEditorRegistry != null) {
            IEditorDescriptor iEditorDescriptor = iEditorRegistry.getDefaultEditor(string);
            if (iEditorDescriptor != null) {
                return iEditorDescriptor.getId();
            }
            return iEditorRegistry.findEditor(DEFAULT_TEXT_EDITOR_ID).getId();
        }
        return null;
    }

    public static void log(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        Object object = null;
        object = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, CorePlugin.getUniqueIdentifier(), 0, throwable.getMessage() == null ? "" : throwable.getMessage(), throwable);
        CorePlugin.log(object);
    }

    public static void log(IStatus iStatus) {
        ResourcesPlugin.getPlugin().getLog().log(iStatus);
    }

    public static String getUniqueIdentifier() {
        if (CorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return CorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public Shell getShell() {
        Shell shell = CorePlugin.getActiveWorkbenchShell();
        if (shell != null) {
            return shell;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = CorePlugin.getDefault().getWorkbench().getWorkbenchWindows();
        return iWorkbenchWindowArray[0].getShell();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = CorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }
}

