/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore;

import com.palmsource.eclipse.palmoscore.CorePlugin;
import com.palmsource.eclipse.palmoscore.Messages;
import com.palmsource.eclipse.palmoscore.projects.IPalmOSProject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeBuilder;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class PalmOSBuildToolsVerifier
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "com.palmsource.eclipse.palmoscore.palmOSBuildToolsVerifier";
    private static final String KEY_MAKE_IDENTIFIER = "PalmOSBuildToolsVerifier.make.identifier";
    private static final String KEY_MAKE_ERROR = "PalmOSBuildToolsVerifier.incorrect_make.text";
    private static final String KEY_MAKE_VERSION_OPT = "PalmOSBuildToolsVerifier.make.version_flag";
    private boolean verified = true;
    private String stdoutResults = null;
    private String stderrResults = null;

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        IProject[] iProjectArray;
        IProject iProject = this.getProject();
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        this.stdoutResults = null;
        this.stderrResults = null;
        IPalmOSProject iPalmOSProject = CorePlugin.getPalmOSProject(iProject);
        IWorkspace iWorkspace = iProject.getWorkspace();
        IMarker[] iMarkerArray = iProject.findMarkers("com.palmsource.eclipse.palmoscore.problem", true, 2);
        if (iMarkerArray != null) {
            iWorkspace.deleteMarkers(iMarkerArray);
        }
        if (iPalmOSProject != null && iPalmOSProject.isManagedProject()) {
            this.verifyManagedMakeProject(iProgressMonitor);
        } else if (iPalmOSProject != null && !iPalmOSProject.isManagedProject()) {
            this.verifyStandardMakeProject(iProgressMonitor);
        }
        if (!this.verified) {
            try {
                iProjectArray = iProject.findMarkers("com.palmsource.eclipse.palmoscore.problem", false, 1);
                if (iProjectArray != null && iProjectArray.length > 0) {
                    int n2 = 0;
                    while (n2 < iProjectArray.length) {
                        int n3 = (Integer)iProjectArray[n2].getAttribute("severity");
                        String string = (String)iProjectArray[n2].getAttribute("message");
                        if (n3 == 2 && string.equals(this.stderrResults)) {
                            return null;
                        }
                        ++n2;
                    }
                }
                IMarker iMarker = iProject.createMarker("com.palmsource.eclipse.palmoscore.problem");
                iMarker.setAttribute("location", 0);
                iMarker.setAttribute("message", (Object)this.stderrResults);
                iMarker.setAttribute("severity", 2);
                iMarker.setAttribute("charStart", -1);
                iMarker.setAttribute("charEnd", -1);
            }
            catch (CoreException coreException) {}
        }
        iProjectArray = new IProject[]{this.getProject()};
        this.forgetLastBuiltState();
        return new IProject[0];
    }

    private void verifyManagedMakeProject(IProgressMonitor iProgressMonitor) throws CoreException {
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        String string = iManagedBuildInfo.getMakeCommand();
        if (string == null) {
            this.verified = false;
        } else {
            String[] stringArray = new String[]{Messages.getString(KEY_MAKE_VERSION_OPT)};
            Path path = new Path(string);
            IPath iPath = this.getProject().getLocation();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("CWD", iPath.toOSString());
            hashMap.put("PWD", iPath.toOSString());
            this.launchVerification((IPath)path, stringArray, hashMap, iPath, iProgressMonitor);
        }
    }

    private void verifyStandardMakeProject(IProgressMonitor iProgressMonitor) throws CoreException {
        IMakeBuilderInfo iMakeBuilderInfo = MakeCorePlugin.createBuildInfo((IProject)this.getProject(), (String)MakeBuilder.BUILDER_ID);
        IPath iPath = iMakeBuilderInfo.getBuildCommand();
        if (iPath == null) {
            this.verified = false;
        } else {
            IResource iResource;
            String[] stringArray = new String[]{Messages.getString(KEY_MAKE_VERSION_OPT)};
            IPath iPath2 = null;
            if (!iMakeBuilderInfo.getBuildLocation().isEmpty() && (iResource = this.getProject().getParent().findMember(iMakeBuilderInfo.getBuildLocation())) instanceof IContainer && iResource.exists()) {
                iPath2 = iResource.getLocation();
            }
            if (iPath2 == null) {
                iPath2 = this.getProject().getLocation();
            }
            this.launchVerification(iPath, stringArray, iMakeBuilderInfo.getEnvironment(), iPath2, iProgressMonitor);
        }
    }

    private void launchVerification(IPath iPath, String[] stringArray, Map map, IPath iPath2, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        String string;
        CommandLauncher commandLauncher = new CommandLauncher();
        commandLauncher.showCommand(false);
        Properties properties = commandLauncher.getEnvironment();
        properties.putAll((Map<?, ?>)map);
        String[] stringArray2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<?> enumeration = properties.propertyNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                arrayList.add(String.valueOf(string) + "=" + properties.getProperty(string));
            }
            stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        }
        string = null;
        Process process = commandLauncher.execute(iPath, stringArray, stringArray2, iPath2);
        if (process != null) {
            try {
                process.getOutputStream().close();
            }
            catch (IOException iOException) {}
            object = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (commandLauncher.waitAndRead((OutputStream)object, (OutputStream)byteArrayOutputStream, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, -1)) != 0) {
                string = commandLauncher.getErrorMessage();
            }
            this.stdoutResults = ((ByteArrayOutputStream)object).toString();
            this.stderrResults = byteArrayOutputStream.toString();
        } else {
            string = commandLauncher.getErrorMessage();
        }
        if (string != null) {
            object = new StringBuffer(String.valueOf(iPath.toString()) + " ");
            object = new StringBuffer(object + "error");
            ((StringBuffer)object).append(System.getProperty("line.separator", "\n"));
            ((StringBuffer)object).append("(").append(string).append(")");
            this.stderrResults = String.valueOf(this.stderrResults) + ((StringBuffer)object).toString();
        }
        if (this.stdoutResults != null && this.stdoutResults.indexOf(Messages.getString(KEY_MAKE_IDENTIFIER)) != -1) {
            this.verified = true;
        } else {
            this.verified = false;
            this.stderrResults = "Project " + this.getProject().getName() + " " + Messages.getString(KEY_MAKE_ERROR);
        }
    }
}

