/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.codesets;

import com.palmsource.eclipse.palmoscore.CorePlugin;
import com.palmsource.eclipse.palmoscore.Messages;
import com.palmsource.eclipse.palmoscore.projects.IProjectDataProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;

public class PreferenceDataProvider
implements IProjectDataProvider {
    public static final String DEV_COMPILER = "tool.compiler.gcc.68K.option.";
    public static final String SIM_COMPILER = "tool.compiler.gcc.x86.option.";
    public static final String PNO_COMPILER = "tool.compiler.pacc.option.";
    public static final String DEV_LINKER = "tool.linker.gcc.68K.option.";
    public static final String SIM_LINKER = "tool.linker.gcc.x86.option.";
    public static final String PNO_LINKER = "tool.linker.palink.option.";
    public static final String PNO_LIBRARIAN = "tool.archiver.palib.option.";
    public static final String RESOURCE_COMPILER = "tool.compiler.palmrc.option.";
    public static final String RESOURCE_MERGE = "tool.builder.prcmerge.option.";
    public static final String OPT_PREPROCESS = "preprocessToConsole";
    public static final String OPT_DEFINES = "defineSymbols";
    public static final String OPT_UNDEFINES = "undefineSymbols";
    public static final String OPT_INCLUDES = "includeDirs";
    public static final String OPT_PREINCLUDES = "preIncludes";
    public static final String OPT_WARNING_LEVEL = "warningLevel";
    public static final String OPT_SUPPRESS_WARNING = "suppressWarnings";
    public static final String OPT_WARN_ERROR = "warningsAsErrors";
    public static final String OPT_PNO_WARN_ERROR = "warningAsError";
    public static final String OPT_VERBOSE = "verbose";
    public static final String OPT_OTHER_FLAGS = "otherFlags";
    public static final String OPT_LINKER_FLAGS = "otherLinkerFlags";
    public static final String OPT_EXCEPTIONS = "exceptions";
    public static final String OPT_ASSERTIONS = "assertions";
    public static final String OPT_LOGO = "logo";
    public static final String OPT_LIBRARIES = "libraries";
    public static final String OPT_LIBRARY_PATH = "libraryPath";
    public static final String OPT_LISTING_FILE = "listingFile";
    public static final String OPT_XREF = "xref";
    public static final String OPT_MAP = "map";
    public static final String OPT_SYMBOLS = "symbols";
    public static final String OPT_LOCALS = "locals";
    public static final String OPT_LOCALE = "locale";
    public static final String OPT_STRICT_LOCALE = "strictLocale";
    public static final String OPT_NO_LOCALE_CHECK = "noLocaleCheck";
    public static final String OPT_OVERLAY_FILTER = "overlayFilter";
    public static final String OPT_ENCODING_TARGET = "encodingTarget";
    public static final String OPT_STRICT_ENCODING = "strictEncoding";
    public static final String OPT_QUIET = "quiet";
    public static final String OPT_NO_WARN_SIZE = "noWarnSize";
    public static final String OPT_ONLY = "only";
    public static final String OPT_OMIT = "omit";
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";
    private static final String LOCALE = "enUS";
    private static final String ENCODING = "LATIN";
    protected String compiler;
    protected String linker;
    protected String librarian;
    protected String simcompiler;
    protected String simlinker;
    protected String pnocompiler;
    protected String pnolinker;
    protected String pnolibrarian;
    protected String palmrc;
    protected String prcmerge;
    IPreferenceStore prefStore = CorePlugin.getDefault().getPreferenceStore();

    private PreferenceDataProvider() {
    }

    public PreferenceDataProvider(String string) {
        if ("68K".equals(string)) {
            this.compiler = DEV_COMPILER;
            this.linker = DEV_LINKER;
            this.librarian = null;
            this.simcompiler = null;
            this.simlinker = null;
            this.pnocompiler = null;
            this.pnolinker = null;
            this.pnolibrarian = null;
        } else if ("Garnet".equals(string)) {
            this.compiler = DEV_COMPILER;
            this.linker = DEV_LINKER;
            this.librarian = null;
            this.simcompiler = SIM_COMPILER;
            this.simlinker = SIM_LINKER;
            this.pnocompiler = PNO_COMPILER;
            this.pnolinker = PNO_LINKER;
            this.pnolibrarian = PNO_LIBRARIAN;
        } else if ("Protein".equals(string)) {
            this.compiler = PNO_COMPILER;
            this.linker = PNO_LINKER;
            this.librarian = PNO_LIBRARIAN;
            this.simcompiler = SIM_COMPILER;
            this.simlinker = SIM_LINKER;
            this.pnocompiler = null;
            this.pnolinker = null;
            this.pnolibrarian = null;
        } else {
            throw new IllegalArgumentException(Messages.getString("PreferenceDataProvider.INVALID_TARGET_OS_API"));
        }
        this.palmrc = RESOURCE_COMPILER;
        this.prcmerge = RESOURCE_MERGE;
    }

    public Map getProjectDataValues() {
        HashMap hashMap = new HashMap();
        this.addDefaults(hashMap);
        this.addCompiler(hashMap);
        this.addSimCompiler(hashMap);
        this.addPnoCompiler(hashMap);
        this.addLinker(hashMap);
        this.addSimLinker(hashMap);
        this.addPnoLinker(hashMap);
        this.addResources(hashMap);
        this.addExtras(hashMap);
        return hashMap;
    }

    protected void addDefaults(Map map) {
        map.put("LOCALE", LOCALE);
        map.put("PRC_TEXT_ENCODING", ENCODING);
    }

    protected void addCompiler(Map map) {
        map.put("DEFINES", this.getPreference(String.valueOf(this.compiler) + OPT_DEFINES));
        map.put("UNDEFINES", this.getPreference(String.valueOf(this.compiler) + OPT_UNDEFINES));
        map.put("LOCAL_INCLUDE_PATHS", this.getOptionStringList(String.valueOf(this.compiler) + OPT_INCLUDES, "-I", true));
        if (!this.compiler.equals(PNO_COMPILER)) {
            map.put("PRE_INCLUDE_PATHS", this.getOptionStringList(String.valueOf(this.compiler) + OPT_PREINCLUDES, "-include", true));
            map.put("WARNING_LEVEL", this.getOptionMatch(String.valueOf(this.compiler) + OPT_WARNING_LEVEL, new String[][]{{"", ""}, {"-w", Messages.getString("PreferenceDataProvider.NONE")}, {"-Wall", Messages.getString("PreferenceDataProvider.ALL")}}));
            map.put("WARNING_AS_ERROR", this.getBoolean(String.valueOf(this.compiler) + OPT_WARN_ERROR));
        } else {
            map.put("PRE_INCLUDE_PATHS", this.getOptionStringList(String.valueOf(this.compiler) + OPT_PREINCLUDES, "--preinclude=", true));
            map.put("WARNING_LEVEL", this.getOptionMatch(String.valueOf(this.compiler) + OPT_SUPPRESS_WARNING, new String[][]{{"-W0", Messages.getString("PreferenceDataProvider.NONE")}, {"-W2", Messages.getString("PreferenceDataProvider.SOME")}, {"-W4", Messages.getString("PreferenceDataProvider.ALL")}}));
            map.put("ENABLE_ASSERTIONS", this.getOptionMatch(String.valueOf(this.compiler) + OPT_ASSERTIONS, new String[][]{{"-UNDEBUG", TRUE}, {"-DNDEBUG", FALSE}}));
            map.put("ENABLE_EXCEPTIONS", this.getOptionMatch(String.valueOf(this.compiler) + OPT_EXCEPTIONS, new String[][]{{"-ex", TRUE}, {"-noex", FALSE}}));
            map.put("ARM_LOGO", this.getOptionMatch(String.valueOf(this.compiler) + OPT_LOGO, new String[][]{{"-logo", TRUE}, {"-nologo", FALSE}}));
            map.put("WARNING_AS_ERROR", this.getBoolean(String.valueOf(this.compiler) + OPT_PNO_WARN_ERROR));
        }
        map.put("VERBOSE", this.getBoolean(String.valueOf(this.compiler) + OPT_VERBOSE));
        map.put("ADDITIONAL_COMPILER_FLAGS", this.getPreference(String.valueOf(this.compiler) + OPT_OTHER_FLAGS));
    }

    protected void addSimCompiler(Map map) {
        if (this.simcompiler == null) {
            return;
        }
        map.put("SIM_WARNING_LEVEL", this.getOptionMatch(String.valueOf(this.simcompiler) + OPT_WARNING_LEVEL, new String[][]{{"-w", Messages.getString("PreferenceDataProvider.NONE")}, {"-Wall", Messages.getString("PreferenceDataProvider.ALL")}}));
        map.put("SIM_DEFINES", this.getPreference(String.valueOf(this.simcompiler) + OPT_DEFINES));
        map.put("SIM_UNDEFINES", this.getPreference(String.valueOf(this.simcompiler) + OPT_UNDEFINES));
        map.put("SIM_LOCAL_INCLUDE_PATHS", this.getOptionStringList(String.valueOf(this.simcompiler) + OPT_INCLUDES, "-I", true));
        map.put("SIM_PRE_INCLUDE_PATHS", this.getOptionStringList(String.valueOf(this.simcompiler) + OPT_PREINCLUDES, "-include", true));
        map.put("ADDITIONAL_SIM_COMPILER_FLAGS", this.getPreference(String.valueOf(this.simcompiler) + OPT_OTHER_FLAGS));
        map.put("SIM_WARNING_AS_ERROR", this.getBoolean(String.valueOf(this.simcompiler) + OPT_WARN_ERROR));
        map.put("SIM_VERBOSE", this.getBoolean(String.valueOf(this.simcompiler) + OPT_VERBOSE));
    }

    protected void addPnoCompiler(Map map) {
        if (this.pnocompiler == null) {
            return;
        }
        map.put("PNO_WARNING_LEVEL", this.getOptionMatch(String.valueOf(this.pnocompiler) + OPT_SUPPRESS_WARNING, new String[][]{{"-W0", Messages.getString("PreferenceDataProvider.NONE")}, {"-W2", Messages.getString("PreferenceDataProvider.SOME")}, {"-W4", Messages.getString("PreferenceDataProvider.ALL")}}));
        map.put("ENABLE_ASSERTIONS", this.getOptionMatch(String.valueOf(this.pnocompiler) + OPT_ASSERTIONS, new String[][]{{"-UNDEBUG", TRUE}, {"-DNDEBUG", FALSE}}));
        map.put("PNO_DEFINES", this.getPreference(String.valueOf(this.pnocompiler) + OPT_DEFINES));
        map.put("PNO_UNDEFINES", this.getPreference(String.valueOf(this.pnocompiler) + OPT_UNDEFINES));
        map.put("PNO_LOCAL_INCLUDE_PATHS", this.getOptionStringList(String.valueOf(this.pnocompiler) + OPT_INCLUDES, "-I", true));
        map.put("PNO_PRE_INCLUDE_PATHS", this.getOptionStringList(String.valueOf(this.pnocompiler) + OPT_PREINCLUDES, "--preinclude=", true));
        map.put("ADDITIONAL_PNO_COMPILER_FLAGS", this.getPreference(String.valueOf(this.pnocompiler) + OPT_OTHER_FLAGS));
        map.put("PNO_WARNING_AS_ERROR", this.getBoolean(String.valueOf(this.pnocompiler) + OPT_PNO_WARN_ERROR));
        map.put("PNO_VERBOSE", this.getBoolean(String.valueOf(this.pnocompiler) + OPT_VERBOSE));
        map.put("ARM_LOGO", this.getOptionMatch(String.valueOf(this.pnocompiler) + OPT_LOGO, new String[][]{{"-logo", TRUE}, {"-nologo", FALSE}}));
        if (this.pnolibrarian == null) {
            return;
        }
        map.put("ADDITIONAL_AR_FLAGS", this.getPreference(String.valueOf(this.pnolibrarian) + OPT_OTHER_FLAGS));
    }

    protected void addLinker(Map map) {
        if (this.linker.equals(PNO_LINKER)) {
            map.put("LINKER_XREF", this.getOptionBoolean(String.valueOf(this.linker) + OPT_XREF, "-xref"));
            map.put("LINKER_MAP", this.getOptionBoolean(String.valueOf(this.linker) + OPT_MAP, "-map"));
            map.put("LINKER_SYMBOLS", this.getOptionBoolean(String.valueOf(this.linker) + OPT_SYMBOLS, "-symbols"));
            map.put("LINKER_LISTING", this.getOptionString(String.valueOf(this.linker) + OPT_LISTING_FILE, "-list "));
            map.put("LINKER_LOCALS", this.getOptionBoolean(String.valueOf(this.linker) + OPT_LOCALS, "-locals"));
        }
        map.put("ADDITIONAL_LINK_LIBRARIES", this.getPreference(String.valueOf(this.linker) + OPT_LIBRARIES));
        map.put("ADDITIONAL_LINK_LIBPATH", this.getPreference(String.valueOf(this.linker) + OPT_LIBRARY_PATH));
        map.put("ADDITIONAL_LINKER_FLAGS", this.getPreference(String.valueOf(this.linker) + OPT_OTHER_FLAGS));
        if (this.librarian == null) {
            return;
        }
        map.put("ADDITIONAL_AR_FLAGS", this.getPreference(String.valueOf(this.librarian) + OPT_OTHER_FLAGS));
    }

    protected void addSimLinker(Map map) {
        if (this.simlinker == null) {
            return;
        }
        map.put("ADDITIONAL_SIM_LINK_LIBRARIES", this.getPreference(String.valueOf(this.simlinker) + OPT_LIBRARIES));
        map.put("ADDITIONAL_SIM_LINK_LIBPATH", this.getPreference(String.valueOf(this.simlinker) + OPT_LIBRARY_PATH));
        map.put("ADDITIONAL_SIM_LINKER_FLAGS", this.getPreference(String.valueOf(this.simlinker) + OPT_OTHER_FLAGS));
    }

    protected void addPnoLinker(Map map) {
        if (this.pnolinker == null) {
            return;
        }
        map.put("ADDITIONAL_PNO_LINK_LIBRARIES", this.getPreference(String.valueOf(this.pnolinker) + OPT_LIBRARIES));
        map.put("ADDITIONAL_PNO_LINK_LIBPATH", this.getPreference(String.valueOf(this.pnolinker) + OPT_LIBRARY_PATH));
        map.put("ADDITIONAL_PNO_LINKER_FLAGS", this.getPreference(String.valueOf(this.pnolinker) + OPT_OTHER_FLAGS));
    }

    protected void addResources(Map map) {
        map.put("PRC_TEXT_ENCODING", this.getOptionMatch(String.valueOf(this.palmrc) + OPT_ENCODING_TARGET, new String[][]{{"-target 4.0", Messages.getString("PreferenceDataProvider.LATIN")}, {"-target 4.0J", Messages.getString("PreferenceDataProvider.JAPANESE")}, {"-target 4.0CS", Messages.getString("PreferenceDataProvider.SIMPLIFIED_CHINESE")}}));
        map.put("PRC_INCLUDES", this.getOptionStringList(String.valueOf(this.palmrc) + OPT_INCLUDES, "-i ", true));
        map.put("LOCALE", this.getResourceLocale());
        map.put("PRC_NO_LOCALE_CHECK", this.getBoolean(String.valueOf(this.palmrc) + OPT_NO_LOCALE_CHECK));
        map.put("PRC_STRICT_LOCALE", this.getBoolean(String.valueOf(this.palmrc) + OPT_STRICT_LOCALE));
        map.put("PRC_STRICT_ENCODING", this.getBoolean(String.valueOf(this.palmrc) + OPT_STRICT_ENCODING));
        map.put("PRC_NO_WARN_SIZE", this.getBoolean(String.valueOf(this.palmrc) + OPT_NO_WARN_SIZE));
        map.put("PRC_OVERLAY_FILTER", this.getOptionMatch(String.valueOf(this.palmrc) + OPT_OVERLAY_FILTER, new String[][]{{"", ""}, {"-overlayFilter BASE", Messages.getString("PreferenceDataProvider.BASE")}, {"-overlayFilter OVERLAY", Messages.getString("PreferenceDataProvider.OVERLAY")}, {"-overlayFilter FULL", Messages.getString("PreferenceDataProvider.FULL")}}));
        map.put("PRC_QUIET", this.getBoolean(String.valueOf(this.palmrc) + OPT_QUIET));
        map.put("ADDITIONAL_PRC_FLAGS", this.getPreference(String.valueOf(this.palmrc) + OPT_OTHER_FLAGS));
        map.put("PRCMERGE_ONLY", this.getOptionStringList(String.valueOf(this.prcmerge) + OPT_ONLY, "-only ", false));
        map.put("PRCMERGE_OMIT", this.getOptionStringList(String.valueOf(this.prcmerge) + OPT_OMIT, "-omit ", false));
        map.put("PRCMERGE_QUIET", this.getBoolean(String.valueOf(this.prcmerge) + OPT_QUIET));
        map.put("ADDITIONAL_PRCMERGE_FLAGS", this.getPreference(String.valueOf(this.prcmerge) + OPT_OTHER_FLAGS));
    }

    protected void addExtras(Map map) {
    }

    protected String getPreference(String string) {
        return this.prefStore.getString(string);
    }

    private String getBoolean(String string) {
        if (this.prefStore.getBoolean(string)) {
            return TRUE;
        }
        return "";
    }

    private String getOptionBoolean(String string, String string2) {
        if (this.prefStore.getBoolean(string)) {
            return string2;
        }
        return "";
    }

    private String getOptionString(String string, String string2) {
        String string3 = this.getPreference(string);
        if (string3.length() != 0) {
            return String.valueOf(string2) + string3;
        }
        return string3;
    }

    private String getOptionStringList(String string, String string2, boolean bl) {
        String string3 = this.getPreference(string);
        if (string3.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        String[] stringArray = string3.split(bl ? ";" : "\\s");
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null && stringArray[n].length() != 0) {
                stringBuffer.append(string2);
                stringBuffer.append(stringArray[n]);
                stringBuffer.append(" ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String getOptionMatch(String string, String[][] stringArray) {
        String string2 = this.getPreference(string);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n][0] != null && stringArray[n][1] != null && string2.equals(stringArray[n][0])) {
                return stringArray[n][1];
            }
            ++n;
        }
        return "";
    }

    private String getResourceLocale() {
        String[] stringArray;
        String string = this.getPreference(String.valueOf(this.palmrc) + OPT_LOCALE);
        if (string != null && string.length() > 0 && !string.startsWith("-locale ")) {
            return string;
        }
        if (string.startsWith("-locale ") && (stringArray = string.split("-locale ")).length >= 2 && stringArray[1] != null) {
            return stringArray[1];
        }
        return "";
    }

    private void listMap(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            System.out.println(String.valueOf(string) + "=" + string2);
        }
    }
}

