/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.codesets;

import com.palmsource.eclipse.palmoscore.CorePlugin;
import com.palmsource.eclipse.palmoscore.Messages;
import com.palmsource.eclipse.palmoscore.codesets.CodeSetFileDescriptor;
import com.palmsource.eclipse.palmoscore.codesets.ICodeSetProvider;
import com.palmsource.eclipse.palmoscore.projects.IProjectDataProvider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class ProjectCodeGenerator {
    private static final String FILE_EXISTS = "ProjectCodeGenerator.fileExists.text";
    private static final String GENERATING_CONTENTS = "ProjectCodeGenerator.generateContents.text";
    private static final String GENERATING_FILES = "ProjectCodeGenerator.generateFiles.text";
    private static final String GENERATING_BINARIES = "ProjectCodeGenerator.generateBinaries.text";
    private static final String GENERATING_TEMPLATES = "ProjectCodeGenerator.generateTemplates.text";
    private final Vector codeSetProviders = new Vector();
    private final Vector projectDataProviders = new Vector();

    public void addCodeSetProvider(ICodeSetProvider iCodeSetProvider) {
        if (iCodeSetProvider != null) {
            this.codeSetProviders.add(iCodeSetProvider);
        }
    }

    public void addProjectDataProvider(IProjectDataProvider iProjectDataProvider) {
        if (iProjectDataProvider != null) {
            this.projectDataProviders.add(iProjectDataProvider);
        }
    }

    public void generateContents(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.subTask(Messages.getString(GENERATING_CONTENTS));
        Map map = this.getProjectDataValues();
        int n = 0;
        while (n < this.codeSetProviders.size()) {
            ICodeSetProvider iCodeSetProvider = (ICodeSetProvider)this.codeSetProviders.elementAt(n);
            this.generateFiles(iCodeSetProvider, iProject, iProgressMonitor);
            this.generateBinaries(iCodeSetProvider, iProject, iProgressMonitor);
            this.generateTemplates(iCodeSetProvider, iProject, map, iProgressMonitor);
            ++n;
        }
    }

    private void generateFiles(ICodeSetProvider iCodeSetProvider, IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.subTask(Messages.getString(GENERATING_FILES));
        CodeSetFileDescriptor[] codeSetFileDescriptorArray = iCodeSetProvider.getFiles();
        if (codeSetFileDescriptorArray != null) {
            int n = 0;
            while (n < codeSetFileDescriptorArray.length) {
                Object object;
                Object object2;
                Object object3;
                Path path;
                IFile iFile = iProject.getFile(codeSetFileDescriptorArray[n].getDestFileName());
                if (iFile.exists()) {
                    path = new Status(4, CorePlugin.getPluginID(), -1, String.valueOf(Messages.getString(FILE_EXISTS)) + iFile.getName(), null);
                    object3 = new CoreException((IStatus)path);
                    throw object3;
                }
                path = new Path(codeSetFileDescriptorArray[n].getPluginPathFileName());
                object3 = new ByteArrayOutputStream();
                try {
                    String string;
                    int n2 = codeSetFileDescriptorArray[n].getDestFileName().indexOf(47);
                    while (n2 != -1) {
                        object2 = iProject.getFolder(codeSetFileDescriptorArray[n].getDestFileName().substring(0, n2));
                        if (!object2.exists()) {
                            object2.create(true, true, iProgressMonitor);
                        }
                        n2 = codeSetFileDescriptorArray[n].getDestFileName().indexOf(47, n2 + 1);
                    }
                    object2 = new BufferedReader(new InputStreamReader(codeSetFileDescriptorArray[n].getSourcePlugin().openStream((IPath)path)));
                    object = new BufferedWriter(new OutputStreamWriter((OutputStream)object3));
                    while ((string = ((BufferedReader)object2).readLine()) != null) {
                        ((Writer)object).write(string);
                        ((BufferedWriter)object).newLine();
                    }
                    ((BufferedReader)object2).close();
                    ((BufferedWriter)object).flush();
                    ((BufferedWriter)object).close();
                }
                catch (IOException iOException) {
                    object2 = new Status(4, CorePlugin.getPluginID(), -1, iOException.getMessage(), (Throwable)iOException);
                    object = new CoreException((IStatus)object2);
                    throw object;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object3).toByteArray());
                try {
                    iFile.create((InputStream)byteArrayInputStream, true, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                    throw coreException;
                }
                iProgressMonitor.worked(1);
                ++n;
            }
        }
    }

    private void generateBinaries(ICodeSetProvider iCodeSetProvider, IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.subTask(Messages.getString(GENERATING_BINARIES));
        CodeSetFileDescriptor[] codeSetFileDescriptorArray = iCodeSetProvider.getBinaries();
        if (codeSetFileDescriptorArray != null) {
            int n = 0;
            while (n < codeSetFileDescriptorArray.length) {
                Object object;
                Path path = new Path(codeSetFileDescriptorArray[n].getPluginPathFileName());
                IFile iFile = iProject.getFile(codeSetFileDescriptorArray[n].getDestFileName());
                if (iFile.exists()) {
                    Status status = new Status(4, CorePlugin.getPluginID(), -1, String.valueOf(Messages.getString(FILE_EXISTS)) + iFile.getName(), null);
                    object = new CoreException((IStatus)status);
                    throw object;
                }
                try {
                    int n2 = codeSetFileDescriptorArray[n].getDestFileName().indexOf(47);
                    while (n2 != -1) {
                        object = iProject.getFolder(codeSetFileDescriptorArray[n].getDestFileName().substring(0, n2));
                        if (!object.exists()) {
                            object.create(true, true, iProgressMonitor);
                        }
                        n2 = codeSetFileDescriptorArray[n].getDestFileName().indexOf(47, n2 + 1);
                    }
                    iFile.create(codeSetFileDescriptorArray[n].getSourcePlugin().openStream((IPath)path), true, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                    throw coreException;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                iProgressMonitor.worked(1);
                ++n;
            }
        }
    }

    private void generateTemplates(ICodeSetProvider iCodeSetProvider, IProject iProject, Map hashMap, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.subTask(Messages.getString(GENERATING_TEMPLATES));
        CodeSetFileDescriptor[] codeSetFileDescriptorArray = iCodeSetProvider.getTemplates();
        if (codeSetFileDescriptorArray != null) {
            Map map = iCodeSetProvider.getTemplateProperties();
            if (map != null) {
                hashMap = new HashMap(hashMap);
                hashMap.putAll(map);
            }
            int n = 0;
            while (n < codeSetFileDescriptorArray.length) {
                Object object;
                Object object2;
                Object object3;
                Path path;
                IFile iFile = iProject.getFile(codeSetFileDescriptorArray[n].getDestFileName());
                if (iFile.exists()) {
                    path = new Status(4, CorePlugin.getPluginID(), -1, String.valueOf(Messages.getString(FILE_EXISTS)) + iFile.getName(), null);
                    object3 = new CoreException((IStatus)path);
                    throw object3;
                }
                path = new Path(codeSetFileDescriptorArray[n].getPluginPathFileName());
                object3 = new ByteArrayOutputStream();
                try {
                    String string;
                    int n2 = codeSetFileDescriptorArray[n].getDestFileName().indexOf(47);
                    while (n2 != -1) {
                        object2 = iProject.getFolder(codeSetFileDescriptorArray[n].getDestFileName().substring(0, n2));
                        if (!object2.exists()) {
                            object2.create(true, true, iProgressMonitor);
                        }
                        n2 = codeSetFileDescriptorArray[n].getDestFileName().indexOf(47, n2 + 1);
                    }
                    object2 = new BufferedReader(new InputStreamReader(codeSetFileDescriptorArray[n].getSourcePlugin().openStream((IPath)path)));
                    object = new BufferedWriter(new OutputStreamWriter((OutputStream)object3));
                    while ((string = ((BufferedReader)object2).readLine()) != null) {
                        ((Writer)object).write(this.applySubstitutions(string, hashMap));
                        ((BufferedWriter)object).newLine();
                    }
                    ((BufferedReader)object2).close();
                    ((BufferedWriter)object).flush();
                    ((BufferedWriter)object).close();
                }
                catch (IOException iOException) {
                    object2 = new Status(4, CorePlugin.getPluginID(), -1, iOException.getMessage(), (Throwable)iOException);
                    object = new CoreException((IStatus)object2);
                    throw object;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object3).toByteArray());
                try {
                    iFile.create((InputStream)byteArrayInputStream, true, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                    throw coreException;
                }
                iProgressMonitor.worked(1);
                ++n;
            }
        }
    }

    private String applySubstitutions(String string, Map map) {
        int n;
        int n2;
        String string2 = string;
        while ((n2 = string2.indexOf("???")) != -1 && (n = string2.indexOf("???", n2 + 3)) != -1) {
            String string3 = string2.substring(n2 + 3, n);
            String string4 = (String)map.get(string3);
            string2 = string4 != null ? String.valueOf(string2.substring(0, n2)) + string4 + string2.substring(n + 3) : String.valueOf(string2.substring(0, n2)) + string2.substring(n + 3);
        }
        return string2;
    }

    private Map getProjectDataValues() {
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < this.projectDataProviders.size()) {
            hashMap.putAll(((IProjectDataProvider)this.projectDataProviders.elementAt(n)).getProjectDataValues());
            ++n;
        }
        return hashMap;
    }
}

