/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.internal.errorparsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class PACCErrorParser
implements IErrorParser {
    static String LPAREN = "\\(";
    static String RPAREN = "\\)";
    static String WHITE = "\\s*";
    static String LOCATION = "(.+)";
    static String NOLINE = "()()";
    static String LINE = String.valueOf(LPAREN) + "(\\d+)()" + RPAREN;
    static String LINEOFFSET = String.valueOf(LPAREN) + "(\\d+)," + WHITE + "(\\d+)" + RPAREN;
    static String FIELDSEPARATOR = String.valueOf(WHITE) + "\\:" + WHITE;
    static String SEVERITY = "(error|warning)";
    static String ERRORCODE = "(.+)";
    static String DESCRIPTION = "(.+)";
    static Pattern LINEOFFSET_PATTERN = Pattern.compile(String.valueOf(LOCATION) + LINEOFFSET + FIELDSEPARATOR + SEVERITY + WHITE + ERRORCODE + FIELDSEPARATOR + DESCRIPTION);
    static Pattern LINE_PATTERN = Pattern.compile(String.valueOf(LOCATION) + LINE + FIELDSEPARATOR + SEVERITY + WHITE + ERRORCODE + FIELDSEPARATOR + DESCRIPTION);
    static Pattern NOLINE_PATTERN = Pattern.compile(String.valueOf(LOCATION) + NOLINE + FIELDSEPARATOR + SEVERITY + WHITE + ERRORCODE + FIELDSEPARATOR + DESCRIPTION);

    public boolean processLine(String string, ErrorParserManager errorParserManager) {
        Matcher matcher = LINEOFFSET_PATTERN.matcher(string);
        if (!matcher.matches()) {
            matcher = LINE_PATTERN.matcher(string);
        }
        if (!matcher.matches()) {
            matcher = NOLINE_PATTERN.matcher(string);
        }
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            matcher.group(3);
            String string4 = matcher.group(4);
            matcher.group(5);
            String string5 = matcher.group(6);
            IFile iFile = this.getFile(string2, errorParserManager);
            int n = string3.length() == 0 ? 0 : Integer.parseInt(string3);
            int n2 = string4.equalsIgnoreCase("warning") ? 1 : 2;
            String string6 = null;
            errorParserManager.generateMarker((IResource)iFile, n, string5, n2, string6);
            return true;
        }
        return false;
    }

    private IFile getFile(String string, ErrorParserManager errorParserManager) {
        IFile iFile = errorParserManager.findFilePath(string);
        if (iFile == null) {
            iFile = errorParserManager.findFileName(string);
        }
        return iFile;
    }
}

