/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.internal.launch;

import com.palmsource.eclipse.palmoscore.Messages;

public class LaunchMethod {
    private static final char SPACE = ' ';
    private static final char OPENPAREN = '(';
    private static final char CLOSEPAREN = ')';
    private static final String EMPTY = "";
    private static final String SYSUIAPPSWITCH = "SysUIAppSwitch";
    private static final String SYSAPPLAUNCH = "SysAppLaunch";
    public static final int DO_NOTHING_COMMAND = -1;
    public static final int CUSTOM_COMMAND = -2;
    public static final int INVALID_COMMAND = -3;
    public static final int SYSUIAPPSWITCHFLAG = 1;
    public static final int SYSAPPLAUNCHFLAG = 2;
    private static String[] suffixArray = new String[]{" (SysUIAppSwitch)", " (SysAppLaunch)"};
    private static String[] nameMap = new String[89];
    public int cmdValue;
    public int cmdHow;

    static {
        LaunchMethod._add(0, "sysAppLaunchCmdNormalLaunch");
        LaunchMethod._add(1, "sysAppLaunchCmdFind");
        LaunchMethod._add(2, "sysAppLaunchCmdGoTo");
        LaunchMethod._add(3, "sysAppLaunchCmdSyncNotify");
        LaunchMethod._add(4, "sysAppLaunchCmdTimeChange");
        LaunchMethod._add(5, "sysAppLaunchCmdSystemReset");
        LaunchMethod._add(6, "sysAppLaunchCmdAlarmTriggered");
        LaunchMethod._add(7, "sysAppLaunchCmdDisplayAlarm");
        LaunchMethod._add(8, "sysAppLaunchCmdCountryChange");
        LaunchMethod._add(9, "sysAppLaunchCmdSysRequestLocal");
        LaunchMethod._add(10, "sysAppLaunchCmdSaveData");
        LaunchMethod._add(11, "sysAppLaunchCmdInitDatabase");
        LaunchMethod._add(12, "sysAppLaunchCmdSyncCallApplicationV10");
        LaunchMethod._add(13, "sysAppLaunchCmdPanelCalledFromApp");
        LaunchMethod._add(14, "sysAppLaunchCmdReturnFromPanel");
        LaunchMethod._add(15, "sysAppLaunchCmdLookup");
        LaunchMethod._add(16, "sysAppLaunchCmdSystemLock");
        LaunchMethod._add(17, "sysAppLaunchCmdSysRequestRemote");
        LaunchMethod._add(18, "sysAppLaunchCmdHandleSyncCallApp");
        LaunchMethod._add(19, "sysAppLaunchCmdAddRecord");
        LaunchMethod._add(20, "sysSvcLaunchCmdSetServiceID");
        LaunchMethod._add(21, "sysSvcLaunchCmdGetServiceID");
        LaunchMethod._add(22, "sysSvcLaunchCmdGetServiceList");
        LaunchMethod._add(23, "sysSvcLaunchCmdGetServiceInfo");
        LaunchMethod._add(24, "sysAppLaunchCmdFailedAppNotify");
        LaunchMethod._add(25, "sysAppLaunchCmdEventHook");
        LaunchMethod._add(26, "sysAppLaunchCmdExgReceiveData");
        LaunchMethod._add(27, "sysAppLaunchCmdExgAskUser");
        LaunchMethod._add(30, "sysDialLaunchCmdDial");
        LaunchMethod._add(31, "sysDialLaunchCmdHangUp");
        LaunchMethod._add(40, "sysSvcLaunchCmdGetQuickEditLabel");
        LaunchMethod._add(50, "sysAppLaunchCmdURLParams");
        LaunchMethod._add(51, "sysAppLaunchCmdNotify");
        LaunchMethod._add(52, "sysAppLaunchCmdOpenDB");
        LaunchMethod._add(53, "sysAppLaunchCmdAntennaUp");
        LaunchMethod._add(54, "sysAppLaunchCmdGotoURL");
        LaunchMethod._add(55, "sysAppLaunchCmdNppiNoUI");
        LaunchMethod._add(56, "sysAppLaunchCmdNppiUI");
        LaunchMethod._add(57, "sysAppLaunchCmdExgPreview");
        LaunchMethod._add(58, "sysAppLaunchCmdCardLaunch");
        LaunchMethod._add(59, "sysAppLaunchCmdExgGetData");
        LaunchMethod._add(60, "sysAppLaunchCmdAttention");
        LaunchMethod._add(61, "sysAppLaunchPnpsPreLaunch");
        LaunchMethod._add(63, "sysAppLaunchCmdMultimediaEvent");
        LaunchMethod._add(87, "sysAppLaunchCmdFepPanelAddWord");
        LaunchMethod._add(88, "sysAppLaunchCmdLookupWord");
    }

    static void _add(int n, String string) {
        LaunchMethod.nameMap[n] = string;
    }

    public LaunchMethod() {
        this.cmdValue = -1;
    }

    public LaunchMethod(int n, int n2) {
        this.cmdValue = n;
        this.cmdHow = n2;
    }

    public LaunchMethod(String string) {
        this.cmdValue = -3;
        this.cmdHow = 0;
        String[] stringArray = string.split(" ");
        if (stringArray.length == 2) {
            try {
                this.cmdValue = Integer.parseInt(stringArray[0]);
                this.cmdHow = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public String toMenuString() {
        if (this.isDoNothing()) {
            return this.getString("LaunchTab.Do_Nothing");
        }
        return String.valueOf(this.isWellKnown() ? this.wellKnownName() : this.getString("LaunchTab.Custom")) + suffixArray[this.cmdHow == 1 ? 0 : 1];
    }

    public String toPodPrefString() {
        if (this.isDoNothing()) {
            return "Do Nothing";
        }
        String string = EMPTY;
        string = String.valueOf(string) + this.cmdValue;
        if (this.cmdHow == 2) {
            string = String.valueOf(string) + " Sublaunch";
        }
        return string;
    }

    public String toArchiveString() {
        return String.valueOf(Integer.toString(this.cmdValue)) + ' ' + this.cmdHow;
    }

    public boolean isDoNothing() {
        return this.cmdValue == -1;
    }

    public boolean isWellKnown() {
        return !this.isDoNothing() && this.wellKnownName() != null;
    }

    public boolean isCustom() {
        return !this.isDoNothing() && this.wellKnownName() == null;
    }

    public String wellKnownName() {
        if (this.cmdValue >= 0 && this.cmdValue < nameMap.length) {
            return nameMap[this.cmdValue];
        }
        return null;
    }

    public boolean equals(LaunchMethod launchMethod) {
        return this.cmdValue == launchMethod.cmdValue && this.cmdHow == launchMethod.cmdHow;
    }

    private String getString(String string) {
        return Messages.getString(string);
    }
}

