/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.internal.launch;

import com.palmsource.eclipse.palmoscore.CorePlugin;
import com.palmsource.eclipse.palmoscore.Messages;
import com.palmsource.eclipse.palmoscore.internal.launch.IProjectInfoThunk;
import com.palmsource.eclipse.palmoscore.internal.launch.LaunchMethod;
import com.palmsource.eclipse.palmoscore.projects.IPalmOSProject;
import com.palmsource.eclipse.palmoscore.targets.ITargetEnvironment;
import com.palmsource.eclipse.palmoscore.targets.TargetEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.RuntimeOptions;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MICommand;
import org.eclipse.cdt.debug.mi.core.command.MIExecArguments;
import org.eclipse.cdt.debug.mi.core.command.MIFileSymbolFile;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.PE;
import org.eclipse.cdt.utils.spawner.EnvironmentReader;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class PalmLaunchDelegate
extends AbstractCLaunchDelegate {
    private static final String APPCREATOR = "-AppCreator:";
    private static final String AUTOLOAD = "-AutoLoad:";
    private static final String AUTORUN = "-AutoRun:";
    private static final String DEBUG_CONSOLE = "Debug Console";
    private static final String DEBUGGER_ID = "com.palmsource.launch.palmosdebugger";
    private static final String DEBUGGER_NAME_NATIVE_RELEASE = "Palm OS Debugger/PalmOSDebuggerMI.exe";
    private static final String DEBUGGER_NAME_NATIVE_DEBUG = "Palm OS Debugger/PalmOSDebuggerMI.dbg.exe";
    private static final String DEBUGGER_NAME_SIMULATOR = "pxgdb";
    private static final String DEVNUBCREATOR = "devn";
    private static final String DLLPATH = "-DLLPath:";
    private static final String EMPTY = "";
    private static final String PATH_IDENTIFIER = "PATH";
    private static final String POD_PREFS = "com.palmsource.eclipse.tools.pod.win32";
    private static final String QUOTE = "\"";
    private static final String SEMICOLON = ";";
    private static final String SPACE = " ";
    private static final String[] ADDITIONAL_ENVIRONMENT_STRINGS = new String[]{"INHIBIT_UPDATE_TIMEOUT_WARNING", "1"};
    private static final int ERROR = 1;
    private static final int INFORMATION = 2;
    private static final int QUESTION = 3;
    private static final int WARNING = 4;
    private static final int CONFIRM = 5;
    private static final String NETSTAT_COMMAND = "netstat -aop TCP";
    private static final String WHITE = "[ \t]+";
    private static final String NONWHITE = "[^ \t]+";
    private static final String NUMBER = "[0-9]+";
    private static final String matchProto = "TCP";
    private static final String matchLocalAddress = "[^ \t]+\\:([0-9]+)";
    private static final String matchForeignAddress = "[^ \t]+\\:[0-9]+";
    private static final String matchState = "LISTENING";
    private static final String matchPID = "([0-9]+)";
    private static final int STANDARD_DEBUGGER_PORT = 2000;
    private static final int ALTERNATE_DEBUGGER_PORT = 6414;
    private static final int DYNAMIC_DEBUGGER_PORT_LOW = 59876;
    private static final int DYNAMIC_DEBUGGER_PORT_HIGH = 59976;
    private static Boolean canGetOpenPortsForProcessCache;
    private static final IPath LAUNCH_TEMP_PATH;

    static {
        LAUNCH_TEMP_PATH = CorePlugin.getDefault().getStateLocation().append(".launch_temp");
    }

    private void abort(String string) throws CoreException {
        this.abort(string, null, 0);
    }

    private String[] addArrays(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2;
        }
        if (stringArray2 == null) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    private ILaunchConfiguration addDebuggerPreferences(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.copy(EMPTY);
        if (this.isNativeLaunch((ILaunchConfiguration)iLaunchConfigurationWorkingCopy)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            File file = this.createLaunchPrefs((ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
            String string = file.getPath();
            arrayList.add(string);
            String string2 = this.getTargetEnvironment((ILaunchConfiguration)iLaunchConfigurationWorkingCopy).getPODPrefsPath().toOSString();
            arrayList.add(string2);
            iLaunchConfigurationWorkingCopy.setAttribute("com.palmsource.launch.pod_prefs", arrayList);
        }
        return iLaunchConfigurationWorkingCopy;
    }

    private long calculateDownloadTimeout(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        long l = 0L;
        IProject[] iProjectArray = this.getInstallProjects(iLaunchConfiguration);
        int n = 0;
        while (n < iProjectArray.length) {
            l += this.calculateDownloadTimeout(iLaunchConfiguration, iProjectArray[n]);
            ++n;
        }
        return l;
    }

    private long calculateDownloadTimeout(ILaunchConfiguration iLaunchConfiguration, IProject iProject) throws CoreException {
        long l = 0L;
        IPath iPath = this.getPrcPath(iLaunchConfiguration, iProject);
        if (iPath != null) {
            File file = iPath.toFile();
            long l2 = file.length();
            l = (l2 / 1024L + 1L) * 1000L;
        }
        return l;
    }

    private boolean canGetOpenPortsForProcess() throws CoreException {
        if (canGetOpenPortsForProcessCache == null) {
            String string = System.getProperty("os.name").toLowerCase();
            if (!string.startsWith("windows")) {
                this.abort("Windows-specific code needs to be ported.");
            }
            CommandResult commandResult = this.runCommand(NETSTAT_COMMAND);
            canGetOpenPortsForProcessCache = new Boolean(commandResult.success());
        }
        return canGetOpenPortsForProcessCache;
    }

    private void configureDebugger(ILaunchConfiguration iLaunchConfiguration, ICDISession iCDISession) throws CoreException {
        if (!(iCDISession instanceof Session)) {
            this.abort("Invalid session type");
        }
        Session session = (Session)iCDISession;
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        try {
            Object object;
            IPath iPath;
            Object object2;
            if (this.isNativeLaunch(iLaunchConfiguration)) {
                object2 = this.getLaunchProject(iLaunchConfiguration);
                iPath = this.getPrcPath(iLaunchConfiguration, (IProject)object2);
                object = iPath.toOSString();
                Object object3 = commandFactory.createMIFileExecFile((String)object);
                this.postCommand(mISession, (Command)object3);
                iPath = this.getDebugSymbolPath(iLaunchConfiguration, (IProject)object2);
                if (this.pathExists(iPath) && new File((String)(object = iPath.toOSString())).exists()) {
                    object3 = commandFactory.createMIFileSymbolFile((String)object);
                    this.postCommand(mISession, (Command)object3);
                }
                IProject[] iProjectArray = this.getInstallProjects(iLaunchConfiguration);
                int n = 0;
                while (n < iProjectArray.length) {
                    IProject iProject = iProjectArray[n];
                    iPath = this.getPrcPath(iLaunchConfiguration, iProject);
                    object = iPath.toOSString();
                    object3 = new MIFileExecAddFile((String)object);
                    this.postCommand(mISession, (Command)object3);
                    iPath = this.getDebugSymbolPath(iLaunchConfiguration, iProject);
                    if (this.pathExists(iPath) && new File((String)(object = iPath.toOSString())).exists()) {
                        object3 = new MIFileSymbolFile((String)object);
                        this.postCommand(mISession, (Command)object3);
                    }
                    ++n;
                }
            } else {
                Object object4;
                SharedLibraryManager sharedLibraryManager;
                object2 = this.getHostName(iLaunchConfiguration);
                if (object2 == null) {
                    this.abort(this.getString("PalmLaunchDelegate.Target_Environment_executable_not_specified._5"));
                }
                Object object5 = commandFactory.createMIFileExecFile((String)object2);
                this.postCommand(mISession, (Command)object5);
                iPath = this.getHostArgsUser(iLaunchConfiguration);
                object = this.getPalmSimArgsForRunningACobaltApp(iLaunchConfiguration);
                String[] stringArray = this.addArrays((String[])iPath, (String[])object);
                object5 = new MIExecArgumentsAlwaysQuote(stringArray);
                this.postCommand(mISession, (Command)object5);
                ICDISharedLibraryManager iCDISharedLibraryManager = session.getSharedLibraryManager();
                if (iCDISharedLibraryManager instanceof SharedLibraryManager) {
                    sharedLibraryManager = (SharedLibraryManager)iCDISharedLibraryManager;
                    try {
                        sharedLibraryManager.setAutoLoadSymbols(true);
                    }
                    catch (CDIException cDIException) {}
                    sharedLibraryManager.setDeferredBreakpoint(true);
                    sharedLibraryManager.setStopOnSolibEvents(true);
                    object5 = new MIRemoveAllWatchSolib();
                    this.postCommand(mISession, (Command)object5);
                    object4 = this.getInstallProjects(iLaunchConfiguration);
                    int n = 0;
                    while (n < ((IProject[])object4).length) {
                        IProject iProject = object4[n];
                        IPath iPath2 = this.getDllPath(iLaunchConfiguration, iProject);
                        String string = iPath2.lastSegment();
                        int n2 = string.lastIndexOf(46);
                        if (n2 != -1) {
                            string = string.substring(0, n2);
                        }
                        String string2 = "(.*/)*" + string + "(_[[:digit:]]+)*\\.dll";
                        object5 = new MIAddWatchSolib(string2);
                        this.postCommand(mISession, (Command)object5);
                        ++n;
                    }
                }
                object5 = commandFactory.createMIGDBSet(new String[]{"shell", "on"});
                this.postCommand(mISession, (Command)object5);
                sharedLibraryManager = new RuntimeOptions(session);
                object4 = this.getEnvironmentProperties();
                sharedLibraryManager.setEnvironment((Properties)object4);
            }
            object2 = this.getPilotMainFile(iLaunchConfiguration);
            if (object2 != null) {
                iPath = session.getBreakpointManager().createLocation((String)object2, "PilotMain", 0);
                try {
                    session.getBreakpointManager().setLocationBreakpoint(1, (ICDILocation)iPath, null, null, true);
                }
                catch (CDIException cDIException) {
                    this.abort("Unable to set temporary breakpoint in PilotMain.", cDIException, 0);
                }
            }
        }
        catch (Throwable throwable) {
            this.abort("Unable to configure the debugger: " + throwable.getMessage(), throwable, 0);
        }
    }

    private boolean containsWhitespace(String string) {
        int n = 0;
        while (n < string.length()) {
            if (Character.isWhitespace(string.charAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(IPath var1_1, IPath var2_2) throws IOException, FileNotFoundException {
        var3_3 = var2_2.append(var1_1.lastSegment());
        var4_4 = var1_1.toFile();
        var5_5 = var3_3.toFile();
        var5_5.createNewFile();
        var6_6 = new FileInputStream(var4_4);
        try {
            var7_7 = new FileOutputStream(var5_5);
            try {
                try {
                    Class.forName("java.nio.channels.FileChannel");
                    var8_8 = var6_6.getChannel();
                    var9_10 = var7_7.getChannel();
                    var9_10.transferFrom(var8_8, 0L, var8_8.size());
                    ** GOTO lbl-1000
                }
                catch (ClassNotFoundException v0) {
                    var8_9 = new byte[1024];
                    var9_11 = 0;
                }
                while ((var9_11 = var6_6.read(var8_9)) != -1) {
                    var7_7.write(var8_9, 0, var9_11);
                }
            }
            catch (Throwable var11_12) {
                var10_13 = null;
                var7_7.close();
                throw var11_12;
            }
lbl-1000:
            // 2 sources

            {
                var10_14 = null;
                var7_7.close();
            }
        }
        catch (Throwable var13_15) {
            var12_16 = null;
            var6_6.close();
            throw var13_15;
        }
        {
            var12_17 = null;
        }
        var6_6.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File createLaunchPrefs(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        LaunchMethod launchMethod;
        String string = iLaunchConfiguration.getAttribute("com.palmsource.launch.launch_code", EMPTY);
        String string2 = iLaunchConfiguration.getAttribute("com.palmsource.launch.launch_data", EMPTY);
        String string3 = this.getHostAddress(iLaunchConfiguration);
        int n = this.getHostPort(iLaunchConfiguration);
        String string4 = this.getTargetEnvironment(iLaunchConfiguration).getType();
        if (string4.equals("device")) {
            n = -1;
        } else if (this.isLocalHost(string3) && this.canGetOpenPortsForProcess()) {
            launchMethod = this.getHostProcessInfo(iLaunchConfiguration);
            if (launchMethod == null) {
                this.abort(Messages.getString("PalmLaunchDelegate.error_no_host"));
            }
            if ((n = this.getProcessDebuggerPort((IProcessInfo)launchMethod)) == -1) {
                this.abort(Messages.getString("PalmLaunchDelegate.error_bad_port"));
            }
        } else {
            n = this.getHostPort(iLaunchConfiguration);
        }
        launchMethod = new LaunchMethod(string);
        String string5 = launchMethod.toPodPrefString();
        try {
            File file = File.createTempFile("PODSTemp", ".xml", null);
            file.deleteOnExit();
            FileWriter fileWriter = new FileWriter(file);
            try {
                fileWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
                fileWriter.write("<!DOCTYPE PREFDATA>\n");
                fileWriter.write("<PREFDATA>\n");
                fileWriter.write("\t<CATEGORY ID=\"Protocols\">\n");
                fileWriter.write("\t\t<PANEL ID=\"68K Palm OS Debug Kernel\">\n");
                fileWriter.write("\t\t\t<DATA ID=\"poser_path\"/>\n");
                fileWriter.write("\t\t\t<DATA ID=\"simulator_path\"/>\n");
                fileWriter.write("\t\t\t<DATA ID=\"launch_code\">" + string5 + "</DATA>\n");
                fileWriter.write("\t\t\t<DATA ID=\"param_block\">" + string2 + "</DATA>\n");
                fileWriter.write("\t\t\t<DATA ID=\"enable_pno_debugging\">false</DATA>\n");
                fileWriter.write("\t\t</PANEL>\n");
                fileWriter.write("\t</CATEGORY>\n");
                if (n != -1) {
                    fileWriter.write("\t<CATEGORY ID=\"Communications\">\n");
                    fileWriter.write("\t\t<PANEL ID=\"Sockets\">\n");
                    fileWriter.write("\t\t\t<DATA ID=\"ip\">" + string3 + "</DATA>\n");
                    fileWriter.write("\t\t\t<DATA ID=\"port\">" + n + "</DATA>\n");
                    fileWriter.write("\t\t</PANEL>\n");
                    fileWriter.write("\t</CATEGORY>\n");
                }
                fileWriter.write("</PREFDATA>\n");
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                fileWriter.close();
                throw throwable;
            }
            {
                Object var11_14 = null;
            }
            fileWriter.close();
            return file;
        }
        catch (IOException iOException) {
            this.abort(String.valueOf(this.getString("PalmLaunchDelegate.Unable_to_create_pref_file")) + iOException.getMessage());
            return null;
        }
    }

    private void createLaunchTempDirectory() {
        File file = LAUNCH_TEMP_PATH.toFile();
        this.deleteDirectory(file);
        file.mkdirs();
    }

    private void deleteDirectory(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                File file2 = fileArray[n];
                this.deleteDirectory(file2);
                ++n;
            }
        }
        file.delete();
    }

    private void ensurePathExists(IPath iPath) throws CoreException {
        if (!this.pathExists(iPath)) {
            this.fileNotFound(iPath);
        }
    }

    private Process execDetached(String[] stringArray) throws IOException {
        String[] stringArray2 = this.toStringArray(this.getEnvironmentProperties());
        try {
            Process process = ProcessFactory.getFactory().exec("true");
            if (process instanceof Spawner) {
                Spawner spawner = (Spawner)process;
                spawner.exec_detached(stringArray, stringArray2, null);
                return spawner;
            }
        }
        catch (IOException iOException) {}
        return Runtime.getRuntime().exec(stringArray, stringArray2);
    }

    private void fileNotFound(IPath iPath) throws CoreException {
        String string = this.getString("PalmLaunchDelegate.File_not_found");
        String string2 = MessageFormat.format(string, iPath.toOSString());
        this.abort(string2);
    }

    private int findUnusedLocalPort(int n, int n2) {
        Random random = new Random(System.currentTimeMillis());
        int n3 = 0;
        while (n3 < 100) {
            try {
                int n4 = random.nextInt(n2 - n) + n;
                new ServerSocket(n4).close();
                return n4;
            }
            catch (IOException iOException) {
                ++n3;
            }
        }
        return -1;
    }

    private IPath getAxfPath(ILaunchConfiguration iLaunchConfiguration, IProject iProject) throws CoreException {
        IPath iPath = this.getProjectInfo(iProject).getAxfPath();
        return iPath;
    }

    private IPath getCoffPath(ILaunchConfiguration iLaunchConfiguration, IProject iProject) throws CoreException {
        IPath iPath = this.getProjectInfo(iProject).getCoffPath();
        return iPath;
    }

    private long getCommandTimeout(ICDISession iCDISession) {
        MISession mISession;
        if (iCDISession instanceof Session && (mISession = ((Session)iCDISession).getMISession()) != null) {
            return mISession.getCommandTimeout();
        }
        return 0L;
    }

    private IProject getCurrentProject(ILaunchConfiguration iLaunchConfiguration) {
        ICElement iCElement = CorePlugin.getContext();
        if (iCElement == null) {
            return null;
        }
        ICProject iCProject = iCElement.getCProject();
        if (iCProject == null) {
            return null;
        }
        IProject iProject = iCProject.getProject();
        return iProject;
    }

    private String getDebuggerID(ILaunchConfiguration iLaunchConfiguration) {
        return DEBUGGER_ID;
    }

    private String getDebuggerPath(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        if (this.isNativeLaunch(iLaunchConfiguration)) {
            String string = CorePlugin.findProperty(POD_PREFS, PATH_IDENTIFIER);
            if (string == null) {
                this.abort(this.getString("PalmLaunchDelegate.Unable_to_determine_path_to_debugger_2"));
            }
            Path path = new Path(string);
            IPath iPath = path.append(DEBUGGER_NAME_NATIVE_RELEASE);
            IPath iPath2 = path.append(DEBUGGER_NAME_NATIVE_DEBUG);
            if (iPath.toFile().exists()) {
                path = iPath;
            } else if (iPath2.toFile().exists()) {
                path = iPath2;
            } else {
                this.fileNotFound(iPath);
            }
            String string2 = path.toOSString();
            return string2;
        }
        return DEBUGGER_NAME_SIMULATOR;
    }

    private IPath getDebugSymbolPath(ILaunchConfiguration iLaunchConfiguration, IProject iProject) throws CoreException {
        IPath iPath = this.isNativeLaunch(iLaunchConfiguration) ? (this.isProteinProject(iProject) ? this.getAxfPath(iLaunchConfiguration, iProject) : this.getCoffPath(iLaunchConfiguration, iProject)) : this.getDllPath(iLaunchConfiguration, iProject);
        return iPath;
    }

    private IPath getDllPath(ILaunchConfiguration iLaunchConfiguration, IProject iProject) throws CoreException {
        IPath iPath = this.getProjectInfo(iProject).getDllPath();
        return iPath;
    }

    private Properties getEnvironmentProperties() {
        Properties properties = this.getEnvVars();
        int n = 0;
        while (n < ADDITIONAL_ENVIRONMENT_STRINGS.length) {
            properties.setProperty(ADDITIONAL_ENVIRONMENT_STRINGS[n], ADDITIONAL_ENVIRONMENT_STRINGS[n + 1]);
            n += 2;
        }
        return properties;
    }

    private Properties getEnvVars() {
        return EnvironmentReader.getEnvVars();
    }

    private IFile getExecFile(ILaunchConfiguration iLaunchConfiguration, IProject iProject) throws CoreException {
        IPath iPath = this.getDebugSymbolPath(iLaunchConfiguration, iProject);
        this.ensurePathExists(iPath);
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(iPath);
        if (!(iFile instanceof IFile)) {
            this.fileNotFound(iPath);
        }
        return iFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFileNameForSymbol(ILaunchConfiguration iLaunchConfiguration, IProject iProject, String string) throws CoreException, IOException {
        String string2;
        PE pE;
        block19: {
            String string3;
            block20: {
                String string4;
                block18: {
                    String string5;
                    block17: {
                        IPath iPath = this.getDebugSymbolPath(iLaunchConfiguration, iProject);
                        if (!this.pathExists(iPath)) {
                            return null;
                        }
                        String string6 = iPath.toOSString();
                        if (string6 == null) {
                            return null;
                        }
                        pE = null;
                        try {
                            pE = new PE(string6);
                        }
                        catch (Throwable throwable) {
                            return null;
                        }
                        try {
                            String string7 = null;
                            int n = 0;
                            Coff.Symbol[] symbolArray = pE.getSymbols();
                            if (symbolArray == null) {
                                string5 = null;
                                Object var18_14 = null;
                                break block17;
                            }
                            byte[] byArray = pE.getStringTable();
                            if (byArray == null) {
                                string4 = null;
                                break block18;
                            }
                            PE.NTOptionalHeader nTOptionalHeader = pE.getNTOptionalHeader();
                            int n2 = 0;
                            if (nTOptionalHeader != null) {
                                n2 = nTOptionalHeader.ImageBase + nTOptionalHeader.FileAlignment;
                            }
                            int n3 = 0;
                            while (true) {
                                if (n3 >= symbolArray.length) {
                                    string2 = null;
                                    break block19;
                                }
                                Coff.Symbol symbol = symbolArray[n3++];
                                if (symbol.n_sclass == 103) {
                                    n = symbol.n_value - n2;
                                    symbol = symbolArray[n3++];
                                    int n4 = symbol.n_value - n2;
                                    if (symbol.isLongName()) {
                                        string7 = symbol.getName(byArray);
                                        continue;
                                    }
                                    byte[] byArray2 = new byte[18];
                                    System.arraycopy(symbol._n_name, 0, byArray2, 0, 8);
                                    byArray2[8] = (byte)(n4 >>> 0);
                                    byArray2[9] = (byte)(n4 >>> 8);
                                    byArray2[10] = (byte)(n4 >>> 16);
                                    byArray2[11] = (byte)(n4 >>> 24);
                                    byArray2[12] = (byte)(symbol.n_scnum >>> 0);
                                    byArray2[13] = (byte)(symbol.n_scnum >>> 8);
                                    byArray2[14] = (byte)(symbol.n_type >>> 0);
                                    byArray2[15] = (byte)(symbol.n_type >>> 8);
                                    byArray2[16] = (byte)(symbol.n_sclass >>> 0);
                                    byArray2[17] = (byte)(symbol.n_numaux >>> 0);
                                    int n5 = 0;
                                    while (n5 < 18 && byArray2[n5] != 0) {
                                        ++n5;
                                    }
                                    string7 = new String(byArray2, 0, n5);
                                    continue;
                                }
                                String string8 = symbol.getName(byArray);
                                if (EMPTY.equals(string8)) {
                                    int n6 = 0;
                                    while (n6 < 8 && symbol._n_name[n6++] != 0) {
                                    }
                                    if (n6 == 8) {
                                        string8 = new String(symbol._n_name, 0, 8);
                                    }
                                }
                                if (string.equals(string8) && n3 < n) break;
                            }
                            string3 = string7;
                            break block20;
                        }
                        catch (Throwable throwable) {
                            Object var18_18 = null;
                            pE.dispose();
                            throw throwable;
                        }
                    }
                    pE.dispose();
                    return string5;
                }
                Object var18_15 = null;
                pE.dispose();
                return string4;
            }
            Object var18_16 = null;
            pE.dispose();
            return string3;
        }
        Object var18_17 = null;
        pE.dispose();
        return string2;
    }

    private String[] getHostArgsUser(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String[] stringArray = this.getProgramArgumentsArray(iLaunchConfiguration);
        return stringArray;
    }

    private String getHostAddress(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = this.getTargetEnvironment(iLaunchConfiguration).getHostAddress();
        return string;
    }

    private String getHostName(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = this.getTargetEnvironment(iLaunchConfiguration).getHostPath();
        return string;
    }

    private int getHostPort(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = this.getTargetEnvironment(iLaunchConfiguration).getHostPort();
        return Integer.parseInt(string);
    }

    private IProcessInfo getHostProcessInfo(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = this.getHostName(iLaunchConfiguration);
        if (string == null) {
            return null;
        }
        IProcessList iProcessList = this.getProcessList();
        if (iProcessList == null) {
            return null;
        }
        IProcessInfo[] iProcessInfoArray = iProcessList.getProcessList();
        if (iProcessInfoArray == null) {
            return null;
        }
        int n = 0;
        while (n < iProcessInfoArray.length) {
            IProcessInfo iProcessInfo = iProcessInfoArray[n];
            String string2 = iProcessInfo.getName();
            if (string.equalsIgnoreCase(string2)) {
                return iProcessInfo;
            }
            ++n;
        }
        return null;
    }

    private IProject[] getInstallProjects(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IProject[] iProjectArray = new IProject[]{};
        try {
            if (this.isCustomLaunch(iLaunchConfiguration)) {
                IResource[] iResourceArray = CorePlugin.resurrectResources(iLaunchConfiguration, "com.palmsource.launch.installables");
                iProjectArray = new IProject[iResourceArray.length];
                System.arraycopy(iResourceArray, 0, iProjectArray, 0, iResourceArray.length);
            } else {
                iProjectArray = new IProject[]{this.getCurrentProject(iLaunchConfiguration)};
            }
        }
        catch (CoreException coreException) {}
        if (iProjectArray == null) {
            this.abort(Messages.getString("PalmLaunchDelegate.error_no_projects_to_install"));
        }
        return iProjectArray;
    }

    private LaunchManager getLaunchManager() {
        return (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
    }

    private IProject getLaunchProject(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IProject iProject = null;
        try {
            if (this.isCustomLaunch(iLaunchConfiguration)) {
                IResource[] iResourceArray = CorePlugin.resurrectResources(iLaunchConfiguration, "com.palmsource.launch.launchable");
                iProject = (IProject)iResourceArray[0];
            } else {
                iProject = this.getCurrentProject(iLaunchConfiguration);
            }
        }
        catch (CoreException coreException) {}
        if (iProject == null) {
            this.abort(Messages.getString("PalmLaunchDelegate.error_no_project_to_launch"));
        }
        return iProject;
    }

    private int[] getProcessListeningPorts(IProcessInfo iProcessInfo) throws CoreException {
        CommandResult commandResult;
        String string = System.getProperty("os.name").toLowerCase();
        if (!string.startsWith("windows")) {
            this.abort("Windows-specific code needs to be ported.");
        }
        if (!(commandResult = this.runCommand(NETSTAT_COMMAND)).success()) {
            return new int[]{2000, 6414};
        }
        Pattern pattern = Pattern.compile("[ \t]+TCP[ \t]+[^ \t]+\\:([0-9]+)[ \t]+[^ \t]+\\:[0-9]+[ \t]+LISTENING[ \t]+" + iProcessInfo.getPid());
        String[] stringArray = commandResult.getOutAsArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            Matcher matcher = pattern.matcher(stringArray[n]);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                arrayList.add(string2);
            }
            ++n;
        }
        int[] nArray = new int[arrayList.size()];
        int n2 = 0;
        while (n2 < arrayList.size()) {
            nArray[n2] = Integer.parseInt((String)arrayList.get(n2));
            ++n2;
        }
        return nArray;
    }

    private String[] getPalmSimArgsForRunningACobaltApp(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IProject iProject = this.getLaunchProject(iLaunchConfiguration);
        IProject[] iProjectArray = this.getInstallProjects(iLaunchConfiguration);
        ArrayList<String> arrayList = new ArrayList<String>();
        IPath iPath = this.getPrcPath(iLaunchConfiguration, iProject);
        this.ensurePathExists(iPath);
        String string = iPath.toOSString();
        arrayList.add(AUTORUN + string);
        if (iProjectArray.length == 1) {
            iPath = this.getPrcPath(iLaunchConfiguration, iProjectArray[0]);
            this.ensurePathExists(iPath);
            string = iPath.toOSString();
            arrayList.add(AUTOLOAD + string);
            IPath iPath2 = this.getDllPath(iLaunchConfiguration, iProjectArray[0]);
            if (this.pathExists(iPath2)) {
                iPath2 = iPath2.removeLastSegments(1);
                string = iPath2.toOSString();
                arrayList.add(DLLPATH + string);
            }
        } else if (iProjectArray.length > 1) {
            this.createLaunchTempDirectory();
            string = LAUNCH_TEMP_PATH.toOSString();
            arrayList.add(AUTOLOAD + string);
            arrayList.add(DLLPATH + string);
            int n = 0;
            while (n < iProjectArray.length) {
                IProject iProject2 = iProjectArray[n];
                iPath = this.getPrcPath(iLaunchConfiguration, iProject2);
                IPath iPath3 = this.getDllPath(iLaunchConfiguration, iProject2);
                try {
                    this.ensurePathExists(iPath);
                    this.copyFile(iPath, LAUNCH_TEMP_PATH);
                    if (this.pathExists(iPath3)) {
                        this.copyFile(iPath3, LAUNCH_TEMP_PATH);
                    }
                }
                catch (Throwable throwable) {
                    this.deleteDirectory(LAUNCH_TEMP_PATH.toFile());
                    this.abort(String.valueOf(this.getString("PalmLaunchDelegate.Unable_to_copy_files")) + throwable.getMessage());
                }
                ++n;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private String[] getPalmSimArgsForRunningAGarnetApp(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        this.getLaunchProject(iLaunchConfiguration);
        IProject[] iProjectArray = this.getInstallProjects(iLaunchConfiguration);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-AppCreator:devn");
        if (!this.isNativeProject(this.getLaunchProject(iLaunchConfiguration))) {
            boolean bl = true;
            String string = EMPTY;
            int n = 0;
            while (n < iProjectArray.length) {
                IPath iPath = this.getDllPath(iLaunchConfiguration, iProjectArray[n]);
                if (this.pathExists(iPath)) {
                    iPath = iPath.removeLastSegments(1);
                    String string2 = iPath.toOSString();
                    if (bl) {
                        string = String.valueOf(string) + DLLPATH;
                        bl = false;
                    } else {
                        string = String.valueOf(string) + SEMICOLON;
                    }
                    string = String.valueOf(string) + string2;
                }
                ++n;
            }
            if (string.length() > 0) {
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getPilotMainFile(ILaunchConfiguration iLaunchConfiguration) throws CoreException, IOException {
        IProject iProject = this.getLaunchProject(iLaunchConfiguration);
        return this.getFileNameForSymbol(iLaunchConfiguration, iProject, "_PilotMain");
    }

    protected String getPluginID() {
        return CorePlugin.getPluginID();
    }

    private int getProcessDebuggerPort(IProcessInfo iProcessInfo) throws CoreException {
        int[] nArray = this.getProcessListeningPorts(iProcessInfo);
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 == 2000 || n2 == 6414 || n2 >= 59876 && n2 <= 59976) {
                return n2;
            }
            ++n;
        }
        return 0;
    }

    private IPath getPrcPath(ILaunchConfiguration iLaunchConfiguration, IProject iProject) throws CoreException {
        IPath iPath = this.getProjectInfo(iProject).getPrcPath();
        return iPath;
    }

    private IProcessList getProcessList() throws CoreException {
        return CCorePlugin.getDefault().getProcessList();
    }

    public String getProgramArguments(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = this.getTargetEnvironment(iLaunchConfiguration).getHostArguments();
        return string;
    }

    private IProjectInfoThunk getProjectInfo(IProject iProject) throws CoreException {
        String string;
        IPalmOSProject iPalmOSProject = CorePlugin.getPalmOSProject(iProject);
        if (iPalmOSProject == null) {
            this.abort(Messages.getString("PalmLaunchDelegate.error_cannot_access_palmosproject"));
        }
        if ((string = iPalmOSProject.getTargetOSAPI()) == null) {
            this.abort(Messages.getString("PalmLaunchDelegate.error_no_target_os"));
        }
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(CorePlugin.getPluginID(), "projectInfoThunks");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                String string2 = iConfigurationElement.getAttribute("targetOSAPI");
                if (string.equalsIgnoreCase(string2)) {
                    Object object = iConfigurationElement.createExecutableExtension("class");
                    IProjectInfoThunk iProjectInfoThunk = (IProjectInfoThunk)object;
                    iProjectInfoThunk.setPalmOSProject(iPalmOSProject);
                    return iProjectInfoThunk;
                }
                ++n2;
            }
            ++n;
        }
        this.abort(String.valueOf(this.getString("PalmLaunchDelegate.Unable_to_launch_find_IProjectInfoThunk_adapter_for__3")) + string);
        return null;
    }

    private String getString(String string) {
        return Messages.getString(string);
    }

    private ITargetEnvironment getTargetEnvironment(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        if (this.isNativeProject(this.getLaunchProject(iLaunchConfiguration))) {
            return this.getTargetEnvironment(iLaunchConfiguration, "Device");
        }
        return this.getTargetEnvironment(iLaunchConfiguration, "Simulator");
    }

    private ITargetEnvironment getTargetEnvironment(ILaunchConfiguration iLaunchConfiguration, String string) throws CoreException {
        ITargetEnvironment iTargetEnvironment;
        Map map = new HashMap();
        try {
            map = iLaunchConfiguration.getAttribute("com.palmsource.launch.target_configurations", new HashMap());
        }
        catch (CoreException coreException) {}
        String string2 = (String)map.get(string);
        if (string2 == null) {
            this.abort(this.getString("PalmLaunchDelegate.NoTargetEnvironment1"));
        }
        if ((iTargetEnvironment = TargetEnvironment.getTargetEnvironment(string2)) == null) {
            this.abort(this.getString("PalmLaunchDelegate.NoTargetEnvironment2"));
        }
        return iTargetEnvironment;
    }

    private boolean isCustomLaunch(ILaunchConfiguration iLaunchConfiguration) {
        try {
            boolean bl = iLaunchConfiguration.getAttribute("com.palmsource.launch.custom_launch", false);
            return bl;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean isDebugProject(IProject iProject) throws CoreException {
        return this.getProjectInfo(iProject).isDebugConfiguration();
    }

    private boolean isLocalHost(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.isLoopbackAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    private boolean isNativeLaunch(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IProject iProject = this.getLaunchProject(iLaunchConfiguration);
        if (!this.isProteinProject(iProject)) {
            return true;
        }
        return this.isNativeProject(iProject);
    }

    private boolean isNativeProject(IProject iProject) throws CoreException {
        return this.getProjectInfo(iProject).isDeviceTarget();
    }

    private boolean isProteinProject(IProject iProject) throws CoreException {
        return this.getProjectInfo(iProject).isProteinProject();
    }

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        iLaunchConfiguration = this.preConfigure(iLaunchConfiguration);
        this.getTargetEnvironment(iLaunchConfiguration);
        boolean bl = string.equals("debug");
        boolean bl2 = !bl;
        IProject iProject = this.getLaunchProject(iLaunchConfiguration);
        if (bl && !this.isDebugProject(iProject)) {
            bl = false;
            String string2 = this.getString("PalmLaunchDelegate.LaunchingTitle");
            String string3 = this.getString("PalmLaunchDelegate.RunInstead");
            String string4 = MessageFormat.format(string3, iProject.getName());
            bl2 = this.openDialog(3, string2, string4);
        }
        if (bl || bl2) {
            this.setSourceLocator(iLaunch, iLaunchConfiguration);
            this.updateReferencedProjects(iLaunch, iLaunchConfiguration);
            this.launchTargetEnvironment(iLaunchConfiguration, string, iLaunch, iProgressMonitor);
            iLaunchConfiguration = this.addDebuggerPreferences(iLaunchConfiguration);
            if (bl) {
                this.launchForDebugging(iLaunchConfiguration, iLaunch, iProgressMonitor);
            } else if (bl2) {
                this.launchForRunning(iLaunchConfiguration, iLaunch, iProgressMonitor);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void launchForDebugging(ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        ICDISession iCDISession = null;
        try {
            ICDebugConfiguration iCDebugConfiguration = this.getDebugConfig(iLaunchConfiguration);
            iCDISession = iCDebugConfiguration.getDebugger().createLaunchSession(iLaunchConfiguration, null);
            this.pauseForDebugAttach();
            this.configureDebugger(iLaunchConfiguration, iCDISession);
            ICDITarget iCDITarget = iCDISession.getTargets()[0];
            Process process = iCDITarget.getProcess();
            String string = this.renderProcessLabel(AbstractCLaunchDelegate.getProjectName((ILaunchConfiguration)iLaunchConfiguration));
            IProcess iProcess = DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process, (String)string);
            Process process2 = iCDISession.getSessionProcess();
            IProcess iProcess2 = null;
            if (process2 != null) {
                iProcess2 = DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process2, (String)DEBUG_CONSOLE);
            }
            IFile iFile = this.getExecFile(iLaunchConfiguration, this.getLaunchProject(iLaunchConfiguration));
            long l = this.setDownloadTimeout(iCDISession, iLaunchConfiguration);
            try {
                CDebugModel.newDebugTarget((ILaunch)iLaunch, (ICDITarget)iCDISession.getCurrentTarget(), (String)this.renderTargetLabel(iCDebugConfiguration), (IProcess)iProcess, (IProcess)iProcess2, (IFile)iFile, (boolean)true, (boolean)false, (boolean)false);
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                this.setCommandTimeout(iCDISession, l);
                throw throwable;
            }
            {
                Object var15_18 = null;
                this.setCommandTimeout(iCDISession, l);
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                iLaunch.terminate();
                if (iCDISession != null) {
                    iCDISession.terminate();
                }
            }
            catch (Throwable throwable2) {
                DebugPlugin.log((Throwable)throwable2);
            }
            if (throwable instanceof CoreException) {
                throw (CoreException)throwable;
            }
            this.abort("Failed launching debugger", throwable, 0);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void launchForRunning(ILaunchConfiguration iLaunchConfiguration, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        this.getLaunchManager().removeLaunch(iLaunch);
        if (this.isNativeLaunch(iLaunchConfiguration)) {
            ICDISession iCDISession = null;
            try {
                ICDebugConfiguration iCDebugConfiguration = this.getDebugConfig(iLaunchConfiguration);
                iCDISession = iCDebugConfiguration.getDebugger().createLaunchSession(iLaunchConfiguration, null);
                this.pauseForDebugAttach();
                this.configureDebugger(iLaunchConfiguration, iCDISession);
                Session session = (Session)iCDISession;
                MISession mISession = session.getMISession();
                mISession.getCommandFactory();
                long l = this.setDownloadTimeout(iCDISession, iLaunchConfiguration);
                try {
                    MIExecRunNoDebug mIExecRunNoDebug = new MIExecRunNoDebug();
                    this.postCommand(mISession, (Command)mIExecRunNoDebug);
                }
                catch (Throwable throwable) {
                    Object var11_18 = null;
                    this.setCommandTimeout(iCDISession, l);
                    throw throwable;
                }
                {
                    Object var11_19 = null;
                    this.setCommandTimeout(iCDISession, l);
                }
                mISession.getMIInferior().setTerminated();
                session.terminate();
                return;
            }
            catch (Throwable throwable) {
                try {
                    if (iCDISession != null) {
                        iCDISession.terminate();
                    }
                }
                catch (Throwable throwable2) {
                    DebugPlugin.log((Throwable)throwable2);
                }
                this.abort(String.valueOf(this.getString("PalmLaunchDelegate.Unable_to_launch_Target_Environment___4")) + throwable.getMessage(), throwable, 0);
                return;
            }
        }
        String string = this.getHostName(iLaunchConfiguration);
        String[] stringArray = this.getHostArgsUser(iLaunchConfiguration);
        String[] stringArray2 = this.getPalmSimArgsForRunningACobaltApp(iLaunchConfiguration);
        if (string == null) {
            this.abort(this.getString("PalmLaunchDelegate.Target_Environment_executable_not_specified._5"));
        }
        String[] stringArray3 = new String[]{string};
        stringArray3 = this.addArrays(stringArray3, stringArray);
        stringArray3 = this.addArrays(stringArray3, stringArray2);
        try {
            this.execDetached(stringArray3);
            return;
        }
        catch (IOException iOException) {
            this.abort(String.valueOf(this.getString("PalmLaunchDelegate.Unable_to_launch_Target_Environment___4")) + iOException.getMessage(), iOException, 0);
        }
    }

    private void launchTargetEnvironment(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        String string2;
        if (!this.isNativeLaunch(iLaunchConfiguration)) {
            return;
        }
        String string3 = this.getTargetEnvironment(iLaunchConfiguration).getType();
        if (string3.equals("device")) {
            return;
        }
        String string4 = this.getHostAddress(iLaunchConfiguration);
        if (!this.isLocalHost(string4)) {
            return;
        }
        int n = 0;
        IProcessInfo iProcessInfo = this.getHostProcessInfo(iLaunchConfiguration);
        if (iProcessInfo != null && (n = this.getProcessDebuggerPort(iProcessInfo)) != 0) {
            return;
        }
        if (this.canGetOpenPortsForProcess()) {
            n = this.findUnusedLocalPort(59876, 59976);
            if (n == -1) {
                this.abort("Unable to find a free port to use for debugging.");
            }
        } else {
            n = this.getHostPort(iLaunchConfiguration);
        }
        if ((string2 = this.getHostName(iLaunchConfiguration)) == null) {
            this.abort(this.getString("PalmLaunchDelegate.Target_Environment_executable_not_specified._5"));
        }
        String[] stringArray = new String[]{string2};
        stringArray = this.addArrays(stringArray, this.getHostArgsUser(iLaunchConfiguration));
        if (string3.equals("simulator")) {
            stringArray = this.addArrays(stringArray, this.getPalmSimArgsForRunningAGarnetApp(iLaunchConfiguration));
            stringArray = this.addArrays(stringArray, new String[]{"-68kdebuggerport:localhost:" + n});
        }
        try {
            this.execDetached(stringArray);
        }
        catch (Throwable throwable) {
            this.abort(String.valueOf(this.getString("PalmLaunchDelegate.Unable_to_launch_Target_Environment___6")) + throwable.getMessage(), throwable, 0);
        }
        String string5 = this.getString("PalmLaunchDelegate.LaunchingTitle");
        String string6 = this.getString("PalmLaunchDelegate.LaunchingMessage");
        boolean bl = this.openDialog(5, string5, string6);
        if (!bl) {
            this.abort(this.getString("PalmLaunchDelegate.User_cancelled_debug_session._7"));
        }
    }

    private boolean openDialog(final int n, final String string, final String string2) {
        final boolean[] blArray = new boolean[]{true};
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            public void run() {
                switch (n) {
                    case 1: {
                        MessageDialog.openError(null, (String)string, (String)string2);
                        break;
                    }
                    case 2: {
                        MessageDialog.openInformation(null, (String)string, (String)string2);
                        break;
                    }
                    case 3: {
                        blArray[0] = MessageDialog.openQuestion(null, (String)string, (String)string2);
                        break;
                    }
                    case 4: {
                        MessageDialog.openWarning(null, (String)string, (String)string2);
                        break;
                    }
                    case 5: {
                        blArray[0] = MessageDialog.openConfirm(null, (String)string, (String)string2);
                    }
                }
            }
        });
        return blArray[0];
    }

    private boolean pathExists(IPath iPath) {
        return iPath != null && iPath.toFile().exists();
    }

    private void pauseForDebugAttach() {
        if (CorePlugin.getAttachPOD()) {
            String string = this.getString("PalmLaunchDelegate.LaunchingTitle");
            String string2 = "Attach Visual Studio to the POD/MI instance.  To continue, click OK.";
            this.openDialog(2, string, string2);
        }
    }

    private MIInfo postCommand(MISession mISession, Command command) throws MIException {
        mISession.postCommand(command);
        MIInfo mIInfo = command.getMIInfo();
        if (mIInfo == null) {
            throw new MIException("No answer");
        }
        return mIInfo;
    }

    private ILaunchConfiguration preConfigure(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.copy(EMPTY);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", this.getDebuggerID((ILaunchConfiguration)iLaunchConfigurationWorkingCopy));
        iLaunchConfigurationWorkingCopy.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, this.getDebuggerPath((ILaunchConfiguration)iLaunchConfigurationWorkingCopy));
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true);
        return iLaunchConfigurationWorkingCopy;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandResult runCommand(String string) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Throwable throwable = null;
        try {
            Process process = Runtime.getRuntime().exec(string);
            try {
                StreamReaderThread streamReaderThread = new StreamReaderThread(process.getInputStream(), stringBuffer2);
                StreamReaderThread streamReaderThread2 = new StreamReaderThread(process.getErrorStream(), stringBuffer);
                streamReaderThread.start();
                try {
                    streamReaderThread2.start();
                    try {
                        n = process.waitFor();
                    }
                    catch (Throwable throwable2) {
                        Object var9_11 = null;
                        streamReaderThread2.join();
                        throw throwable2;
                    }
                    {
                        Object var9_12 = null;
                        streamReaderThread2.join();
                    }
                }
                catch (Throwable throwable3) {
                    Object var11_14 = null;
                    streamReaderThread.join();
                    throw throwable3;
                }
                {
                    Object var11_15 = null;
                    streamReaderThread.join();
                }
            }
            catch (Throwable throwable4) {
                Object var13_17 = null;
                process.destroy();
                throw throwable4;
            }
            {
                Object var13_18 = null;
                process.destroy();
                return new CommandResult(n, stringBuffer2.toString(), stringBuffer.toString(), throwable);
            }
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
        }
        return new CommandResult(n, stringBuffer2.toString(), stringBuffer.toString(), throwable);
    }

    private void setCommandTimeout(ICDISession iCDISession, long l) {
        MISession mISession;
        if (iCDISession instanceof Session && (mISession = ((Session)iCDISession).getMISession()) != null) {
            mISession.setCommandTimeout(l);
        }
    }

    private long setDownloadTimeout(ICDISession iCDISession, ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        long l;
        long l2 = this.calculateDownloadTimeout(iLaunchConfiguration);
        if (l2 > (l = this.getCommandTimeout(iCDISession))) {
            this.setCommandTimeout(iCDISession, l2);
        }
        return l;
    }

    private String[] toStringArray(Properties properties) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)properties.get(string);
            arrayList.add(String.valueOf(string) + '=' + string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void updateReferencedProjects(ILaunch iLaunch, ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IProject iProject = this.getLaunchProject(iLaunchConfiguration);
        IProjectDescription iProjectDescription = iProject.getDescription();
        IProject[] iProjectArray = iProjectDescription.getReferencedProjects();
        IProject[] iProjectArray2 = this.getInstallProjects(iLaunchConfiguration);
        HashSet<IProject> hashSet = new HashSet<IProject>();
        hashSet.addAll(Arrays.asList(iProjectArray));
        hashSet.addAll(Arrays.asList(iProjectArray2));
        hashSet.remove(iProject);
        IProject[] iProjectArray3 = hashSet.toArray(new IProject[hashSet.size()]);
        iProjectDescription.setReferencedProjects(iProjectArray3);
    }

    private class ExtraCoffStuff {
        private static final int C_NULL = 0;
        private static final int C_AUTO = 1;
        private static final int C_EXT = 2;
        private static final int C_STAT = 3;
        private static final int C_REG = 4;
        private static final int C_EXTDEF = 5;
        private static final int C_LABEL = 6;
        private static final int C_ULABEL = 7;
        private static final int C_MOS = 8;
        private static final int C_ARG = 9;
        private static final int C_STRTAG = 10;
        private static final int C_MOU = 11;
        private static final int C_UNTAG = 12;
        private static final int C_TPDEF = 13;
        private static final int C_USTATIC = 14;
        private static final int C_ENTAG = 15;
        private static final int C_MOE = 16;
        private static final int C_REGPARM = 17;
        private static final int C_FIELD = 18;
        private static final int C_AUTOARG = 19;
        private static final int C_LASTENT = 20;
        private static final int C_BLOCK = 100;
        private static final int C_FCN = 101;
        private static final int C_EOS = 102;
        private static final int C_FILE = 103;
        private static final int C_LINE = 104;
        private static final int C_ALIAS = 105;
        private static final int C_HIDDEN = 106;
        private static final int C_EFCN = 255;
        private static final int E_SYMNMLEN = 8;
        private static final int E_FILNMLEN = 18;

        ExtraCoffStuff() {
        }
    }

    private class MIFileExecAddFile
    extends MICommand {
        public MIFileExecAddFile(String string) {
            super("-file-exec-add-file", new String[]{string});
        }
    }

    private class MIExecRunNoDebug
    extends MICommand {
        public MIExecRunNoDebug() {
            super("-exec-run-nodebug");
        }

        public MIExecRunNoDebug(String[] stringArray) {
            super("-exec-run-nodebug", stringArray);
        }
    }

    private class MIExecArgumentsAlwaysQuote
    extends MIExecArguments {
        public MIExecArgumentsAlwaysQuote(String[] stringArray) {
            super(stringArray);
        }

        protected String parametersToString() {
            String[] stringArray = this.getParameters();
            String[] stringArray2 = this.getOptions();
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray != null && stringArray.length > 0) {
                if (stringArray2 != null && stringArray2.length > 0) {
                    int n = 0;
                    while (n < stringArray.length) {
                        if (stringArray[n].startsWith("-")) {
                            stringBuffer.append('-').append('-');
                            break;
                        }
                        ++n;
                    }
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer2.setLength(0);
                    String string = stringArray[n];
                    int n2 = 0;
                    while (n2 < string.length()) {
                        char c = string.charAt(n2);
                        if (c == '\"' || c == '\\') {
                            stringBuffer2.append('\\');
                        }
                        stringBuffer2.append(c);
                        ++n2;
                    }
                    stringBuffer2.insert(0, '\"');
                    stringBuffer2.append('\"');
                    stringBuffer.append(' ').append(stringBuffer2.toString());
                    ++n;
                }
            }
            return stringBuffer.toString().trim();
        }
    }

    private class MIAddWatchSolib
    extends MICommand {
        public MIAddWatchSolib(String string) {
            super("add-watch-solib", new String[]{string}, null);
        }
    }

    private class MIRemoveWatchSolib
    extends MICommand {
        public MIRemoveWatchSolib(String string) {
            super("remove-watch-solib", new String[]{string}, null);
        }
    }

    private class MIRemoveAllWatchSolib
    extends MICommand {
        public MIRemoveAllWatchSolib() {
            super("remove-all-watch-solib");
        }
    }

    private class StreamReaderThread
    extends Thread {
        InputStream in;
        StringBuffer out;

        public StreamReaderThread(InputStream inputStream, StringBuffer stringBuffer) {
            this.in = inputStream;
            this.out = stringBuffer;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            InputStreamReader inputStreamReader = new InputStreamReader(this.in);
            try {
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                try {
                    try {
                        int n;
                        while ((n = ((Reader)bufferedReader).read()) != -1) {
                            this.out.append((char)n);
                        }
                    }
                    catch (Exception exception) {
                        this.out.append(String.valueOf(Messages.getString("PalmLaunchDelegate.error_read")) + exception.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    try {
                        ((Reader)bufferedReader).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var5_7 = null;
                    try {}
                    catch (IOException iOException) {}
                    ((Reader)bufferedReader).close();
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    ((Reader)inputStreamReader).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var7_10 = null;
            }
            try {}
            catch (IOException iOException) {
                return;
            }
            ((Reader)inputStreamReader).close();
        }
    }

    private class CommandResult {
        private int result;
        private String out;
        private String err;
        private Throwable e;
        private final String EOL_PATTERN = System.getProperty("line.separator");

        public CommandResult(int n, String string, String string2, Throwable throwable) {
            this.result = n;
            this.out = string;
            this.err = string2;
            this.e = throwable;
        }

        public boolean success() {
            return this.getResult() == 0 && this.getException() == null && this.getErr().length() == 0;
        }

        public int getResult() {
            return this.result;
        }

        public String getOut() {
            return this.out;
        }

        public String[] getOutAsArray() {
            String[] stringArray = this.out.split(this.EOL_PATTERN);
            return stringArray;
        }

        public String getErr() {
            return this.err;
        }

        public String[] getErrAsArray() {
            String[] stringArray = this.err.split(this.EOL_PATTERN);
            return stringArray;
        }

        public Throwable getException() {
            return this.e;
        }
    }
}

