/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.internal.launch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.ICDebugger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibUnloadedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ISourceLocator;

public class PalmOSDebugger
implements ICDebugger {
    private static final String GDB = "pxgdb";

    public ICDISession createAttachSession(ILaunchConfiguration iLaunchConfiguration, IFile iFile, int n) throws CDIException {
        return null;
    }

    public ICDISession createCoreSession(ILaunchConfiguration iLaunchConfiguration, IFile iFile, IPath iPath) throws CDIException {
        return null;
    }

    public ICDISession createLaunchSession(ILaunchConfiguration iLaunchConfiguration, IFile iFile) throws CDIException {
        try {
            String string = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, GDB);
            String string2 = iLaunchConfiguration.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, "");
            List list = iLaunchConfiguration.getAttribute("com.palmsource.launch.pod_prefs", null);
            ICDISession iCDISession = this.createCSession(string, string2, list);
            return iCDISession;
        }
        catch (Exception exception) {
            throw new CDIException("Error creating session: " + exception.getMessage());
        }
    }

    private ICDISession createCSession(String string, String string2, List list) throws IOException, MIException {
        MISession mISession;
        Object object;
        PTY pTY = null;
        try {
            pTY = new PTY();
        }
        catch (IOException iOException) {}
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add("-q");
        arrayList.add("-nw");
        arrayList.add("-i");
        arrayList.add("mi1");
        if (string2.length() > 0) {
            arrayList.add("--command=" + string2);
        }
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                object = (String)list.get(n);
                arrayList.add("--podprefs=" + (String)object);
                ++n;
            }
        }
        if (pTY != null) {
            arrayList.add("-tty");
            arrayList.add(pTY.getSlaveName());
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        object = this.getGDBProcess(stringArray);
        try {
            mISession = MIPlugin.getDefault().createMISession((Process)object, pTY, 0);
        }
        catch (MIException mIException) {
            ((Process)object).destroy();
            throw mIException;
        }
        return new BumbleSession(mISession, false);
    }

    private Process getGDBProcess(String[] stringArray) throws IOException {
        final Process process = ProcessFactory.getFactory().exec(stringArray);
        Thread thread = new Thread("GDB Start"){

            public void run() {
                Object object;
                try {
                    InputStream inputStream = process.getInputStream();
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    while ((object = bufferedReader.readLine()) != null) {
                        if (!((String)(object = ((String)object).trim())).startsWith("(gdb)")) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {}
                object = process;
                synchronized (object) {
                    process.notifyAll();
                }
            }
        };
        thread.start();
        Process process2 = process;
        synchronized (process2) {
            int n = 10000;
            while (thread.isAlive()) {
                try {
                    process.wait(n);
                    break;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            thread.interrupt();
            thread.join(1000L);
        }
        catch (InterruptedException interruptedException) {}
        return process;
    }

    class BumbleSession
    extends Session {
        ICDIBreakpointManager myBreakpointManager;

        public BumbleSession(MISession mISession, boolean bl) {
            super(mISession, bl);
            this.myBreakpointManager = new BumbleBreakpointManager(this);
        }

        public ICDIBreakpointManager getBreakpointManager() {
            return this.myBreakpointManager;
        }
    }

    class BumbleBreakpointManager
    extends BreakpointManager
    implements Observer,
    IDebugEventSetListener {
        CDebugTarget debugTarget = null;
        static /* synthetic */ Class class$0;

        public BumbleBreakpointManager(Session session) {
            super(session);
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
            session.getMISession().addObserver((Observer)this);
        }

        public void handleDebugEvents(DebugEvent[] debugEventArray) {
            int n = 0;
            while (n < debugEventArray.length) {
                Object object;
                if (debugEventArray[n].getKind() == 4 && (object = debugEventArray[n].getSource()) instanceof CDebugTarget) {
                    this.debugTarget = (CDebugTarget)object;
                }
                ++n;
            }
        }

        public void update(Observable observable, Object object) {
            if (object instanceof MISharedLibUnloadedEvent) {
                try {
                    this.generateDeferredBreakpoints();
                }
                catch (CDIException cDIException) {}
            }
        }

        private ICSourceLocator getCSourceLocator() {
            if (this.debugTarget == null) {
                return null;
            }
            ILaunch iLaunch = this.debugTarget.getLaunch();
            if (iLaunch == null) {
                return null;
            }
            ISourceLocator iSourceLocator = iLaunch.getSourceLocator();
            if (iSourceLocator == null) {
                return null;
            }
            ICSourceLocator iCSourceLocator = null;
            if (iSourceLocator instanceof ICSourceLocator) {
                iCSourceLocator = (ICSourceLocator)iSourceLocator;
            } else if (iSourceLocator instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)iSourceLocator;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iCSourceLocator = (ICSourceLocator)iAdaptable.getAdapter((Class)clazz);
            }
            return iCSourceLocator;
        }

        private void generateDeferredBreakpoints() throws CDIException {
            ICSourceLocator iCSourceLocator = this.getCSourceLocator();
            if (iCSourceLocator == null) {
                return;
            }
            String string = CDIDebugModel.getPluginIdentifier();
            IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(string);
            ICDIBreakpoint[] iCDIBreakpointArray = this.getBreakpoints();
            MIBreakpoint[] mIBreakpointArray = this.getMIBreakpoints();
            int n = 0;
            while (n < iCDIBreakpointArray.length) {
                block6: {
                    Breakpoint breakpoint = (Breakpoint)iCDIBreakpointArray[n];
                    int n2 = breakpoint.getMIBreakpoint().getNumber();
                    int n3 = 0;
                    while (n3 < mIBreakpointArray.length) {
                        if (n2 != mIBreakpointArray[n3].getNumber()) {
                            ++n3;
                            continue;
                        }
                        break block6;
                    }
                    try {
                        this.deferStaleBreakpoint(breakpoint, iCSourceLocator, iBreakpointManager, iBreakpointArray);
                    }
                    catch (CoreException coreException) {}
                }
                ++n;
            }
        }

        private void deferStaleBreakpoint(Breakpoint breakpoint, ICSourceLocator iCSourceLocator, IBreakpointManager iBreakpointManager, IBreakpoint[] iBreakpointArray) throws CDIException, CoreException {
            if (breakpoint.isTemporary()) {
                return;
            }
            ICDILocation iCDILocation = breakpoint.getLocation();
            String string = iCDILocation.getFile();
            int n = iCDILocation.getLineNumber();
            if (n == 0) {
                return;
            }
            Object object = iCSourceLocator.findSourceElement(string);
            if (!(object instanceof IResource)) {
                return;
            }
            IResource iResource = (IResource)object;
            int n2 = 0;
            while (n2 < iBreakpointArray.length) {
                if (iBreakpointArray[n2] instanceof ICLineBreakpoint) {
                    ICLineBreakpoint iCLineBreakpoint = (ICLineBreakpoint)iBreakpointArray[n2];
                    int n3 = iCLineBreakpoint.getLineNumber();
                    IMarker iMarker = iCLineBreakpoint.getMarker();
                    IResource iResource2 = iMarker.getResource();
                    if (n == n3 && iResource.equals((Object)iResource2)) {
                        String string2 = iResource.getLocation().toOSString();
                        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(this, iBreakpointManager, iCLineBreakpoint, string2, iResource, n){
                            final /* synthetic */ BumbleBreakpointManager this$1;
                            private final /* synthetic */ IBreakpointManager val$bpManager;
                            private final /* synthetic */ ICLineBreakpoint val$debugPluginBreakpoint;
                            private final /* synthetic */ String val$sourceHandle;
                            private final /* synthetic */ IResource val$resource1;
                            private final /* synthetic */ int val$line1;
                            {
                                this.this$1 = bumbleBreakpointManager;
                                this.val$bpManager = iBreakpointManager;
                                this.val$debugPluginBreakpoint = iCLineBreakpoint;
                                this.val$sourceHandle = string;
                                this.val$resource1 = iResource;
                                this.val$line1 = n;
                            }

                            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                                this.val$bpManager.removeBreakpoint((IBreakpoint)this.val$debugPluginBreakpoint, true);
                                CDIDebugModel.createLineBreakpoint((String)this.val$sourceHandle, (IResource)this.val$resource1, (int)this.val$line1, (boolean)true, (int)0, (String)"", (boolean)true);
                            }
                        };
                        ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, null);
                    }
                }
                ++n2;
            }
        }
    }
}

