/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.internal.launch.ui;

import com.palmsource.eclipse.palmoscore.CorePlugin;
import com.palmsource.eclipse.palmoscore.Messages;
import com.palmsource.eclipse.palmoscore.internal.launch.LaunchMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LaunchTab
extends AbstractLaunchConfigurationTab {
    private static final char SPACE = ' ';
    private static final char BACKSLASH = '\\';
    private static final char ZERO = '0';
    private static final char EKS = 'x';
    private static final char MIN_ASCII = ' ';
    private static final char MAX_ASCII = '~';
    private static final String EMPTY = "";
    private static final int LESSTHAN = -1;
    private static final int EQUALTO = 0;
    private static final int GREATERTHAN = 1;
    private Label fLaunchCodeLabel;
    private Combo fLaunchCodeCombo;
    private Label fCustomLaunchCodeLabel;
    private Text fCustomLaunchCodeText;
    private Label fLaunchDataLabel;
    private Text fLaunchDataText;
    private Label dummy1;
    private Button fDisplayAsHex;
    private Label dummy2;
    private Label fWarning;
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            LaunchTab.this.updateLaunchConfigurationDialog();
        }
    };
    static ArrayList fgSysAppLaunchCmdList = new ArrayList(35);

    static {
        LaunchTab._add(-1, 0);
        LaunchTab._add(0, 1);
        LaunchTab._add(1, 2);
        LaunchTab._add(2, 1);
        LaunchTab._add(3, 2);
        LaunchTab._add(4, 2);
        LaunchTab._add(5, 2);
        LaunchTab._add(6, 2);
        LaunchTab._add(7, 2);
        LaunchTab._add(8, 2);
        LaunchTab._add(10, 2);
        LaunchTab._add(11, 2);
        LaunchTab._add(13, 1);
        LaunchTab._add(14, 1);
        LaunchTab._add(15, 2);
        LaunchTab._add(19, 2);
        LaunchTab._add(26, 2);
        LaunchTab._add(27, 2);
        LaunchTab._add(50, 1);
        LaunchTab._add(50, 2);
        LaunchTab._add(51, 2);
        LaunchTab._add(52, 1);
        LaunchTab._add(54, 1);
        LaunchTab._add(57, 2);
        LaunchTab._add(58, 2);
        LaunchTab._add(59, 2);
        LaunchTab._add(60, 2);
        LaunchTab._add(61, 2);
        LaunchTab._add(63, 2);
        LaunchTab._add(87, 2);
        LaunchTab._add(88, 2);
        LaunchTab._add(-2, 1);
        LaunchTab._add(-2, 2);
        Collections.sort(fgSysAppLaunchCmdList, new Comparator(){

            public int compare(Object object, Object object2) {
                LaunchMethod launchMethod = (LaunchMethod)object;
                LaunchMethod launchMethod2 = (LaunchMethod)object2;
                if (launchMethod.isDoNothing()) {
                    if (launchMethod2.isDoNothing()) {
                        return 0;
                    }
                    return -1;
                }
                if (launchMethod2.isDoNothing()) {
                    return 1;
                }
                if (launchMethod.isCustom()) {
                    if (launchMethod2.isCustom()) {
                        return launchMethod.cmdHow == 1 ? -1 : 1;
                    }
                    return 1;
                }
                if (launchMethod2.isCustom()) {
                    return -1;
                }
                int n = launchMethod.wellKnownName().compareTo(launchMethod2.wellKnownName());
                if (n != 0) {
                    return n;
                }
                return launchMethod.cmdHow == 1 ? -1 : 1;
            }

            public boolean equals(Object object) {
                return false;
            }
        });
    }

    static void _add(int n, int n2) {
        fgSysAppLaunchCmdList.add(new LaunchMethod(n, n2));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = null;
        this.fLaunchCodeLabel = new Label(composite2, 0);
        this.fLaunchCodeLabel.setText(this.getString("LaunchTab.Launch_code"));
        this.fLaunchCodeCombo = new Combo(composite2, 8);
        ListIterator listIterator = fgSysAppLaunchCmdList.listIterator();
        while (listIterator.hasNext()) {
            LaunchMethod launchMethod = (LaunchMethod)listIterator.next();
            this.fLaunchCodeCombo.add(launchMethod.toMenuString());
            if (launchMethod.cmdValue != 0) continue;
            this.fLaunchCodeCombo.select(this.fLaunchCodeCombo.getItemCount() - 1);
        }
        this.fLaunchCodeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                int n = LaunchTab.this.fLaunchCodeCombo.getSelectionIndex();
                LaunchMethod launchMethod = (LaunchMethod)fgSysAppLaunchCmdList.get(n);
                LaunchTab.this.updateCustomLaunchCode(launchMethod.isCustom());
                LaunchTab.this.updateLaunchConfigurationDialog();
            }
        });
        gridData = new GridData(768);
        this.fLaunchCodeCombo.setLayoutData((Object)gridData);
        this.fCustomLaunchCodeLabel = new Label(composite2, 0);
        this.fCustomLaunchCodeLabel.setText(this.getString("LaunchTab.Custom_code"));
        this.fCustomLaunchCodeText = new Text(composite2, 2052);
        gridData = new GridData(768);
        this.fCustomLaunchCodeText.setLayoutData((Object)gridData);
        this.fCustomLaunchCodeText.addModifyListener(this.fBasicModifyListener);
        this.fLaunchDataLabel = new Label(composite2, 0);
        this.fLaunchDataLabel.setText(this.getString("LaunchTab.Launch_data"));
        this.fLaunchDataText = new Text(composite2, 2052);
        gridData = new GridData(768);
        this.fLaunchDataText.setLayoutData((Object)gridData);
        this.fLaunchDataText.addModifyListener(this.fBasicModifyListener);
        this.dummy1 = new Label(composite2, 0);
        this.fDisplayAsHex = new Button(composite2, 32);
        this.fDisplayAsHex.setText(this.getString("LaunchTab.Display_as_hex"));
        this.fDisplayAsHex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LaunchTab.this.updateLaunchDataText();
                LaunchTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.dummy2 = new Label(composite2, 0);
        this.fWarning = new Label(composite2, 64);
        this.fWarning.setText(this.getString("LaunchTab.Warning"));
        gridData = new GridData(770);
        gridData.widthHint = 200;
        this.fWarning.setLayoutData((Object)gridData);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        LaunchMethod launchMethod;
        ListIterator listIterator;
        String string;
        LaunchMethod launchMethod2 = null;
        try {
            string = iLaunchConfiguration.getAttribute("com.palmsource.launch.launch_code", EMPTY);
            launchMethod2 = new LaunchMethod(string);
        }
        catch (CoreException coreException) {
            try {
                int n = iLaunchConfiguration.getAttribute("com.palmsource.launch.launch_code", 0);
                listIterator = fgSysAppLaunchCmdList.listIterator();
                while (listIterator.hasNext()) {
                    launchMethod = (LaunchMethod)listIterator.next();
                    if (launchMethod.cmdValue != n) continue;
                    launchMethod2 = launchMethod;
                    break;
                }
                if (launchMethod2 == null) {
                    launchMethod2 = new LaunchMethod(n, 2);
                }
            }
            catch (CoreException coreException2) {}
        }
        if (launchMethod2 != null) {
            int n = 0;
            listIterator = fgSysAppLaunchCmdList.listIterator();
            while (listIterator.hasNext()) {
                launchMethod = (LaunchMethod)listIterator.next();
                if (launchMethod2.equals(launchMethod)) {
                    this.fLaunchCodeCombo.select(n);
                    this.updateCustomLaunchCode(false);
                    break;
                }
                ++n;
            }
            if (n >= fgSysAppLaunchCmdList.size()) {
                n = 0;
                listIterator = fgSysAppLaunchCmdList.listIterator();
                while (listIterator.hasNext()) {
                    launchMethod = (LaunchMethod)listIterator.next();
                    if (launchMethod.isCustom() && launchMethod.cmdHow == launchMethod2.cmdHow) {
                        this.fLaunchCodeCombo.select(n);
                        break;
                    }
                    ++n;
                }
                this.fCustomLaunchCodeText.setText(String.valueOf(launchMethod2.cmdValue));
                this.updateCustomLaunchCode(true);
            }
        }
        try {
            string = iLaunchConfiguration.getAttribute("com.palmsource.launch.launch_data", EMPTY);
            this.setLaunchDataInBox(string);
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        int n = this.fLaunchCodeCombo.getSelectionIndex();
        if (n >= 0 && n < fgSysAppLaunchCmdList.size()) {
            LaunchMethod launchMethod = (LaunchMethod)fgSysAppLaunchCmdList.get(n);
            if (launchMethod.isCustom()) {
                int n2 = 0;
                String string = this.fCustomLaunchCodeText.getText();
                try {
                    n2 = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {}
                launchMethod = new LaunchMethod(n2, launchMethod.cmdHow);
            }
            String string = launchMethod.toArchiveString();
            iLaunchConfigurationWorkingCopy.setAttribute("com.palmsource.launch.launch_code", string);
        }
        iLaunchConfigurationWorkingCopy.setAttribute("com.palmsource.launch.launch_data", this.getLaunchDataFromBox());
    }

    public boolean canSave() {
        return this.isValid(null);
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        boolean bl;
        int n;
        String string;
        this.setErrorMessage(null);
        int n2 = this.fLaunchCodeCombo.getSelectionIndex();
        if (n2 >= fgSysAppLaunchCmdList.size()) {
            string = this.fCustomLaunchCodeText.getText();
            try {
                n = Integer.valueOf(string);
                if (n < 32768 || n > 65535) {
                    this.setErrorMessage(this.getString("LaunchTab.Custom_launch_code_out_of_range"));
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(this.getString("LaunchTab.Custom_launch_code_invalid"));
                return false;
            }
        }
        string = this.fLaunchDataText.getText();
        n = this.fDisplayAsHex.getSelection();
        boolean bl2 = n != 0 ? this.convertFromHex(string) != null : (bl = this.convertToHex(string) != null);
        if (!bl) {
            this.setErrorMessage(this.getString("LaunchTab.Custom_launch_data_invalid"));
            return false;
        }
        return super.isValid(iLaunchConfiguration);
    }

    public String getName() {
        return this.getString("LaunchTab.TabTitle");
    }

    public Image getImage() {
        return CorePlugin.getImage(5);
    }

    private String getString(String string) {
        return Messages.getString(string);
    }

    private void updateCustomLaunchCode(boolean bl) {
        this.fCustomLaunchCodeLabel.setEnabled(bl);
        this.fCustomLaunchCodeText.setEnabled(bl);
    }

    private void updateLaunchDataText() {
        String string = this.getLaunchDataFromBox(!this.fDisplayAsHex.getSelection());
        this.setLaunchDataInBox(string, this.fDisplayAsHex.getSelection());
    }

    private String getLaunchDataFromBox() {
        return this.getLaunchDataFromBox(this.fDisplayAsHex.getSelection());
    }

    private String getLaunchDataFromBox(boolean bl) {
        String string = this.fLaunchDataText.getText();
        if (bl) {
            string = this.convertFromHex(string);
        }
        return string;
    }

    private void setLaunchDataInBox(String string) {
        this.setLaunchDataInBox(string, this.fDisplayAsHex.getSelection());
    }

    private void setLaunchDataInBox(String string, boolean bl) {
        if (bl) {
            string = this.convertToHex(string);
        }
        this.fLaunchDataText.setText(string);
    }

    private String convertToHex(String string) {
        String string2 = EMPTY;
        int n = 0;
        char c = '0';
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            switch (n) {
                case 0: {
                    if (c2 != '\\') {
                        string2 = String.valueOf(string2) + CorePlugin.formatHexByte(c2);
                        break;
                    }
                    n = 1;
                    break;
                }
                case 1: {
                    if (c2 != 'x') {
                        return null;
                    }
                    n = 2;
                    break;
                }
                case 2: {
                    c = c2;
                    n = 3;
                    break;
                }
                case 3: {
                    string2 = this.appendNybblesAsHex(string2, c, c2);
                    if (string2 == null) {
                        return null;
                    }
                    n = 0;
                }
            }
            ++n2;
        }
        if (n == 3 && (string2 = this.appendNybblesAsHex(string2, '0', c)) == null) {
            return null;
        }
        return string2;
    }

    private String appendNybblesAsHex(String string, char c, char c2) {
        String string2 = new String(new char[]{c, c2});
        try {
            char cfr_ignored_0 = (char)Integer.parseInt(string2, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return String.valueOf(string) + string2;
    }

    private String convertFromHex(String string) {
        String string2 = EMPTY;
        boolean bl = false;
        char c = '0';
        int n = 0;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            if (!bl) {
                if (c2 != ' ') {
                    c = c2;
                    bl = true;
                }
            } else {
                string2 = c2 == ' ' ? this.appendNybblesAsASCII(string2, '0', c) : this.appendNybblesAsASCII(string2, c, c2);
                if (string2 == null) {
                    return null;
                }
                bl = false;
            }
            ++n;
        }
        if (bl && (string2 = this.appendNybblesAsASCII(string2, '0', c)) == null) {
            return null;
        }
        return string2;
    }

    private String appendNybblesAsASCII(String string, char c, char c2) {
        char c3;
        String string2 = new String(new char[]{c, c2});
        try {
            c3 = (char)Integer.parseInt(string2, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (c3 >= ' ' && c3 <= '~') {
            return String.valueOf(string) + c3;
        }
        return String.valueOf(string) + '\\' + 'x' + string2;
    }
}

