/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.internal.launch.ui;

import com.palmsource.eclipse.palmoscore.CorePlugin;
import com.palmsource.eclipse.palmoscore.Messages;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectTab
extends AbstractLaunchConfigurationTab {
    private Button fDefaultRadio;
    private Button fCustomRadio;
    private Label fLaunchableLabel;
    private Combo fLaunchableCombo;
    private Label fInstallableLabel;
    private CheckboxTableViewer fInstallables;
    private static final boolean SUPPORT_DEFAULT_INSTALL = false;
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            ProjectTab.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = null;
        this.fLaunchableLabel = new Label(composite2, 0);
        this.fLaunchableLabel.setText(this.getString("ProjectTab.Launchable"));
        this.fLaunchableCombo = new Combo(composite2, 8);
        this.fLaunchableCombo.addModifyListener(this.fBasicModifyListener);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fLaunchableCombo.setLayoutData((Object)gridData);
        this.fInstallableLabel = new Label(composite2, 0);
        this.fInstallableLabel.setText(this.getString("ProjectTab.Files_to_install"));
        this.fInstallables = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2048);
        this.fInstallables.setContentProvider((IContentProvider)new PalmProjectContentProvider());
        this.fInstallables.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.fInstallables.setInput((Object)ResourcesPlugin.getWorkspace());
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.fInstallables.getTable().setLayoutData((Object)gridData);
        this.fInstallables.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                TableItem tableItem = ProjectTab.this.getTableItemFor((IResource)checkStateChangedEvent.getElement());
                ProjectTab.this.updateCheckState(tableItem, tableItem.getChecked());
                ProjectTab.this.updateLaunchConfigurationDialog();
                ProjectTab.this.updateLaunchableCombo();
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        ICElement iCElement = CorePlugin.getContext();
        if (iCElement == null) {
            return;
        }
        ICProject iCProject = iCElement.getCProject();
        if (iCProject == null) {
            return;
        }
        IProject iProject = iCProject.getProject();
        if (iProject == null) {
            return;
        }
        CorePlugin.flattenResources(iLaunchConfigurationWorkingCopy, "com.palmsource.launch.launchable", (IResource[])new IProject[]{iProject});
        CorePlugin.flattenResources(iLaunchConfigurationWorkingCopy, "com.palmsource.launch.installables", (IResource[])new IProject[]{iProject});
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", iProject.getName());
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        block9: {
            IProject[] iProjectArray;
            IResource[] iResourceArray;
            try {
                iResourceArray = CorePlugin.resurrectResources(iLaunchConfiguration, "com.palmsource.launch.installables");
                this.fInstallables.setAllChecked(false);
                int n = 0;
                while (n < iResourceArray.length) {
                    iProjectArray = iResourceArray[n];
                    TableItem tableItem = this.getTableItemFor((IResource)iProjectArray);
                    if (tableItem == null) {
                        System.err.println("ProjectTab.initializeFrom: unable to find table item for file " + iProjectArray.getFullPath().toString());
                    } else {
                        this.updateCheckState(tableItem, true);
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {}
            try {
                this.updateLaunchableCombo();
                this.fLaunchableCombo.select(0);
                iResourceArray = CorePlugin.resurrectResources(iLaunchConfiguration, "com.palmsource.launch.launchable");
                if (iResourceArray.length <= 0) break block9;
                IResource iResource = iResourceArray[0];
                iProjectArray = this.getInstallables();
                int n = 0;
                while (n < iProjectArray.length) {
                    if (iResource.equals((Object)iProjectArray[n])) {
                        this.fLaunchableCombo.select(n);
                        break;
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("com.palmsource.launch.custom_launch", true);
        IProject iProject = null;
        IProject[] iProjectArray = this.getInstallables();
        int n = this.fLaunchableCombo.getSelectionIndex();
        if (n >= 0 && n < iProjectArray.length) {
            iProject = iProjectArray[n];
        }
        if (iProject != null) {
            CorePlugin.flattenResources(iLaunchConfigurationWorkingCopy, "com.palmsource.launch.launchable", new IResource[]{iProject});
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", iProject.getName());
        }
        CorePlugin.flattenResources(iLaunchConfigurationWorkingCopy, "com.palmsource.launch.installables", (IResource[])iProjectArray);
    }

    public boolean canSave() {
        return this.isValid(null);
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        this.setErrorMessage(null);
        IProject[] iProjectArray = this.getInstallables();
        if (iProjectArray.length == 0) {
            this.setErrorMessage(this.getString("ProjectTab.No_installable_items_selected"));
            return false;
        }
        return super.isValid(iLaunchConfiguration);
    }

    public String getName() {
        return this.getString("ProjectTab.TabTitle");
    }

    public Image getImage() {
        return CorePlugin.getImage(5);
    }

    private String getString(String string) {
        return Messages.getString(string);
    }

    private TableItem getTableItemFor(IResource iResource) {
        TableItem[] tableItemArray = this.fInstallables.getTable().getItems();
        return this.getTableItemFor(iResource, tableItemArray);
    }

    private TableItem getTableItemFor(IResource iResource, TableItem[] tableItemArray) {
        int n = 0;
        while (n < tableItemArray.length) {
            Object object = tableItemArray[n].getData();
            if (iResource.equals(object)) {
                return tableItemArray[n];
            }
            ++n;
        }
        return null;
    }

    private void updateCheckState(TableItem tableItem, boolean bl) {
        this.setGrayed(tableItem, false);
        this.setChecked(tableItem, bl);
    }

    private void setGrayed(TableItem tableItem, boolean bl) {
        if (tableItem.getGrayed() != bl) {
            tableItem.setGrayed(bl);
        }
    }

    private void setChecked(TableItem tableItem, boolean bl) {
        if (tableItem.getChecked() != bl) {
            tableItem.setChecked(bl);
        }
    }

    private void updateLaunchableCombo() {
        String string = null;
        int n = this.fLaunchableCombo.getSelectionIndex();
        if (n >= 0) {
            string = this.fLaunchableCombo.getItem(n);
        }
        IProject[] iProjectArray = this.getInstallables();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < iProjectArray.length) {
            if (iProjectArray[n2] instanceof IResource) {
                IProject iProject = iProjectArray[n2];
                arrayList.add(iProject.getName());
            }
            ++n2;
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        this.fLaunchableCombo.setItems(stringArray);
        this.fLaunchableCombo.setEnabled(arrayList.size() != 0);
        int n3 = -1;
        if (string != null) {
            n3 = this.fLaunchableCombo.indexOf(string);
        }
        if (n3 >= 0) {
            this.fLaunchableCombo.select(n3);
        } else {
            this.fLaunchableCombo.select(0);
        }
    }

    private void setVisibleCustomElements(boolean bl) {
        this.fInstallableLabel.setVisible(bl);
        this.fInstallables.getTable().setVisible(bl);
        this.fLaunchableLabel.setVisible(bl);
        this.fLaunchableCombo.setVisible(bl);
    }

    private IProject[] getProjects() {
        IContentProvider iContentProvider = this.fInstallables.getContentProvider();
        IStructuredContentProvider iStructuredContentProvider = (IStructuredContentProvider)iContentProvider;
        Object[] objectArray = iStructuredContentProvider.getElements((Object)ResourcesPlugin.getWorkspace());
        IProject[] iProjectArray = new IProject[objectArray.length];
        System.arraycopy(objectArray, 0, iProjectArray, 0, objectArray.length);
        return iProjectArray;
    }

    protected IProject[] getInstallables() {
        Object[] objectArray = this.fInstallables.getCheckedElements();
        IProject[] iProjectArray = new IProject[objectArray.length];
        System.arraycopy(objectArray, 0, iProjectArray, 0, objectArray.length);
        return iProjectArray;
    }

    private class PalmProjectContentProvider
    extends WorkbenchContentProvider {
        PalmProjectContentProvider() {
        }

        public Object[] getChildren(Object object) {
            ArrayList<IProject> arrayList = new ArrayList<IProject>();
            if (object instanceof IWorkspace) {
                IWorkspace iWorkspace = (IWorkspace)object;
                IProject[] iProjectArray = iWorkspace.getRoot().getProjects();
                int n = 0;
                while (n < iProjectArray.length) {
                    IProject iProject = iProjectArray[n];
                    try {
                        if (iProject.hasNature("com.palmsource.eclipse.palmoscore.palmOSNature")) {
                            arrayList.add(iProject);
                        }
                    }
                    catch (Exception exception) {}
                    ++n;
                }
            }
            return arrayList.toArray(new Object[arrayList.size()]);
        }

        public Object getParent(Object object) {
            if (object instanceof IProject) {
                IProject iProject = (IProject)object;
                return iProject.getWorkspace();
            }
            return null;
        }
    }
}

