/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.internal.launch.ui;

import com.palmsource.eclipse.palmoscore.CorePlugin;
import com.palmsource.eclipse.palmoscore.Messages;
import com.palmsource.eclipse.palmoscore.projects.IPalmOSProject;
import com.palmsource.eclipse.palmoscore.projects.IPalmOSTarget;
import com.palmsource.eclipse.palmoscore.targets.ITargetEnvironment;
import com.palmsource.eclipse.palmoscore.targets.TargetEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TargetTab
extends AbstractLaunchConfigurationTab {
    public static final String TARGET_PLATFORM_DEVICE = "Device";
    public static final String TARGET_PLATFORM_SIMULATOR = "Simulator";
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            TargetTab.this.updateLaunchConfigurationDialog();
        }
    };
    private Group fGroup;
    private Map fMenus = new HashMap();

    private void addUIFor(ILaunchConfiguration iLaunchConfiguration, Composite composite, IPalmOSTarget iPalmOSTarget) {
        Label label = new Label(composite, 0);
        label.setText(this.getProjectTargetName(iPalmOSTarget));
        Combo combo = new Combo(composite, 8);
        combo.addModifyListener(this.fBasicModifyListener);
        this.setMenuItems(iLaunchConfiguration, iPalmOSTarget, combo);
        GridData gridData = new GridData(768);
        combo.setLayoutData((Object)gridData);
        this.fMenus.put(this.getProjectTargetID(iPalmOSTarget), combo);
        label = new Label(composite, 0);
        label = new Label(composite, 64);
        label.setText(this.getProjectTargetHelpText(iPalmOSTarget));
        gridData = new GridData(770);
        gridData.widthHint = 500;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
    }

    public boolean canSave() {
        return this.isValid(null);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout(1, false);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = null;
        Label label = new Label(composite2, 0);
        label.setText(this.getString("TargetTab.Instructions"));
        this.fGroup = new Group(composite2, 0);
        gridData = new GridData(1808);
        this.fGroup.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(2, false);
        this.fGroup.setLayout((Layout)gridLayout);
    }

    private IProject getCurrentProject(ILaunchConfiguration iLaunchConfiguration) {
        ICElement iCElement = CorePlugin.getContext();
        if (iCElement == null) {
            return null;
        }
        ICProject iCProject = iCElement.getCProject();
        if (iCProject == null) {
            return null;
        }
        IProject iProject = iCProject.getProject();
        return iProject;
    }

    public Image getImage() {
        return CorePlugin.getImage(5);
    }

    private IProject getLaunchProject(ILaunchConfiguration iLaunchConfiguration) {
        IProject iProject = null;
        try {
            if (this.isCustomLaunch(iLaunchConfiguration)) {
                IResource[] iResourceArray = CorePlugin.resurrectResources(iLaunchConfiguration, "com.palmsource.launch.launchable");
                if (iResourceArray.length > 0) {
                    iProject = (IProject)iResourceArray[0];
                }
            } else {
                iProject = this.getCurrentProject(iLaunchConfiguration);
            }
        }
        catch (CoreException coreException) {}
        return iProject;
    }

    private Combo getMenuFor(IPalmOSTarget iPalmOSTarget) {
        String string = this.getProjectTargetID(iPalmOSTarget);
        Combo combo = (Combo)this.fMenus.get(string);
        return combo;
    }

    private Combo[] getMenus() {
        Collection collection = this.fMenus.values();
        return collection.toArray(new Combo[collection.size()]);
    }

    public String getName() {
        return this.getString("TargetTab.TabTitle");
    }

    private String getProjectTargetHelpText(IPalmOSTarget iPalmOSTarget) {
        if (iPalmOSTarget.isDeviceTarget()) {
            return this.getString("TargetTab.Native_Help");
        }
        if (iPalmOSTarget.isSimulatorTarget()) {
            return this.getString("TargetTab.Simulator_Help");
        }
        return this.getString("TargetTab.Unknown");
    }

    private String getProjectTargetID(IPalmOSTarget iPalmOSTarget) {
        if (iPalmOSTarget.isDeviceTarget()) {
            return TARGET_PLATFORM_DEVICE;
        }
        if (iPalmOSTarget.isSimulatorTarget()) {
            return TARGET_PLATFORM_SIMULATOR;
        }
        return this.getString("TargetTab.Unknown");
    }

    private String getProjectTargetName(IPalmOSTarget iPalmOSTarget) {
        if (iPalmOSTarget.isDeviceTarget()) {
            return this.getString("TargetTab.Native");
        }
        if (iPalmOSTarget.isSimulatorTarget()) {
            return this.getString("TargetTab.Simulator");
        }
        return this.getString("TargetTab.Unknown");
    }

    private IPalmOSTarget[] getProjectTargets(ILaunchConfiguration iLaunchConfiguration) {
        IProject iProject = this.getLaunchProject(iLaunchConfiguration);
        return this.getProjectTargets(iProject);
    }

    private IPalmOSTarget[] getProjectTargets(IProject iProject) {
        IPalmOSProject iPalmOSProject = CorePlugin.getPalmOSProject(iProject);
        IPalmOSTarget[] iPalmOSTargetArray = new IPalmOSTarget[]{};
        if (iPalmOSProject != null) {
            iPalmOSTargetArray = iPalmOSProject.getTargets();
        }
        return iPalmOSTargetArray;
    }

    private String getString(String string) {
        return Messages.getString(string);
    }

    private String getTargetEnvironmentID(ITargetEnvironment iTargetEnvironment) {
        return iTargetEnvironment.getID();
    }

    private String getTargetEnvironmentName(ITargetEnvironment iTargetEnvironment) {
        return iTargetEnvironment.getName();
    }

    private ITargetEnvironment[] getTargetEnvironmentsFor(ILaunchConfiguration iLaunchConfiguration, IPalmOSTarget iPalmOSTarget) {
        IProject iProject = this.getLaunchProject(iLaunchConfiguration);
        IPalmOSProject iPalmOSProject = CorePlugin.getPalmOSProject(iProject);
        String string = iPalmOSProject.getTargetOSAPI();
        boolean bl = "Protein".equals(string);
        ITargetEnvironment[] iTargetEnvironmentArray = TargetEnvironment.getTargetEnvironments();
        ArrayList<ITargetEnvironment> arrayList = new ArrayList<ITargetEnvironment>(iTargetEnvironmentArray.length);
        int n = 0;
        while (n < iTargetEnvironmentArray.length) {
            ITargetEnvironment iTargetEnvironment = iTargetEnvironmentArray[n];
            String string2 = iTargetEnvironment.getType();
            boolean bl2 = string2.equals("emulator");
            boolean bl3 = string2.equals("simulator");
            if (bl) {
                Path path;
                if (iPalmOSTarget.isDeviceTarget()) {
                    if (!bl2 && !bl3) {
                        arrayList.add(iTargetEnvironment);
                    }
                } else if (iPalmOSTarget.isSimulatorTarget() && bl3 && this.isPalmSimCobalt((IPath)(path = new Path(iTargetEnvironment.getHostPath())))) {
                    arrayList.add(iTargetEnvironment);
                }
            } else if (iPalmOSTarget.isDeviceTarget()) {
                arrayList.add(iTargetEnvironment);
            } else if (iPalmOSTarget.isSimulatorTarget() && bl3) {
                arrayList.add(iTargetEnvironment);
            }
            ++n;
        }
        return arrayList.toArray(new ITargetEnvironment[0]);
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.resetWidgets(iLaunchConfiguration);
        try {
            Map map = iLaunchConfiguration.getAttribute("com.palmsource.launch.target_configurations", new HashMap());
            IPalmOSTarget[] iPalmOSTargetArray = this.getProjectTargets(iLaunchConfiguration);
            int n = 0;
            while (n < iPalmOSTargetArray.length) {
                IPalmOSTarget iPalmOSTarget = iPalmOSTargetArray[n];
                String string = this.getProjectTargetID(iPalmOSTarget);
                ITargetEnvironment[] iTargetEnvironmentArray = this.getTargetEnvironmentsFor(iLaunchConfiguration, iPalmOSTarget);
                String string2 = (String)map.get(string);
                Combo combo = this.getMenuFor(iPalmOSTarget);
                if (combo != null) {
                    combo.select(0);
                    if (string2 != null) {
                        int n2 = 0;
                        while (n2 < iTargetEnvironmentArray.length) {
                            ITargetEnvironment iTargetEnvironment = iTargetEnvironmentArray[n2];
                            String string3 = this.getTargetEnvironmentID(iTargetEnvironment);
                            if (string3.equals(string2)) {
                                combo.select(n2);
                                break;
                            }
                            ++n2;
                        }
                    }
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
    }

    private boolean isCustomLaunch(ILaunchConfiguration iLaunchConfiguration) {
        try {
            boolean bl = iLaunchConfiguration.getAttribute("com.palmsource.launch.custom_launch", false);
            return bl;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean isPalmSimCirce(IPath iPath) {
        IPath iPath2 = iPath.removeLastSegments(1);
        IPath iPath3 = iPath2.append("libcirce.dll");
        return this.pathExists(iPath3);
    }

    private boolean isPalmSimCobalt(IPath iPath) {
        IPath iPath2 = iPath.removeLastSegments(1);
        IPath iPath3 = iPath2.append("libbinder.dll");
        return this.pathExists(iPath3);
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        this.setErrorMessage(null);
        Combo[] comboArray = this.getMenus();
        if (comboArray.length == 0) {
            this.setErrorMessage(this.getString("TargetTab.No_valid_project_configurations"));
            return false;
        }
        int n = 0;
        while (n < comboArray.length) {
            if (comboArray[n].getSelectionIndex() < 0) {
                if (comboArray[n].getItemCount() > 0) {
                    this.setErrorMessage(this.getString("TargetTab.No_selected_environment1"));
                } else {
                    this.setErrorMessage(this.getString("TargetTab.No_selected_environment2"));
                }
                return false;
            }
            ++n;
        }
        return super.isValid(iLaunchConfiguration);
    }

    private boolean pathExists(IPath iPath) {
        return iPath != null && iPath.toFile().exists();
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IPalmOSTarget[] iPalmOSTargetArray = this.getProjectTargets((ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
        int n = 0;
        while (n < iPalmOSTargetArray.length) {
            int n2;
            IPalmOSTarget iPalmOSTarget = iPalmOSTargetArray[n];
            String string = this.getProjectTargetID(iPalmOSTarget);
            ITargetEnvironment[] iTargetEnvironmentArray = this.getTargetEnvironmentsFor((ILaunchConfiguration)iLaunchConfigurationWorkingCopy, iPalmOSTarget);
            Combo combo = this.getMenuFor(iPalmOSTarget);
            if (combo != null && (n2 = combo.getSelectionIndex()) >= 0 && n2 < iTargetEnvironmentArray.length) {
                ITargetEnvironment iTargetEnvironment = iTargetEnvironmentArray[n2];
                String string2 = this.getTargetEnvironmentID(iTargetEnvironment);
                hashMap.put(string, string2);
            }
            ++n;
        }
        iLaunchConfigurationWorkingCopy.setAttribute("com.palmsource.launch.target_configurations", hashMap);
    }

    private void resetWidgets(ILaunchConfiguration iLaunchConfiguration) {
        this.fMenus.clear();
        Control[] controlArray = this.fGroup.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].dispose();
            ++n;
        }
        IPalmOSTarget[] iPalmOSTargetArray = this.getProjectTargets(iLaunchConfiguration);
        int n2 = 0;
        while (n2 < iPalmOSTargetArray.length) {
            this.addUIFor(iLaunchConfiguration, (Composite)this.fGroup, iPalmOSTargetArray[n2]);
            ++n2;
        }
        this.fGroup.layout();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    private void setMenuItems(ILaunchConfiguration iLaunchConfiguration, IPalmOSTarget iPalmOSTarget, Combo combo) {
        ITargetEnvironment[] iTargetEnvironmentArray = this.getTargetEnvironmentsFor(iLaunchConfiguration, iPalmOSTarget);
        int n = 0;
        while (n < iTargetEnvironmentArray.length) {
            combo.add(this.getTargetEnvironmentName(iTargetEnvironmentArray[n]));
            ++n;
        }
    }
}

