/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.internal.managedmake;

import com.palmsource.eclipse.palmoscore.CorePlugin;
import com.palmsource.eclipse.palmoscore.Messages;
import com.palmsource.eclipse.palmoscore.managedmake.IPalmOSManagedTool;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;

public class PalmOSManagedMakefileGenerator
extends GnuMakefileGenerator {
    public static final String PROJECT_ROOT = "$(ROOT)";
    private static final String MSG_HEADER = "Makefile.header.line";
    private static final String TOOL_CONTRIBUTION_POINT = "toolDefinitions";
    private static final String TOOL_CONTRIBUTION_CLASS = "class";
    private static final String TOOL_CONTRIBUTION_ID = "ID";
    private static final String TOOL_CONTRIBUTION_TOOL_ID = "managedBuildInfoToolID";
    private static final String DEPENDENCY_CONTRIBUTION_POINT = "toolDependencyDefinitions";
    private static final String DEPENDENCY_CONTRIBUTION_CONFIGS = "configurationIDs";
    private static final String DEPENDENCY_CONTRIBUTION_TOOL = "toolID";
    private static final String DEPENDENCY_CONTRIBUTION_DEPS = "dependencies";
    private static final String DEPENDENCY_CONTRIBUTION_INPUTS = "inputs";
    private ArrayList myBuildTools = new ArrayList();
    private Map myDepInfo = new HashMap();
    private IProject myProject;
    private IProgressMonitor myMonitor;
    private IManagedBuildInfo myInfo;
    private Vector mySubDirList = new Vector();
    private Vector myInvalidDirList = new Vector();

    public void initialize(IProject iProject, IManagedBuildInfo iManagedBuildInfo, IProgressMonitor iProgressMonitor) {
        super.initialize(iProject, iManagedBuildInfo, iProgressMonitor);
        this.myProject = iProject;
        this.myMonitor = iProgressMonitor;
        this.myInfo = iManagedBuildInfo;
        this.readToolDependencies();
        this.readTools();
        this.completeToolInitialization();
    }

    public MultiStatus generateMakefiles(IResourceDelta iResourceDelta) throws CoreException {
        MyResourceProxyVisitor myResourceProxyVisitor = new MyResourceProxyVisitor(this, this.myInfo);
        this.myProject.accept((IResourceProxyVisitor)myResourceProxyVisitor, 0);
        return super.generateMakefiles(iResourceDelta);
    }

    public MultiStatus regenerateMakefiles() throws CoreException {
        MyResourceProxyVisitor myResourceProxyVisitor = new MyResourceProxyVisitor(this, this.myInfo);
        this.myProject.accept((IResourceProxyVisitor)myResourceProxyVisitor, 0);
        return super.regenerateMakefiles();
    }

    protected StringBuffer addDefaultHeader() {
        return this.palmOSHeader();
    }

    protected StringBuffer addFragmentDependenciesHeader() {
        return this.palmOSHeader();
    }

    protected StringBuffer addFragmentMakefileHeader() {
        return this.palmOSHeader();
    }

    protected StringBuffer addTopHeader() {
        return this.palmOSHeader();
    }

    private StringBuffer palmOSHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        this.outputCommentLine(stringBuffer);
        stringBuffer.append("# " + Messages.getString(MSG_HEADER) + IManagedBuilderMakefileGenerator.NEWLINE);
        this.outputCommentLine(stringBuffer);
        stringBuffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + IManagedBuilderMakefileGenerator.NEWLINE);
        return stringBuffer;
    }

    protected void populateSourcesMakefile(IFile iFile) throws CoreException {
        StringBuffer stringBuffer = this.addDefaultHeader();
        Iterator iterator = this.myBuildTools.iterator();
        while (iterator.hasNext()) {
            IPalmOSManagedTool iPalmOSManagedTool = ((ToolInfo)iterator.next()).toolClass;
            String string = iPalmOSManagedTool.sourcesMakefileContribution();
            if (string == null || string.length() <= 0) continue;
            stringBuffer.append(String.valueOf(string) + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        stringBuffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + this.addSubdirectories());
        PalmOSManagedMakefileGenerator.save(stringBuffer, iFile);
    }

    protected void populateFragmentMakefile(IContainer iContainer) throws CoreException {
        IPath iPath = iContainer.getProjectRelativePath();
        IPath iPath2 = this.getBuildWorkingDir();
        if (iPath2 == null) {
            return;
        }
        IPath iPath3 = iPath2.append(iPath);
        IPath iPath4 = this.createDirectory(iPath3.toString());
        IFile iFile = this.createFile(iPath4.addTrailingSeparator().append("subdir.mk"));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addFragmentMakefileHeader());
        Iterator iterator = this.myBuildTools.iterator();
        while (iterator.hasNext()) {
            IPalmOSManagedTool iPalmOSManagedTool = ((ToolInfo)iterator.next()).toolClass;
            String string = iPalmOSManagedTool.fragmentMakefileContribution(iContainer);
            if (string == null || string.length() <= 0) continue;
            stringBuffer.append(String.valueOf(string) + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        PalmOSManagedMakefileGenerator.save(stringBuffer, iFile);
    }

    protected void populateObjectsMakefile(IFile iFile) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addDefaultHeader());
        Iterator iterator = this.myBuildTools.iterator();
        while (iterator.hasNext()) {
            IPalmOSManagedTool iPalmOSManagedTool = ((ToolInfo)iterator.next()).toolClass;
            String string = iPalmOSManagedTool.objectsMakefileContribution();
            if (string == null || string.length() <= 0) continue;
            stringBuffer.append(String.valueOf(string) + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        PalmOSManagedMakefileGenerator.save(stringBuffer, iFile);
    }

    protected void populateTopMakefile(IFile iFile, boolean bl) throws CoreException {
        String string;
        Object object;
        String string2;
        Object object2;
        String[] stringArray;
        Object object3;
        Object object4;
        StringBuffer stringBuffer = this.addTopHeader();
        stringBuffer.append("ROOT := .." + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("-include $(ROOT)/makefile.init" + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("RM := ");
        stringBuffer.append(String.valueOf(this.myInfo.getCleanCommand()) + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("-include $(ROOT)/auto-generated.mk" + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("-include sources.mk" + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("-include $(SUBDIRS:%=%/subdir.mk)" + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("-include objects.mk" + IManagedBuilderMakefileGenerator.NEWLINE);
        Iterator iterator = this.myBuildTools.iterator();
        while (iterator.hasNext()) {
            object4 = ((ToolInfo)iterator.next()).toolClass;
            object3 = object4.getDependencyFiles();
            if (object3 == null || ((String[])object3).length <= 0) continue;
            int n = 0;
            while (n < ((String[])object3).length) {
                stringArray = CorePlugin.escapeString(object3[n]);
                if (stringArray != null && stringArray.length() > 0) {
                    stringBuffer.append("-include " + (String)stringArray + IManagedBuilderMakefileGenerator.NEWLINE);
                }
                ++n;
            }
        }
        stringBuffer.append("-include $(ROOT)/makefile.defs" + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        object4 = "all:";
        object3 = this.myInfo.getBuildArtifactExtension();
        if (object3 == null) {
            object3 = "";
        }
        String string3 = this.myInfo.getOutputPrefix((String)object3);
        stringArray = bl ? "clean all" : "all";
        stringBuffer.append(String.valueOf(object4) + " " + CorePlugin.escapeString(String.valueOf(string3) + this.myInfo.getBuildArtifactName()));
        if (((String)object3).length() > 0) {
            stringBuffer.append("." + (String)object3);
        }
        stringBuffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + IManagedBuilderMakefileGenerator.NEWLINE);
        IProject[] iProjectArray = null;
        try {
            iProjectArray = this.myProject.getReferencedProjects();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        ArrayList<String> arrayList = new ArrayList<String>(iProjectArray.length);
        if (iProjectArray.length > 0) {
            boolean bl2 = true;
            if (iProjectArray != null) {
                int n = 0;
                while (n < iProjectArray.length) {
                    object2 = iProjectArray[n];
                    if (object2.exists()) {
                        if (bl2) {
                            stringBuffer.append("dependents:" + IManagedBuilderMakefileGenerator.NEWLINE);
                            bl2 = false;
                        }
                        string2 = object2.getLocation().toString();
                        object = stringArray;
                        if (ManagedBuildManager.manages((IResource)object2)) {
                            IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)object2);
                            string2 = String.valueOf(string2) + "/" + iManagedBuildInfo.getConfigurationName();
                            string = iManagedBuildInfo.getBuildArtifactName();
                            String string4 = iManagedBuildInfo.getBuildArtifactExtension();
                            String string5 = iManagedBuildInfo.getOutputPrefix(string4);
                            if (iManagedBuildInfo.needsRebuild()) {
                                object = "clean all";
                            }
                            String string6 = String.valueOf(string2) + "/" + string5 + string;
                            if (string4.length() > 0) {
                                string6 = String.valueOf(string6) + "." + string4;
                            }
                            string6 = this.escapeWhitespaces(string6);
                            arrayList.add(string6);
                        }
                        stringBuffer.append("\t-cd " + this.escapeWhitespaces(string2) + " " + "&&" + " " + "$(MAKE) " + (String)object + IManagedBuilderMakefileGenerator.NEWLINE);
                    }
                    ++n;
                }
            }
            stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        }
        Iterator iterator2 = this.myBuildTools.iterator();
        while (iterator2.hasNext()) {
            IPalmOSManagedTool iPalmOSManagedTool = ((ToolInfo)iterator2.next()).toolClass;
            object2 = iPalmOSManagedTool.topMakefileContribution();
            if (object2 == null || ((String)object2).length() <= 0) continue;
            stringBuffer.append(String.valueOf(object2) + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        stringBuffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("clean:" + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("\t-$(RM) ");
        Iterator iterator3 = this.myBuildTools.iterator();
        while (iterator3.hasNext()) {
            object2 = ((ToolInfo)iterator3.next()).toolClass;
            string2 = object2.getOutputs();
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(String.valueOf(string2) + " ");
            }
            if ((object = object2.getDependencyFiles()) == null || ((String[])object).length <= 0) continue;
            int n = 0;
            while (n < ((String[])object).length) {
                string = CorePlugin.escapeString(object[n]);
                if (string != null && string.length() > 0) {
                    stringBuffer.append(String.valueOf(string) + " ");
                }
                ++n;
            }
        }
        stringBuffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append(".PHONY: all clean dependents" + IManagedBuilderMakefileGenerator.NEWLINE);
        object2 = arrayList.listIterator();
        object2 = arrayList.listIterator();
        while (object2.hasNext()) {
            stringBuffer.append(String.valueOf((String)object2.next()) + ":" + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        stringBuffer.append("-include $(ROOT)/makefile.targets" + IManagedBuilderMakefileGenerator.NEWLINE);
        PalmOSManagedMakefileGenerator.save(stringBuffer, iFile);
    }

    private void readToolDependencies() {
        String string = this.myInfo.getDefaultConfiguration(this.myInfo.getDefaultTarget()).getParent().getId();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("com.palmsource.eclipse.palmoscore", DEPENDENCY_CONTRIBUTION_POINT);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                String string2 = iConfigurationElement.getAttribute(DEPENDENCY_CONTRIBUTION_CONFIGS);
                String[] stringArray = string2.split(",");
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (string.equals(stringArray[n3])) {
                        DependencyInfo dependencyInfo = new DependencyInfo();
                        dependencyInfo.dependencies = iConfigurationElement.getAttribute(DEPENDENCY_CONTRIBUTION_DEPS);
                        dependencyInfo.inputs = iConfigurationElement.getAttribute(DEPENDENCY_CONTRIBUTION_INPUTS);
                        dependencyInfo.toolID = iConfigurationElement.getAttribute(DEPENDENCY_CONTRIBUTION_TOOL);
                        this.myDepInfo.put(dependencyInfo.toolID, dependencyInfo);
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void readTools() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("com.palmsource.eclipse.palmoscore", TOOL_CONTRIBUTION_POINT);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                String string = iConfigurationElement.getAttribute(TOOL_CONTRIBUTION_ID);
                if (this.myDepInfo.containsKey(string)) {
                    try {
                        ToolInfo toolInfo = new ToolInfo();
                        toolInfo.toolClass = (IPalmOSManagedTool)iConfigurationElement.createExecutableExtension(TOOL_CONTRIBUTION_CLASS);
                        toolInfo.managedBuildInfoToolID = iConfigurationElement.getAttribute(TOOL_CONTRIBUTION_TOOL_ID);
                        toolInfo.UID = iConfigurationElement.getAttribute(TOOL_CONTRIBUTION_ID);
                        this.myBuildTools.add(toolInfo);
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    private void completeToolInitialization() {
        Iterator iterator = this.myBuildTools.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            String[] stringArray;
            ToolInfo toolInfo = (ToolInfo)iterator.next();
            DependencyInfo dependencyInfo = (DependencyInfo)this.myDepInfo.get(toolInfo.UID);
            ArrayList<IPalmOSManagedTool> arrayList = new ArrayList<IPalmOSManagedTool>();
            if (dependencyInfo != null && dependencyInfo.dependencies != null) {
                stringArray = dependencyInfo.dependencies.split(",");
                int n = 0;
                while (n < stringArray.length) {
                    object3 = this.myBuildTools.iterator();
                    while (object3.hasNext()) {
                        object2 = (ToolInfo)object3.next();
                        if (((ToolInfo)object2).UID == null || !((ToolInfo)object2).UID.equals(stringArray[n])) continue;
                        arrayList.add(((ToolInfo)object2).toolClass);
                    }
                    ++n;
                }
            }
            stringArray = new ArrayList();
            if (dependencyInfo != null && dependencyInfo.inputs != null) {
                String[] stringArray2 = dependencyInfo.inputs.split(",");
                int n = 0;
                while (n < stringArray2.length) {
                    object2 = this.myBuildTools.iterator();
                    while (object2.hasNext()) {
                        object = (ToolInfo)object2.next();
                        if (((ToolInfo)object).UID == null || !((ToolInfo)object).UID.equals(stringArray2[n])) continue;
                        stringArray.add(((ToolInfo)object).toolClass);
                    }
                    ++n;
                }
            }
            Object object4 = null;
            object3 = this.myInfo.getDefaultConfiguration(this.myInfo.getDefaultTarget()).getTools();
            int n = 0;
            while (n < ((Object)object3).length) {
                object = object3[n];
                String string = object.getId();
                if (string != null && string.equals(toolInfo.managedBuildInfoToolID)) {
                    object4 = object;
                    break;
                }
                ++n;
            }
            toolInfo.toolClass.initialize(toolInfo.UID, this.myProject, (ITool)object4, this.myInfo, arrayList.toArray(new IPalmOSManagedTool[arrayList.toArray().length]), stringArray.toArray(new IPalmOSManagedTool[stringArray.toArray().length]));
        }
    }

    private StringBuffer addSubdirectories() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SUBDIRS := \\\n");
        ListIterator listIterator = this.mySubDirList.listIterator();
        while (listIterator.hasNext()) {
            IContainer iContainer = (IContainer)listIterator.next();
            if (iContainer.getFullPath() == this.myProject.getFullPath()) {
                stringBuffer.append(". \\\n");
                continue;
            }
            IPath iPath = iContainer.getProjectRelativePath();
            stringBuffer.append(String.valueOf(iPath.toString()) + " " + "\\\n");
        }
        stringBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        return stringBuffer;
    }

    private IPath createDirectory(String string) throws CoreException {
        IFolder iFolder = this.myProject.getFolder(string);
        if (!iFolder.exists()) {
            IFolder iFolder2;
            IPath iPath = new Path(string).removeLastSegments(1);
            if (!iPath.isEmpty() && !(iFolder2 = this.myProject.getFolder(iPath)).exists()) {
                this.createDirectory(iPath.toString());
            }
            try {
                iFolder.create(true, true, null);
            }
            catch (CoreException coreException) {
                if (coreException.getStatus().getCode() == 374) {
                    iFolder.refreshLocal(0, null);
                }
                throw coreException;
            }
            if (!iFolder.isDerived()) {
                iFolder.setDerived(true);
            }
        }
        return iFolder.getFullPath();
    }

    private IFile createFile(IPath iPath) throws CoreException {
        IWorkspaceRoot iWorkspaceRoot = CCorePlugin.getWorkspace().getRoot();
        IFile iFile = iWorkspaceRoot.getFileForLocation(iPath);
        if (iFile == null) {
            iFile = iWorkspaceRoot.getFile(iPath);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
        try {
            iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)new SubProgressMonitor(this.myMonitor, 1));
            if (!iFile.isDerived()) {
                iFile.setDerived(true);
            }
        }
        catch (CoreException coreException) {
            if (coreException.getStatus().getCode() == 374) {
                iFile.refreshLocal(0, null);
            }
            throw coreException;
        }
        return iFile;
    }

    private static void save(StringBuffer stringBuffer, IFile iFile) throws CoreException {
        byte[] byArray = stringBuffer.toString().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        iFile.setContents((InputStream)byteArrayInputStream, true, true, null);
    }

    private class DependencyInfo {
        public String dependencies;
        public String inputs;
        public String toolID;

        DependencyInfo() {
        }
    }

    private class ToolInfo {
        public IPalmOSManagedTool toolClass;
        public String managedBuildInfoToolID;
        public String UID;

        ToolInfo() {
        }
    }

    private class MyResourceProxyVisitor
    implements IResourceProxyVisitor {
        private PalmOSManagedMakefileGenerator generator;
        private IManagedBuildInfo info;

        public MyResourceProxyVisitor(PalmOSManagedMakefileGenerator palmOSManagedMakefileGenerator2, IManagedBuildInfo iManagedBuildInfo) {
            this.generator = palmOSManagedMakefileGenerator2;
            this.info = iManagedBuildInfo;
        }

        public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
            if (this.generator == null) {
                return false;
            }
            if (iResourceProxy.getType() == 1) {
                IResource iResource = iResourceProxy.requestResource();
                String string = iResource.getFileExtension();
                if (this.info.buildsFileType(string) && !this.generator.isGeneratedResource(iResource)) {
                    IContainer iContainer = iResource.getParent();
                    if (iResource.getProjectRelativePath().toString().indexOf(" ") != -1) {
                        if (!PalmOSManagedMakefileGenerator.this.myInvalidDirList.contains(iContainer)) {
                            PalmOSManagedMakefileGenerator.this.myInvalidDirList.add(iContainer);
                        }
                    } else if (!PalmOSManagedMakefileGenerator.this.mySubDirList.contains(iContainer)) {
                        PalmOSManagedMakefileGenerator.this.mySubDirList.add(iContainer);
                    }
                }
                return false;
            }
            return true;
        }
    }
}

