/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.internal.projects;

import com.palmsource.eclipse.palmoscore.CorePlugin;
import com.palmsource.eclipse.palmoscore.Messages;
import com.palmsource.eclipse.palmoscore.internal.projects.ProjectUpgrader;
import com.palmsource.eclipse.palmoscore.projects.IPalmOSProject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.core.model.IncludeEntry;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigNature;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathContainer;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Node;

public class PODS11ProjectUpgrader
extends ProjectUpgrader {
    private Vector managedMakeProjects = new Vector();
    private Vector standardMakeProjects = new Vector();

    public boolean loadProjectsToUpgrade(IProject[] iProjectArray) {
        boolean bl = false;
        int n = 0;
        while (n < iProjectArray.length) {
            int n2;
            IProject iProject = iProjectArray[n];
            IPalmOSProject iPalmOSProject = CorePlugin.getPalmOSProject(iProject);
            if (iPalmOSProject != null && (n2 = iPalmOSProject.getProjectVersion()) < 10100) {
                if (iPalmOSProject.isManagedProject()) {
                    this.managedMakeProjects.add(iProject);
                } else {
                    this.standardMakeProjects.add(iProject);
                }
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public void performUpgrade(IProgressMonitor iProgressMonitor, boolean bl) {
        IFile iFile;
        String[] stringArray;
        IProject iProject;
        int n = 0;
        while (n < this.managedMakeProjects.size()) {
            iProject = (IProject)this.managedMakeProjects.elementAt(n);
            try {
                boolean bl2 = true;
                iProject.refreshLocal(1, null);
                stringArray = new String[]{".project", ".cdtproject", ".cdtbuild"};
                int n2 = 0;
                while (n2 < stringArray.length) {
                    iFile = iProject.getFile(stringArray[n2]);
                    if (iFile == null || !iFile.exists()) {
                        MessageDialog.openError((Shell)ManagedBuilderUIPlugin.getDefault().getShell(), (String)Messages.getString("ProjectUpgradeManager.error.upgradeError.title"), (String)MessageFormat.format(Messages.getString("ProjectUpgradeManager.error.missingFile.description"), iProject.getName(), iFile.getName()));
                        bl2 = false;
                    }
                    ++n2;
                }
                if (bl2) {
                    int n3;
                    iProject.refreshLocal(0, null);
                    IPalmOSProject iPalmOSProject = CorePlugin.getPalmOSProject(iProject);
                    iFile = ManagedBuildManager.getBuildInfo((IResource)iProject);
                    boolean bl3 = false;
                    List list = iFile.getTargets();
                    Object object = list.iterator();
                    while (object.hasNext()) {
                        ITarget iTarget = (ITarget)object.next();
                        IConfiguration[] iConfigurationArray = iTarget.getConfigurations();
                        int n4 = 0;
                        while (n4 < iConfigurationArray.length) {
                            String string;
                            IOption iOption;
                            IConfiguration iConfiguration = iConfigurationArray[n4];
                            ITool iTool = iConfiguration.getToolById("com.palmsource.eclipse.palmostools.compiler.palmrc");
                            if (iTool != null && (iOption = iTool.getOptionById("tool.compiler.palmrc.option.locale")) != null && (string = iOption.getStringValue()) != null && string.startsWith("-locale")) {
                                iConfiguration.setOption(iOption, string.substring(7, string.length()));
                                bl3 = true;
                            }
                            if (iConfiguration != null && iConfiguration.getId().startsWith("configuration.pno.sim.exe") && (iOption = iConfiguration.getToolById("com.palmsource.eclipse.palmos5dev.linker.gcc")) != null && (string = iOption.getOptionById("tool.linker.gcc.x86.option.otherFlags")) != null) {
                                boolean bl4 = false;
                                String[] stringArray2 = string.getStringListValue();
                                int n5 = 0;
                                while (n5 < stringArray2.length) {
                                    if (stringArray2[n5] != null && stringArray2[n5].equals("--entry 0")) {
                                        bl4 = true;
                                    }
                                    ++n5;
                                }
                                if (!bl4) {
                                    String[] stringArray3 = new String[stringArray2.length + 1];
                                    System.arraycopy(stringArray2, 0, stringArray3, 1, stringArray2.length);
                                    stringArray3[0] = "--entry 0";
                                    iConfiguration.setOption((IOption)string, stringArray3);
                                    bl3 = true;
                                }
                            }
                            ++n4;
                        }
                    }
                    if (bl3) {
                        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)true);
                    }
                    if ((n3 = ((String)(object = iPalmOSProject.getActiveTarget().getActiveConfiguration().getArtifactName())).lastIndexOf(".")) != -1) {
                        object = ((String)object).substring(0, n3);
                    }
                    this.changePalmOSSetting(iPalmOSProject.getProject(), null, "DB_NAME", (String)object);
                    this.changePalmOSSetting(iPalmOSProject.getProject(), null, "PROJECT_VERSION", String.valueOf(10100));
                    this.removePalmOSSetting(iPalmOSProject.getProject(), null, "SDK5_LOCATION");
                    this.removePalmOSSetting(iPalmOSProject.getProject(), null, "SDK6_LOCATION");
                }
            }
            catch (Exception exception) {
                CorePlugin.log(exception);
                MessageDialog.openError((Shell)ManagedBuilderUIPlugin.getDefault().getShell(), (String)Messages.getString("ProjectUpgradeManager.error.upgradeError.title"), (String)MessageFormat.format(Messages.getString("ProjectUpgradeManager.error.generic.description"), iProject.getName(), exception.getMessage()));
            }
            ++n;
        }
        n = 0;
        while (n < this.standardMakeProjects.size()) {
            iProject = (IProject)this.standardMakeProjects.elementAt(n);
            try {
                boolean bl5 = true;
                iProject.refreshLocal(1, null);
                stringArray = new String[]{".project", ".cdtproject"};
                int n6 = 0;
                while (n6 < stringArray.length) {
                    iFile = iProject.getFile(stringArray[n6]);
                    if (iFile == null || !iFile.exists()) {
                        MessageDialog.openError((Shell)ManagedBuilderUIPlugin.getDefault().getShell(), (String)Messages.getString("ProjectUpgradeManager.error.upgradeError.title"), (String)MessageFormat.format(Messages.getString("ProjectUpgradeManager.error.missingFile.description"), iProject.getName(), iFile.getName()));
                        bl5 = false;
                    }
                    ++n6;
                }
                if (bl5) {
                    CCorePlugin.getDefault().mapCProjectOwner(iProject, MakeCorePlugin.MAKE_PROJECT_ID, true);
                    ScannerConfigNature.addScannerConfigNature((IProject)iProject);
                    IPalmOSProject iPalmOSProject = CorePlugin.getPalmOSProject(iProject);
                    PODS11ProjectUpgrader.updateScannerInfo(iProgressMonitor, iProject, iPalmOSProject.getScannerInfoCommand(), iPalmOSProject.getScannerInfoArguments());
                    this.changePalmOSSetting(iPalmOSProject.getProject(), null, "PROJECT_VERSION", String.valueOf(10100));
                    this.removePalmOSSetting(iPalmOSProject.getProject(), null, "SDK5_LOCATION");
                    this.removePalmOSSetting(iPalmOSProject.getProject(), null, "SDK6_LOCATION");
                    iProject.refreshLocal(1, null);
                }
            }
            catch (CoreException coreException) {
                CorePlugin.log(coreException);
                MessageDialog.openError((Shell)ManagedBuilderUIPlugin.getDefault().getShell(), (String)Messages.getString("ProjectUpgradeManager.error.upgradeError.title"), (String)MessageFormat.format(Messages.getString("ProjectUpgradeManager.error.generic.description"), iProject.getName(), coreException.getMessage()));
            }
            ++n;
        }
    }

    public static void updateScannerInfo(IProgressMonitor iProgressMonitor, IProject iProject, String string, String string2) throws CoreException {
        String string3;
        String string4;
        Object object;
        Object object2;
        IScannerConfigBuilderInfo iScannerConfigBuilderInfo;
        ICDescriptor iCDescriptor;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        new ArrayList();
        try {
            iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject, false);
            if (iCDescriptor != null) {
                iScannerConfigBuilderInfo = iCDescriptor.getProjectData("org.eclipse.cdt.make.core.makeScannerInfo");
                object2 = iScannerConfigBuilderInfo.getChildNodes();
                int n = 0;
                while (n < object2.getLength()) {
                    object = object2.item(n);
                    string4 = object.getNodeName();
                    if (string4 != null && string4.equals("includePath")) {
                        string3 = object.getAttributes().getNamedItem("path").getNodeValue();
                        if (string3 != null && string3.indexOf("SDK5_LOCATION") == -1 && string3.indexOf("SDK6_LOCATION") == -1) {
                            arrayList2.add(string3);
                        }
                    } else if (string4 != null && string4.equals("definedSymbol") && (string3 = object.getAttributes().getNamedItem("symbol").getNodeValue()) != null && string3.indexOf("__MWERKS__") == -1) {
                        arrayList.add(string3);
                    }
                    ++n;
                }
                Node node = iScannerConfigBuilderInfo.getFirstChild();
                while (node != null) {
                    iScannerConfigBuilderInfo.removeChild(node);
                    node = iScannerConfigBuilderInfo.getFirstChild();
                }
                iCDescriptor.saveProjectData();
            }
        }
        catch (CoreException coreException) {
            CorePlugin.log(coreException);
        }
        if ((iCDescriptor = CoreModel.getDefault().create(iProject)) != null) {
            iScannerConfigBuilderInfo = iCDescriptor.getRawPathEntries();
            object2 = new ArrayList();
            int n = 0;
            while (n < ((IScannerConfigBuilderInfo)iScannerConfigBuilderInfo).length) {
                object = iScannerConfigBuilderInfo[n];
                if (!(object instanceof IncludeEntry) || (string3 = (string4 = (IncludeEntry)object).getIncludePath().toString()) == null || string3.indexOf("SDK5_LOCATION") == -1 && string3.indexOf("SDK6_LOCATION") == -1) {
                    object2.add(object);
                }
                ++n;
            }
            IContainerEntry iContainerEntry = arrayList2.iterator();
            while (iContainerEntry.hasNext()) {
                object = (String)iContainerEntry.next();
                string4 = CoreModel.newIncludeEntry((IPath)Path.EMPTY, (IPath)Path.EMPTY, (IPath)new Path((String)object));
                object2.add(string4);
            }
            iContainerEntry = arrayList.iterator();
            while (iContainerEntry.hasNext()) {
                object = (String)iContainerEntry.next();
                string4 = "1";
                if (((String)object).indexOf(61) != -1) {
                    string4 = ((String)object).substring(((String)object).indexOf(61) + 1);
                    object = ((String)object).substring(0, ((String)object).indexOf(61));
                }
                string3 = CoreModel.newMacroEntry((IPath)Path.EMPTY, (String)object, (String)string4);
                object2.add(string3);
            }
            iContainerEntry = CoreModel.newContainerEntry((IPath)DiscoveredPathContainer.CONTAINER_ID);
            if (!object2.contains(iContainerEntry)) {
                object2.add(iContainerEntry);
            }
            iCDescriptor.setRawPathEntries(object2.toArray(new IPathEntry[object2.size()]), iProgressMonitor);
        }
        MakeCorePlugin.getDefault().getDiscoveryManager().removeDiscoveredInfo(iProject);
        iScannerConfigBuilderInfo = MakeCorePlugin.createScannerConfigBuildInfo((IProject)iProject, (String)ScannerConfigBuilder.BUILDER_ID);
        iScannerConfigBuilderInfo.setAutoDiscoveryEnabled(true);
        iScannerConfigBuilderInfo.setMakeBuilderConsoleParserEnabled(true);
        iScannerConfigBuilderInfo.setMakeBuilderConsoleParserId("org.eclipse.cdt.make.core.GCCScannerInfoConsoleParser");
        iScannerConfigBuilderInfo.setESIProviderCommandEnabled(true);
        iScannerConfigBuilderInfo.setUseDefaultESIProviderCmd(false);
        iScannerConfigBuilderInfo.setESIProviderCommand((IPath)new Path(string));
        iScannerConfigBuilderInfo.setESIProviderArguments(string2);
        iScannerConfigBuilderInfo.setESIProviderConsoleParserId("org.eclipse.cdt.make.core.GCCSpecsConsoleParser");
        iScannerConfigBuilderInfo.setSIProblemGenerationEnabled(true);
    }
}

