/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.internal.projects;

import com.palmsource.eclipse.palmoscore.projects.IPalmOSConfiguration;
import com.palmsource.eclipse.palmoscore.projects.IPalmOSTarget;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.runtime.IPath;

public abstract class PalmOSManagedConfiguration
implements IPalmOSConfiguration {
    private IPalmOSTarget target;
    private IConfiguration configuration;

    public PalmOSManagedConfiguration(IPalmOSTarget iPalmOSTarget, IConfiguration iConfiguration) {
        this.target = iPalmOSTarget;
        this.configuration = iConfiguration;
    }

    public IPalmOSTarget getTarget() {
        return this.target;
    }

    public String getName() {
        String string = null;
        if (this.configuration != null) {
            string = this.configuration.getName();
        }
        return string;
    }

    public IPath getOutputDirectory() {
        IPath iPath = null;
        if (this.target != null && this.configuration != null) {
            iPath = this.target.getPalmOSProject().getProject().getLocation().append(this.configuration.getName());
        }
        return iPath;
    }

    public String getArtifactName() {
        String string = null;
        if (this.configuration != null) {
            string = this.configuration.getTarget().getArtifactName();
            String string2 = this.configuration.getTarget().getArtifactExtension();
            if (string2 != null && string2.length() > 0) {
                string = String.valueOf(string) + "." + string2;
            }
        }
        return string;
    }

    public IPath getArtifact() {
        IPath iPath = null;
        IPath iPath2 = this.getOutputDirectory();
        String string = this.getArtifactName();
        if (iPath2 != null && string != null) {
            iPath = iPath2.append(string);
        }
        return iPath;
    }

    public boolean isDebugConfiguration() {
        boolean bl = false;
        if (this.configuration != null) {
            bl = this.configuration.getName().toLowerCase().indexOf("debug") != -1;
        }
        return bl;
    }

    public boolean isReleaseConfiguration() {
        return !this.isDebugConfiguration();
    }
}

