/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.internal.projects;

import com.palmsource.eclipse.palmoscore.projects.IPalmOSProject;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public abstract class PalmOSProject
implements IPalmOSProject {
    private IProject project;

    protected PalmOSProject() {
    }

    public IProject getProject() {
        return this.project;
    }

    protected void saveProject(IProject iProject) {
        this.project = iProject;
    }

    public boolean isApplicationProject() {
        String string = this.getPalmOSProjectSetting("PROJECT_TYPE");
        return string != null && string.equals("appl");
    }

    public boolean isSharedLibraryProject() {
        String string = this.getPalmOSProjectSetting("PROJECT_TYPE");
        return string != null && string.equals("slib");
    }

    public boolean isStaticLibraryProject() {
        String string = this.getPalmOSProjectSetting("PROJECT_TYPE");
        return string != null && string.equals("lib");
    }

    public String getSDK() {
        return this.getPalmOSProjectSetting("SDK");
    }

    public String getTargetOSAPI() {
        return this.getPalmOSProjectSetting("OS_API");
    }

    public int getProjectVersion() {
        int n = 0;
        String string = this.getPalmOSProjectSetting("PROJECT_VERSION");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }

    protected String getPalmOSProjectSetting(String string) {
        String string2 = null;
        if (this.project != null) {
            Object object;
            Object object2 = null;
            try {
                object = this.project.getDescription().getBuildSpec();
                int n = 0;
                while (n < ((ICommand[])object).length) {
                    if (object[n].getBuilderName().equals("com.palmsource.eclipse.palmoscore.palmOSMakeBuilder")) {
                        object2 = object[n];
                        break;
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {}
            if (object2 != null && (object = object2.getArguments()) != null && string != null) {
                string2 = (String)object.get(string);
            }
        }
        return string2;
    }
}

