/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.internal.projects;

import com.palmsource.eclipse.palmoscore.projects.IPalmOSConfiguration;
import com.palmsource.eclipse.palmoscore.projects.IPalmOSTarget;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

public class PalmOSStandardConfiguration
implements IPalmOSConfiguration {
    private static String DEBUG_DEVICE_OUTPUT_DIR = "DEBUG_DEVICE_OUTPUT_DIR";
    private static String RELEASE_DEVICE_OUTPUT_DIR = "RELEASE_DEVICE_OUTPUT_DIR";
    private static String DEBUG_SIMULATOR_OUTPUT_DIR = "DEBUG_SIMULATOR_OUTPUT_DIR";
    private static String RELEASE_SIMULATOR_OUTPUT_DIR = "RELEASE_SIMULATOR_OUTPUT_DIR";
    private static String APPLICATION_EXTENSION = ".prc";
    private static String SHARED_LIB_EXTENSION = ".prc";
    private static String STATIC_LIB_DEVICE_EXT = ".a";
    private static String STATIC_LIB_SIM_EXT = ".lib";
    private static String DATABASE_EXTENSION = ".pdb";
    private IPalmOSTarget target;
    private Map makefileDefs;
    private String name;
    private boolean isDebug;

    public PalmOSStandardConfiguration(IPalmOSTarget iPalmOSTarget, String string, Map map) {
        this.target = iPalmOSTarget;
        this.name = string;
        this.makefileDefs = map;
        this.isDebug = string.equalsIgnoreCase("Debug");
    }

    public String getName() {
        return this.name;
    }

    public IPalmOSTarget getTarget() {
        return this.target;
    }

    public boolean isDebugConfiguration() {
        return this.isDebug;
    }

    public boolean isReleaseConfiguration() {
        return !this.isDebug;
    }

    public IPath getOutputDirectory() {
        String string = null;
        IPath iPath = null;
        if (this.target.isSimulatorTarget() && this.isDebugConfiguration()) {
            string = (String)this.makefileDefs.get(DEBUG_SIMULATOR_OUTPUT_DIR);
        } else if (this.target.isSimulatorTarget() && this.isReleaseConfiguration()) {
            string = (String)this.makefileDefs.get(RELEASE_SIMULATOR_OUTPUT_DIR);
        } else if (this.target.isDeviceTarget() && this.isDebugConfiguration()) {
            string = (String)this.makefileDefs.get(DEBUG_DEVICE_OUTPUT_DIR);
        } else if (this.target.isDeviceTarget() && this.isReleaseConfiguration()) {
            string = (String)this.makefileDefs.get(RELEASE_DEVICE_OUTPUT_DIR);
        }
        if (string != null) {
            iPath = this.target.getPalmOSProject().getProject().getLocation().append(string);
        }
        return iPath;
    }

    public String getArtifactName() {
        String string = null;
        if (this.makefileDefs != null) {
            String string2 = (String)this.makefileDefs.get("ARTIFACT_NAME");
            String string3 = (String)this.makefileDefs.get("PROJECT_TYPE");
            String string4 = (String)this.makefileDefs.get("TARGET_PLATFORM");
            if (string2 != null && string3 != null && string4 != null) {
                string = string3.equalsIgnoreCase("pdb") ? string2.concat(DATABASE_EXTENSION) : (string3.equalsIgnoreCase("slib") ? string2.concat(SHARED_LIB_EXTENSION) : (string3.equalsIgnoreCase("lib") ? (string4.equalsIgnoreCase("Device") ? string2.concat(STATIC_LIB_DEVICE_EXT) : string2.concat(STATIC_LIB_SIM_EXT)) : string2.concat(APPLICATION_EXTENSION)));
            }
        }
        return string;
    }

    public IPath getArtifact() {
        IPath iPath = null;
        IPath iPath2 = this.getOutputDirectory();
        if (iPath2 != null) {
            iPath = this.getOutputDirectory().append(this.getArtifactName());
        }
        return iPath;
    }
}

