/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.internal.projects;

import com.palmsource.eclipse.palmoscore.CorePlugin;
import com.palmsource.eclipse.palmoscore.Messages;
import com.palmsource.eclipse.palmoscore.internal.projects.IProjectUpgrader;
import com.palmsource.eclipse.palmoscore.internal.projects.PODS11ProjectUpgrader;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Vector;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ProjectUpgradeManager
implements IResourceChangeListener {
    private static Vector projectUpgraders = new Vector();
    private static boolean initializedUpgraders = false;

    public ProjectUpgradeManager() {
        ProjectUpgradeManager.initUpgraders();
    }

    private static synchronized void initUpgraders() {
        if (!initializedUpgraders) {
            projectUpgraders.add(new PODS11ProjectUpgrader());
        }
        initializedUpgraders = true;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (iResourceChangeEvent != null && (iResourceChangeEvent.getType() & 1) != 0 && iResourceChangeEvent.getDelta() != null) {
            IProject[] iProjectArray;
            IProject iProject = null;
            IResourceDelta[] iResourceDeltaArray = iResourceChangeEvent.getDelta().getAffectedChildren(1);
            if (iResourceDeltaArray != null) {
                int n = 0;
                while (n < iResourceDeltaArray.length) {
                    IResourceDelta iResourceDelta = iResourceDeltaArray[n];
                    if (iResourceDelta.getResource() != null && iResourceDelta.getResource() instanceof IProject) {
                        iProject = (IProject)iResourceDelta.getResource();
                        break;
                    }
                    ++n;
                }
            }
            if (iProject != null && iProject.exists() && ProjectUpgradeManager.upgradeNeeded(iProjectArray = new IProject[]{iProject})) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        Shell shell = CorePlugin.getDefault().getShell();
                        MessageDialog.openInformation((Shell)shell, (String)Messages.getString("ProjectUpgradeManager.needToUpgrade.title"), (String)MessageFormat.format(Messages.getString("ProjectUpgradeManager.needToUpgrade.description"), iProjectArray[0].getName()));
                    }
                });
            }
        }
    }

    public static boolean upgradeNeeded(IProject[] iProjectArray) {
        ProjectUpgradeManager.initUpgraders();
        boolean bl = false;
        int n = 0;
        while (n < projectUpgraders.size()) {
            IProjectUpgrader iProjectUpgrader = (IProjectUpgrader)projectUpgraders.elementAt(n);
            if (iProjectUpgrader.loadProjectsToUpgrade(iProjectArray)) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public static void doProjectUpgrade(IProgressMonitor iProgressMonitor, IProject[] iProjectArray, boolean bl) {
        ProjectUpgradeManager.initUpgraders();
        int n = 0;
        while (n < projectUpgraders.size()) {
            IProjectUpgrader iProjectUpgrader = (IProjectUpgrader)projectUpgraders.elementAt(n);
            iProjectUpgrader.performUpgrade(iProgressMonitor, bl);
            ++n;
        }
    }

    public static void run(boolean bl, IRunnableContext iRunnableContext, final IProject[] iProjectArray, final boolean bl2) {
        try {
            iRunnableContext.run(bl, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(this, iProjectArray, bl2){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ IProject[] val$projects;
                            private final /* synthetic */ boolean val$isStartUp;
                            {
                                this.this$1 = var1_1;
                                this.val$projects = iProjectArray;
                                this.val$isStartUp = bl;
                            }

                            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                                ProjectUpgradeManager.doProjectUpgrade(iProgressMonitor, this.val$projects, this.val$isStartUp);
                            }
                        };
                        CorePlugin.getWorkspace().run(iWorkspaceRunnable, iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException(operationCanceledException.getMessage());
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            MakeUIPlugin.logException((Throwable)invocationTargetException, (String)MakeUIPlugin.getResourceString((String)"UpdateMakeProjectAction.exception.error"), (String)MakeUIPlugin.getResourceString((String)"UpdateMakeProjectAction.eception.message"));
        }
    }

    private class ProjectUpgradeJob
    extends WorkspaceJob {
        private IProject[] projects;

        public ProjectUpgradeJob(IProject[] iProjectArray) {
            super(Messages.getString("ProjectUpgradeManager.name"));
            ProjectUpgradeManager.initUpgraders();
        }

        public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
            ProjectUpgradeManager.doProjectUpgrade(null, this.projects, false);
            return Status.OK_STATUS;
        }
    }
}

