/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.internal.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public abstract class PalmOSTool {
    private String name;
    private IPath workdir;
    private String[] options;

    protected PalmOSTool(String string) {
        this.name = string;
    }

    protected abstract String[] getCommand();

    public IPath getWorkdir() {
        return this.workdir;
    }

    public void setWorkdir(IPath iPath) {
        this.workdir = iPath;
    }

    public String[] getOptions() {
        return this.options;
    }

    public void setOptions(String[] stringArray) {
        this.options = stringArray;
    }

    public IStatus execute() {
        Status status;
        File file = this.getWorkdir() == null ? null : this.getWorkdir().toFile();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(2048);
            String[] stringArray = this.getCommand();
            Process process = Runtime.getRuntime().exec(stringArray, null, file);
            InputStream inputStream = process.getInputStream();
            PalmOSTool.copyStream(inputStream, byteArrayOutputStream);
            InputStream inputStream2 = process.getErrorStream();
            PalmOSTool.copyErrorStream(inputStream2, byteArrayOutputStream2);
            process.waitFor();
            int n = process.exitValue();
            if (n == 0) {
                status = new Status(0, this.name, n, "", null);
            } else {
                String string = String.valueOf(byteArrayOutputStream.toString()) + byteArrayOutputStream2.toString();
                string = string.replaceAll("\r\n", "\n");
                String[] stringArray2 = string.split("\n");
                MultiStatus multiStatus = new MultiStatus(this.name, n, String.valueOf(this.name) + " failed with exit code " + n, null);
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    multiStatus.add((IStatus)new Status(4, this.name, n, stringArray2[n2], null));
                    ++n2;
                }
                status = multiStatus;
            }
        }
        catch (Exception exception) {
            status = new Status(4, this.name, -1, exception.getMessage(), (Throwable)exception);
        }
        return status;
    }

    private static void copyStream(InputStream inputStream, OutputStream outputStream) {
        final InputStream inputStream2 = inputStream;
        final OutputStream outputStream2 = outputStream;
        Thread thread = new Thread("copyStream"){

            public void run() {
                try {
                    byte[] byArray = new byte[128];
                    while (inputStream2.read(byArray) != -1) {
                        outputStream2.write(byArray);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    private static void copyErrorStream(InputStream inputStream, OutputStream outputStream) {
        final InputStream inputStream2 = inputStream;
        final OutputStream outputStream2 = outputStream;
        Thread thread = new Thread("copyErrorStream"){

            public void run() {
                try {
                    byte[] byArray = new byte[128];
                    while (inputStream2.read(byArray) != -1) {
                        outputStream2.write(byArray);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    private static void printList(List list, PrintStream printStream) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            printStream.print(iterator.next() + " ");
        }
        printStream.println("");
    }
}

