/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.targets;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractXMLDocument {
    protected Document document;
    protected IPath source;
    protected boolean modified = false;

    public AbstractXMLDocument() {
        this(null);
    }

    public AbstractXMLDocument(IPath iPath) {
        this.source = iPath;
        if (iPath == null) {
            this.document = this.getDefaultDocument();
        } else if (!iPath.toFile().exists()) {
            try {
                iPath.toFile().createNewFile();
                this.document = this.getDefaultDocument();
                this.writeDocument(iPath, this.document);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            this.document = this.readDocument(iPath);
        }
    }

    protected abstract Document getDefaultDocument();

    public Document getDocument() {
        return this.document;
    }

    protected void setDocument(Document document) {
        this.document = document;
    }

    public IPath getSource() {
        return this.source;
    }

    public void setSource(IPath iPath) {
        this.source = iPath;
    }

    public Element getDocRoot() {
        return this.document != null ? this.document.getDocumentElement() : null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public void load() {
        if (this.document == null || this.source == null) {
            return;
        }
        this.document = this.readDocument(this.source);
        this.modified = false;
    }

    public void store() {
        if (this.document == null || this.source == null) {
            return;
        }
        if (this.modified) {
            this.writeDocument(this.source, this.document);
            this.modified = false;
        }
    }

    public void delete() {
        if (this.document == null || this.source == null) {
            return;
        }
        this.source.toFile().delete();
        this.document = null;
        this.source = null;
        this.modified = false;
    }

    protected Document newEmptyDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return document;
    }

    protected Document readDocument(IPath iPath) {
        Document document = null;
        try {
            document = this.readXML(iPath);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return document;
    }

    protected Document readXML(IPath iPath) throws ParserConfigurationException, IOException, SAXException {
        Document document;
        block5: {
            FileReader fileReader = null;
            try {
                File file = iPath.toFile();
                fileReader = new FileReader(file);
                document = this.readXML(fileReader);
                Object var4_5 = null;
                if (fileReader == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_6 = null;
                    if (fileReader == null) break block6;
                    try {
                        ((Reader)fileReader).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((Reader)fileReader).close();
            }
            catch (IOException iOException) {}
        }
        return document;
    }

    protected Document readXML(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        return this.readXML(new InputStreamReader(inputStream));
    }

    protected Document readXML(Reader reader) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(reader));
        return document;
    }

    protected void writeDocument(IPath iPath, Document document) {
        try {
            this.writeXML(iPath, document);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    protected void writeXML(IPath var1_1, Document var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 67->71)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void writeXML(Writer writer, Document document) throws IOException {
        StreamResult streamResult = new StreamResult(writer);
        DOMSource dOMSource = new DOMSource(document);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw (IOException)new IOException().initCause(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw (IOException)new IOException().initCause(transformerException);
        }
    }
}

