/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.targets;

import com.palmsource.eclipse.palmoscore.CorePlugin;
import com.palmsource.eclipse.palmoscore.Messages;
import com.palmsource.eclipse.palmoscore.targets.AbstractXMLDocument;
import com.palmsource.eclipse.palmoscore.targets.IPODPreferences;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PODPreferences
extends AbstractXMLDocument
implements IPODPreferences {
    private static final String[] TAGPATH_DEBUG_METHOD_PATH = new String[]{Messages.getString("PODPreferences.protocols"), Messages.getString("PODPreferences.68k_debug_kernel"), "debug_method"};
    private static final String[] TAGPATH_HOST_PATH = new String[]{Messages.getString("PODPreferences.protocols"), Messages.getString("PODPreferences.68k_debug_kernel"), "poser_path"};
    private static final String[] TAGPATH_HOST_ARGUMENTS = new String[]{Messages.getString("PODPreferences.protocols"), Messages.getString("PODPreferences.68k_debug_kernel"), "poser_command_line"};
    private static String[] TAGPATH_COMMUNICATIONS;
    private static final String[] TAGPATH_SERIAL_PORT;
    private static final String[] TAGPATH_USB_LIBRARY;
    private static final String[] TAGPATH_IP_ADDRESS;
    private static final String[] TAGPATH_IP_PORT;
    private static final String[] PROTOCOL_PANELS;
    private static final Map typeMap;
    private static final Map methodMap;
    private static final IPath TARGET_DEFAULTS;

    static {
        String[] stringArray = new String[3];
        stringArray[0] = Messages.getString("PODPreferences.protocols");
        stringArray[2] = "comm_plugin";
        TAGPATH_COMMUNICATIONS = stringArray;
        TAGPATH_SERIAL_PORT = new String[]{Messages.getString("PODPreferences.communications"), Messages.getString("PODPreferences.serial"), "PORT"};
        TAGPATH_USB_LIBRARY = new String[]{Messages.getString("PODPreferences.communications"), Messages.getString("PODPreferences.usb"), "USB_DLL_PATH"};
        TAGPATH_IP_ADDRESS = new String[]{Messages.getString("PODPreferences.communications"), Messages.getString("PODPreferences.sockets"), "ip"};
        TAGPATH_IP_PORT = new String[]{Messages.getString("PODPreferences.communications"), Messages.getString("PODPreferences.sockets"), "port"};
        PROTOCOL_PANELS = new String[]{Messages.getString("PODPreferences.68k_debug_kernel"), Messages.getString("PODPreferences.arm_debugMgr"), Messages.getString("PODPreferences.arm_debugNub")};
        typeMap = new HashMap(4);
        methodMap = new HashMap(3);
        typeMap.put("device", Messages.getString("PODPreferences.palm_device"));
        typeMap.put("emulator", Messages.getString("PODPreferences.emulator"));
        typeMap.put("simulator", Messages.getString("PODPreferences.simulator"));
        typeMap.put("virtio", Messages.getString("PODPreferences.device"));
        methodMap.put("usb", Messages.getString("PODPreferences.usb_plugin"));
        methodMap.put("serial", Messages.getString("PODPreferences.serial_plugin"));
        methodMap.put("socket", Messages.getString("PODPreferences.comm_plugin"));
        TARGET_DEFAULTS = new Path("targets");
    }

    public PODPreferences() {
    }

    public PODPreferences(IPath iPath) {
        super(iPath);
    }

    protected Document getDefaultDocument() {
        Document document = this.newEmptyDocument();
        Element element = document.createElement("PREFDATA_COLLECTION");
        document.appendChild(element);
        return document;
    }

    public void applyDefaults(String string) {
        if (this.document == null || string == null) {
            return;
        }
        String string2 = "pod_" + string + "_prefs.xml";
        IPath iPath = TARGET_DEFAULTS.append(string2);
        try {
            this.document = this.readXML(CorePlugin.getDefault().openStream(iPath));
        }
        catch (Exception exception) {
            this.document = this.getDefaultDocument();
        }
        this.setDebugMethod(string);
    }

    public void applyPreferences(PODPreferences pODPreferences) {
        if (this.document == null) {
            this.document = this.getDefaultDocument();
        }
        Node node = this.document.importNode(pODPreferences.getDocRoot(), true);
        this.document.removeChild(this.getDocRoot());
        this.document.appendChild(node);
        this.setModified(true);
    }

    private String getDebugMethod() {
        String string = this.getTagText(TAGPATH_DEBUG_METHOD_PATH);
        String string2 = this.getMapKey(typeMap, string);
        return string2 != null ? string2 : "device";
    }

    private void setDebugMethod(String string) {
        String string2 = (String)typeMap.get(string);
        this.setTagText(TAGPATH_DEBUG_METHOD_PATH, string2);
    }

    public String getHostPath() {
        return this.getTagText(TAGPATH_HOST_PATH);
    }

    public void setHostPath(String string) {
        this.setTagText(TAGPATH_HOST_PATH, string);
    }

    public String getHostArguments() {
        return this.getTagText(TAGPATH_HOST_ARGUMENTS);
    }

    public void setHostArguments(String string) {
        this.setTagText(TAGPATH_HOST_ARGUMENTS, string);
    }

    public String getHostAddress() {
        return this.getTagText(TAGPATH_IP_ADDRESS);
    }

    public void setHostAddress(String string) {
        this.setTagText(TAGPATH_IP_ADDRESS, string);
    }

    public String getHostPort() {
        return this.getTagText(TAGPATH_IP_PORT);
    }

    public void setHostPort(String string) {
        this.setTagText(TAGPATH_IP_PORT, string);
    }

    public String getSerialPort() {
        return this.getTagText(TAGPATH_SERIAL_PORT);
    }

    public void setSerialPort(String string) {
        this.setTagText(TAGPATH_SERIAL_PORT, string);
    }

    public String getUSBLibrary() {
        return this.getTagText(TAGPATH_USB_LIBRARY);
    }

    public void setUSBLibrary(String string) {
        this.setTagText(TAGPATH_USB_LIBRARY, string);
    }

    public String getCommunicationMethod() {
        PODPreferences.TAGPATH_COMMUNICATIONS[1] = PROTOCOL_PANELS[0];
        String string = this.getTagText(TAGPATH_COMMUNICATIONS);
        String string2 = this.getMapKey(methodMap, string);
        return string2 != null ? string2 : "usb";
    }

    public void setCommunicationMethod(String string) {
        String string2 = (String)methodMap.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException(Messages.getString("PODPreferences.error_invalid_argument"));
        }
        int n = 0;
        while (n < PROTOCOL_PANELS.length) {
            PODPreferences.TAGPATH_COMMUNICATIONS[1] = PROTOCOL_PANELS[n];
            this.setTagText(TAGPATH_COMMUNICATIONS, string2);
            ++n;
        }
    }

    private String getTagText(String[] stringArray) {
        if (stringArray.length != 3) {
            return null;
        }
        return this.getPODPrefValue(stringArray[0], stringArray[1], stringArray[2]);
    }

    private void setTagText(String[] stringArray, String string) {
        if (stringArray.length != 3) {
            return;
        }
        this.setPODPrefValue(stringArray[0], stringArray[1], stringArray[2], string);
    }

    public String getPODPrefValue(String string, String string2, String string3) {
        if (this.document == null) {
            return null;
        }
        Element element = this.findElementByPath(string, string2, string3);
        return element != null ? this.getTextNodeValue(element) : "";
    }

    public void setPODPrefValue(String string, String string2, String string3, String string4) {
        if (this.document == null) {
            return;
        }
        Element element = this.findElementByPath(string, string2, string3);
        if (element == null) {
            element = this.createElementByPath(string, string2, string3);
        }
        this.setTextNodeValue(element, string4);
        this.modified = true;
    }

    private String getMapKey(Map map, String string) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.equals(map.get(string2))) continue;
            return string2;
        }
        return null;
    }

    private Element createElementByPath(String string, String string2, String string3) {
        if (this.document == null) {
            return null;
        }
        Element element = this.document.getDocumentElement();
        Element element2 = this.document.createElement("PREFDATA");
        Element element3 = this.document.createElement("CATEGORY");
        element3.setAttribute("ID", string);
        Element element4 = this.document.createElement("PANEL");
        element4.setAttribute("ID", string2);
        Element element5 = this.document.createElement("DATA");
        element5.setAttribute("ID", string3);
        element4.appendChild(element5);
        element3.appendChild(element4);
        element2.appendChild(element3);
        element.appendChild(element2);
        return element5;
    }

    private Element findElementByPath(String string, String string2, String string3) {
        Element element;
        if (this.document == null) {
            return null;
        }
        Element element2 = this.document.getDocumentElement();
        ElemIter elemIter = new ElemIter(element2, "PREFDATA");
        while ((element = elemIter.next()) != null) {
            Element element3;
            Element element4;
            Element element5 = this.findElemWithTagAndID(element, "CATEGORY", string);
            if (element5 == null || (element4 = this.findElemWithTagAndID(element5, "PANEL", string2)) == null || (element3 = this.findElemWithTagAndID(element4, "DATA", string3)) == null) continue;
            return element3;
        }
        return null;
    }

    private Element findElemWithTagAndID(Element element, String string, String string2) {
        Element element2;
        ElemIter elemIter = new ElemIter(element, string);
        while ((element2 = elemIter.next()) != null) {
            if (!this.attrEquals(element2, "ID", string2)) continue;
            return element2;
        }
        return null;
    }

    public String getTextNodeValue(Element element) {
        Node node = this.getTextNode(element);
        return node != null ? node.getNodeValue() : "";
    }

    public void setTextNodeValue(Element element, String string) {
        Node node = this.getTextNode(element);
        if (node != null) {
            node.setNodeValue(string);
        } else {
            node = this.document.createTextNode(string);
            element.appendChild(node);
        }
    }

    private Node getTextNode(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 3) {
                return node;
            }
            ++n;
        }
        return null;
    }

    private boolean attrEquals(Element element, String string, String string2) {
        String string3 = element.getAttribute(string);
        return string3 != null && string3.equalsIgnoreCase(string2);
    }

    private class ElemIter {
        private Element element;
        private String tag;
        private NodeList childNodes;
        private int index;

        public ElemIter(Element element, String string) {
            this.element = element;
            this.tag = string;
            this.childNodes = element.getElementsByTagName(string);
            this.index = 0;
        }

        public Element next() {
            while (this.index < this.childNodes.getLength()) {
                Node node;
                if ((node = this.childNodes.item(this.index++)).getNodeType() != 1) continue;
                Element element = (Element)node;
                return element;
            }
            return null;
        }
    }
}

