/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.targets;

import com.palmsource.eclipse.palmoscore.CorePlugin;
import com.palmsource.eclipse.palmoscore.Messages;
import com.palmsource.eclipse.palmoscore.targets.AbstractXMLDocument;
import com.palmsource.eclipse.palmoscore.targets.DefaultTargets;
import com.palmsource.eclipse.palmoscore.targets.IPODPreferences;
import com.palmsource.eclipse.palmoscore.targets.ITargetEnvironment;
import com.palmsource.eclipse.palmoscore.targets.PODPreferences;
import com.palmsource.eclipse.palmoscore.targets.UniqueIdentifier;
import java.io.File;
import java.io.FilenameFilter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TargetEnvironment
extends AbstractXMLDocument
implements ITargetEnvironment {
    private static final String TAG_TARGET = "TARGET_ENV";
    private static final String TAG_TYPE = "TYPE";
    private static final String TAG_ID = "ID";
    private static final String TAG_NAME = "NAME";
    private static final String TAG_POD_PREFS = "POD_PREFS";
    private static final String TARGET_DIRECTORY = "targets";
    private static final String TARGET_FILENAME = "target";
    private static final String TARGET_EXTENSION = "-target.xml";
    private static final String PODPREFS_EXTENSION = "-podprefs.xml";
    private static final IPath TARGET_SETTINGS;
    private static final String IDENT_EXTENSION = "-ident.xml";
    private static Map generators;
    Element docRoot;
    PODPreferences podPrefs;

    static {
        boolean bl;
        TARGET_SETTINGS = CorePlugin.getDefault().getStateLocation().append(TARGET_DIRECTORY);
        File file = TARGET_SETTINGS.toFile();
        boolean bl2 = bl = !file.exists();
        if (bl) {
            file.mkdirs();
        }
        generators = new HashMap(ITargetEnvironment.TargetTypes.length);
        int n = 0;
        while (n < ITargetEnvironment.TargetTypes.length) {
            String string = ITargetEnvironment.TargetTypes[n];
            IPath iPath = TARGET_SETTINGS.append(String.valueOf(string) + IDENT_EXTENSION);
            generators.put(string, new UniqueIdentifier(iPath));
            ++n;
        }
        if (bl) {
            DefaultTargets.makeDefaultTargets();
        }
    }

    private TargetEnvironment() {
    }

    public TargetEnvironment(IPath iPath) {
        super(iPath);
        this.docRoot = this.document.getDocumentElement();
        this.podPrefs = new PODPreferences(this.getPODPrefsPath());
    }

    public TargetEnvironment(String string) {
        this.document = this.getDefaultDocument();
        this.docRoot = this.document.getDocumentElement();
        this.setType(string);
        Integer n = this.getNextID(string);
        String string2 = TargetEnvironment.getText("targetFormat");
        String string3 = TargetEnvironment.getText(String.valueOf(string) + "Label");
        this.setID(MessageFormat.format(string2, string, n));
        this.setName(MessageFormat.format(string2, string3, n));
        String string4 = String.valueOf(this.getID()) + TARGET_EXTENSION;
        String string5 = String.valueOf(this.getID()) + PODPREFS_EXTENSION;
        this.setSource(TARGET_SETTINGS.append(string4));
        this.setPODPrefsName(string5);
        this.podPrefs = new PODPreferences();
        this.podPrefs.applyDefaults(string);
        this.podPrefs.setSource(this.getPODPrefsPath());
        this.store();
    }

    protected Document getDefaultDocument() {
        Document document = this.newEmptyDocument();
        Element element = document.createElement(TAG_TARGET);
        document.appendChild(element);
        return document;
    }

    public void store() {
        super.store();
        this.podPrefs.store();
    }

    public void delete() {
        super.delete();
        this.podPrefs.delete();
    }

    public IPath getSource() {
        return this.source;
    }

    public void setSource(IPath iPath) {
        this.source = iPath;
    }

    public String getType() {
        return this.getAttribute(TAG_TYPE);
    }

    private void setType(String string) {
        this.setAttribute(TAG_TYPE, string);
    }

    public String getID() {
        return this.getAttribute(TAG_ID);
    }

    private void setID(String string) {
        this.setAttribute(TAG_ID, string);
    }

    private Integer getNextID(String string) {
        UniqueIdentifier uniqueIdentifier = (UniqueIdentifier)generators.get(string);
        if (uniqueIdentifier == null) {
            throw new IllegalArgumentException(Messages.getString("TargetEnvironment.invalid_target_type"));
        }
        return uniqueIdentifier.getNextID();
    }

    public String getName() {
        return this.getAttribute(TAG_NAME);
    }

    public void setName(String string) {
        this.setAttribute(TAG_NAME, string);
    }

    public IPODPreferences getPODPreferences() {
        return this.podPrefs;
    }

    private String getPODPrefsName() {
        return this.getAttribute(TAG_POD_PREFS);
    }

    private void setPODPrefsName(String string) {
        this.setAttribute(TAG_POD_PREFS, string);
    }

    public IPath getPODPrefsPath() {
        String string = this.getPODPrefsName();
        return string != null ? TARGET_SETTINGS.append(string) : null;
    }

    private String getAttribute(String string) {
        return this.docRoot.getAttribute(string);
    }

    private void setAttribute(String string, String string2) {
        this.docRoot.setAttribute(string, string2);
        this.modified = true;
    }

    public String toString() {
        return this.getName();
    }

    public Document getPODPrefDocument() {
        return this.podPrefs.getDocument();
    }

    public String getHostPath() {
        return this.podPrefs.getHostPath();
    }

    public void setHostPath(String string) {
        this.podPrefs.setHostPath(string);
    }

    public String getHostArguments() {
        return this.podPrefs.getHostArguments();
    }

    public void setHostArguments(String string) {
        this.podPrefs.setHostArguments(string);
    }

    public String getHostAddress() {
        return this.podPrefs.getHostAddress();
    }

    public void setHostAddress(String string) {
        this.podPrefs.setHostAddress(string);
    }

    public String getHostPort() {
        return this.podPrefs.getHostPort();
    }

    public void setHostPort(String string) {
        this.podPrefs.setHostPort(string);
    }

    public String getSerialPort() {
        return this.podPrefs.getSerialPort();
    }

    public void setSerialPort(String string) {
        this.podPrefs.setSerialPort(string);
    }

    public String getUSBLibrary() {
        return this.podPrefs.getUSBLibrary();
    }

    public void setUSBLibrary(String string) {
        this.podPrefs.setUSBLibrary(string);
    }

    public String getCommunicationMethod() {
        return this.podPrefs.getCommunicationMethod();
    }

    public void setCommunicationMethod(String string) {
        this.podPrefs.setCommunicationMethod(string);
    }

    public String getPODPrefValue(String string, String string2, String string3) {
        return this.podPrefs.getPODPrefValue(string, string2, string3);
    }

    public void setPODPrefValue(String string, String string2, String string3, String string4) {
        this.podPrefs.setPODPrefValue(string, string2, string3, string4);
    }

    public static ITargetEnvironment[] getTargetEnvironments() {
        IPath iPath = TARGET_SETTINGS;
        ArrayList<TargetEnvironment> arrayList = new ArrayList<TargetEnvironment>(10);
        final File file = iPath.toFile();
        if (!file.isDirectory()) {
            return new ITargetEnvironment[0];
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file2, String string) {
                return file2.equals(file) && string.endsWith(TargetEnvironment.TARGET_EXTENSION);
            }
        };
        String[] stringArray = file.list(filenameFilter);
        int n = 0;
        while (n < stringArray.length) {
            TargetEnvironment targetEnvironment = new TargetEnvironment(iPath.append(stringArray[n]));
            arrayList.add(targetEnvironment);
            ++n;
        }
        return arrayList.toArray(new ITargetEnvironment[arrayList.size()]);
    }

    public static ITargetEnvironment getTargetEnvironment(String string) {
        ITargetEnvironment[] iTargetEnvironmentArray = TargetEnvironment.getTargetEnvironments();
        int n = 0;
        while (n < iTargetEnvironmentArray.length) {
            if (string.equalsIgnoreCase(iTargetEnvironmentArray[n].getID())) {
                return iTargetEnvironmentArray[n];
            }
            ++n;
        }
        return null;
    }

    public static String getText(String string) {
        return Messages.getString("TargetEnv." + string);
    }
}

