/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.ui;

import com.palmsource.eclipse.palmoscore.Messages;
import com.palmsource.eclipse.palmoscore.projects.IProjectDataProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class PalmOSOptionsPanel
extends Composite
implements IProjectDataProvider {
    private static final String KEY_PRC_NAME_LABEL = "WizardPalmOSSettingsPage.prcNameLabel";
    private static final String KEY_MODIFY_PRC_NAME_LABEL = "WizardPalmOSSettingsPage.prcModifyNameLabel";
    private static final String KEY_CREATOR_ID_LABEL = "WizardPalmOSSettingsPage.creatorIDLabel";
    private static final String KEY_CREATOR_URL_LABEL = "WizardPalmOSSettingsPage.creatorIDURL.text";
    private static final String KEY_TYPE_LABEL = "WizardPalmOSSettingsPage.appTypeLabel";
    private static final String KEY_TYPE_APP_LABEL = "WizardPalmOSSettingsPage.appTypeAppLabel";
    private static final String KEY_TYPE_SLIB_LABEL = "WizardPalmOSSettingsPage.appTypeSLibLabel";
    private static final String KEY_TYPE_LIB_LABEL = "WizardPalmOSSettingsPage.appTypeLibLabel";
    private static final String KEY_TYPE_PDB_LABEL = "WizardPalmOSSettingsPage.appTypePDBLabel";
    private static final String KEY_DB_TYPE_LABEL = "WizardPalmOSSettingsPage.dbTypeLabel";
    private static final String KEY_DB_NAME_LABEL = "WizardPalmOSSettingsPage.dbNameLabel";
    private static final String KEY_VERSION_LABEL = "WizardPalmOSSettingsPage.versionLabel";
    private static final String KEY_BIT_LABEL = "WizardPalmOSSettingsPage.bitLabel";
    private static final String KEY_BACKUP_BIT_LABEL = "WizardPalmOSSettingsPage.backupBitLabel";
    private static final String KEY_COPY_PREVENT_BIT_LABEL = "WizardPalmOSSettingsPage.copyPreventBitLabel";
    private static final String KEY_HIDDEN_BIT_LABEL = "WizardPalmOSSettingsPage.hiddenBitLabel";
    private static final String KEY_RESET_BIT_LABEL = "WizardPalmOSSettingsPage.resetBitLabel";
    private static final String KEY_BUNDLE_BIT_LABEL = "WizardPalmOSSettingsPage.bundleBitLabel";
    private static final String ERR_INVALID_APP_NAME = "WizardPalmOSSettingsPage.invalidAppName.text";
    private static final String ERR_INVALID_CREATOR_ID = "WizardPalmOSSettingsPage.invalidCreatorID.text";
    private static final String ERR_INVALID_CREATOR_ID_LOWER = "WizardPalmOSSettingsPage.invalidCreatorID.lower";
    private static final String ERR_INVALID_CREATOR_ID_DEFAULT = "WizardPalmOSSettingsPage.invalidCreatorID.default";
    private static final String ERR_INVALID_VERSION = "WizardPalmOSSettingsPage.invalidVersion.text";
    private static final String ERR_INVALID_NAME_PARENS = "WizardPalmOSSettingsPage.invalidAppName.parens.text";
    private static final String ERR_INVALID_DB_TYPE = "WizardPalmOSSettingsPage.invalidDBType.text";
    private static final String ERR_INVALID_DB_NAME = "WizardPalmOSSettingsPage.invalidDBName.text";
    private static final String DEFAULT_CREATOR_ID = "STRT";
    private static final String DEFAULT_APP_DB_TYPE = "appl";
    private static final String DEFAULT_SLIB_DB_TYPE = "libr";
    private Button typeApp;
    private Button typeLib;
    private Button typeSLib;
    private Button typePDB;
    private Text prcField;
    private Text creatorIDField;
    private Text dbTypeField;
    private Text dbNameField;
    private Text versionField;
    private Button backupBit;
    private Button copyPreventBit;
    private Button hiddenBit;
    private Button resetBit;
    private Button bundleBit;
    private boolean allowTypeApp = true;
    private boolean allowTypeLib = true;
    private boolean allowTypeSLib = true;
    private boolean allowTypePDB = false;
    private boolean initialized = false;
    private boolean prcFieldChanged = false;
    private boolean dbNameFieldChanged = false;
    private boolean enablePRCField = true;
    private String lastError;
    private Vector modifyListeners = new Vector();
    private IProjectDataProvider defaultsProvider;
    private static final int MAX_PROJECT_NAME_LENGTH = 31;

    public PalmOSOptionsPanel(Composite composite, int n, IProjectDataProvider iProjectDataProvider, boolean bl) {
        super(composite, n);
        this.defaultsProvider = iProjectDataProvider;
        this.enablePRCField = bl;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.getString(KEY_TYPE_LABEL));
        this.typeApp = new Button((Composite)this, 16400);
        this.typeApp.setText(Messages.getString(KEY_TYPE_APP_LABEL));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.typeApp.setLayoutData((Object)gridData);
        this.typeApp.setEnabled(this.allowTypeApp);
        new Label((Composite)this, 0);
        this.typeSLib = new Button((Composite)this, 16400);
        this.typeSLib.setText(Messages.getString(KEY_TYPE_SLIB_LABEL));
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 1;
        gridData2.grabExcessHorizontalSpace = true;
        this.typeSLib.setLayoutData((Object)gridData2);
        this.typeSLib.setEnabled(this.allowTypeSLib);
        new Label((Composite)this, 0);
        this.typeLib = new Button((Composite)this, 16400);
        this.typeLib.setText(Messages.getString(KEY_TYPE_LIB_LABEL));
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 1;
        gridData3.grabExcessHorizontalSpace = true;
        this.typeLib.setLayoutData((Object)gridData3);
        this.typeLib.setEnabled(this.allowTypeLib);
        new Label((Composite)this, 0);
        this.typePDB = new Button((Composite)this, 16400);
        this.typePDB.setText(Messages.getString(KEY_TYPE_PDB_LABEL));
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.verticalAlignment = 1;
        gridData4.grabExcessHorizontalSpace = true;
        this.typePDB.setLayoutData((Object)gridData4);
        this.typePDB.setEnabled(this.allowTypePDB);
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        Label label2 = new Label((Composite)this, 0);
        label2.setText(Messages.getString(KEY_PRC_NAME_LABEL));
        this.prcField = new Text((Composite)this, 2052);
        GridData gridData5 = new GridData();
        gridData5.horizontalAlignment = 4;
        gridData5.verticalAlignment = 2;
        gridData5.grabExcessHorizontalSpace = true;
        gridData5.grabExcessVerticalSpace = false;
        this.prcField.setLayoutData((Object)gridData5);
        this.prcField.setEnabled(this.enablePRCField);
        if (!this.enablePRCField) {
            this.prcField.setText(Messages.getString(KEY_MODIFY_PRC_NAME_LABEL));
        }
        Label label3 = new Label((Composite)this, 0);
        label3.setText(Messages.getString(KEY_DB_TYPE_LABEL));
        this.dbTypeField = new Text((Composite)this, 2052);
        GridData gridData6 = new GridData();
        gridData6.horizontalAlignment = 4;
        gridData6.verticalAlignment = 2;
        gridData6.grabExcessHorizontalSpace = true;
        gridData6.grabExcessVerticalSpace = false;
        this.dbTypeField.setLayoutData((Object)gridData6);
        Label label4 = new Label((Composite)this, 0);
        label4.setText(Messages.getString(KEY_DB_NAME_LABEL));
        this.dbNameField = new Text((Composite)this, 2052);
        GridData gridData7 = new GridData();
        gridData7.horizontalAlignment = 4;
        gridData7.verticalAlignment = 2;
        gridData7.grabExcessHorizontalSpace = true;
        gridData7.grabExcessVerticalSpace = false;
        this.dbNameField.setLayoutData((Object)gridData7);
        Label label5 = new Label((Composite)this, 0);
        label5.setText(Messages.getString(KEY_VERSION_LABEL));
        this.versionField = new Text((Composite)this, 2052);
        GridData gridData8 = new GridData();
        gridData8.horizontalAlignment = 4;
        gridData8.verticalAlignment = 2;
        gridData8.grabExcessHorizontalSpace = true;
        gridData8.grabExcessVerticalSpace = false;
        this.versionField.setLayoutData((Object)gridData8);
        Label label6 = new Label((Composite)this, 0);
        label6.setText(Messages.getString(KEY_CREATOR_ID_LABEL));
        this.creatorIDField = new Text((Composite)this, 2052);
        GridData gridData9 = new GridData();
        gridData9.horizontalAlignment = 4;
        gridData9.verticalAlignment = 2;
        gridData9.grabExcessHorizontalSpace = true;
        gridData9.grabExcessVerticalSpace = false;
        this.creatorIDField.setLayoutData((Object)gridData9);
        Label label7 = new Label((Composite)this, 0);
        label7.setText(Messages.getString(KEY_CREATOR_URL_LABEL));
        GridData gridData10 = new GridData();
        gridData10.horizontalAlignment = 4;
        gridData10.verticalAlignment = 2;
        gridData10.grabExcessHorizontalSpace = true;
        gridData10.grabExcessVerticalSpace = false;
        gridData10.horizontalSpan = 2;
        label7.setLayoutData((Object)gridData10);
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        Label label8 = new Label((Composite)this, 0);
        label8.setText(Messages.getString(KEY_BIT_LABEL));
        new Label((Composite)this, 0);
        this.backupBit = new Button((Composite)this, 16416);
        this.backupBit.setText(Messages.getString(KEY_BACKUP_BIT_LABEL));
        this.backupBit.setSelection(true);
        this.copyPreventBit = new Button((Composite)this, 16416);
        this.copyPreventBit.setText(Messages.getString(KEY_COPY_PREVENT_BIT_LABEL));
        GridData gridData11 = new GridData();
        gridData11.horizontalAlignment = 4;
        gridData11.verticalAlignment = 1;
        gridData11.grabExcessHorizontalSpace = true;
        this.copyPreventBit.setLayoutData((Object)gridData11);
        this.hiddenBit = new Button((Composite)this, 16416);
        this.hiddenBit.setText(Messages.getString(KEY_HIDDEN_BIT_LABEL));
        this.resetBit = new Button((Composite)this, 16416);
        this.resetBit.setText(Messages.getString(KEY_RESET_BIT_LABEL));
        GridData gridData12 = new GridData();
        gridData12.horizontalAlignment = 4;
        gridData12.verticalAlignment = 1;
        gridData12.grabExcessHorizontalSpace = true;
        this.resetBit.setLayoutData((Object)gridData12);
        this.bundleBit = new Button((Composite)this, 16416);
        this.bundleBit.setText(Messages.getString(KEY_BUNDLE_BIT_LABEL));
        this.typeApp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PalmOSOptionsPanel.this.typeApp.getSelection() && PalmOSOptionsPanel.this.dbTypeField.getText().equals(PalmOSOptionsPanel.DEFAULT_SLIB_DB_TYPE)) {
                    PalmOSOptionsPanel.this.dbTypeField.setText(PalmOSOptionsPanel.DEFAULT_APP_DB_TYPE);
                    PalmOSOptionsPanel.this.sendModifyEvent();
                }
            }
        });
        this.typeSLib.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PalmOSOptionsPanel.this.typeSLib.getSelection() && PalmOSOptionsPanel.this.dbTypeField.getText().equals(PalmOSOptionsPanel.DEFAULT_APP_DB_TYPE)) {
                    PalmOSOptionsPanel.this.dbTypeField.setText(PalmOSOptionsPanel.DEFAULT_SLIB_DB_TYPE);
                    PalmOSOptionsPanel.this.sendModifyEvent();
                }
            }
        });
        this.typeLib.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = !PalmOSOptionsPanel.this.typeLib.getSelection();
                PalmOSOptionsPanel.this.backupBit.setEnabled(bl);
                PalmOSOptionsPanel.this.copyPreventBit.setEnabled(bl);
                PalmOSOptionsPanel.this.hiddenBit.setEnabled(bl);
                PalmOSOptionsPanel.this.resetBit.setEnabled(bl);
                PalmOSOptionsPanel.this.bundleBit.setEnabled(bl);
                PalmOSOptionsPanel.this.dbTypeField.setEnabled(bl);
                PalmOSOptionsPanel.this.dbNameField.setEnabled(bl);
                PalmOSOptionsPanel.this.creatorIDField.setEnabled(bl);
                PalmOSOptionsPanel.this.versionField.setEnabled(bl);
                PalmOSOptionsPanel.this.sendModifyEvent();
            }
        });
        this.typePDB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = !PalmOSOptionsPanel.this.typePDB.getSelection();
                PalmOSOptionsPanel.this.backupBit.setEnabled(bl);
                PalmOSOptionsPanel.this.copyPreventBit.setEnabled(bl);
                PalmOSOptionsPanel.this.hiddenBit.setEnabled(bl);
                PalmOSOptionsPanel.this.resetBit.setEnabled(bl);
                PalmOSOptionsPanel.this.bundleBit.setEnabled(bl);
                PalmOSOptionsPanel.this.dbTypeField.setEnabled(bl);
                PalmOSOptionsPanel.this.dbNameField.setEnabled(bl);
                PalmOSOptionsPanel.this.creatorIDField.setEnabled(bl);
                PalmOSOptionsPanel.this.versionField.setEnabled(bl);
                PalmOSOptionsPanel.this.sendModifyEvent();
            }
        });
        if (this.enablePRCField) {
            this.prcField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    PalmOSOptionsPanel.this.prcFieldChanged = true;
                    PalmOSOptionsPanel.this.sendModifyEvent();
                }
            });
        }
        this.creatorIDField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PalmOSOptionsPanel.this.sendModifyEvent();
            }
        });
        this.dbTypeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PalmOSOptionsPanel.this.sendModifyEvent();
            }
        });
        this.dbNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PalmOSOptionsPanel.this.dbNameFieldChanged = true;
                PalmOSOptionsPanel.this.sendModifyEvent();
            }
        });
        this.versionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PalmOSOptionsPanel.this.sendModifyEvent();
            }
        });
    }

    public boolean isValid() {
        this.lastError = null;
        if (this.typeApp.getSelection() || this.typeSLib.getSelection() || !this.initialized) {
            String string;
            String string2;
            if (this.enablePRCField) {
                string2 = this.getPRCField();
                if (string2 == null || string2.length() == 0 || string2.length() > 31) {
                    this.lastError = Messages.getString(ERR_INVALID_APP_NAME);
                    return false;
                }
                if (string2.indexOf("(") != -1 || string2.indexOf(")") != -1) {
                    this.lastError = Messages.getString(ERR_INVALID_NAME_PARENS);
                    return false;
                }
            }
            if ((string2 = this.getCreatorID()) == null || string2.length() != 4) {
                this.lastError = Messages.getString(ERR_INVALID_CREATOR_ID);
                return false;
            }
            char[] cArray = string2.toCharArray();
            int n = 0;
            while (n < string2.toCharArray().length) {
                char c = cArray[n];
                if (c < ' ' || c > '~') {
                    this.lastError = Messages.getString(ERR_INVALID_CREATOR_ID);
                    return false;
                }
                ++n;
            }
            if (Character.isLowerCase(cArray[0]) && Character.isLowerCase(cArray[1]) && Character.isLowerCase(cArray[2]) && Character.isLowerCase(cArray[3])) {
                this.lastError = Messages.getString(ERR_INVALID_CREATOR_ID_LOWER);
            }
            if (DEFAULT_CREATOR_ID.equals(string2)) {
                this.lastError = Messages.getString(ERR_INVALID_CREATOR_ID_DEFAULT);
            }
            if ((string = this.getDBName()) == null || string.length() == 0 || string.length() > 31) {
                this.lastError = Messages.getString(ERR_INVALID_DB_NAME);
                return false;
            }
            if (string.indexOf("(") != -1 || string.indexOf(")") != -1) {
                this.lastError = Messages.getString(ERR_INVALID_NAME_PARENS);
                return false;
            }
            String string3 = this.getDBType();
            if (string3 == null || string3.length() != 4) {
                this.lastError = Messages.getString(ERR_INVALID_DB_TYPE);
                return false;
            }
            int n2 = 0;
            while (n2 < string3.toCharArray().length) {
                if (string3.toCharArray()[n2] < ' ' || string3.toCharArray()[n2] > '~') {
                    this.lastError = Messages.getString(ERR_INVALID_DB_TYPE);
                    return false;
                }
                ++n2;
            }
            if (this.getVersion() == null) {
                this.lastError = Messages.getString(ERR_INVALID_VERSION);
                return false;
            }
            try {
                Integer.valueOf(this.getVersion());
            }
            catch (NumberFormatException numberFormatException) {
                this.lastError = Messages.getString(ERR_INVALID_VERSION);
                return false;
            }
            if (Integer.valueOf(this.getVersion()) < 0) {
                this.lastError = Messages.getString(ERR_INVALID_VERSION);
                return false;
            }
        }
        return true;
    }

    public Map getProjectDataValues() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.enablePRCField) {
            String string = this.getPRCField();
            if (string != null && string.length() > 31) {
                string = string.substring(0, 31);
            }
            hashMap.put("ARTIFACT_NAME", string);
        }
        hashMap.put("CREATOR_ID", this.getCreatorID());
        hashMap.put("DB_TYPE", this.getDBType());
        hashMap.put("DB_NAME", this.getDBName());
        hashMap.put("DATABASE_VERSION", this.getVersion());
        hashMap.put("DATABASE_HIDDEN", this.getHiddenBit());
        hashMap.put("DATABASE_BACKUP", this.getBackupBit());
        hashMap.put("DATABASE_PROTECT", this.getCopyPreventBit());
        hashMap.put("DATABASE_RESET", this.getResetBit());
        hashMap.put("DATABASE_BUNDLE", this.getBundleBit());
        hashMap.put("PROJECT_TYPE", this.getProjectType());
        return hashMap;
    }

    public String getLastError() {
        return this.lastError;
    }

    public void allowApplicationProject(boolean bl) {
        this.allowTypeApp = bl;
    }

    public void allowSharedLibProject(boolean bl) {
        this.allowTypeSLib = bl;
    }

    public void allowStaticLibProject(boolean bl) {
        this.allowTypeLib = bl;
    }

    public void allowDatabaseProject(boolean bl) {
        this.allowTypePDB = bl;
    }

    public void initialize(boolean bl) {
        Object v;
        Object v2;
        Object v3;
        Object v4;
        Map map = this.getDefaultValues();
        Object v5 = map.get("PROJECT_TYPE");
        if (v5 != null && ((String)v5).equals("slib")) {
            this.typeSLib.setSelection(true);
            this.typeLib.setEnabled(bl && this.allowTypeLib);
            this.typeApp.setEnabled(bl && this.allowTypeApp);
            this.typePDB.setEnabled(bl && this.allowTypePDB);
        } else if (v5 != null && ((String)v5).equals("lib")) {
            this.typeLib.setSelection(true);
            this.typeSLib.setEnabled(bl && this.allowTypeSLib);
            this.typeApp.setEnabled(bl && this.allowTypeApp);
            this.typePDB.setEnabled(bl && this.allowTypePDB);
        } else if (v5 != null && ((String)v5).equals("pdb")) {
            this.typePDB.setSelection(true);
            this.typeSLib.setEnabled(bl && this.allowTypeSLib);
            this.typeApp.setEnabled(bl && this.allowTypeApp);
            this.typeLib.setEnabled(bl && this.allowTypeLib);
        } else {
            this.typeApp.setSelection(true);
            this.typeSLib.setEnabled(bl && this.allowTypeSLib);
            this.typeLib.setEnabled(bl && this.allowTypeLib);
            this.typePDB.setEnabled(bl && this.allowTypePDB);
        }
        if (this.enablePRCField && (v4 = map.get("ARTIFACT_NAME")) != null) {
            this.prcField.setText((String)v4);
        }
        this.prcFieldChanged = false;
        v4 = map.get("CREATOR_ID");
        if (v4 != null) {
            this.creatorIDField.setText((String)v4);
        }
        if ((v3 = map.get("DATABASE_VERSION")) != null) {
            this.versionField.setText((String)v3);
        }
        if ((v2 = map.get("DB_TYPE")) != null) {
            this.dbTypeField.setText((String)v2);
        }
        if ((v = map.get("DB_NAME")) != null) {
            this.dbNameField.setText((String)v);
        }
        this.dbNameFieldChanged = false;
        Object v6 = map.get("DATABASE_HIDDEN");
        this.hiddenBit.setSelection(v6 != null && ((String)v6).trim().length() > 0);
        v6 = map.get("DATABASE_BACKUP");
        this.backupBit.setSelection(v6 != null && ((String)v6).trim().length() > 0);
        v6 = map.get("DATABASE_PROTECT");
        this.copyPreventBit.setSelection(v6 != null && ((String)v6).trim().length() > 0);
        v6 = map.get("DATABASE_RESET");
        this.resetBit.setSelection(v6 != null && ((String)v6).trim().length() > 0);
        v6 = map.get("DATABASE_BUNDLE");
        this.bundleBit.setSelection(v6 != null && ((String)v6).trim().length() > 0);
        this.initialized = true;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)modifyListener);
        this.addListener(24, (Listener)typedListener);
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error((int)4);
        }
        this.removeListener(24, (SWTEventListener)modifyListener);
    }

    public void artifactNameChanged() {
        if (!this.prcFieldChanged && this.enablePRCField) {
            this.prcField.setText((String)this.getDefaultValues().get("ARTIFACT_NAME"));
            this.prcFieldChanged = false;
        }
        if (!this.dbNameFieldChanged) {
            this.dbNameField.setText((String)this.getDefaultValues().get("ARTIFACT_NAME"));
            this.dbNameFieldChanged = false;
        }
    }

    private void sendModifyEvent() {
        Event event = new Event();
        this.notifyListeners(24, event);
    }

    private String getProjectType() {
        String string = !this.initialized ? (String)this.getDefaultValues().get("PROJECT_TYPE") : (this.typeLib.getSelection() ? "lib" : (this.typeSLib.getSelection() ? "slib" : (this.typePDB.getSelection() ? "pdb" : DEFAULT_APP_DB_TYPE)));
        return string;
    }

    private String getPRCField() {
        String string = "";
        if (!this.prcFieldChanged) {
            string = (String)this.getDefaultValues().get("ARTIFACT_NAME");
        } else if (this.enablePRCField) {
            string = this.prcField.getText();
        }
        return string;
    }

    private String getCreatorID() {
        String string = !this.initialized ? (String)this.getDefaultValues().get("CREATOR_ID") : this.creatorIDField.getText();
        return string;
    }

    private String getVersion() {
        String string = !this.initialized ? (String)this.getDefaultValues().get("DATABASE_VERSION") : this.versionField.getText();
        return string;
    }

    private String getDBType() {
        String string = !this.initialized ? (String)this.getDefaultValues().get("DB_TYPE") : this.dbTypeField.getText();
        return string;
    }

    private String getDBName() {
        String string = !this.dbNameFieldChanged ? (String)this.getDefaultValues().get("DB_NAME") : this.dbNameField.getText();
        return string;
    }

    private String getHiddenBit() {
        String string = !this.initialized ? ((String)this.getDefaultValues().get("DATABASE_HIDDEN")).trim() : (this.hiddenBit.getSelection() ? "-h" : "");
        return string;
    }

    private String getResetBit() {
        String string = !this.initialized ? ((String)this.getDefaultValues().get("DATABASE_RESET")).trim() : (this.resetBit.getSelection() ? "-r" : "");
        return string;
    }

    private String getBackupBit() {
        String string = !this.initialized ? ((String)this.getDefaultValues().get("DATABASE_BACKUP")).trim() : (this.backupBit.getSelection() ? "-b" : "");
        return string;
    }

    private String getCopyPreventBit() {
        String string = !this.initialized ? ((String)this.getDefaultValues().get("DATABASE_PROTECT")).trim() : (this.copyPreventBit.getSelection() ? "-p" : "");
        return string;
    }

    private String getBundleBit() {
        String string = !this.initialized ? ((String)this.getDefaultValues().get("DATABASE_BUNDLE")).trim() : (this.bundleBit.getSelection() ? "-dbFlagBundle" : "");
        return string;
    }

    private String getDBTypeDefault(String string) {
        String string2 = DEFAULT_APP_DB_TYPE;
        if (string != null && string.equals("slib")) {
            string2 = DEFAULT_SLIB_DB_TYPE;
        }
        return string2;
    }

    private Map getDefaultValues() {
        return this.defaultsProvider.getProjectDataValues();
    }
}

