/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.ui.preferences;

import com.palmsource.eclipse.palmoscore.ui.preferences.AbstractPreferencePage;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class GnuCompilerPreferencePage
extends AbstractPreferencePage {
    private static final String PAGE = "GNUCompilerPreferencePage.";
    private static final String GCC = "gcc";
    public static final String GCC_PREFIX = "tool.compiler.gcc.";
    public static final String GCC_LINKER_PREFIX = "tool.linker.gcc.";
    public static final String GCC_DEFINE_SYMBOLS = "defineSymbols";
    public static final String GCC_UNDEFINE_SYMBOLS = "undefineSymbols";
    public static final String GCC_INCLUDE_DIRS = "includeDirs";
    public static final String GCC_PREINCLUDES = "preIncludes";
    public static final String GCC_EXCEPTIONS = "exceptions";
    public static final String GCC_ASSERTIONS = "assertions";
    public static final String GCC_WARNING_LEVEL = "warningLevel";
    public static final String GCC_WARNINGS_AS_ERRORS = "warningsAsErrors";
    public static final String GCC_VERBOSE = "verbose";
    public static final String GCC_OTHER_FLAGS = "otherFlags";
    public static final String[] COMPILER_TARGETS = new String[]{"68K", "x86"};

    public GnuCompilerPreferencePage() {
        this.setDescription(this.getText("description"));
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem[] tabItemArray = new TabItem[COMPILER_TARGETS.length];
        int n = 0;
        while (n < COMPILER_TARGETS.length) {
            tabItemArray[n] = new TabItem(tabFolder, 0);
            tabItemArray[n].setText(COMPILER_TARGETS[n]);
            tabItemArray[n].setControl(this.createCompilerPanel((Composite)tabFolder, COMPILER_TARGETS[n]));
            ++n;
        }
    }

    private Control createCompilerPanel(Composite composite, String string) {
        String string2 = GCC_PREFIX + string + "." + "option.";
        String string3 = GCC_LINKER_PREFIX + string + "." + "option.";
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, true));
        TabFolder tabFolder = this.createTabFolder(composite2);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        tabFolder.setLayoutData((Object)gridData);
        Composite composite3 = this.createTabItem(tabFolder, this.getText("defineSymbolsTab"));
        this.addOptionListEditor(String.valueOf(string2) + GCC_DEFINE_SYMBOLS, this.getText(GCC_DEFINE_SYMBOLS), this.getText("defineSymbolsLabel"), composite3);
        composite3 = this.createTabItem(tabFolder, this.getText("undefineSymbolsTab"));
        this.addOptionListEditor(String.valueOf(string2) + GCC_UNDEFINE_SYMBOLS, this.getText(GCC_UNDEFINE_SYMBOLS), this.getText("undefineSymbolsLabel"), composite3);
        composite3 = this.createTabItem(tabFolder, this.getText("includeDirsTab"));
        this.addPathListEditor(String.valueOf(string2) + GCC_INCLUDE_DIRS, this.getText(GCC_INCLUDE_DIRS), this.getText("includeDirsLabel"), composite3);
        composite3 = this.createTabItem(tabFolder, this.getText("preIncludesTab"));
        this.addPathListEditor(String.valueOf(string2) + GCC_PREINCLUDES, this.getText(GCC_PREINCLUDES), this.getText("preIncludesLabel"), composite3);
        Group group = this.createGroup(composite2, this.getText("generalLabel"), 1, 1);
        this.addEnumEditor(String.valueOf(string2) + GCC_EXCEPTIONS, this.getText(GCC_EXCEPTIONS), 1, new String[][]{{this.getText("exceptionsOn"), "-fexceptions"}, {this.getText("exceptionsOff"), "-fno-exceptions"}}, (Composite)group);
        this.addEnumEditor(String.valueOf(string2) + GCC_ASSERTIONS, this.getText(GCC_ASSERTIONS), 1, new String[][]{{this.getText("assertionsOn"), "-UNDEBUG"}, {this.getText("assertionsOff"), "-DNDEBUG"}}, (Composite)group);
        group = this.createGroup(composite2, this.getText("warningsLabel"), 1, 1);
        this.addEnumEditor(String.valueOf(string2) + GCC_WARNING_LEVEL, this.getText(GCC_WARNING_LEVEL), 1, new String[][]{{this.getText("warningLevelDefault"), ""}, {this.getText("warningLevelNone"), "-w"}, {this.getText("warningLevelAll"), "-Wall"}}, (Composite)group);
        this.addBooleanEditor(String.valueOf(string2) + GCC_WARNINGS_AS_ERRORS, this.getText(GCC_WARNINGS_AS_ERRORS), (Composite)group);
        this.addBooleanEditor(String.valueOf(string2) + GCC_VERBOSE, this.getText(GCC_VERBOSE), (Composite)group);
        group = this.createGroup(composite2, this.getText("compilerOptionsLabel"), 1, 1);
        this.addStringEditor(String.valueOf(string2) + GCC_OTHER_FLAGS, this.getText(GCC_OTHER_FLAGS), (Composite)group);
        group = this.createGroup(composite2, this.getText("linkerOptionsLabel"), 1, 1);
        this.addStringEditor(String.valueOf(string3) + GCC_OTHER_FLAGS, this.getText(GCC_OTHER_FLAGS), (Composite)group);
        return composite2;
    }

    private String getText(String string) {
        return AbstractPreferencePage.getResource(PAGE + string);
    }
}

