/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.ui.preferences.targets;

import com.palmsource.eclipse.palmoscore.targets.PODPreferences;
import com.palmsource.eclipse.palmoscore.ui.preferences.targets.AbstractTargetViewer;
import com.palmsource.eclipse.palmoscore.ui.preferences.targets.PODPrefContentProvider;
import com.palmsource.eclipse.palmoscore.ui.preferences.targets.PODPrefLabelProvider;
import com.palmsource.eclipse.palmoscore.ui.preferences.targets.Util;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.w3c.dom.Element;

public class PODPrefViewer
extends AbstractTargetViewer {
    private static final String PROPERTY = "property";
    private static final String VALUE = "value";
    protected TableTreeViewer viewer;
    private Object currentSeln;

    public PODPrefViewer(Composite composite, int n) {
        super(composite, n);
        this.composite.setLayout((Layout)new GridLayout(2, true));
        this.viewer = new TableTreeViewer(this.composite, 67588);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Table table = this.viewer.getTableTree().getTable();
        TableLayout tableLayout = new TableLayout();
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(Util.getText("advancedDialog.propertyLabel"));
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(Util.getText("advancedDialog.valueLabel"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, 150, false));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, 300, true));
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new PODPrefContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PODPrefLabelProvider());
        this.viewer.setColumnProperties(new String[]{PROPERTY, VALUE});
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new TextCellEditor((Composite)table, 0);
        this.viewer.setCellEditors(cellEditorArray);
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object object, String string) {
                return PODPrefViewer.this.getDataValue(object, string) != null;
            }

            public Object getValue(Object object, String string) {
                return PODPrefViewer.this.getDataValue(object, string);
            }

            public void modify(Object object, String string, Object object2) {
                PODPrefViewer.this.setDataValue(object, string, object2);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
                Object object = structuredSelection.getFirstElement();
                if (object != PODPrefViewer.this.currentSeln && PODPrefViewer.this.isDataNode(object)) {
                    PODPrefViewer.this.currentSeln = object;
                    PODPrefViewer.this.viewer.editElement(object, 1);
                }
                PODPrefViewer.this.currentSeln = object;
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
                Object object = iStructuredSelection.getFirstElement();
                if (PODPrefViewer.this.viewer.isExpandable(object)) {
                    PODPrefViewer.this.viewer.setExpandedState(object, !PODPrefViewer.this.viewer.getExpandedState(object));
                }
            }
        });
    }

    public PODPrefViewer(Composite composite) {
        this(composite, 0);
    }

    public TableTreeViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(TableTreeViewer tableTreeViewer) {
        this.viewer = tableTreeViewer;
    }

    public Object getInput() {
        return this.viewer.getInput();
    }

    public void setInput(Object object) {
        this.viewer.setInput(object);
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    public void setSelection(ISelection iSelection, boolean bl) {
        this.viewer.setSelection(iSelection, bl);
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.viewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.viewer.removeSelectionChangedListener(iSelectionChangedListener);
    }

    private boolean isDataNode(Object object) {
        Element element;
        return object instanceof Element && "DATA".equals((element = (Element)object).getTagName());
    }

    private boolean isDataTag(Element element) {
        return "DATA".equals(element.getTagName());
    }

    private String getID(Element element) {
        return element.getAttribute("ID");
    }

    private String getDataValue(Object object, String string) {
        Element element = (Element)object;
        if (this.isDataTag(element) && string.equals(VALUE)) {
            PODPreferences pODPreferences = (PODPreferences)this.getInput();
            return pODPreferences.getTextNodeValue(element);
        }
        return null;
    }

    private void setDataValue(Object object, String string, Object object2) {
        Element element = (Element)((TableTreeItem)object).getData();
        if (this.isDataTag(element) && string.equals(VALUE)) {
            PODPreferences pODPreferences = (PODPreferences)this.getInput();
            pODPreferences.setTextNodeValue(element, (String)object2);
            pODPreferences.setModified(true);
            this.viewer.refresh();
        }
    }
}

