/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.ui.preferences.targets;

import com.palmsource.eclipse.palmoscore.targets.ITargetEnvironment;
import com.palmsource.eclipse.palmoscore.ui.preferences.targets.AbstractTargetViewer;
import com.palmsource.eclipse.palmoscore.ui.preferences.targets.AdvancedEditAction;
import com.palmsource.eclipse.palmoscore.ui.preferences.targets.BrowseButtonAction;
import com.palmsource.eclipse.palmoscore.ui.preferences.targets.Util;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TargetEditor
extends AbstractTargetViewer
implements IContentProvider {
    ITargetEnvironment target;
    Text targetName;
    Text hostPath;
    Text hostOptions;
    Text hostAddress;
    Text hostPort;
    Text usbPath;
    Text serialPort;
    Button usbButton;
    Button serialButton;
    Button hostPathButton;
    Button usbPathButton;
    Button advancedButton;
    Label targetNameLabel;
    Label pathLabel;
    Label usbLabel;
    Label serialLabel;
    Label message;
    Composite details;
    Composite deviceDetails;
    Composite targetDetails;

    public TargetEditor(Composite composite, int n) {
        super(composite, n);
        this.setContentProvider(this);
        GridLayout gridLayout = new GridLayout(4, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.composite.setLayout((Layout)gridLayout);
        Label label = new Label(this.composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.targetNameLabel = new Label(this.composite, 0);
        this.targetNameLabel.setText(Util.getText("targetNameLabel"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.targetNameLabel.setLayoutData((Object)gridData);
        this.targetName = new Text(this.composite, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.targetName.setLayoutData((Object)gridData);
        this.targetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string;
                String string2 = ((Text)modifyEvent.getSource()).getText();
                if (!string2.equals(string = TargetEditor.this.target.getName())) {
                    TargetEditor.this.target.setName(string2);
                    TargetEditor.this.fireTargetChangedEvent(TargetEditor.this.target);
                }
            }
        });
        label = new Label(this.composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.details = new Composite(this.composite, 0);
        gridData = new GridData(1810);
        gridData.horizontalSpan = 4;
        this.details.setLayoutData((Object)gridData);
        this.details.setLayout((Layout)new StackLayout());
        this.deviceDetails = this.createDetails(this.details, true);
        this.targetDetails = this.createDetails(this.details, false);
        this.message = new Label(this.composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.message.setLayoutData((Object)gridData);
        this.advancedButton = new Button(this.composite, 8);
        this.advancedButton.setText(Util.getText("advancedButton"));
        gridData = new GridData(128);
        gridData.horizontalSpan = 1;
        BrowseButtonAction browseButtonAction = new BrowseButtonAction(this.usbPathButton, this.usbPath);
        BrowseButtonAction browseButtonAction2 = new BrowseButtonAction(this.hostPathButton, this.hostPath);
        AdvancedEditAction advancedEditAction = new AdvancedEditAction(this.advancedButton);
        browseButtonAction.setViewer((Viewer)this);
        browseButtonAction2.setViewer((Viewer)this);
        advancedEditAction.setViewer((Viewer)this);
        this.refresh();
    }

    private Composite createDetails(Composite composite, boolean bl) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(4, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        if (bl) {
            this.usbButton = new Button(composite2, 16);
            this.usbButton.setText(Util.getText("usbButton"));
            GridData gridData = new GridData(256);
            gridData.horizontalSpan = 1;
            this.usbButton.setLayoutData((Object)gridData);
            this.usbButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TargetEditor.this.target.setCommunicationMethod("usb");
                    TargetEditor.this.toggleCommunications(true);
                }
            });
            this.serialButton = new Button(composite2, 16);
            this.serialButton.setText(Util.getText("serialButton"));
            gridData = new GridData(256);
            gridData.horizontalSpan = 1;
            this.serialButton.setLayoutData((Object)gridData);
            this.serialButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TargetEditor.this.target.setCommunicationMethod("serial");
                    TargetEditor.this.toggleCommunications(false);
                }
            });
            Label label = new Label(composite2, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            label.setLayoutData((Object)gridData);
            this.usbLabel = new Label(composite2, 0);
            this.usbLabel.setText(Util.getText("usbLabel"));
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            this.usbLabel.setLayoutData((Object)gridData);
            this.usbPath = new Text(composite2, 2052);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.usbPath.setLayoutData((Object)gridData);
            this.usbPath.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    String string;
                    String string2 = ((Text)modifyEvent.getSource()).getText();
                    if (!string2.equals(string = TargetEditor.this.target.getUSBLibrary())) {
                        TargetEditor.this.target.setUSBLibrary(string2);
                        TargetEditor.this.checkTargetPath(TargetEditor.this.target, string2);
                    }
                }
            });
            this.usbPathButton = new Button(composite2, 8);
            this.usbPathButton.setText(Util.getText("browseButton"));
            gridData = new GridData(128);
            gridData.horizontalSpan = 1;
            this.usbPathButton.setLayoutData((Object)gridData);
            label = new Label(composite2, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            label.setLayoutData((Object)gridData);
            this.serialLabel = new Label(composite2, 0);
            this.serialLabel.setText(Util.getText("serialLabel"));
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            this.serialLabel.setLayoutData((Object)gridData);
            this.serialPort = new Text(composite2, 2052);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.serialPort.setLayoutData((Object)gridData);
            this.serialPort.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    String string;
                    String string2 = ((Text)modifyEvent.getSource()).getText();
                    if (!string2.equals(string = TargetEditor.this.target.getSerialPort())) {
                        TargetEditor.this.target.setSerialPort(string2);
                    }
                }
            });
        } else {
            this.pathLabel = new Label(composite2, 0);
            this.pathLabel.setText(Util.getText("pathLabel"));
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            this.pathLabel.setLayoutData((Object)gridData);
            this.hostPath = new Text(composite2, 2052);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.hostPath.setLayoutData((Object)gridData);
            this.hostPath.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    String string;
                    String string2 = ((Text)modifyEvent.getSource()).getText();
                    if (!string2.equals(string = TargetEditor.this.target.getHostPath())) {
                        TargetEditor.this.target.setHostPath(string2);
                        TargetEditor.this.checkTargetPath(TargetEditor.this.target, string2);
                    }
                }
            });
            this.hostPathButton = new Button(composite2, 8);
            this.hostPathButton.setText(Util.getText("browseButton"));
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            this.hostPathButton.setLayoutData((Object)gridData);
            Label label = new Label(composite2, 0);
            label.setText(Util.getText("optionsLabel"));
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            label.setLayoutData((Object)gridData);
            this.hostOptions = new Text(composite2, 2052);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.hostOptions.setLayoutData((Object)gridData);
            this.hostOptions.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    String string;
                    String string2 = ((Text)modifyEvent.getSource()).getText();
                    if (!string2.equals(string = TargetEditor.this.target.getHostArguments())) {
                        TargetEditor.this.target.setHostArguments(string2);
                    }
                }
            });
            Label label2 = new Label(composite2, 0);
            label2.setText(Util.getText("addressLabel"));
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            label2.setLayoutData((Object)gridData);
            this.hostAddress = new Text(composite2, 2052);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.hostAddress.setLayoutData((Object)gridData);
            this.hostAddress.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    String string;
                    String string2 = ((Text)modifyEvent.getSource()).getText();
                    if (!string2.equals(string = TargetEditor.this.target.getHostAddress())) {
                        TargetEditor.this.target.setHostAddress(string2);
                    }
                }
            });
            Label label3 = new Label(composite2, 0);
            label3.setText(Util.getText("portLabel"));
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            label3.setLayoutData((Object)gridData);
            this.hostPort = new Text(composite2, 2052);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.hostPort.setLayoutData((Object)gridData);
            this.hostPort.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    String string;
                    String string2 = ((Text)modifyEvent.getSource()).getText();
                    if (!string2.equals(string = TargetEditor.this.target.getHostPort())) {
                        TargetEditor.this.target.setHostPort(string2);
                    }
                }
            });
        }
        return composite2;
    }

    public void refresh() {
        if (this.target == null) {
            this.composite.setVisible(false);
            return;
        }
        String string = this.target.getType();
        String string2 = String.valueOf(Util.getTargetName(string)) + " " + Util.getText("pathLabel");
        this.updateTextControl(this.targetName, this.target.getName());
        this.updateTextControl(this.hostPath, this.target.getHostPath());
        this.updateTextControl(this.hostOptions, this.target.getHostArguments());
        this.updateTextControl(this.hostAddress, this.target.getHostAddress());
        this.updateTextControl(this.hostPort, this.target.getHostPort());
        this.updateTextControl(this.usbPath, this.target.getUSBLibrary());
        this.updateTextControl(this.serialPort, this.target.getSerialPort());
        this.pathLabel.setText(string2);
        String string3 = this.target.getCommunicationMethod();
        if ("usb".equals(string3)) {
            this.toggleCommunications(true);
        } else if ("serial".equals(string3)) {
            this.toggleCommunications(false);
        }
        this.selectTargetDetails();
        this.composite.setVisible(true);
        this.composite.layout();
    }

    private void updateTextControl(Text text, String string) {
        text.setText(string != null ? string : "");
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (this.target != null) {
            this.target.store();
        }
        this.target = (ITargetEnvironment)object2;
        this.refresh();
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.target);
    }

    public void setSelection(ISelection iSelection, boolean bl) {
        StructuredSelection structuredSelection = (StructuredSelection)iSelection;
        this.target = (ITargetEnvironment)structuredSelection.getFirstElement();
        this.refresh();
    }

    private void setTargetText(Control control) {
        String string = null;
        if (control instanceof Text) {
            string = ((Text)control).getText();
        }
        if (this.target == null) {
            return;
        }
        if (control == this.targetName) {
            this.target.setName(string);
        } else if (control == this.hostPath) {
            this.target.setHostPath(string);
        } else if (control == this.hostOptions) {
            this.target.setHostArguments(string);
        } else if (control == this.hostAddress) {
            this.target.setHostAddress(string);
        } else if (control == this.hostPort) {
            this.target.setHostPort(string);
        } else if (control == this.usbPath) {
            this.target.setUSBLibrary(string);
        } else if (control == this.serialPort) {
            this.target.setSerialPort(string);
        }
    }

    private void selectTargetDetails() {
        StackLayout stackLayout = (StackLayout)this.details.getLayout();
        Composite composite = null;
        if (this.target != null) {
            String string = this.target.getType();
            if (string.equals("device")) {
                composite = this.deviceDetails;
                this.checkTargetPath(this.target, this.target.getUSBLibrary());
            } else {
                composite = this.targetDetails;
                this.checkTargetPath(this.target, this.target.getHostPath());
            }
        }
        stackLayout.topControl = composite;
        this.details.layout();
    }

    private void toggleCommunications(boolean bl) {
        this.usbButton.setSelection(bl);
        this.usbLabel.setEnabled(bl);
        this.usbPath.setEnabled(bl);
        this.usbPathButton.setEnabled(bl);
        this.serialButton.setSelection(!bl);
        this.serialLabel.setEnabled(!bl);
        this.serialPort.setEnabled(!bl);
    }

    private void fireTargetChangedEvent(ITargetEnvironment iTargetEnvironment) {
        StructuredSelection structuredSelection = new StructuredSelection((Object)iTargetEnvironment);
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)structuredSelection);
        this.fireSelectionChanged(selectionChangedEvent);
    }

    private void checkTargetPath(ITargetEnvironment iTargetEnvironment, String string) {
        if (iTargetEnvironment.getType().equals("device") && !iTargetEnvironment.getCommunicationMethod().equals("usb")) {
            this.setMessage(null, null);
            return;
        }
        if (string == null || string.equals("")) {
            this.setMessage("pathMissing", iTargetEnvironment.getType());
            return;
        }
        Path path = new Path(string);
        if (path.isAbsolute() && !path.toFile().exists()) {
            this.setMessage("pathInvalid", iTargetEnvironment.getType());
        } else {
            this.setMessage(null, null);
        }
    }

    private void setMessage(String string, String string2) {
        if (string != null) {
            String string3 = Util.getText("error." + string);
            String string4 = Util.getText("error." + string2);
            this.message.setText(String.valueOf(string4) + " " + string3);
        } else {
            this.message.setText("");
        }
    }
}

