/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.ui.preferences.targets;

import com.palmsource.eclipse.palmoscore.targets.ITargetEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TargetTree {
    private Map targetTree;

    public TargetTree() {
        String[] stringArray = ITargetEnvironment.TargetTypes;
        this.targetTree = new TreeMap();
        int n = 0;
        while (n < stringArray.length) {
            this.targetTree.put(stringArray[n], new ArrayList());
            ++n;
        }
    }

    public TargetTree(ITargetEnvironment[] iTargetEnvironmentArray) {
        this();
        int n = 0;
        while (n < iTargetEnvironmentArray.length) {
            this.addTarget(iTargetEnvironmentArray[n]);
            ++n;
        }
    }

    public Object[] getTargetElements() {
        return this.targetTree.keySet().toArray();
    }

    public List getTargetList(String string) {
        return (List)this.targetTree.get(string);
    }

    public ITargetEnvironment getTarget(String string, int n) {
        List list = this.getTargetList(string);
        return (ITargetEnvironment)list.get(n);
    }

    public void addTarget(ITargetEnvironment iTargetEnvironment) {
        List list = this.getTargetList(iTargetEnvironment.getType());
        if (list != null) {
            list.add(iTargetEnvironment);
        }
    }

    public void addTarget(int n, ITargetEnvironment iTargetEnvironment) {
        List list = this.getTargetList(iTargetEnvironment.getType());
        list.add(n, iTargetEnvironment);
    }

    public Object removeTarget(ITargetEnvironment iTargetEnvironment) {
        List list = this.getTargetList(iTargetEnvironment.getType());
        return this.removeTarget(list, iTargetEnvironment, list.indexOf(iTargetEnvironment));
    }

    public Object removeTarget(String string, int n) {
        List list = this.getTargetList(string);
        return this.removeTarget(list, (ITargetEnvironment)list.get(n), n);
    }

    private Object removeTarget(List list, ITargetEnvironment iTargetEnvironment, int n) {
        list.remove(iTargetEnvironment);
        if (n > 0) {
            return list.get(n - 1);
        }
        if (n == 0 && list.size() > 0) {
            return list.get(0);
        }
        return iTargetEnvironment.getType();
    }
}

