/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.ui.preferences.targets;

import com.palmsource.eclipse.palmoscore.ui.preferences.targets.AbstractTargetViewer;
import com.palmsource.eclipse.palmoscore.ui.preferences.targets.DeleteTargetAction;
import com.palmsource.eclipse.palmoscore.ui.preferences.targets.NewTargetAction;
import com.palmsource.eclipse.palmoscore.ui.preferences.targets.TargetTreeContentProvider;
import com.palmsource.eclipse.palmoscore.ui.preferences.targets.TargetTreeLabelProvider;
import com.palmsource.eclipse.palmoscore.ui.preferences.targets.Util;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TargetTreeViewer
extends AbstractTargetViewer {
    TreeViewer treeViewer;

    public TargetTreeViewer(Composite composite) {
        this(composite, 0);
    }

    public TargetTreeViewer(Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.composite.setLayout((Layout)gridLayout);
        Label label = new Label(this.composite, 0);
        label.setText(Util.getText("targetsLabel"));
        this.treeViewer = new TreeViewer(this.composite, 2052);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.treeViewer.getControl().setLayoutData((Object)gridData);
        this.treeViewer.setContentProvider((IContentProvider)new TargetTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TargetTreeLabelProvider());
        this.treeViewer.setSorter(new ViewerSorter(){});
        Button button = new Button(this.composite, 8);
        button.setText(Util.getText("newButton"));
        gridData = new GridData(768);
        button.setLayoutData((Object)gridData);
        Button button2 = new Button(this.composite, 8);
        button2.setText(Util.getText("deleteButton"));
        gridData = new GridData(768);
        button2.setLayoutData((Object)gridData);
        NewTargetAction newTargetAction = new NewTargetAction(button);
        newTargetAction.setEnabled(false);
        DeleteTargetAction deleteTargetAction = new DeleteTargetAction(button2);
        deleteTargetAction.setEnabled(false);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)newTargetAction);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)deleteTargetAction);
        newTargetAction.setViewer((Viewer)this.treeViewer);
        deleteTargetAction.setViewer((Viewer)this.treeViewer);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
                Object object = iStructuredSelection.getFirstElement();
                if (TargetTreeViewer.this.treeViewer.isExpandable(object)) {
                    TargetTreeViewer.this.treeViewer.setExpandedState(object, !TargetTreeViewer.this.treeViewer.getExpandedState(object));
                }
            }
        });
    }

    public Viewer getViewer() {
        return this.treeViewer;
    }

    public Object getInput() {
        return this.treeViewer.getInput();
    }

    public void setInput(Object object) {
        this.treeViewer.setInput(object);
    }

    public void refresh() {
        this.treeViewer.refresh();
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public void setSelection(ISelection iSelection, boolean bl) {
        this.treeViewer.setSelection(iSelection, bl);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.treeViewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.treeViewer.removeSelectionChangedListener(iSelectionChangedListener);
    }
}

