/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.ui.wizards;

import com.palmsource.eclipse.palmoscore.Messages;
import com.palmsource.eclipse.palmoscore.codesets.CodeSetExtensionData;
import com.palmsource.eclipse.palmoscore.codesets.EmptyCodeSet;
import com.palmsource.eclipse.palmoscore.codesets.ICodeSetProvider;
import com.palmsource.eclipse.palmoscore.projects.IProjectDataProvider;
import com.palmsource.eclipse.palmoscore.ui.wizards.AbstractProjectDataPage;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class CodeSetSelectionWizardPage
extends AbstractProjectDataPage {
    private static final String KEY_CODE_GEN_TITLE = "WizardCodeGenPage.title";
    private static final String KEY_CODE_GEN_DESC = "WizardCodeGenPage.description";
    private static final String KEY_CODE_LIST_LABEL = "WizardCodeGenPage.codeListLabel";
    private static final String EMPTY_CODESET_TITLE = "WizardCodeGenPage.emptyCodeSet.title";
    private static final String EMPTY_CODESET_DESC = "WizardCodeGenPage.emptyCodeSet.description";
    private List guiList;
    private Text codeDescription;
    private CodeSetExtensionData[] completeCodeSetCollection;
    private CodeSetExtensionData[] filteredCollection;
    private IProjectDataProvider filterProvider;
    private boolean pageHasBeenVisible = false;
    private int selectedIndex = 0;

    public CodeSetSelectionWizardPage(IProjectDataProvider iProjectDataProvider, CodeSetExtensionData[] codeSetExtensionDataArray) {
        this(Messages.getString(KEY_CODE_GEN_TITLE), Messages.getString(KEY_CODE_GEN_DESC), iProjectDataProvider, codeSetExtensionDataArray);
    }

    public CodeSetSelectionWizardPage(String string, String string2, IProjectDataProvider iProjectDataProvider, CodeSetExtensionData[] codeSetExtensionDataArray) {
        super("CodeSetSelectionWizardPage");
        this.setTitle(string);
        this.setDescription(string2);
        this.completeCodeSetCollection = codeSetExtensionDataArray;
        this.filterProvider = iProjectDataProvider;
        this.setCodeSetFilter(null);
    }

    public ICodeSetProvider getSelectedCodeSet() {
        if (!this.pageHasBeenVisible) {
            this.setCodeSetFilter((String)this.filterProvider.getProjectDataValues().get("PROJECT_TYPE"));
            return this.filteredCollection[0].getCodeSetProvider();
        }
        if (this.guiList.getSelectionIndex() < 0) {
            return this.filteredCollection[0].getCodeSetProvider();
        }
        return this.filteredCollection[this.guiList.getSelectionIndex()].getCodeSetProvider();
    }

    public void setCodeSetFilter(String string) {
        int n;
        int n2 = 0;
        if (string == null) {
            n2 = this.completeCodeSetCollection.length;
        } else {
            n = 0;
            while (n < this.completeCodeSetCollection.length) {
                CodeSetExtensionData codeSetExtensionData = this.completeCodeSetCollection[n];
                if (codeSetExtensionData.getProjectType().equals(string)) {
                    ++n2;
                }
                ++n;
            }
        }
        if (n2 == 0) {
            this.filteredCollection = new CodeSetExtensionData[1];
            this.filteredCollection[0] = new CodeSetExtensionData(Messages.getString(EMPTY_CODESET_TITLE), Messages.getString(EMPTY_CODESET_DESC), string, new EmptyCodeSet());
        } else {
            this.filteredCollection = new CodeSetExtensionData[n2];
            n = 0;
            int n3 = 0;
            while (n3 < this.completeCodeSetCollection.length) {
                CodeSetExtensionData codeSetExtensionData = this.completeCodeSetCollection[n3];
                if (string == null || codeSetExtensionData.getProjectType().equals(string)) {
                    this.filteredCollection[n++] = this.completeCodeSetCollection[n3];
                }
                ++n3;
            }
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 9;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        composite3.setLayout((Layout)gridLayout2);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite3.setLayoutData((Object)gridData);
        this.guiList = new List(composite3, 2048);
        GridData gridData2 = new GridData(1808);
        gridData2.widthHint = 100;
        this.guiList.setLayoutData((Object)gridData2);
        this.guiList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (CodeSetSelectionWizardPage.this.guiList.getSelectionIndex() >= 0 && CodeSetSelectionWizardPage.this.guiList.getSelectionIndex() <= CodeSetSelectionWizardPage.this.filteredCollection.length) {
                    CodeSetSelectionWizardPage.this.selectedIndex = CodeSetSelectionWizardPage.this.guiList.getSelectionIndex();
                    CodeSetSelectionWizardPage.this.codeDescription.setText(CodeSetSelectionWizardPage.this.filteredCollection[CodeSetSelectionWizardPage.this.guiList.getSelectionIndex()].getDescription());
                } else {
                    CodeSetSelectionWizardPage.this.codeDescription.setText("");
                }
            }
        });
        this.codeDescription = new Text(composite3, 2120);
        GridData gridData3 = new GridData(1808);
        this.codeDescription.setLayoutData((Object)gridData3);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    public Map getProjectDataValues() {
        HashMap hashMap = new HashMap();
        return hashMap;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.initialize();
            this.pageHasBeenVisible = true;
        }
    }

    private void initialize() {
        this.setCodeSetFilter((String)this.filterProvider.getProjectDataValues().get("PROJECT_TYPE"));
        this.guiList.removeAll();
        this.codeDescription.setText("");
        int n = 0;
        while (n < this.filteredCollection.length) {
            this.guiList.add(this.filteredCollection[n].getTitle());
            ++n;
        }
        this.guiList.setSelection(this.selectedIndex);
        n = this.selectedIndex;
        if (n < 0 || n > this.filteredCollection.length) {
            n = 0;
        }
        this.codeDescription.setText(this.filteredCollection[n].getDescription());
    }
}

