/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.palmoscore.ui.wizards;

import com.palmsource.eclipse.palmoscore.CorePlugin;
import com.palmsource.eclipse.palmoscore.Messages;
import com.palmsource.eclipse.palmoscore.PalmOSManagedNature;
import com.palmsource.eclipse.palmoscore.PalmOSNature;
import com.palmsource.eclipse.palmoscore.codesets.CodeSetExtensionData;
import com.palmsource.eclipse.palmoscore.codesets.ProjectCodeGenerator;
import com.palmsource.eclipse.palmoscore.projects.IProjectDataProvider;
import com.palmsource.eclipse.palmoscore.projects.IProjectTargetProvider;
import com.palmsource.eclipse.palmoscore.ui.wizards.CodeSetSelectionWizardPage;
import com.palmsource.eclipse.palmoscore.ui.wizards.PalmOSOptionsPage;
import com.palmsource.eclipse.palmoscore.ui.wizards.ProjectPlatformPageProxy;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewManagedProjectOptionPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewManagedProjectWizard;
import org.eclipse.cdt.ui.wizards.NewCProjectWizard;
import org.eclipse.cdt.ui.wizards.NewCProjectWizardPage;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;

public abstract class NewManagedPalmOSProjectWizard
extends NewManagedProjectWizard
implements IProjectDataProvider,
IProjectTargetProvider {
    private static final String KEY_TASK_NAME = "MakePalmOSAppWizard.task_name";
    private static final String CPROJECT_PAGE_NAME = "CProjectWizardPage";
    private static final String OPTIONS_TITLE = "MngMakeProjectWizard.options.title";
    private static final String OPTIONS_DESC = "MngMakeProjectWizard.options.desc";
    private static final String MSG_ADD_NATURE = "MngMakeProjectWizard.message.add_nature";
    private static final String MSG_ADD_BUILDER = "MngMakeProjectWizard.message.add_builder";
    private static final String MSG_SAVE = "MngMakeProjectWizard.message.save";
    protected ProjectPlatformPageProxy proxyPage;
    private ProjectCodeGenerator projCodeGenerator;
    private CodeSetSelectionWizardPage codeSetSelectionWizardPage;
    protected PalmOSOptionsPage palmOSOptionsPage;
    private String title;
    private String description;

    public NewManagedPalmOSProjectWizard(String string, String string2) {
        super(string, string2);
        this.title = string;
        this.description = string2;
        this.projCodeGenerator = new ProjectCodeGenerator();
        this.palmOSOptionsPage = new PalmOSOptionsPage(new DefaultNameProvider());
        this.codeSetSelectionWizardPage = new CodeSetSelectionWizardPage(this.palmOSOptionsPage, this.getCodeSets());
        this.targetConfigurationPage = new ProjectPlatformPageProxy(CPROJECT_PAGE_NAME, this.palmOSOptionsPage, this, this);
        this.proxyPage = (ProjectPlatformPageProxy)this.targetConfigurationPage;
    }

    public abstract CodeSetExtensionData[] getCodeSets();

    public Map getProjectDataValues() {
        Map map = this.palmOSOptionsPage.getProjectDataValues();
        map.put("PROJECT_VERSION", String.valueOf(10100));
        return map;
    }

    public void addPages() {
        this.fMainPage = new NewCProjectWizardPage(CPROJECT_PAGE_NAME);
        this.fMainPage.setTitle(this.title);
        this.fMainPage.setDescription(this.description);
        this.addPage((IWizardPage)this.fMainPage);
        this.addPage((IWizardPage)this.palmOSOptionsPage);
        this.addPage((IWizardPage)this.codeSetSelectionWizardPage);
        this.optionPage = new NewManagedProjectOptionPage(CPROJECT_PAGE_NAME, (NewManagedProjectWizard)this);
        this.optionPage.setTitle(Messages.getString(OPTIONS_TITLE));
        this.optionPage.setDescription(Messages.getString(OPTIONS_DESC));
        this.addPage((IWizardPage)this.optionPage);
    }

    protected void doRun(IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(Messages.getString(KEY_TASK_NAME), 2);
        this.doManagedProjectRun((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 5), (String)this.getProjectDataValues().get("ARTIFACT_NAME"));
        if (this.newProject != null) {
            CCorePlugin.getDefault().convertProjectFromCtoCC(this.newProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        }
        PalmOSNature.addNature(this.getProjectHandle(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        PalmOSManagedNature.addNature(this.getProjectHandle(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        this.performApply(this.getProjectHandle(), iProgressMonitor);
        this.projCodeGenerator.addProjectDataProvider(this.palmOSOptionsPage);
        this.projCodeGenerator.addProjectDataProvider(this.codeSetSelectionWizardPage);
        this.projCodeGenerator.addProjectDataProvider(this);
        this.projCodeGenerator.addCodeSetProvider(this.codeSetSelectionWizardPage.getSelectedCodeSet());
        this.projCodeGenerator.generateContents(this.getProjectHandle(), iProgressMonitor);
        this.applyDefaults();
    }

    protected void applyDefaults() {
        IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
        ManagedBuildManager.getBuildInfo((IResource)this.getProjectHandle());
        ITarget[] iTargetArray = ManagedBuildManager.getTargets((IResource)this.getProjectHandle());
        int n = 0;
        while (n < iTargetArray.length) {
            ITarget iTarget = iTargetArray[n];
            if (!iTarget.isTestTarget()) {
                IConfiguration[] iConfigurationArray = iTarget.getConfigurations();
                int n2 = 0;
                while (n2 < iConfigurationArray.length) {
                    IConfiguration iConfiguration = iConfigurationArray[n2];
                    ITool[] iToolArray = iConfiguration.getTools();
                    int n3 = 0;
                    while (n3 < iToolArray.length) {
                        ITool iTool = iToolArray[n3];
                        IOption[] iOptionArray = iTool.getOptions();
                        int n4 = 0;
                        while (n4 < iOptionArray.length) {
                            IOption iOption = iOptionArray[n4];
                            if (iPreferenceStore.contains(iOption.getId())) {
                                String string = iPreferenceStore.getString(iOption.getId());
                                block5 : switch (iOption.getValueType()) {
                                    case 0: {
                                        ManagedBuildManager.setOption((IConfiguration)iConfiguration, (IOption)iOption, (boolean)Boolean.valueOf(string));
                                        break;
                                    }
                                    case 3: {
                                        String[] stringArray;
                                        if (string.length() <= 0) break;
                                        String[] stringArray2 = string.split(" ");
                                        String[] stringArray3 = null;
                                        try {
                                            stringArray3 = iOption.getStringListValue();
                                        }
                                        catch (BuildException buildException) {}
                                        if (stringArray3 != null && stringArray3.length > 0) {
                                            stringArray = new String[stringArray3.length + stringArray2.length];
                                            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                                            System.arraycopy(stringArray3, 0, stringArray, stringArray2.length, stringArray3.length);
                                            stringArray2 = stringArray;
                                        }
                                        if (stringArray2.length <= 0) break;
                                        ManagedBuildManager.setOption((IConfiguration)iConfiguration, (IOption)iOption, (String[])stringArray2);
                                        break;
                                    }
                                    case 4: {
                                        String[] stringArray;
                                        if (string.length() <= 0) break;
                                        String[] stringArray2 = string.split(";");
                                        String[] stringArray4 = null;
                                        try {
                                            stringArray4 = iOption.getIncludePaths();
                                        }
                                        catch (BuildException buildException) {}
                                        if (stringArray4 != null && stringArray4.length > 0) {
                                            stringArray = new String[stringArray4.length + stringArray2.length];
                                            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                                            System.arraycopy(stringArray4, 0, stringArray, stringArray2.length, stringArray4.length);
                                            stringArray2 = stringArray;
                                        }
                                        if (stringArray2.length <= 0) break;
                                        ManagedBuildManager.setOption((IConfiguration)iConfiguration, (IOption)iOption, (String[])stringArray2);
                                        break;
                                    }
                                    case 5: {
                                        String[] stringArray;
                                        if (string.length() <= 0) break;
                                        String[] stringArray2 = string.split(" ");
                                        String[] stringArray5 = null;
                                        try {
                                            stringArray5 = iOption.getDefinedSymbols();
                                        }
                                        catch (BuildException buildException) {}
                                        if (stringArray5 != null && stringArray5.length > 0) {
                                            stringArray = new String[stringArray5.length + stringArray2.length];
                                            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                                            System.arraycopy(stringArray5, 0, stringArray, stringArray2.length, stringArray5.length);
                                            stringArray2 = stringArray;
                                        }
                                        if (stringArray2.length <= 0) break;
                                        ManagedBuildManager.setOption((IConfiguration)iConfiguration, (IOption)iOption, (String[])stringArray2);
                                        break;
                                    }
                                    case 6: {
                                        String[] stringArray;
                                        if (string.length() <= 0) break;
                                        String[] stringArray2 = string.split(" ");
                                        String[] stringArray6 = null;
                                        try {
                                            stringArray6 = iOption.getLibraries();
                                        }
                                        catch (BuildException buildException) {}
                                        if (stringArray6 != null && stringArray6.length > 0) {
                                            stringArray = new String[stringArray6.length + stringArray2.length];
                                            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                                            System.arraycopy(stringArray6, 0, stringArray, stringArray2.length, stringArray6.length);
                                            stringArray2 = stringArray;
                                        }
                                        if (stringArray2.length <= 0) break;
                                        ManagedBuildManager.setOption((IConfiguration)iConfiguration, (IOption)iOption, (String[])stringArray2);
                                        break;
                                    }
                                    case 7: {
                                        String[] stringArray;
                                        if (string.length() <= 0) break;
                                        String[] stringArray2 = string.split(" ");
                                        String[] stringArray7 = null;
                                        try {
                                            stringArray7 = iOption.getUserObjects();
                                        }
                                        catch (BuildException buildException) {}
                                        if (stringArray7 != null && stringArray7.length > 0) {
                                            stringArray = new String[stringArray7.length + stringArray2.length];
                                            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                                            System.arraycopy(stringArray7, 0, stringArray, stringArray2.length, stringArray7.length);
                                            stringArray2 = stringArray;
                                        }
                                        if (stringArray2.length <= 0) break;
                                        ManagedBuildManager.setOption((IConfiguration)iConfiguration, (IOption)iOption, (String[])stringArray2);
                                        break;
                                    }
                                    case 1: {
                                        String[] stringArray2 = iOption.getApplicableValues();
                                        int n5 = 0;
                                        while (n5 < stringArray2.length) {
                                            if (string.equalsIgnoreCase(iOption.getEnumCommand(stringArray2[n5]))) {
                                                ManagedBuildManager.setOption((IConfiguration)iConfiguration, (IOption)iOption, (String)stringArray2[n5]);
                                                break block5;
                                            }
                                            ++n5;
                                        }
                                        break;
                                    }
                                    default: {
                                        ManagedBuildManager.setOption((IConfiguration)iConfiguration, (IOption)iOption, (String)string);
                                    }
                                }
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        ManagedBuildManager.saveBuildInfo((IProject)this.getProjectHandle(), (boolean)true);
    }

    private void performApply(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        ICommand iCommand = null;
        IProjectDescription iProjectDescription = iProject.getDescription();
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        int n = 0;
        while (n < iCommandArray.length) {
            if (iCommandArray[n].getBuilderName().equals("com.palmsource.eclipse.palmoscore.palmOSMakeBuilder")) {
                iCommand = iCommandArray[n];
                break;
            }
            ++n;
        }
        if (iCommand != null) {
            Hashtable hashtable = iCommand.getArguments();
            if (hashtable == null) {
                hashtable = new Hashtable();
            }
            Map map = this.getProjectDataValues();
            map.remove("ARTIFACT_NAME");
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashtable.put(string, map.get(string));
            }
            iCommand.setArguments(hashtable);
            iProjectDescription.setBuildSpec(iCommandArray);
            iProject.setDescription(iProjectDescription, iProgressMonitor);
        }
    }

    private void doManagedProjectRun(IProgressMonitor iProgressMonitor, String string) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        super.doRun((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 5));
        try {
            iProgressMonitor.subTask(Messages.getString(MSG_ADD_NATURE));
            ManagedCProjectNature.addManagedNature((IProject)this.newProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            iProgressMonitor.subTask(Messages.getString(MSG_ADD_BUILDER));
            ManagedCProjectNature.addManagedBuilder((IProject)this.newProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        }
        catch (CoreException coreException) {
            ManagedBuilderUIPlugin.log((Throwable)coreException);
        }
        ITarget iTarget = null;
        try {
            IConfiguration[] iConfigurationArray;
            ManagedBuildManager.createBuildInfo((IResource)this.newProject);
            ITarget[] iTargetArray = this.proxyPage.getTargets();
            int n = 0;
            while (n < iTargetArray.length) {
                iTarget = ManagedBuildManager.createTarget((IResource)this.newProject, (ITarget)iTargetArray[n]);
                if (iTarget != null) {
                    Object object;
                    try {
                        object = CCorePlugin.getDefault().getCProjectDescription(this.newProject, true);
                        object.remove("org.eclipse.cdt.core.ScannerInfoProvider");
                        object.create("org.eclipse.cdt.core.ScannerInfoProvider", ManagedBuildManager.INTERFACE_IDENTITY);
                        object.remove("org.eclipse.cdt.core.BinaryParser");
                        object.create("org.eclipse.cdt.core.BinaryParser", iTarget.getBinaryParserId());
                    }
                    catch (CoreException coreException) {
                        ManagedBuilderUIPlugin.log((Throwable)coreException);
                    }
                    object = string == null || string.length() == 0 ? this.newProject.getName() : string;
                    iTarget.setArtifactName((String)object);
                    IConfiguration[] iConfigurationArray2 = iTargetArray[n].getConfigurations();
                    Random random = new Random();
                    random.setSeed(System.currentTimeMillis());
                    int n2 = 0;
                    while (n2 < iConfigurationArray2.length) {
                        IConfiguration iConfiguration = iConfigurationArray2[n2];
                        int n3 = random.nextInt();
                        if (n3 < 0) {
                            n3 *= -1;
                        }
                        iTarget.createConfiguration(iConfiguration, String.valueOf(iConfiguration.getId()) + "." + n3);
                        ++n2;
                    }
                }
                ++n;
            }
            if (iTarget != null && (iConfigurationArray = iTarget.getConfigurations()).length > 0) {
                ManagedBuildManager.setDefaultConfiguration((IProject)this.newProject, (IConfiguration)iConfigurationArray[0]);
            }
            ManagedBuildManager.setNewProjectVersion((IProject)this.newProject);
        }
        catch (BuildException buildException) {
            ManagedBuilderUIPlugin.log((Throwable)buildException);
        }
        if (this.newProject != null) {
            this.optionPage.performApply((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
        }
        iProgressMonitor.subTask(Messages.getString(MSG_SAVE));
        ManagedBuildManager.saveBuildInfo((IProject)this.newProject, (boolean)true);
    }

    protected String getBuildGoalName() {
        return this.newProject.getName();
    }

    private class DefaultNameProvider
    implements IProjectDataProvider {
        DefaultNameProvider() {
        }

        public Map getProjectDataValues() {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("ARTIFACT_NAME", ((NewCProjectWizard)NewManagedPalmOSProjectWizard.this).fMainPage.getProjectName());
            return hashtable;
        }
    }
}

